<?php

class LandedcostitemsController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'DeleteLandedCostItem', 'SaveLandedCostItem', 'GetLandedCostItemsList', 'CheckSubledgerExist','Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }

    public function actionGetLandedCostItemsList() {

        $model = new MasLandedCostItems();
        //To get model from finance module
        Yii::app()->getModule('finance');
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            1 => 'item_type',
            2 => 'item_name',
            3 => 'description',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  ( item_name LIKE '%" . $searchString . "%' OR ledger.description LIKE '%" . $searchString . "%' OR subledger.description LIKE '%" . $searchString . "%' OR t.description LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('ledger', 'subledger')->count(array('condition' => $condition));
        $model = $model->with('ledger', 'subledger')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;


        foreach ($model as $row) {
            $div = '';
            if ($row['item_type'] == 1)
                $addition_deduction = "Addition";
            if ($row['item_type'] == 2)
                $addition_deduction = "Deduction";

            $rowData[] = array($m,
                $row['ledger']['description'],
                $row['subledger']['description'],
                $addition_deduction,
                $row['item_name'],
                $row['description'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row['item_name'], 'isActive' => $row['isActive']),);

            $m++;
        }


        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        //To get model from finance module
        Yii::app()->getModule('finance');
        $model = new MasLandedCostItems();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->with('ledger', 'subledger')->findByPk($id);

            $model->subledger_name = $model->subledger->description;
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSaveLandedCostItem() {
        $model = new MasLandedCostItems();

        if (isset($_POST['MasLandedCostItems'])) {
            $model->created_by = Yii::app()->user->id;
            if ((int) @$_POST['MasLandedCostItems']['id'] > 0) {
                $id = (int) @$_POST['MasLandedCostItems']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $flag = 0;
                $audit_type = 'UPDATED';
            } else {
                $flag = 1;
                $audit_type = 'CREATED';
            }
            $model->updated_date_time = date('Y-m-d h:i:s');
            $model->description = $_POST['MasLandedCostItems']['description'];
            $model->attributes = $_POST['MasLandedCostItems'];
            $model->have_sub_ledger = $_POST['MasLandedCostItems']['have_sub_ledger'];

            if ($model->save()) {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'LANDED_COST_ITEM', Yii::app()->user->id, $audit_type, " with name: - {$model->item_name}  "
                );
                // end audit log

                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['bank_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDeleteMasLandedCostItems() {
        $id = $_POST['id'];
        $model_q1 = QuotesAddition::model()->findAll(array('condition' => 'particular=' . $id));
        $model_q2 = QuotesDeduction::model()->findAll(array('condition' => 'particular=' . $id));
        $model_o1 = OrderAddition::model()->findAll(array('condition' => 'particular=' . $id));
        $model_o2 = OrderDeduction::model()->findAll(array('condition' => 'particular=' . $id));
        $model_d1 = DirectPurchasingOrderAddition::model()->findAll(array('condition' => 'particular=' . $id));
        $model_d2 = DirectPurchasingOrderDeduction::model()->findAll(array('condition' => 'particular=' . $id));
        if (empty($model_q1) && empty($model_q2) && empty($model_o1) && empty($model_o2) && empty($model_d1) && empty($model_d2)) {
            $model = new MasLandedCostItems();
            $model->deleteByPk($id);
            echo "success";
        } else {
            echo "fail";
        }
    }

    public function actionCheckSubledgerExist() {
        $account_id = (int) Yii::app()->request->getParam('account_id');
        //To get model from finance module
        Yii::app()->getModule('finance');

        $fin_ledger_details = FinanceLegder::model()->findByPk($account_id);

        echo $fin_ledger_details->haveSubledger;

        Yii::app()->end();
    }

    public function actionDisable() {
        date_default_timezone_set("Asia/Dubai");
        $id = $_POST['id'];

        if (!empty($id)) {
            $model = new MasLandedCostItems();
            $model = $model->findByPk($id);
            if ($model->isActive == 'N') {
                $model->isActive = 'Y';
            } else {
                $model->isActive = 'N';
            }
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d h:i:s');
            $model->save(false);
            echo "success";
        } else {
            echo "fail";
        }
    }

}
