<?php

class HiringtransferController extends Controller
{
      public function accessRules() {

            return array(

                array('allow', // allow all users to perform 'index' and 'view' actions

                  'actions' => array('login', 'error', 'logout'),

                  'users' => array('*'),

                  ),

                array('allow', // allow authenticated user to perform 'create' and 'update' actions

                  'actions' => array('Index','Create','Receive','Transfer','SaveTransfer','GetList','GetSerializedList','PrintPDF','Convert','GetTransferList',
                  'HiringItems','PrintSerializedPDF','GetHiringMachineList','GetHiringSpareList','HiringSpareItems','removeitem','Getbin','GetLocationDetails'),
                  'expression' => '$user->isMember()', /**copied by jisha from bouleward on 8-11-17**/

                  ),

                array('deny', // deny all users

                  'users' => array('*'),

                  ),

                );
        }
        
	public function actionIndex()
	{
		$this->render('index');
	}
	
	public function actionGetList()
        {
    
            $model = new InventoryHiringTransfer();
            $draw = $_POST['draw'];
            $offset = $_POST['start'];
            $limit = $_POST['length'];
            $columns = array(
    
                // datatable column index  => database column name
    
                0 => 't.id',
                1 => 'transfer_date',
                2 => 'warehouseFrom.warehouse_name',
                3 => 'direct_transfer_description',
                4 => 'reference'
            );
    
            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder = $_POST['order'][0]['dir'];
            $orderBy = $filterColumn . " " . $filterOrder;
            $condition = 't.status="T"';
    
            if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
                $searchString = $_POST['search']['value'];
                $condition .= " and t.id LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%' OR t.direct_transfer_description LIKE '%" . $searchString . "%' OR warehouseFrom.warehouse_name LIKE '%" . $searchString . "%'";
            }
            $count = $model->with('warehouseFrom')->count(array('condition' => $condition));
            $model = $model->with('warehouseFrom')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData = array();
            $m = 1;
    
            foreach ($model as $row) {
                $req_date='';
                if (!empty($row->transfer_date) && ($row->transfer_date != "0000-00-00")) {
                    $req_date = date("d/m/Y", strtotime($row->transfer_date));
                }
    
                $div = '';
                if (isset(Yii::app()->user->havePermissionOn['direct_transfer_view']) || Yii::app()->user->authorised_user == 1) {
                    $div = '<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'iwarehouse/directcreate&type=view&id=' . $row['id'] . '\',\'Direct Transfer\',\'xl\')"><i class="fa fa-eye"></i></button>';
                }
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inv_directtransfer_pdf"])) {
                    $div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintDirectTransferPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
    
                }
                $rowData[] = array($row['id'], $req_date, $row['warehouseFrom']['warehouse_name'],$row['direct_transfer_description'], $row['reference']);
                $m++;
            }
            $data['data'] = $rowData;
            echo json_encode($data);
        }
        
        	public function actionGetSerializedList()
        {
    
            $model = new InventoryHiringTransfer();
            $draw = $_POST['draw'];
            $offset = $_POST['start'];
            $limit = $_POST['length'];
            $columns = array(
    
                // datatable column index  => database column name
    
                0 => 't.id',
                1 => 'transfer_date',
                2 => 'warehouseFrom.warehouse_name',
                3 => 'direct_transfer_description',
                4 => 'reference'
            );
    
            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder = $_POST['order'][0]['dir'];
            $orderBy = $filterColumn . " " . $filterOrder;
            $condition = 't.status="C"';
    
            if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
                $searchString = $_POST['search']['value'];
                $condition .= " and t.id LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%' OR t.direct_transfer_description LIKE '%" . $searchString . "%' OR warehouseFrom.warehouse_name LIKE '%" . $searchString . "%'";
            }
            $count = $model->with('warehouseFrom')->count(array('condition' => $condition));
            $model = $model->with('warehouseFrom')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData = array();
            $m = 1;
    
            foreach ($model as $row) {
                $req_date='';
                if (!empty($row->completed_date) && ($row->completed_date != "0000-00-00")) {
                    $req_date = date("d/m/Y", strtotime($row->completed_date));
                }
    
                $div = '';
                if (isset(Yii::app()->user->havePermissionOn['direct_transfer_view']) || Yii::app()->user->authorised_user == 1) {
                    $div = '<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'iwarehouse/directcreate&type=view&id=' . $row['id'] . '\',\'Direct Transfer\',\'xl\')"><i class="fa fa-eye"></i></button>';
                }
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inv_directtransfer_pdf"])) {
                    $div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintDirectTransferPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
    
                }
                $rowData[] = array($row['id'], $req_date,$row['warehouseFrom']['warehouse_name'], $row['direct_transfer_description'], $row['reference']);
                $m++;
            }
            $data['data'] = $rowData;
            echo json_encode($data);
        }
        
         public function actionCreate()
        {
            $model=new InventoryHiringTransfer();
            $model_items=array(new InventoryHiringTransferItem());
            $id = (int) Yii::app()->request->getParam('id');
            $type =  Yii::app()->request->getParam('type');
            if($id>0){
                
                $model=$model->findByPk($id);
               // print_r($model->transfer_date);die();
                $transfer_date = str_replace('/', '-', $model->transfer_date);
                $transfer_date = date('d/m/Y', strtotime($transfer_date));
                $model->transfer_date= $transfer_date;
                $model_items = InventoryHiringTransferItem::model()->findAll(array('condition'=>'transfer_id="'.$id.'"'));  
                if(empty($model_items)){
                      $model_items=array(new InventoryHiringTransferItem());  
                }
               
           }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('create', array('model' => $model,'model_items'=>$model_items,'type' => $type));
        }
        public function actionSaveTransfer()
        {
    
            $model = new InventoryHiringTransfer();
    
            /************ START Code for Save ***************/
    
            if (isset($_POST['InventoryHiringTransfer'])) {
    
                if ((int) @$_POST['InventoryHiringTransfer']['id'] > 0) {
    
                    $id = (int) @$_POST['InventoryHiringTransfer']['id'];
                    $model = $model->findByPk($id);
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time = date('y-m-d');
                } else {
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date_time = date('y-m-d h:m:s');
                }
    
                $model->attributes = $_POST['InventoryHiringTransfer'];
                $model->direct_transfer_description = $_POST['InventoryHiringTransfer']['direct_transfer_description'];
                $model->reference = $_POST['InventoryHiringTransfer']['reference'];
                if ($_POST['InventoryHiringTransfer']['transfer_date'] != '' && $_POST['InventoryHiringTransfer']['transfer_date'] != '0000-00-00') {
                    $model->transfer_date = str_replace('/', '-', $_POST['InventoryHiringTransfer']['transfer_date']);
                    $model->transfer_date = date("Y-m-d", strtotime($model->transfer_date));
                }
                $valid = $model->validate();
                $other_errors = array();
                if (isset($_POST['InventoryHiringTransferItem'])) {
    
                    foreach ($_POST['InventoryHiringTransferItem'] as $i => $items) {
    
                        if ($items['id'] > 0) {
                            $model_item[$i] = InventoryHiringTransferItem::model()->findByPK($items['id']);
    
                        } else {
                            $model_item[$i] = new InventoryHiringTransferItem();
                        }
    
                        $model_item[$i]->product_id = $items['product_id'];
                        $model_item[$i]->item_description = $items['item_description'];
                        //$model_item[$i]->item_name = $items['item_name'];
                        $part_number      = explode('-', $items['item_name']);
                        $mc_spare=$part_number[1];
                        $value_machine_type = ($mc_spare=='02')? '01': '03';
                        $model_item[$i]->item_name =$part_number[0].'-'.$value_machine_type.'-'.$part_number[2];
                        $model_item[$i]->transfer_qty = $items['transfer_qty'];
                        $model_item[$i]->unit = $items['unit'];
                        $valid = $model_item[$i]->validate() && $valid;
    
                    }
    
                }
                if ($valid) {
    
                    $model->save();
                    foreach ($model_item as $each) {
                        $each->transfer_id = $model->id;
                        $each->save();
                    }
                    $jsonData['id'] = $model->id;
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                } else {
                    $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                    if (!empty($model_item[0]->product_id)) {
                        $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                    } else {
                        $error2[] = "Please add atleast one line item";
                    }
    
                    $error = CJSON::encode(array_merge_recursive($error1, $error2, $other_errors));
                    if ($error != '[]') {
                        echo $error;
                    }
    
                }
            }
        }
        
        public function actionPrintPDF(){
            $model=new InventoryHiringTransfer();
            $id = Yii::app()->request->getParam('id');
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.print_hiring_transfer', array('model' => $model, 'id' => $id, 'title' => $title),true));
            $mPDF1->Output("HiringTransferReceipt.pdf", 'I');
        }
        public function actionPrintSerializedPDF(){
            $model=new InventoryHiringTransfer();
            $id = Yii::app()->request->getParam('id');
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.print_hiring_transfer_serialized', array('model' => $model, 'id' => $id, 'title' => $title),true));
            $mPDF1->Output("HiringTransferReceipt.pdf", 'I');
        }
    public function actionConvert() 
    {
        $transaction_id = (int) Yii::app()->request->getParam('id');

    	$transaction_type='HIRING_TRANSFER';
        $model	        = InventoryHiringTransfer::model()->findByPk($transaction_id);           
        $modelItems  	= InventoryHiringTransferItem::model()->findAll(array('condition'=>'transfer_id ='.$transaction_id));
        $warehouse      = $model->to_warehouse_id;
        $status         = "HT";
        $k=0;
        if(!empty($modelItems)){
        	foreach ($modelItems as $eachItem) {
        		$modelItems[$k] = new ProductLocationDetails;
        		$modelItems[$k]->product_id = $eachItem->product_id;
        		$modelItems[$k]->quantity   = $eachItem->	transfer_qty;
        		$modelItems[$k]->header_id   = $transaction_id;
        		$modelItems[$k]->header_item_id   = $eachItem->id;
        		$modelItems[$k]->transaction_type   = $transaction_type;
        		$modelItems[$i]->part_number = $eachItem['item_name'];
                        $modelItems[$i]->description = $eachItem['item_description'];
                        $k++;
        	}
        }
        $warehouse = $model->from_warehouse_id; 
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
        $this->render('convert',array('model'=>$model,'status'=>$status,'items'=>$modelItems, 'warehouse' => $warehouse));
    }
    
    public function actionGetTransferList()
        {
    
            $model = new ProductLocationHiringDetails();
            $draw = $_POST['draw'];
            $offset = $_POST['start'];
            $limit = $_POST['length'];
            $columns = array(
    
                // datatable column index  => database column name
    
                0 => 't.id',
                1 => 't.part_number',
                2 => 't.oem_number',
                3 => 't.description',
                4 => 'quantity',
                5 => 'serial_no',
                6 => 'expiry_date',
            );
    
            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder = $_POST['order'][0]['dir'];
            $orderBy = $filterColumn . " " . $filterOrder;
            $condition = 't.quantity>0';
            //$condition = '1=1';
    
            if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
                $searchString = $_POST['search']['value'];
                $condition .= " and t.id LIKE '%" . $searchString . "%' OR t.part_number LIKE '%" . $searchString . "%' OR t.description LIKE '%" . $searchString . "%'";
            }
            $count = $model->with('product')->count(array('condition' => $condition));
            $model = $model->with('product')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData = array();
            $m = 1;
    
            foreach ($model as $row) {
                $expiry_date="";
                if (!empty($row->expiry_date) && ($row->expiry_date != "" && $row->expiry_date != "0000-00-00")) {
                    $expiry_date = date("d/m/Y", strtotime($row->expiry_date));
                }
                
                /*$modelStockLedgerHiring = StockLedgerHiring::model()->find(array('condition'=>'product_id='.$row['product_id'].' AND header_id='.$row['header_id'].' AND product_location_id='.$row['product_location_id']));
                $quantity =$modelStockLedgerHiring->quantity;
                */
                $div = '';
                /*if (isset(Yii::app()->user->havePermissionOn['direct_transfer_view']) || Yii::app()->user->authorised_user == 1) {
                    $div = '<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'iwarehouse/directcreate&type=view&id=' . $row['id'] . '\',\'Direct Transfer\',\'xl\')"><i class="fa fa-eye"></i></button>';
                }
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inv_directtransfer_pdf"])) {
                    $div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintDirectTransferPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
    
                }*/
                $rowData[] = array($row['id'], $row['part_number'],$row['product']['oem_number'], $row['description'], $row['quantity'], $row['serial_no'], $expiry_date,$row['product']['unit']['symbol']);
                $m++;
            }
            $data['data'] = $rowData;
            echo json_encode($data);
        }
        
        public function actionHiringItems()
    	{
    		$this->render('hiring_location_list');
    	}
    	
    	 public function actionGetHiringMachineList()
        {
    
            $model = new ProductLocationHiringDetails();
            $draw = $_POST['draw'];
            $offset = $_POST['start'];
            $limit = $_POST['length'];
            $columns = array(
    
                // datatable column index  => database column name
    
                0 => 't.id',
                1 => 't.part_number',
                2 => 'product.oem_number',
                3 => 't.description',
                4 => 'quantity',
                5 => 'serial_no',
                6 => 'expiry_date',
                //7 => 'symbol',
            );
    
            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder = $_POST['order'][0]['dir'];
            $orderBy = $filterColumn . " " . $filterOrder;
            $condition = 'product.machine_type="M"';
            //$condition = '1=1';
    
            if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
                $searchString = $_POST['search']['value'];
                $condition .= " AND (t.id LIKE '%" . $searchString . "%' OR product.hiring_part_number LIKE '%" . $searchString . "%' OR product.description LIKE '%" . $searchString . "%' OR product.oem_number LIKE '%" . $searchString . "%' OR product_class LIKE '%" . $searchString . "%' OR t.serial_no LIKE '%" . $searchString . "%')";
            }
            $count = $model->with('product','product.brand_detail')->count(array('condition' => $condition,'group'=>'product_id,serial_no'));
            $model = $model->with('product','product.brand_detail')->findAll(array('select'=>'product_id,serial_no,expiry_date,warehouse_id,sum(quantity) as quantity','condition' => $condition, 'limit' => $limit, 'offset' => $offset,'group'=>'product_id,serial_no', 'order' => $orderBy));
            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData = array();
            $m = 1;
    
            foreach ($model as $row) {
                $expiry_date="";
                if (!empty($row->expiry_date) && ($row->expiry_date != "" && $row->expiry_date != "0000-00-00")) {
                    $expiry_date = date("d/m/Y", strtotime($row->expiry_date));
                }
                $tr_color='N'; //Variable used to assign color 
                if($row['quantity']==0){
                    //External Transfer Checking
                    $model_hire_qty_desc=ProductLocationHiringDetails::model()->find(array('condition' =>'product_id="'.$row['product_id'].'" and serial_no="'.$row['serial_no'].'" and quantity=0','order'=>'id desc'));
                    $model_stockledger_external_transfer_hiring=StockLedgerHiring::model()->find(array('condition' =>'transaction_type="HIRE_INDIRECT_TRANSFER_OUT" and product_id="'.$row['product_id'].'" and product_location_id="'.$model_hire_qty_desc->id.'"'));            
                    if($model_stockledger_external_transfer_hiring->id>0){
                        $tr_color='E'; //External transfer from Hire Inventory
                    }
                    //Hiring Sold
                    $model_stockledger_hiring_sold=StockLedgerHiring::model()->find(array('condition' =>'transaction_type="HIRING_SOLD_OUT" and product_id="'.$row['product_id'].'" and product_location_id="'.$model_hire_qty_desc->id.'"'));            
                    if($model_stockledger_hiring_sold->id>0){
                        $tr_color='S'; //External transfer from Hire Inventory
                    }
                }
                if($row['quantity']==1){
                    $model_damage_qty=ProductLocationHiringDetails::model()->find(array('condition' =>'product_id="'.$row['product_id'].'" and serial_no="'.$row['serial_no'].'" and quantity=1'));
                    if($model_damage_qty->warehouse->warehouse_code=="DAM"){
                        $tr_color='D'; //If product is damage
                    }
                }
                //Year of Manufacture
                $model_pdt_yom=MachineProfile::model()->find(array('condition' =>'product_id="'.$row['product_id'].'" and serial_no="'.$row['serial_no'].'"'));
                $rowData[] = array($m, $row['product']['hiring_part_number'].' <a href="javascript:void(0);" class="machine_location_over" id="machinelocationhelper_'.$m.'_'.$row['product_id'].'_'.$row['serial_no'].'"><i class="fa fa-shopping-cart "><div class="triangle-right"></div></i></a>',$row['product']['oem_number'],$row['product']['brand_detail']['product_class'], $row['product']['description'], $row['quantity'],$row['serial_no'], $expiry_date,$row['product']['unit']['symbol'],$tr_color,$row['product_id'],$model_pdt_yom->year_manufacture);
                $m++;
            }
            $data['data'] = $rowData;
            echo json_encode($data);
        }
        
        public function actionHiringSpareItems()
    	{
    		$this->render('hiring_spare_location_list');
    	}
        
        public function actionGetHiringSpareList()
        {
    
            $model = new ProductLocationHiringDetails();
            $draw = $_POST['draw'];
            $offset = $_POST['start'];
            $limit = $_POST['length'];
            $columns = array(
    
                // datatable column index  => database column name
    
                0 => 't.id',
                1 => 't.part_number',
                2 => 'product.oem_number',
                3 => 'brand_detail.product_class',
                4 => 't.description',
                5 => 'quantity',
                6 => 'quantity',
                7 => 'quantity',
                8 => 'quantity',
                9 => '',
            );
    
            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder = $_POST['order'][0]['dir'];
            $orderBy = $filterColumn . " " . $filterOrder;
            $condition = 'product.machine_type="S"';
            if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
                $searchString = trim($_POST['search']['value']);
                $condition .= " AND (t.id LIKE '%" . $searchString . "%' OR product.hiring_part_number LIKE '%" . $searchString . "%' OR product.description LIKE '%" . $searchString . "%' OR product.oem_number LIKE '%" . $searchString . "%' OR product_class LIKE '%" . $searchString . "%' OR t.serial_no LIKE '%" . $searchString . "%')";
            }
            $count = $model->with('product','product.brand_detail','warehouse')->count(array('condition' => $condition,'group'=>'product_id'));
            $model = $model->with('product','product.brand_detail','warehouse')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset,'group'=>'product_id,serial_no', 'order' => $orderBy));
            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData = array();
            $m = 1;
    
            foreach ($model as $row) {
                $available_qty=$damage_qty=$qty_hire=$total_qty=0;
                //Available Quantity
                $model_qty_available = ProductLocationHiringDetails::model()->with('warehouse')->find(array('select'=>'sum(quantity) as quantity','condition' =>'t.product_id="'.$row['product_id'].'" and warehouse.warehouse_code!="DAM"'));
                if($model_qty_available->quantity>0){
                    $available_qty=$model_qty_available->quantity;
                }
                //Damage Quantity
                $model_qty_damage = ProductLocationHiringDetails::model()->with('warehouse')->find(array('select'=>'sum(quantity) as quantity','condition' =>'t.product_id="'.$row['product_id'].'" and warehouse.warehouse_code="DAM"'));
                if($model_qty_damage->quantity>0){
                    $damage_qty=$model_qty_damage->quantity;
                }
                $model_stock_qty_in = StockLedgerHiring::model()->with('product_location')->find(array('select'=>'sum(t.quantity) as quantity','condition' =>'(t.transaction_type="UPLOAD_HIRING_TRANSFER_IN" OR  t.transaction_type="HIRING_TRANSFER_IN" OR t.transaction_type="INDIRECT_TRANSFER_IN") and t.product_id="'.$row['product_id'].'"'));              
                $model_stock_qty_out_or_return = StockLedgerHiring::model()->with('product_location_hiring')->find(array('select'=>'sum(t.quantity) as quantity','condition' =>'(t.transaction_type="HIRING_TRANSFER_OUT" OR  t.transaction_type="HIRING_RETURN_IN" OR t.transaction_type="DELIVERY_NOTE_CANCEL" OR t.transaction_type="INDIRECT_TRANSFER_OUT") and t.product_id="'.$row['product_id'].'"'));
                if($model_stock_qty_out_or_return->quantity<0){
                    $qty_hire=-1*$model_stock_qty_out_or_return->quantity;
                }else{
                    $qty_hire=$model_stock_qty_out_or_return->quantity;
                }
                $total_qty=$model_stock_qty_in->quantity;
                $rowData[] = array($m, $row['product']['hiring_part_number'].' <a href="javascript:void(0);" class="spare_location_over" id="sparelocationhelper_'.$m.'_'.$row['product_id'].'"><i class="fa fa-shopping-cart "><div class="triangle-right"></div></i></a>',$row['product']['oem_number'],$row['product']['brand_detail']['product_class'], $row['product']['description'],number_format((float)$available_qty, 3, '.', ''),number_format((float)$qty_hire, 3, '.', ''),number_format((float)$damage_qty, 3, '.', ''),number_format((float)$total_qty, 3, '.', ''),$row['product']['unit']['symbol']);
                $m++;
            }
            $data['data'] = $rowData;
            echo json_encode($data);
        }
    public function actionremoveitem(){
        $id = $_POST['id'];
        if($id>0){
             InventoryHiringTransferItem::model()->deleteByPk($id);
             $status['status'] = 'success';
        }else{
            $status['status'] = 'error';
         }
         echo CJSON::encode($status);
     }
    public function actionGetbin(){
        $row = $_POST['row_field'];
        $rack_id = $_POST['rack_id'];
        $drop = array();
        $model = new StockLedger() ;
        $drop['dropdown'] = CHtml::activedropdownlist($model, "[".$row."]bin_id",MasInvBin::getBins_rackwise($rack_id), array('class'=>'form-control','empty'=>'Select'));        
        echo CJSON::encode($drop);
    }
    public function actionGetLocationDetails() {
        $product_id = (int) $_POST['id'];
        $serial_no = $_POST['serial_no'];
        $condition='product_id="'.$product_id.'" and quantity>0';
        if($serial_no!=''){
             $condition.=' and serial_no="'.$serial_no.'"';
        }
        $model_locations = ProductLocationHiringDetails::model()->findAll(array('condition' =>$condition));
        $this->renderPartial('location_details',array('model_locations'=>$model_locations), false, true); 
    }
}