<?php

class HiringreturnController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Create',  'Getfileno', 'SaveReturn', 'getOrderDescription','printFile','GetorderDetails','Gethiringreturndetails'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionCreate() {
        $model = new Creditnote();
        $modelAdd = array(new CreditnoteAddition());
        $modelDed = array(new CreditnoteDeduction());

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'modelAdd' => $modelAdd, 'modelDed' => $modelDed));
    }

   public function actionGetfileno() {
        $searchTerm = $_GET['term'];
        $condition = '(t.file_id LIKE "%' . $searchTerm . '%" OR t.id LIKE "%' . $searchTerm . '%") AND t.sales_group=2';
        $model = new Order();
        $model = $model->with('customer')->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->file_id . ' : ' . $eachModel->id; //$eachModel->invoicetype->inv_code.'-'.
            $data[$i]['currency'] = $eachModel->currencyname->currency;
            $data[$i]['currency_id'] = $eachModel->currencyname->id;
            $data[$i]['exchangerate'] = $eachModel->currencyname->exchange_rate;
            $data[$i]['customer_id'] = $eachModel->customer_id;
            $data[$i]['customer_name'] = $eachModel->customer->customer_name;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionGetOrderDescription() {
        /*$model_settings = new MasCompanySettings();
        $crm_login_company_id = Yii::app()->user->master_user_company_id;
        $model_settings = $model_settings->find(array('condition' => 'crm_company_id=' . $crm_login_company_id));
        $bonus_quantity = $model_settings->bonus_quantity;*/
        $order_id = (int) Yii::app()->request->getParam('id');
        $model = Order::model()->findByPk($order_id);
        $data['customer_name'] = $model->customer->customer_name;
        $data['customer_id'] = $model->customer_id;
        $delitems = HiringPackageDetails::model()->with('deliveryNote')->findAll(array('condition' => 't.order_id=' . $order_id.' AND t.quantity>0 AND consumable="N" AND deliveryNote.status="CL"'));
        //$delitems = DeliveryNoteItem::model()->with('orderitem','deliveryNote')->findAll(array('condition' => 'orderitem.order_id=' . $order_id.' AND deliveryNote.ready_to_invoice ="Y"'));
        $tbl = '<table class="table table-hover table-bordered personal-task" id="credit_item_table">        
            <tr>            
            <th>No</th>  
            <th>Dy.No/Date</th>
            <th>Product</th>            
            <th>Description</th>            
            <th>Batch</th>            
            <th>Serial</th>            
            <th>Qty(Picked)</th>  
            <th>Damaged Qty</th>
            <th>Unit</th>            
            <th>Qty.(Returning)<span style="color : red;">(Base Qty)</th> 
            <th>Damage Qty.(Returning)<span style="color : red;"></th>
            <th>Remarks</th>        
           </tr>';
        $data_exist=0;   
        foreach ($delitems as $i => $eachRow) {
            $factor = 1;
            $model = new CreditnoteItem;
            $store = Store::model()->findByPk($eachRow->product_id);
            $model->unit = $store->unit_id;
            $total_qt= $eachRow->quantity;
            $total_qty = $eachRow->quantity-$eachRow->damage_quantity;
            $cndtn='t.invoice_item_id="' . $eachRow->id . '" AND t.product_id="' . $eachRow->product_id . '" AND t.returned_quantity !="0"';
            $return_qty = CreditnoteItem::model()->with('orderunit')->find(array('select' => '(SUM(t.returned_quantity+t.damage_quantity)) * orderunit.factor AS returned_quantity', 'condition' => $cndtn, 'group' => 't.product_id'))->returned_quantity;
            if ($return_qty < 1) {
                $return_qty = 0;
            }
            $total_return = $return_qty;
            $total_remaining = $total_qty - $total_return;
            $balance_without_damage=$total_qt-$return_qty;
            if ($total_remaining < 1) {
                $total_remaining = 0;
            }
            if ($balance_without_damage < 1) {
                $balance_without_damage = 0;
            }
            $tax_amount=0;
            if($balance_without_damage>0){
                $data_exist=1;
                $tbl .= '<tr>';
                $tbl .= '<td>' . ($i + 1) . '</td>';
                $tbl .= '<td>' .date("d/m/Y",strtotime($eachRow->deliveryNote->delivery_date)) . '</td>';
                $tbl .= '<td><input type="hidden" id="credits_note_productname_' . $i . '" value="' . $store->hiring_part_number . '">' . $store->hiring_part_number
                        . CHtml::activeHiddenField($model, "[$i]product_id", array('value' => $eachRow->product_id)) .
                        CHtml::activeHiddenField($model, "[$i]description", array('value' => $store->description)) .
                        CHtml::activeHiddenField($model, "[$i]invoice_item_id", array('value' => $eachRow->id))
                        . CHtml::activeHiddenField($model, "[$i]rate", array('value' => ''))
                        . CHtml::activeHiddenField($model, "[$i]deliverynote_id", array('value' => $eachRow->delivery_id))
                        . CHtml::activeHiddenField($model, "[$i]id", array('value' =>''))
                        . CHtml::activeHiddenField($model, "[$i]product_loc_hiring_id", array('value' =>$eachRow->product_loc_hiring_id))
                        . CHtml::activeHiddenField($model, "[$i]unit", array('value' => $store->unit_id))
                        . CHtml::hiddenField("CreditnoteItem[$i][total_return]", $total_return,array('id'=>"CreditnoteItem_".$i."_total_return"))
                        . CHtml::hiddenField("CreditnoteItem[$i][total_damage]", $eachRow->damage_quantity,array('id'=>"CreditnoteItem_".$i."_total_damage"))
                        . CHtml::hiddenField("CreditnoteItem[$i][total_quantity]", $total_qt,array('id'=>"CreditnoteItem_".$i."_total_quantity"))
                        . CHtml::hiddenField("CreditnoteItem[$i][total_remaining]", $total_remaining,array('id'=>"CreditnoteItem_".$i."_total_remaining")) .'</td>';
                $tbl .= '<td>' . $store->description . '</td>';
                $tbl .= '<td>' . $eachRow->batch_no . '</td>';
                $tbl .= '<td>' . $eachRow->serial_no . '</td>';
                $tbl .= '<td>' . $total_remaining. '</td> ';
                $tbl .= '<td>' . $eachRow->damage_quantity . '</td> ';
                $tbl .= '<td>' . $store->unit->symbol.'</td> ';
                $tbl .= '<td class="cell-right">' . CHtml::activeHiddenField($model, "[$i]quantity", array('value' =>$total_remaining))
                        . CHtml::activeHiddenField($model, "[$i]net_rate", array('class' => 'rate go text-right to_be_calculated', 'readonly' => 'true', 'value' => '')) 
                        . CHtml::activeHiddenField($model, "[$i]tax_vat_amount", array('value' => 0))
                        . CHtml::activeHiddenField($model, "[$i]net_amount", array('class' => 'rate go text-right to_be_calculated', 'readonly' => 'true')) 
                        . CHtml::activeHiddenField($model, "[$i]tax_vat_percentage", array('class' => 'rate go text-right to_be_calculated', 'readonly' => 'true', 'value' => ''))
                        . CHtml::activeTextField($model, "[$i]returned_quantity", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isNumberKey(event);', 'onkeyup' => 'checkquantity(this.id,this.value);')) . '</td>';
                 $tbl .= '<td class="cell-right">'. CHtml::activeTextField($model, "[$i]damage_quantity", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isNumberKey(event);', 'onkeyup' => 'checkdamagequantity(this.id,this.value);')) . '</td>';
                 $tbl .= '<td>' . CHtml::activeTextArea($model, "[$i]remarks", array('class' => 'go cell-center')).'</td> ';   
                $tbl .=  '</tr>';
            }
        }
        if($data_exist==0){
            $tbl .=  '<tr><td colspan="12" class="text-center text-bold">No Item Exist</td></tr>';
        }
        $tbl .= '</table>';
        $data['tbl'] = $tbl;
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionSaveReturn() {
        $modelCreditNote = new Creditnote;
        if (isset($_POST['Creditnote'])) {

            $modelCreditNote->scenario = 'add';
            $modelCreditNote->attributes = $_POST['Creditnote'];
            $modelorder = Order::model()->findByPk($_POST['Creditnote']['order_id']);
            $modelCreditNote->file_id = $modelorder->file_id;
            $modelCreditNote->invoice_id = 0;
            $modelCreditNote->order_id = $_POST['Creditnote']['order_id'];
            $modelCreditNote->tax_type = $modelorder->tax_type;
            $modelCreditNote->invoice_type = $modelorder->invoice_type;
            $modelCreditNote->customer_id = $_POST['customer_id'];
            $modelCreditNote->contact_id = $modelorder->contact_id;
            $modelCreditNote->created_datetime = date('Y-m-d h:i:s');
            $modelCreditNote->credited_date = date('Y-m-d', strtotime( str_replace('/', '-', $_POST['Creditnote']['credited_date']) ));
            $modelCreditNote->crm_user_id = Yii::app()->user->id;
            $modelCreditNote->created_by = Yii::app()->user->id;
            $modelCreditNote->is_hiring ='Y';
            $return_update = $_POST['Creditnote']['sales_return'];
            $modelCreditNote->sales_return = $_POST['Creditnote']['sales_return'];
            $other_errors = array();
            $grand_total = 0;
            $valid1 = true;
            $valid = true;$i=0;
            foreach ($_POST['CreditnoteItem'] as $j => $item) {
                if ($item['product_id']>0 && ($item['returned_quantity']>0 || $item['damage_quantity']>0)) {
                    $modelItem[$i] = new CreditnoteItem;
                    $modelItem[$i]->attributes = $_POST['CreditnoteItem'][$j];
                    $modelItem[$i]->description = $item['description'];
                    $modelItem[$i]->tax_vat_percentage =$item['tax_vat_percentage'];
                    $modelItem[$i]->tax_vat_amount = $item['tax_vat_amount'];
                    $modelItem[$i]->deliverynote_id =$item['deliverynote_id'];
                    $modelItem[$i]->unit = $item['unit'];
                    $modelItem[$i]->product_loc_hiring_id = $item['product_loc_hiring_id'];
                    $modelItem[$i]->damage_quantity = $item['damage_quantity'];
                    $valid = $modelItem[$i]->validate() && $valid;
                    $i++;
                }
            }
            $valid = $valid && is_array($modelItem);
            if ($modelCreditNote->validate() && $valid) { // after validation saving the whole data 
                $modelCreditNote->save();
                $modelCreditNote->refresh();
                // inserting to audit log
                 AuditLog::saveAuditLogs(
                    'HIRING_RETURN',
                    Yii::app()->user->id,
                    'CREATED',
                    " Checking No: - {$modelCreditNote->id}   "
                );
                // end audit log 
                $jsonData['shoratage'] = "";
                $total_tax_amount = 0;
                foreach ($modelItem as $eachItem) {
                    $eachItem->creditnote_id = $modelCreditNote->id;
                    $eachItem->save(false);
                    //Damage Quantity
                    if($eachItem->damage_quantity>0){
                        $model_pkg_hiring = HiringPackageDetails::model()->findbyPK($eachItem->invoice_item_id);
                        HiringPackageDetails::model()->updateByPK($eachItem->invoice_item_id, array('damage_quantity' =>($model_pkg_hiring->damage_quantity-$eachItem->damage_quantity)));
                    }
                    $grand_total += $eachItem->net_amount;
                    $total_tax_amount += $eachItem->tax_vat_amount;
                }
                $grand_total += $total_tax_amount;
                $modelCreditNote->updateByPk($modelCreditNote->id, array('credited_amount' => $grand_total, 'total_tax_amount' => $total_tax_amount));
                //Updating end date of operator table
                $model_creditnote_quantity = CreditnoteItem::model()->with('parent')->find(array('select'=>'SUM(t.returned_quantity+t.damage_quantity) AS returned_quantity','condition'=>'parent.order_id="'.$_POST['Creditnote']['order_id'].'"'));
                $model_deliveryitem_quantity = DeliveryNoteItem::model()->with('deliveryNote')->find(array('select'=>'SUM(t.picked_qty) as picked_qty','condition'=>'deliveryNote.order_id="'.$_POST['Creditnote']['order_id'].'"'));
                $balance_quantity_exist=$model_deliveryitem_quantity->picked_qty-$model_creditnote_quantity->returned_quantity;
                if($balance_quantity_exist<=0){
                    HiringOperator::model()->updateAll(array('end_date' =>$modelCreditNote->credited_date), 'order_id="'.$_POST['Creditnote']['order_id'].'" and end_date="0000-00-00"');
                }
                $jsonData['file'] = $modelCreditNote->file;
                $jsonData['model'] = $modelCreditNote;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error5 = array();
                $error1 = json_decode(CActiveForm::validate($modelCreditNote, '', false), true);

                if (!empty($modelItem[0]->product_id))
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";

               
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$error5));

                if ($error != '[]')
                    echo $error;
            }
            Yii::app()->end();
        }
    }
    public function actionPrintFile() {


        $id = Yii::app()->request->getParam('id');
        $file_id = Yii::app()->request->getParam('file');
        $customer_id = Yii::app()->request->getParam('customer');
        $frm = Yii::app()->request->getParam('frm');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.creditnote_individual_hiring', array('id' => $id, 'file_id' => $file_id, 'customer_id' => $customer_id), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }
    public function actionGetorderDetails() {
        $customer_id = $_POST['customer_id'];
        $model = Order::model()->findAll(array('condition' =>'order_type="H" and customer_id="'.$customer_id.'"','order'=>'id DESC','limit'=>'100'));       
        $i = 0;
        $data=array();
        foreach ($model as $eachModel) {
            $data[$i]['id'] = $eachModel->id;
            $data[$i]['file_id'] = $eachModel->file_id . ' : ' . $eachModel->id; 
            $i++;
        }
        $order_details=CHtml::listData($data, 'id', 'file_id');
        $drop_down=CHtml::dropDownList('tax_invoice_id', '',$order_details,  array('class' => 'tooltipster', 'title' => 'File No/Order No','data-label'=>'File No/Order No <span style="color:red">*</span>','data-search'=>true,'empty'=>'Select','onchange' => 'gethiringreturndetails(this.value);'));   
        echo CJSON::encode( array('details'=>$drop_down));
    }
    public function actionGethiringreturndetails() {
        $order_id = $_POST['order_id'];
        $model = Order::model()->findByPk($order_id);
        echo CJSON::encode( array(
            'currency'=>$model->currencyname->currency,
            'currency_id'=>$model->currencyname->id,
            'exchangerate'=>$model->currencyname->exchange_rate,
            'customer_id'=>$model->customer_id,
            'customer_name'=>$model->customer->customer_name,
                ));
    }
} 
?>