<?php

class HiringreportsController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('loadconsumablelist', 'excelconsumablelist', 'GetHiringStockState', 'PrintHiringStockStateAsofDetailed','loadoperatorlist',
                                    'exceloperatorlist','loadoperatortimesheet','exceloperatortimesheet','loadoperatorwagesheet','exceloperatorwagesheet'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionloadconsumablelist() {

        $customer_id = $_POST['customer_id'];
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('//hiringreports/consumable_list', array('customer_id' => $customer_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }

    public function actionexcelconsumablelist() {
        $customer_id = $_GET['customer_id'];
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        $filename = 'consumablelist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('excel_consumable_list', array('customer_id' => $customer_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
        Yii::app()->end();
    }

    //added on 23-1-2020
    public function actionGetHiringStockState() {
        $model = new Store();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $searchString = trim($_POST['search']['value']);

        $to_date = ( count(explode('/', $_POST['to_date'])) == 3 ) ? date('Y-m-d', strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-d');

        $generic_id = (int) $_POST['generic_id'];

        $brand_id = (int) $_POST['brand_id'];

        $warehouse = (int) $_POST['warehouse'];



        $condition = 'quantity != 0';

        if ($generic_id > 0)
            $condition .= ' AND generic_id=' . $generic_id;

        if ($brand_id > 0)
            $condition .= ' AND brand_id=' . $brand_id;

        if ($searchString != '')
            $condition .= ' AND part_number LIKE "%' . $searchString . '%"';


        $stock_state_as_of_query = 'CREATE OR REPLACE VIEW view_hiring_stock_state_as_of AS

                                        SELECT S.id AS product_id, S.hiring_part_number AS part_number, S.description AS description,

                                        S.alias_name AS alias_name, B.product_class AS brand, G.generic_name AS generic_name,

                                        S.brand_class_id AS brand_id, S.generic_id AS generic_id ,SUM(L.quantity) AS quantity,

                                        SUBSTRING_INDEX( GROUP_CONCAT(CAST(L.cost_price AS CHAR) ORDER BY L.transaction_date DESC), ",", 1 ) AS rate,PL.batch_no AS batch_no,
                                        PL.expiry_date AS expiry_date,PL.serial_no AS serial_no, L.product_location_id 

                                        FROM erp_stock_ledger_hiring L

                                        LEFT JOIN erp_store S ON S.id = L.product_id LEFT JOIN erp_product_class B ON S.brand_class_id = B.id

                                        LEFT JOIN erp_inventory_generic_name G ON S.generic_id = G.id 
                                        LEFT JOIN erp_mas_inv_warehouse warehouse ON L.warehouse_id = warehouse.id 
                                        
                                        LEFT JOIN erp_product_location_hiring_details PL ON  L.product_location_id=PL.id  
                                        
                                        WHERE S.inventory_item_type IN (1,3) AND L.transaction_date <= "' . $to_date . '"											
                                        AND warehouse.warehouse_code!="DAM"
										
                                        GROUP BY L.product_id,PL.serial_no ORDER BY S.part_number';



        Yii::app()->db->createCommand($stock_state_as_of_query)->execute();



        $count = Yii::app()->db->createCommand('SELECT COUNT(product_id) AS count FROM view_hiring_stock_state_as_of WHERE ' . $condition)->queryScalar();

        $model = Yii::app()->db->createCommand('SELECT * FROM view_hiring_stock_state_as_of WHERE ' . $condition . ' ORDER BY part_number LIMIT ' . $limit . ' OFFSET ' . $offset)->queryAll();

        $totalValue = Yii::app()->db->createCommand('SELECT SUM(quantity*rate)  AS total FROM view_hiring_stock_state_as_of WHERE ' . $condition)->queryScalar();

        $totalValue = number_format(round(($totalValue), 4), 2, '.', '');

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $rowData = array();


        $product_id = "";
        $row_no = 0;
        foreach ($model as $i => $row) {

            $class_repeat = "no";
            $part_number = "";
            $description = "";
            $generic_name = "";
            $brand_name = "";
            $row_show_no = "";
            if ($product_id == $row['product_id']) {
                $class_repeat = 'yes';
                $product_id = $row['product_id'];
                $part_number = "";
                $description = "";
                $generic_name = "";
                $brand_name = "";
                $row_show_no = "";
            } else {
                $product_id = $row['product_id'];

                $part_number = $row['part_number'];
                $description = $row['description'];
                $generic_name = $row['generic_name'];
                $brand_name = $row['brand'];
                $row_no = $row_no + 1;
                $row_show_no = $row_no;
            }

            $total = number_format(round(($row['quantity'] * $row['rate']), 4), 2, '.', '');

            $rowData[] = array($row_show_no, $part_number, $description, $generic_name, $brand_name, $row['serial_no'], $row['batch_no'], ($row['expiry_date'] != "0000-00-00") ? date("d/m/Y", strtotime($row['expiry_date'])) : "", Yii::app()->numberFormatter->formatCurrency($row['quantity'], ""), Yii::app()->numberFormatter->formatCurrency(round($row['rate'], 2), ""), $total, $class_repeat);
        }

        $data['draw'] = $draw;

        $data['total'] = (float) $totalValue;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $data['data'] = $rowData;

        echo json_encode($data);
    }

    public function actionPrintHiringStockStateAsofDetailed() {

        $to_date = ( count(explode('/', $_GET['to_date'])) == 3 ) ? date('Y-m-d', strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');

        $generic_id = (int) $_GET['generic_id'];

        $brand_id = (int) $_GET['brand_id'];

        $searchString = $_GET['part_no'];

        $type = $_GET['type'];



        $condition = 'quantity != 0';

        if ($generic_id > 0)
            $condition .= ' AND generic_id=' . $generic_id;

        if ($brand_id > 0)
            $condition .= ' AND brand_id=' . $brand_id;

        if ($searchString != '')
            $condition .= ' AND part_number LIKE "%' . $searchString . '%"';



        $stock_state_as_of_query = 'CREATE OR REPLACE VIEW view_hiring_stock_state_as_of AS

                                        SELECT S.id AS product_id, S.hiring_part_number AS part_number, S.description AS description,

                                        S.alias_name AS alias_name, B.product_class AS brand, G.generic_name AS generic_name,

                                        S.brand_class_id AS brand_id, S.generic_id AS generic_id ,SUM(L.quantity) AS quantity,

                                        SUBSTRING_INDEX( GROUP_CONCAT(CAST(L.cost_price AS CHAR) ORDER BY L.transaction_date DESC), ",", 1 ) AS rate,PL.batch_no AS batch_no,
                                        PL.expiry_date AS expiry_date,PL.serial_no AS serial_no, L.product_location_id 

                                        FROM erp_stock_ledger_hiring L

                                        LEFT JOIN erp_store S ON S.id = L.product_id LEFT JOIN erp_product_class B ON S.brand_class_id = B.id

                                        LEFT JOIN erp_inventory_generic_name G ON S.generic_id = G.id 
                                        LEFT JOIN erp_mas_inv_warehouse warehouse ON L.warehouse_id = warehouse.id 
                                        
                                        LEFT JOIN erp_product_location_hiring_details PL ON  L.product_location_id=PL.id  
                                        
                                        WHERE S.inventory_item_type IN (1,3) AND L.transaction_date <= "' . $to_date . '"											
                                        AND warehouse.warehouse_code!="DAM"
										
                                        GROUP BY L.product_id,PL.serial_no ORDER BY S.part_number';

        Yii::app()->db->createCommand($stock_state_as_of_query)->execute();



        $model = Yii::app()->db->createCommand('SELECT * FROM view_hiring_stock_state_as_of WHERE ' . $condition . ' ORDER BY part_number')->queryAll();

        if ($type == 'excel') {

            $filename = 'hiring_stockstate_as_of_detailed' . date('dmYhis') . '.xls';

            $data = '<html>

                        <head>

                            <style>

                                table{

                                    width:100%;

                                }

                                .head{

                                    background-color : yellow;

                                    font-weight: bold;

                                    font-size: 14px;

                                }

                                .total{

                                    text-align: right;

                                    font-weight: bold;

                                    font-size: 14px;

                                }

                            </style>

                        </head>

                        <body>

                            <table border=1>

                                <thead>
                
                                    <th>No</th>

                                    <th>Part Number</th>

                                    <th>Description</th>

                                    <th>Generic</th>

                                    <th>Brand /Class</th>
                                    
                                    <th>Serial No</th>
                                    
                                    <th>Batch No</th>
                                    
                                    <th>Expiry Date</th>

                                    <th>Quantity</th>

                                    <th>Rate</th>

                                    <th>Value</th>

                                </thead>

                                <tbody>';

            foreach ($model as $row) {
                $part_number = "";
                $description = "";
                $generic_name = "";
                $brand_name = "";
                $row_show_no = "";
                $product_no = "";
                if ($product_id == $row['product_id']) {
                    $class_repeat = 'yes';
                    $product_id = $row['product_id'];
                    $part_number = "";
                    $description = "";
                    $generic_name = "";
                    $brand_name = "";
                    $row_show_no = "";
                    $product_no = "";
                    $tr_style = "style=background-color:#ADD8E6;";
                } else {
                    $product_id = $row['product_id'];
                    $product_no = $product_id;
                    $part_number = $row['part_number'];
                    $description = $row['description'];
                    $generic_name = $row['generic_name'];
                    $brand_name = $row['brand'];
                    $row_no = $row_no + 1;
                    $row_show_no = $row_no;
                    $tr_style = "style=background-color:#FFFFFF;";
                }

                $data .= '<tr ' . $tr_style . '>

                                                    <td>' . $product_no . '</td>

                                                    <td>' . $part_number . '</td>

                                                    <td>' . $description . '</td>

                                                    <td>' . $generic_name . '</td>

                                                    <td>' . $brand_name . '</td>

                                                    <td>' . $row['serial_no'] . '</td>

                                                    <td>' . $row['batch_no'] . '</td>';

                if ($row['expiry_date'] != "0000-00-00") {

                    $data .= '<td>' . date("d/m/Y", strtotime($row['expiry_date'])) . '</td>';
                } else {
                    $data .= '<td></td>';
                }

                $data .= '<td>' . Yii::app()->numberFormatter->formatCurrency($row['quantity'], "") . '</td>

                                                    <td>' . Yii::app()->numberFormatter->formatCurrency((round($row['rate'], 2)), "") . '</td>

                                                    <td>' . round(($row['quantity'] * $row['rate']), 2) . '</td>

                                                </tr>';
            }

            $data .= '</tbody>

                        </table>

                    </body>

                </html>';

            header("Content-type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
            echo $data;

            Yii::app()->end();

            return;
        } else {

            $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

            $mpdf->WriteHTML($stylesheet, 1);

            $mpdf->WriteHTML($this->renderPartial('application.views.front.hiringreports.pdf.hiring_stock_state_as_of_detailed', array('to_date' => $to_date, 'model' => $model, 'generic_id' => $generic_id, 'brand_id' => $brand_id), true));

            $mpdf->Output("hiring_stock_state_as_of_" . date('dmYhis') . ".pdf", 'I');
        }
    }
    public function actionloadoperatorlist() {

        $employee_id = $_POST['employee_id'];
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $oprtr_status=$_POST['oprtr_status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('//hiringreports/operator_list', array('employee_id' => $employee_id, 'from_date' => $from_date, 'to_date' => $to_date,'oprtr_status'=>$oprtr_status), false, true);
    }

    public function actionexceloperatorlist() {
        $employee_id = $_GET['employee_id'];
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        $oprtr_status=$_GET['oprtr_status'];
        $filename = 'operator_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('excel_operator_list', array('employee_id' => $employee_id, 'from_date' => $from_date, 'to_date' => $to_date,'oprtr_status'=>$oprtr_status), false, true);
        Yii::app()->end();
    }
    public function actionloadoperatortimesheet() {

        $employee_id = $_POST['employee_id'];
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $condition='isActive!="B"';
        if ($employee_id != '') {
            $condition .= ' AND id= "' . $employee_id . '"';
        }
        $model_employee = Employee::model()->findAll(array('condition' =>$condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value->employeefullname]=$value->id;
        }
        ksort($arr_employee);    
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('//hiringreports/operator_timesheet', array('arr_employee'=>$arr_employee,'employee_id' => $employee_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }
    public function actionexceloperatortimesheet() {
        $employee_id = $_GET['employee_id'];
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        $condition='isActive!="B"';
        if ($employee_id != '') {
            $condition .= ' AND id= "' . $employee_id . '"';
        }
        $model_employee = Employee::model()->findAll(array('condition' =>$condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value->employeefullname]=$value->id;
        }
        ksort($arr_employee);
        $filename = 'operator_timesheet.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('excel_operator_timesheet', array('arr_employee'=>$arr_employee,'employee_id' => $employee_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
        Yii::app()->end();
    }
    public function actionloadoperatorwagesheet() {

        $employee_id = $_POST['employee_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('//hiringreports/operator_wagesheet', array('employee_id' => $employee_id, 'month' => $month, 'year' => $year), false, true);
    }
    public function actionexceloperatorwagesheet() {
        $employee_id = $_GET['employee_id'];
        $month = $_GET['month'];
        $year = $_GET['year'];
        $filename = 'operator_wagesheet.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('excel_operator_wagesheet', array('employee_id' => $employee_id, 'month' => $month, 'year' => $year), false, true);
        Yii::app()->end();
    }
    
}
