<?php

class HiringoperatorController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Create','SaveOperators','RemovelineItem','getworkmindate','getmindate','Getemployee','checksetdateavailable'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $model_operators= HiringOperator::model()->findAll(array('condition'=>'order_id ="'.$id.'"'));
        if(empty($model_operators)){
            $model_operators = array(new HiringOperator());
        }
        //Min Date
        $rent_date=$work_date=$rent_date_1='';
        $model_delivery_note= DeliveryNote::model()->find(array('select'=>'min(rent_date) as rent_date','condition'=>'order_id="'.$id.'"'));
        if($model_delivery_note->rent_date!='0000-00-00' && $model_delivery_note->rent_date!=''){
            $rent_date_1=$model_delivery_note->rent_date;
            $rent_date=date("d/m/Y",strtotime($model_delivery_note->rent_date));
        }
        $model_end_date= OrderManhours::model()->find(array('select'=>'max(work_date) as work_date','condition'=>'order_id="'.$id.'"'));
        if($model_end_date->work_date!='0000-00-00' && $model_end_date->work_date!=''){
            if(strtotime($model_end_date->work_date)<strtotime($rent_date_1)){
                $work_date=$rent_date;
            }else{
                $work_date=date("d/m/Y",strtotime($model_end_date->work_date));
            }
        }else{
            $work_date=$rent_date;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model_operators' => $model_operators,'id' => $id,'rent_date'=>$rent_date,'work_date'=>$work_date));
    }
    public function actionSaveOperators() {       
        if ((isset($_POST['HiringOperator']))) {
            $i=0;
            $valid=true;
            foreach ($_POST['HiringOperator'] as $l => $items) {
                if($items['order_id']>0){
                    if($items['id']>0){
                        $model_operators[$i] = HiringOperator::model()->findByPK($items['id']);
                        $model_operators[$i]->updated_by= Yii::app()->user->id;
                        $model_operators[$i]->updated_date_time = date('Y-m-d h:i:s');
                    }else{
                        $model_operators[$i] = new HiringOperator();
                        $model_operators[$i]->created_by= Yii::app()->user->id;
                        $model_operators[$i]->created_date_time = date('Y-m-d h:i:s');
                    }
                    
                    $model_operators[$i]->employee_id = $items['employee_id'];
                    $model_operators[$i]->isActive = $items['isActive'];
                    $model_operators[$i]->order_id = $items['order_id'];
                    if ($items['start_date']!= '0000-00-00' && $items['start_date']!= '') {
                        $model_operators[$i]->start_date= date("Y-m-d", strtotime(str_replace('/', '-', $items['start_date'])));
                    }
                    if ($items['end_date']!= '0000-00-00' && $items['end_date']!= '') {
                        $model_operators[$i]->end_date= date("Y-m-d", strtotime(str_replace('/', '-', $items['end_date'])));
                        $model_operators[$i]->isActive ='R';
                    }
                    $valid = $model_operators[$i]->validate() && $valid;
                    $i++;
                }
            }
            if ($valid) {
                if (!empty($model_operators)) {
                    foreach ($model_operators as $eachModel) {
                        $eachModel->save();
                    } 
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else {
                if (!empty($model_operators))
    			$error = CJSON::encode(json_decode(CActiveForm::validateTabular($model_operators, '', false), true));
                else
                    $error[] = "Please add atleast one line item";
    			if ($error != '[]'||$error!='')
    				echo $error;
            }
        }
    }
    public function actionRemovelineItem(){
        $id = $_POST['id'];
         if($id>0){
            HiringOperator::model()->deleteByPk($id);
            $status['status'] = 'success';
         }else{
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actiongetworkmindate(){
        $id=$_POST['id'];
        $employee_id=$_POST['employee_id'];
        $model_hiringoperator =HiringOperator::model()->find(array('select'=>'min(start_date) as start_date','condition' => 'employee_id="'.$employee_id.'" and order_id="'.$id.'" '));  
        $model_hiringoperator_max =HiringOperator::model()->find(array('select'=>'max(start_date) as start_date,max(end_date) as end_date','condition' => 'employee_id="'.$employee_id.'" and order_id="'.$id.'" '));  
        $model_invoice_date =Invoice::model()->find(array('select'=>'max(invoice_end_date) as invoice_end_date','condition' => 'order_id="'.$id.'" ')); 
        if(strtotime($model_invoice_date->invoice_end_date)>strtotime($model_hiringoperator->start_date)){
            $model_hiringoperator->start_date=date('Y-m-d', strtotime('+1 days', strtotime($model_invoice_date->invoice_end_date)));
        }
        $jsonData['start_date'] =date("d/m/Y",strtotime($model_hiringoperator->start_date));
        $jsonData['end_date'] ='';
        if(strtotime($model_hiringoperator_max->start_date)>  strtotime($model_hiringoperator->end_date)){
            $model_hiringoperator->end_date='';
        }
        if($model_hiringoperator->end_date!=''  && $model_hiringoperator->end_date!='0000-00-00'){
            $jsonData['end_date'] =date("d/m/Y",strtotime($model_hiringoperator->end_date));
        }
        $jsonData['status'] ='success';
        echo CJSON::encode($jsonData);
    }
    public function actiongetmindate(){
        $id=$_POST['id'];
        $employee_id=$_POST['employee_id'];
        $model_hiringoperator =HiringOperator::model()->find(array('select'=>'max(start_date) as start_date,max(end_date) as end_date','condition' => 'employee_id="'.$employee_id.'" and order_id!="'.$id.'" '));  
        $start_date=$end_date=$min_date='';
        if($model_hiringoperator->start_date!=''  && $model_hiringoperator->start_date!='0000-00-00'){
            $start_date=$model_hiringoperator->start_date;
        }
        if($model_hiringoperator->end_date!=''  && $model_hiringoperator->end_date!='0000-00-00'){
            $end_date=$model_hiringoperator->end_date;
        }
        if(strtotime($start_date)>  strtotime($end_date)){
            $min_date=$start_date;
        }else{
            $min_date=$end_date;
        }
        //Checking with rent date
        $model_delivery_note= DeliveryNote::model()->find(array('select'=>'min(rent_date) as rent_date','condition'=>'order_id="'.$id.'"'));
        if($model_delivery_note->rent_date!='0000-00-00' && $model_delivery_note->rent_date!=''){
            $rent_date_1=$model_delivery_note->rent_date;
            if(strtotime($rent_date_1)>strtotime($min_date)){
                $min_date=$rent_date_1;
            }
        }
        $jsonData['min_date'] =date("d/m/Y",strtotime($min_date));;
        $jsonData['status'] ='success';
        echo CJSON::encode($jsonData);
    }
    public function actionGetemployee() {
        $row = $_POST['row_field'];
        $start_date = $_POST['start_date'];
        $order_id = $_POST['order_id'];
        $drop = array();
        $model_operator = new HiringOperator;
        $drop['drop'] = CHtml::activedropdownlist($model_operator, "[" . $row . "]employee_id",HiringOperator::getOperatordetail($start_date,$order_id), array('data-label' => 'Operator Name', 'class' => 'go', 'empty' => 'Select'));        
        echo CJSON::encode($drop);
    }
    public function actionchecksetdateavailable(){
        $order_id=$_POST['id'];
        $employee_id=$_POST['employee_id'];
        $start_date=$_POST['work_date'];
        if($start_date!='' && $start_date!='00/00/0000'){
            $start_date=date("Y-m-d", strtotime(str_replace('/', '-', $start_date)));
        }
        $SQL ="SELECT  employee_id FROM  erp_hiring_operator where (order_id='".$order_id."' AND employee_id='".$employee_id."' AND (start_date='".$start_date."' OR (start_date<='".$start_date."' AND end_date>='".$start_date."') OR (start_date<='".$start_date."' AND end_date='0000-00-00')))"; 
        $model = Yii::app()->db->createCommand($SQL)->queryAll(); 
        if(empty($model)){
            $jsonData['status'] ='error';
        }else{
            $jsonData['status'] ='success';
        }
        echo CJSON::encode($jsonData);
    }
} 
?>