<?php
class HiringdamageController extends Controller
{
    public function accessRules() {
          return array(
              array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),

                ),
              array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('repair','GetHiringProducts','getdamagelist','SaveRepair','Damage','loadpdtdetails','SaveDamage'),
                'expression' => '$user->isMember()',
                ),
              array('deny', // deny all users
                'users' => array('*'),
                ),
              );
      }
    public function actionRepair() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('repair');
    }
    public function actionGetHiringProducts() {
        $searchTerm = $_GET['term'];
        $type = $_GET['type'];
        $condition = '(t.hiring_part_number LIKE "%' . $searchTerm . '%" OR t.machine_id LIKE "%' . $searchTerm . '%" OR t.description LIKE "%' . $searchTerm . '%")';
        if($type!=''){
            $condition.= ' AND t.machine_type="'.$type.'"';
        }
        $model = Store::model()->findAll(array('select' => 'id,hiring_part_number,description,machine_id', 'condition' => $condition, 'limit' => 200));        
        $data=array();
        foreach ($model as $i=>$eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->hiring_part_number.' : '.$eachModel->description;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }  
    public function actiongetdamagelist() {
        $type = $_POST['type'];
        $product_id = $_POST['product_id'];
        $condition = 'warehouse.warehouse_code="DAM" and quantity>0';
        if ($type!='') {
            $condition.=' AND product.machine_type="'.$type.'"';
        }  
        if ($product_id > 0) {
            $condition.=' AND product_id="'.$product_id.'"';
        }  
        $model_details = ProductLocationHiringDetails::model()->with('warehouse','product')->findAll(array('condition' => $condition));
        $model_repair =new HiringRepairHistory();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('damage_product_details', array('model_details' => $model_details,'model_repair'=>$model_repair));
    }
    public function actionSaveRepair() {       
        if ((isset($_POST['HiringRepairHistory']))) {
            $i=0;
            $valid=true;
            foreach ($_POST['HiringRepairHistory'] as $l => $items) {
                if($items['repair_quantity']>0){
                    $model_repair[$i] = new HiringRepairHistory();
                    $model_repair[$i]->product_id = $items['product_id'];
                    $model_repair[$i]->pdt_location_id = $items['pdt_location_id'];
                    $model_repair[$i]->damage_quantity = $items['damage_quantity'];
                    $model_repair[$i]->repair_quantity = $items['repair_quantity'];
                    $model_repair[$i]->warehouse_id = $items['warehouse_id'];
                    if ($items['repair_date']!= '0000-00-00' && $items['repair_date']!= '') {
                        $model_repair[$i]->repair_date= date("Y-m-d", strtotime(str_replace('/', '-', $items['repair_date'])));
                    }
                    $model_repair[$i]->repair_remarks = $items['repair_remarks'];
                    $model_repair[$i]->created_by = Yii::app()->user->id;
                    $model_repair[$i]->created_date_time = date('Y-m-d h:i:s');
                    $valid = $model_repair[$i]->validate() && $valid;
                    $i++;
                }
            }
            if ($valid) {
                if (!empty($model_repair)) {
                    foreach ($model_repair as $eachModel) {
                        $eachModel->save();
                        $modelStore = Store::model()->findBypk($eachModel->product_id);
                        //Updating Old product Location
                        $model_old_location= ProductLocationHiringDetails::model()->findByPk($eachModel->pdt_location_id);
                        $bal_qty=$model_old_location->quantity-$eachModel->repair_quantity;
                        ProductLocationHiringDetails::model()->updateByPK($eachModel->pdt_location_id, array('quantity' => $bal_qty));
                        //End updating Old location
                        //Add to New Pdt Location
                        $model_new_location= new ProductLocationHiringDetails;
                        $model_new_location->header_id =$eachModel->id;
                        $model_new_location->header_item_id  =0;
                        $model_new_location->product_id =$eachModel->product_id;
                        $model_new_location->part_number=$modelStore->hiring_part_number;
                        $model_new_location->description=$modelStore->description;
                        $model_new_location->bill_of_entry ='HIRING_REPAIR';
                        $model_new_location->warehouse_id=$eachModel->warehouse_id;
                        $model_new_location->rack_id=0;
                        $model_new_location->bin_id=0;
                        $model_new_location->batch_no=$model_old_location->batch_no;
                        $model_new_location->serial_no=$model_old_location->serial_no;
                        $model_new_location->quantity=$eachModel->repair_quantity;
                        $model_new_location->transaction_type='HIRING_REPAIR';
                        $model_new_location->created_by = Yii::app()->user->id;
                        $model_new_location->created_date = date('Y-m-d h:i:s');
                        $model_new_location->manufacturing_date = $model_old_location->manufacturing_date;
                        $model_new_location->expiry_date = $model_old_location->expiry_date;
                        $model_new_location->isActive='Y';
                        $model_new_location->save(FALSE);
                        //End New Pdt Location Update
                        //Stock Ledger Hiring-Start
                        $model_stockledger_hiring = new StockLedgerHiring();
                        $model_stockledger_hiring->product_id =$eachModel->product_id;
                        $model_stockledger_hiring->product_location_id = $model_new_location->id;
                        $model_stockledger_hiring->transaction_type ='HIRING_REPAIR';
                        $model_stockledger_hiring->warehouse_id = $eachModel->warehouse_id;
                        $model_stockledger_hiring->rack_id = 0;
                        $model_stockledger_hiring->bin_id = 0;
                        $model_stockledger_hiring->cost_price = $modelStore->rate;
                        $model_stockledger_hiring->quantity =$eachModel->repair_quantity;;
                        $model_stockledger_hiring->transaction_date = date("Y-m-d");
                        $model_stockledger_hiring->header_id =$eachModel->id;
                        $model_stockledger_hiring->created_by = Yii::app()->user->id;
                        $model_stockledger_hiring->created_date = date("Y-m-d H:i:s");
                        $model_stockledger_hiring->save(false);
                        //End Stock Ledger Hiring
                    } 
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else {
                $jsonData['status'] = 'error';
                echo CJSON::encode($jsonData);
            }
        }
    }
    public function actionDamage() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('damage');
    }
    public function actionloadpdtdetails() {
        $product_id = $_POST['product_id'];
        $condition = 'warehouse.warehouse_code!="DAM" and quantity>0 AND product_id="'.$product_id.'"';
        $model_details = ProductLocationHiringDetails::model()->with('warehouse','product')->findAll(array('condition' => $condition));
        $model_damage =new HiringDamageHistory();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('product_details', array('model_details' => $model_details,'model_damage'=>$model_damage));
    }
    public function actionSaveDamage() {       
        if ((isset($_POST['HiringDamageHistory']))) {
            $i=0;
            $valid=true;
            foreach ($_POST['HiringDamageHistory'] as $l => $items) {
                if($items['damage_quantity']>0){
                    $model_damage_history[$i] = new HiringDamageHistory();
                    $model_damage_history[$i]->product_id = $items['product_id'];
                    $model_damage_history[$i]->pdt_loc_id = $items['pdt_loc_id'];
                    $model_damage_history[$i]->hiring_package_details =0;
                    $model_damage_history[$i]->damage_quantity = $items['damage_quantity'];
                    if ($items['damage_date']!= '0000-00-00' && $items['damage_date']!= '') {
                        $model_damage_history[$i]->damage_date= date("Y-m-d", strtotime(str_replace('/', '-', $items['damage_date'])));
                    }
                    $model_damage_history[$i]->damage_remarks = $items['damage_remarks'];
                    $model_damage_history[$i]->created_by = Yii::app()->user->id;
                    $model_damage_history[$i]->created_date_time = date('Y-m-d h:i:s');
                    $valid = $model_damage_history[$i]->validate() && $valid;
                    $i++;
                }
            }
            if ($valid) {
                if (!empty($model_damage_history)) {
                    foreach ($model_damage_history as $eachModel) {
                        $eachModel->save();
                        $modelStore = Store::model()->findBypk($eachModel->product_id);
                        //Updating Old product Location
                        $model_old_location= ProductLocationHiringDetails::model()->findByPk($eachModel->pdt_loc_id);
                        $bal_qty=$model_old_location->quantity-$eachModel->damage_quantity;
                        ProductLocationHiringDetails::model()->updateByPK($eachModel->pdt_loc_id, array('quantity' => $bal_qty));
                        //End updating Old location
                        //Add to New Pdt Location
                        $model_new_location= new ProductLocationHiringDetails;
                        $model_new_location->header_id =$eachModel->id;
                        $model_new_location->header_item_id  =0;
                        $model_new_location->product_id =$eachModel->product_id;
                        $model_new_location->part_number=$modelStore->hiring_part_number;
                        $model_new_location->description=$modelStore->description;
                        $model_new_location->bill_of_entry ='HIRING_DAMAGE';
                        $model_warehouse_details = MasInventoryWarehouse::model()->find(array('condition' =>'warehouse_code="DAM"'));
                        $warehouse_id=$model_warehouse_details->id;
                        $model_new_location->warehouse_id=$warehouse_id;
                        $model_new_location->rack_id=0;
                        $model_new_location->bin_id=0;
                        $model_new_location->batch_no=$model_old_location->quantity;
                        $model_new_location->serial_no=$model_old_location->serial_no;
                        $model_new_location->quantity=$eachModel->damage_quantity;
                        $model_new_location->transaction_type='HIRING_DAMAGE';
                        $model_new_location->created_by = Yii::app()->user->id;
                        $model_new_location->created_date = date('Y-m-d h:i:s');
                        $model_new_location->manufacturing_date = $model_old_location->manufacturing_date;
                        $model_new_location->expiry_date = $model_old_location->expiry_date;
                        $model_new_location->isActive='Y';
                        $model_new_location->save(FALSE);
                        //End New Pdt Location Update
                        //Stock Ledger Hiring-Start
                        $model_stockledger_hiring = new StockLedgerHiring();
                        $model_stockledger_hiring->product_id =$eachModel->product_id;
                        $model_stockledger_hiring->product_location_id = $model_new_location->id;
                        $model_stockledger_hiring->transaction_type ='HIRING_DAMAGE';
                        $model_stockledger_hiring->warehouse_id = $warehouse_id;
                        $model_stockledger_hiring->rack_id = 0;
                        $model_stockledger_hiring->bin_id = 0;
                        $model_stockledger_hiring->cost_price = $modelStore->rate;
                        $model_stockledger_hiring->quantity =$eachModel->damage_quantity;;
                        $model_stockledger_hiring->transaction_date = date("Y-m-d");
                        $model_stockledger_hiring->header_id =$eachModel->id;
                        $model_stockledger_hiring->created_by = Yii::app()->user->id;
                        $model_stockledger_hiring->created_date = date("Y-m-d H:i:s");
                        $model_stockledger_hiring->save(false);
                        //End Stock Ledger Hiring
                    } 
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else {
                if (!empty($model_damage_history))
    			$error = CJSON::encode(json_decode(CActiveForm::validateTabular($model_damage_history, '', false), true));
    			if ($error != '[]'||$error!='')
    				echo $error;
            }
        }
    }
}