<?php

class HiringcreditnoteController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index', 'GetCreditNoteList', 'Create','GetinvoiceDetails','GetinvoiceDetail','SaveCreditNote','PrintCreditNote',
                                        'EditDate','SavecreditDate'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex() {
        $this->render('index');
    }
    public function actionGetCreditNoteList() {
        $model = new Creditnote();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.invoice_id',
            2 => 't.id',
            3 => 't.customer_id',
            4 => 't.credited_date',
            5 => 't.currency',
            6 => 'invoice.grand_total',
            7 => 't.total_tax_amount',
            8 => 't.credited_amount',
            9 => '',
            10 => 't.posted'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" AND t.is_updated_store="Y" and t.is_hiring="Y" and invoice_id!=""';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (customer.customer_name LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR  t.id LIKE '%" . $searchString . "%' OR  t.invoice_id LIKE '%" . $searchString . "%'  OR invoice.invoice_no LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('customer', 'file', 'invoice')->count(array('condition' => $condition));
        $model = $model->with('customer', 'file', 'invoice')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $row) {
            $rowData[] = array($row['id'], $row['file_id'], $row['invoice_id'], $row->customer->customer_name, date("d/m/Y", strtotime($row['credited_date'])), $row['currencyname']['currency_code'], Yii::app()->numberFormatter->formatCurrency($row['invoice']['grand_total'], ""), Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""), Yii::app()->numberFormatter->formatCurrency($row['credited_amount'], ""),$row->created_user,$row['posted']);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $model = new Creditnote();
        $model_items= array(new CreditnoteItem);
        $model_additions = array(new CreditnoteAddition());
        $model_deductions = array(new CreditnoteDeduction());
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model,'model_items'=>$model_items,'model_additions' => $model_additions,'model_deductions' => $model_deductions));
    }
    public function actionGetinvoiceDetails() {
        $customer_id = $_POST['customer_id'];
        $model = Invoice::model()->findAll(array('condition' =>'is_hiring_invoice="Y" and customer_id="'.$customer_id.'" and invoice_status="Y"'));       
        $i = 0;
        $data=array();
        foreach ($model as $eachModel) {
            $data[$i]['id'] = $eachModel->id;
            $data[$i]['file_id'] = $eachModel->file_id . ' : ' . $eachModel->id; 
            $i++;
        }
        $model_creditnote = new Creditnote();
        $invoice_details=CHtml::listData($data, 'id', 'file_id');
        $drop_down=CHtml::activedropDownList($model_creditnote,'invoice_id',$invoice_details,  array('class' => 'tooltipster', 'title' => 'Invoice No','data-label'=>'Invoice No <span style="color:red">*</span>','data-search'=>true,'empty'=>'Select','onchange' => 'getinvoicedetail(this.value);'));   
        echo CJSON::encode( array('details'=>$drop_down));
    }
    public function actionGetinvoiceDetail() {
        $invoice_id = $_POST['invoice_id'];
        $model = Invoice::model()->findByPk($invoice_id);
        //Tax Percentage
        $model_item= InvoiceItem::model()->find(array('condition'=>'invoice_id="'.$invoice_id.'"'));
        //Already Invoice Amount
        $model_creditnote =Creditnote::model()->find(array('select' => 'sum(credited_amount) as credited_amount','condition' => 'invoice_id = "'.$invoice_id.'"'));
        if($model_creditnote->credited_amount==''){
            $model_creditnote->credited_amount=0;
        }
        //Default Currency
        $default_currency='N';
        if($model->currency0->id==Yii::app()->user->company_base_currency){
            $default_currency='Y';
        }
        echo CJSON::encode( array(
            'currency'=>$model->currency0->currency_code,
            'currency_id'=>$model->currency0->id,
            'exchangerate'=>$model->currency0->exchange_rate,
            'grand_total'=>$model->grand_total,
            'vat_percent'=>$model_item->tax_vat_percentage,
            'credited_amount'=>$model_creditnote->credited_amount,
            'default_currency'=>$default_currency,
            'invoice_date'=>date('d/m/Y',strtotime($model->invoice_date)),
        ));
    }
    public function actionSaveCreditNote() {
        $model = new Creditnote;
        if (isset($_POST['Creditnote'])) {
            $model->attributes = $_POST['Creditnote'];
            $invoice = Invoice::model()->findByPk($model->invoice_id);
            $model->file_id = $invoice->file_id;
            $model->order_id= $invoice->order_id;
            $model->tax_type = $invoice->tax_type;
            $model->invoice_type = $invoice->invoice_type;
            $model->customer_id = $invoice->customer_id;
            $model->contact_id = $invoice->contact_id;
            if ($_POST['Creditnote']['credited_date'] != '0000-00-00' && $_POST['Creditnote']['credited_date'] != '') {
                $model->credited_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Creditnote']['credited_date'])));
            }else{
                $model->credited_date ='';
            }
            $model->crm_user_id = Yii::app()->user->id;
            $model->terms_and_conditions = $_POST['terms_conditions'];
            $model->is_hiring="Y";
            $model->is_updated_store="Y";
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            $grand_total = 0;
            $valid = true;
            //Validating Invoice already exist
            $model_creditnote_exist = Creditnote::model()->find(array('select' => 'sum(credited_amount) as credited_amount','condition' =>'invoice_id = "'.$model->invoice_id.'"'));
            $other_error=array();
            if($model_creditnote_exist->credited_amount>0){
                $invoice_total=$_POST['invoice_total_amount'];
                $grand_total=$_POST['grand_total'];
                $total_amt=$model_creditnote_exist->credited_amount+$grand_total;
                $balance_amount=$invoice_total-$total_amt;
                if($balance_amount<0){
                    $balance_amount=0.00;
                }
                if($total_amt>$invoice_total){
                    $valid=false;
                    $other_error[]='Grand Total cannot be greater than '.$balance_amount;
                }     
            }
            foreach ($_POST['CreditnoteItem'] as $i => $item) {
                $modelItem[$i] = new CreditnoteItem;
                $modelItem[$i]->attributes = $_POST['CreditnoteItem'][$i];
                $modelItem[$i]->product_id ='0';
                $modelItem[$i]->description = $item['description'];
                $modelItem[$i]->tax_vat_percentage = $item['tax_vat_percentage'];
                $modelItem[$i]->tax_vat_amount = $item['tax_vat_amount'];
                $modelItem[$i]->unit ='0';
                $valid = $modelItem[$i]->validate() && $valid;                
            }
            $valid = $valid && is_array($modelItem);
            $grand_total_amount=0.00;
            if ($model->validate() && $valid) { 
                $model->save();
                $total_tax_amount = 0;
                foreach ($modelItem as $eachItem) {
                    $eachItem->creditnote_id = $model->id;
                    $eachItem->save();
                    $grand_total_amount += $eachItem->net_amount;
                    $grand_total_amount+=$eachItem->tax_vat_amount;
                    $total_tax_amount += $eachItem->tax_vat_amount;
                }
                $model->updateByPk($model->id, array('credited_amount' => $grand_total_amount, 'total_tax_amount' => $total_tax_amount));
                 // inserting to audit log
                 AuditLog::saveAuditLogs(
                    'CREDIT_NOTE',
                    Yii::app()->user->id,
                    'CREATED',
                    " Checking No: - {$model->id}   "
                );
                // end audit log 
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error5 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($modelItem[0]->description))
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$other_error));
                if ($error != '[]')
                    echo $error;
            }
            Yii::app()->end();
        }
    }
    public function actionPrintCreditNote() {
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.hiring_creditnote_pdf', array('id' => $id), true));
        $mPDF1->Output('CreditNote.pdf', 'I');
    }
    public function actionEditDate() {
        $model = new Creditnote();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('edit_credit_note_date', array('model' => $model));
    }
    public function actionSavecreditDate() {
      if (isset($_POST['Creditnote'])) {
            $id =$_POST['Creditnote']['id']; 
            $is_hiring=$_POST['Creditnote']['is_hiring']; 
            $credited_date =date('Y-m-d', strtotime( str_replace('/', '-', $_POST['Creditnote']['credited_date']) )); 
            Creditnote::model()->updateByPK($id, array('credited_date' =>$credited_date,'updated_by'=>Yii::app()->user->id,'updated_datetime'=> date('Y-m-d h:i:s'))); 
            if($is_hiring=='N'){
                StockLedger::model()->updateAll(array('transaction_date' =>$credited_date), 'header_id="'.$id.'" and transaction_type="CREDIT_NOTE"');
            }
            AuditLog::saveAuditLogs(
                        'CREDIT_NOTE',
                        Yii::app()->user->id,
                        'UPDATED',
                        " with ID: - {$id}  "
            );
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);          
      }
  }
}
