<?php

class FooteritemsController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','DeleteFooterItem','SaveFooterItem','GetFooterItemList','Blockfooteritems','GetFooterTaxValues','UnBlockfooteritems'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
         }
         
        public function actionGetFooterItemList()
         {
 
            $model=new MasFooterItems();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'t.id',
                   1 =>'sales_purchase_type',
                   2 =>'item_type',
                   3 =>'item_name',
                   4 =>'description',
                 
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition  = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  ( item_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order' => $orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                
     
                foreach ($model as $row)
                {
                    $div = '';
                    if($row['sales_purchase_type']==1)
                        $type1="Sales";
                    if($row['sales_purchase_type']==2)
                        $type1="Purchase";
                    if($row['item_type']==1)
                        $type2="Addition";
                    if($row['item_type']==2)
                        $type2="Deduction";
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["footer_items_edit"])){
                      $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'footeritems/create&id=' . $row['id'] . '\',\'Edit Footer Items\',\'lg\')"><i class="fa fa-pencil"></i></button>';             

                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inventory_generic_name_delete"])){
                       // $div .= '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteFooterItem('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }

                    if(isset(Yii::app()->user->havePermissionOn['footer_items_disable']) ||  Yii::app()->user->authorised_user == 1)
                    {

                    if ($row->isActive == "Y") 
                    {
                        $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disablefooteritems(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                    }
                    if ($row->isActive == 'N') 
                    {
                            $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enablefooteritems(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                    }            
                    
                    }
                        $rowData[]=array($m,
                            $type1,
                            $type2,
                            $row['item_name'],
                            $row['description'],
                            '<div class="btn-wrap text-center">' . $div . '</div>',
                            $row['isActive'],
                    );
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new MasFooterItems(); 
        $id=(int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }                   
            
       Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSaveFooterItem()
        {
            $model = new MasFooterItems();
           
            if (isset($_POST['MasFooterItems']))
            {
                $model->created_by = Yii::app()->user->id;
    		if ((int) @$_POST['MasFooterItems']['id'] > 0)
                {
                    $id= (int) @$_POST['MasFooterItems']['id'];
                    $model=$model->findByPk($id); 
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s');
                    $flag = 0;
                    $audit_type = 'UPDATED';
                }else{
                    $audit_type = 'CREATED';
                    $flag = 1;
                }
                $model->updated_date_time =date('Y-m-d h:i:s');
                $model->description=$_POST['MasFooterItems']['description'];
                $model->attributes=$_POST['MasFooterItems'];
                
                if($model->save())
                {       

                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'FOOTER_ITEMS',
                        Yii::app()->user->id,
                        $audit_type,
                        " with name: - {$model->item_name}  "
                    );
                    // end audit log
                    
                       /* if($flag = 1){
                            $finSetings = new FinSettings;
                            $finSetings->attribute = $model->id;
                            $finSetings->att_name = $_POST['MasFooterItems']['description'];
                            $finSetings->save(false);
                        }*/
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['bank_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                       // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
               // $this->render('bank_form', array('model' => $model), false, true);

            }
        }

    public function actionDeleteMasFooterItems()
    {
		$id = $_POST['id'];
                $model_q1 = QuotesAddition::model()->findAll(array('condition' => 'particular='.$id));
                $model_q2 = QuotesDeduction::model()->findAll(array('condition' => 'particular='.$id));
                $model_o1 = OrderAddition::model()->findAll(array('condition' => 'particular='.$id));
                $model_o2 = OrderDeduction::model()->findAll(array('condition' => 'particular='.$id));
                $model_d1 = DirectPurchasingOrderAddition::model()->findAll(array('condition' => 'particular='.$id));
                $model_d2 = DirectPurchasingOrderDeduction::model()->findAll(array('condition' => 'particular='.$id));
                if(empty($model_q1) && empty($model_q2) && empty($model_o1) && empty($model_o2)  && empty($model_d1)  && empty($model_d2)){
                    $model=new MasFooterItems();
                    $model->deleteByPk($id);
                    echo "success";
                }else{
                     echo "fail";
                }
                
    }


    
    public function actionGetFooterTaxValues(){
        $id = $_POST['id'];

        if (!empty($id)) {
            $model = new MasFooterItems();
            $model = $model->findByPk($id);
            $jsonData['tax_percentage'] = $model->tax->percentage;
        }
        else{
             $jsonData['tax_percentage'] = 0;
        }
        echo CJSON::encode($jsonData);
    }
        
    public function actionBlockfooteritems() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasFooterItems::model()->updateByPK($id, array('isActive' => "N"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionUnBlockfooteritems() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasFooterItems::model()->updateByPK($id, array('isActive' => "Y"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
  
  
}