<?php

class FakerController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Bulidcustomer', 'Bulidinventory', 'Syncopeningstock', 'Generateleads', 
                                     'Convert_qtn', 'Qtn_order', 'Orer_dl', 'Syncuom', 'Bulid_product_id', 'Bulid_rack_id'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
		$this->render('index');
	}
   
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    
    public function actionBulidcustomer(){
        for( $i=0; $i < 5000; $i++){
            $customer = new Customer;
            $customer->customer_name = 'Customer '.$i;
            $customer->customer_phone_no = rand(5500000000, 5900000000);
            $customer->customer_email_id = 'customer'.$i.'@gmail.com';
            $customer->customer_address = 'Adds, '.PHP_EOL.' Villa '.$i;
            $customer->customer_state = 'Dubai';
            $customer->customer_country = 143;
            $customer->customer_currency_id = 1;
            if( $customer->save(false) ){
                $adds = new CustomerShippingDetails;
                $adds->customer_id = $customer->id;
                $adds->shipping_customer_name = $customer->customer_name;
                $adds->state = $customer->customer_state;
                $adds->city = $customer->customer_state;
                $adds->postal_code = rand(60000, 90000);
                $adds->country_id = 143;
                $adds->save(false);

                $contact = new CustomerContact;
                $contact->customer_id = $customer->id;
                $contact->person_name = 'Sales/Account';
                $contact->contact_phone_no = $customer->customer_phone_no;
                $contact->save(false);
            }
        }
        echo json_encode( array( 'status' => 'succes' ) );
    }

    public function actionBulidinventory(){
        for( $i=5002; $i < 10000; $i++){
            $store = new Store;
            $store->part_number = 'PRO'.$i;
            $store->description = 'DESCRIPTION OF PRO '.$i;
            $store->brand_class_id = 1;
            $store->inventory_item_type = 1;
            $store->tax_code = 1;
            $store->generic_id = 1;
            $store->warehouse_id = 1;
            $store->rack_id =1;
            $store->bin_id = 1;
            $store->unit_id = 1;
            if( $store->save(false) ){
                $unit = new UnitOfMeasurement;
                $unit->product_id = $store->id;
                $unit->isBase == "Y";
                $unit->name =  Unit::model()->findByPk(1)->symbol;
                $unit->base_unit  = 1;
                $unit->save(false);

                $openingBalance = new OpeningBalance;
                $openingBalance->product_id = $store->id;
                $openingBalance->warehouse_id = 1;
                $openingBalance->opening_quantity = 1000;
                $openingBalance->rate = rand(10, 1000);
                $openingBalance->save(false);
            }
        }
        echo json_encode( array( 'status' => 'succes' ) );
    }

    public function actionSyncopeningstock(){
        $all = OpeningBalance::model()->findAll( array( 'condition' => 'updated="N"' ) );
        foreach( $all as $each ){
            $loc = new ProductLocationDetails;
            $loc->header_id = $each->id;
            $loc->product_id = $each->product_id;
            $loc->bill_of_entry = 'OPENING_STOCK';
            $loc->warehouse_id = $each->warehouse_id;
            $loc->rack_id = $each->rack;
            $loc->bin_id = $each->bin;
            $loc->batch_no = $each->batch_no;
            if( $each->batch_no != '' )
                $loc->expiry_date =$each->expiry;
            $loc->serial_no = $each->serial_no;
            $loc->quantity = $each->opening_quantity;
            $loc->transaction_type = 'OPENING_STOCK';
            $loc->isActive = 'Y';
            $loc->save(false);

            $ledger = new StockLedger;
            $ledger->header_id  = $each->id;
            $ledger->transaction_date = date('Y-01-01');
            $ledger->transaction_type = 'OPENING_STOCK';
            $ledger->product_id = $each->product_id;
            $ledger->quantity = $each->opening_quantity;
            $ledger->product_location_id = $loc->id;
            $ledger->cost_price = $each->rate;
            $ledger->unit_id = $loc->product_id;
            $ledger->warehouse_id = $each->warehouse_id;
            $ledger->rack_id =$each->rack;
            $ledger->bin_id=$each->bin;
            $ledger->created_by=1;
            $ledger->created_date=date('Y-m-d');
            $ledger->save(false);

            //Store::model()->updateBypk($each->product_id, array( 'rate' => $each->rate ));
        }
        echo 'done';
    }

    public function actionGenerateleads(){
        function getContact( $id ){
            return CustomerContact::model()->find( array( 'condition' => 'customer_id='.$id ) );
        }
        
        function generateLead_file( $id ){
            $masterFile = new MasterFile;
            $masterFile->crm_user_id = 1;
            $masterFile->customer_id = $id;
            $masterFile->file_title = 'RAND_'.rand(10,1000);
            $masterFile->start_from = 'L';
            $masterFile->current_process_status = 'L';
            $masterFile->lead_owner_id = 1;
            $masterFile->save(false);
            return $masterFile->id;
        }
        $customers = Customer::model()->findAll();
        foreach( $customers as $each ){
            $lead = new Lead;
            $lead->crm_user_id = 1;
            $lead->file_id = generateLead_file($each->id);
            $lead->customer_id = $each->id;
            $lead->lead_owner_id = 1;
            $lead->sales_group_id = 1;
            $lead->currency = 1;
            $lead->value = rand(1000,50000);

            $contactModel =  getContact($each->id);
            $lead->contact_id = $contactModel->id;
            $lead->mobile = $contactModel->contact_phone_no;

            $lead->enq_date = date('Y-m-d', strtotime( '-'.mt_rand(0,30).' days'));
            $lead->closing_date = date('Y-m-d', strtotime( '+'.mt_rand(0,30).' days'));
            $lead->title = 'RANDOM_TITLE_'.rand(10,1000);
            $lead->remarks = 'REMARKS_'.rand(10,1000);
            $lead->status = 'Y';
            $lead->lead_status = 'Y';
            $lead->save(false);
        }
    }

    public function actionConvert_qtn(){
        function getunit( $id ){
            return UnitOfMeasurement::model()->find( array( 'condition' => 'product_id='.$id ) )->id;
        }
        $allLeads = Lead::model()->findAll();
        foreach( $allLeads as $each ){
            $quote = new Quotes;
            $quote->crm_user_id = 1;
            $quote->file_id = $each->file_id;
            $quote->file_title = $each->title;
            $quote->lead_owner_id = $each->lead_owner_id;
            $quote->enq_ref = $each->id;
            $quote->customer_id = $each->customer_id;
            $quote->contact_id = $each->contact_id;
            $quote->billing_address = $each->customer->customer_address;
            $quote->qtn_start_date = date('Y-m-d', strtotime( '+'.mt_rand(0,5).' days'));
            $quote->qtn_close_date = date('Y-m-d', strtotime( '+'.mt_rand(10,30).' days'));
            $quote->sales_group = 1;
            $quote->currency =1;
            $quote->exchange_rate=1;
            $quote->payment_terms=1;
            $quote->shipping_by=1;
            $quote->qtn_validity = date('Y-m-d', strtotime( '+'.mt_rand(10,30).' days'));
            $quote->qtn_delivery_date = date('Y-m-d', strtotime( '+'.mt_rand(20,60).' days'));
            $quote->qtn_date = date('Y-m-d');
            $quote->shipping_conditions = 'RAND_CON'.rand(100,10000);
            $quote->probability = 50;
            $quote->invoice_type = 1;
            if( $quote->save(false) ){
                $total = 0;
                $vat = 0;
                for( $i=0; $i < 2; $i++ ) :
                    $productModel = Store::model()->findBypk(rand(14, 10000));

                    $quoteItem = new QuotesItem;
                    $quoteItem->quotes_id = $quote->id;
                    $quoteItem->product_id = $productModel->id;
                    $quoteItem->description = $productModel->description;
                    $quoteItem->unit_id = getunit($productModel->id);
                    $quoteItem->quantity = rand(1,100);
                    $quoteItem->rate = rand(2000,5000);
                    $quoteItem->amount = $quoteItem->quantity * $quoteItem->rate;
                    $quoteItem->tax_vat_percentage = 5;
                    $quoteItem->tax_vat_amount = ($quoteItem->amount * 5) / 100 ;
                    $quoteItem->net_amount =$quoteItem->amount;
                    $quoteItem->checked = 1;
                    $quoteItem->save(false);

                    $total += $quoteItem->amount;
                    $vat += $quoteItem->tax_vat_amount;
                endfor;

                $quote->grand_total = ($total+$vat);
                $quote->total_tax_amount = $vat;
                $quote->update();

                MasterFile::model()->updateBypk($quote->file_id, array( 'current_process_status' => 'Q', 'is_approved' => 'Y', 'approved_by' => 1));
            }
        }
    }
    
    public function actionQtn_order(){
        foreach( Quotes::model()->findAll( array( 'condition' => 'id > 3' ) )  as $each ){
            $order = new Order;
            $order->crm_user_id = 1;
            $order->file_id = $each->file_id;
            $order->file_title =  $each->file_title;
            $order->tender_file_id = $each->id;
            $order->customer_id = $each->customer_id;
            $order->contact_id = $each->contact_id;
            $order->billing_address = $each->billing_address;
            $order->lead_owner_id = $each->lead_owner_id;
            $order->shipping_address = $each->billing_address;
            $order->order_date = date('Y-m-d');
            $order->delivery_date= date('Y-m-d');
            $order->sales_group =1;
            $order->reference = rand();
            $order->currency = 1;
            $order->exchange_rate = 1;
            $order->payment_terms =1;
            $order->shipping_by=1;
            $order->lpo =rand();
            $order->isActive = 'Y';
            $order->completed = 'N';
            $order->convert_status = 'Y';
            $order->invoice_type = 1;
            $order->save(false);
            
            $total =0;
            $vat =0;
            
            foreach( $each->items as $eachItem ){
                $orderItem = new OrderItem;
                $orderItem->order_id = $order->id;
                $orderItem->product_id = $eachItem->product_id;
                $orderItem->description = $eachItem->description;
                $orderItem->quantity  = $eachItem->quantity;
                $orderItem->unit_id = $eachItem->unit_id;
                $orderItem->rate = $eachItem->rate;
                $orderItem->amount = $orderItem->quantity * $orderItem->rate;
                $orderItem->tax_vat_percentage = $eachItem->product_id;
                $orderItem->tax_vat_amount  = $eachItem->product_id;
                $orderItem->net_amount = $orderItem->quantity * $orderItem->rate;
                $orderItem->checked = $eachItem->product_id;
                $orderItem->save(false);
            }
            
            $order->grand_total = ($total+$vat);
            $order->total_tax_amount = $vat;
            $order->update();

            MasterFile::model()->updateBypk($order->file_id, array( 'current_process_status' => 'O', 'is_approved' => 'Y', 'approved_by' => 1));
        }

        echo 'done';
    }

    public function actionOrer_dl(){
        foreach( Order::model()->findAll( array( 'condition' => 'id > 3' ) )  as $each ){
            $delivery = new DeliveryNote;
            $delivery->file_id = $each->file_id;
            $delivery->file_title = $each->file_title;
            $delivery->crm_user_id = 1;
            $delivery->customer_id = $each->customer_id;
            $delivery->order_id = $each->id;
            $delivery->contact_id = $each->contact_id;
            $delivery->delivery_date = date('Y-m-d');
            $delivery->shipped_by = 1;
            $delivery->billing_address = $each->billing_address;
            $delivery->shipping_address = $each->billing_address;
            $delivery->sales_group = 1;
            $delivery->awb_no =rand();
            $delivery->no_of_boxes = 1;
            $delivery->tracking_no = rand();
            $delivery->save(false);

            foreach( $each->items as $eachItem ){
                $deliveryItem = new DeliveryNoteItem;
                $deliveryItem->delivery_note_id = $delivery->id;
                $deliveryItem->order_item_id = $eachItem->id;
                $deliveryItem->product_id  = $eachItem->product_id;
                $deliveryItem->description = $eachItem->description;
                $deliveryItem->quantity = $eachItem->quantity;
                $deliveryItem->unit = $eachItem->unit_id;
                $deliveryItem->picked_qty = $eachItem->quantity;
                $deliveryItem->save(false);
            }
        }
    }
    
    public function actionSyncuom(){
        $store = Store::model()->findAll();
        foreach($store as $each){
            $uom = new UnitOfMeasurement;
            $uom->product_id =  $each->id;
            $uom->base_unit = $each->unit_id;
            $uom->name = $each->unit->symbol;
            $uom->factor = 1;
            $uom->price = 0;
            $uom->isBase = 'Y';
            $uom->created_by = 1;
            $uom->created_date_time = date('Y-m-d H:i:s'); 
            $uom->save(false);
        }
    }

    public function actionBulid_product_id(){
        $all = OpeningBalance::model()->findAll();
        foreach( $all as $each ){
            $store = Store::model()->find( array( 'condition' =>  'part_number="'.$each->part_number.'"' ) );
            if( $store->id > 0 ){
                $each->product_id = $store->id;
                $each->save(false);
            }
        }
        echo 'done';
    }

    public function actionBulid_rack_id(){
        $all = OpeningBalance::model()->findAll();
        foreach( $all as $each ){
            $rack = MasInvRack::model()->find( array( 'condition' =>  'name="'.$each->rack_name.'"' ) );
            if( $rack->id > 0 ){
                $each->rack = $rack->id;
                $each->save(false);
            }
        }
        echo 'done';
    }
}