<?php

class DirectinvoiceController extends Controller
{

    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'Save', 'DeleteItem', 'getExchangerate', 'getCustomerContactdetails', 'Print',
                    'getInvoiceTypeWarehouse', 'PrintInvoiceReportPDF','GetProducts','CancelInvoice','cancelcreate','Getunitdrop','GetunitRate','ChangeStatus','UpdateInvoiceStatus'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex()
    {
        $this->render('index');
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionGetList()
    {
        //for login salesman
        $login_user = Yii::app()->user->id;
        //for login salesman
        $warehouse_id = Yii::app()->user->getState('user_warehouse_id');
        $modelDirectInvoice = new DirectInvoice();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.invoice_id',
            2 => 't.remarks',
            3 => 'customer_details.customer_name',
            4 => 't.invoice_date',
            5 => 't.total_tax_amount',
            6 => 'grand_total',
            7 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        //$condition = 'is_posted="N"';
        $condition = '1=1 AND posted="N" AND t.isActive="Y" ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND customer_details.customer_name LIKE '%" . $searchString . "%' OR grand_total LIKE '%" . $searchString . "%' OR remarks LIKE '%" . $searchString . "%' OR invoice_date LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' ";
        }
        //echo $condition;
        if($_POST['invoice_date_from']!='' ){
            $invoice_start_date = date("Y-m-d",strtotime(str_replace('/', '-', $_POST['invoice_date_from'])));
            $condition.= ' AND (t.invoice_date>="'.$invoice_start_date.'")';
        }
        if($_POST['invoice_date_to']!=''){
            $invoice_end_date = date("Y-m-d",strtotime(str_replace('/', '-', $_POST['invoice_date_to'])));
            $condition.= ' AND (t.invoice_date<="'.$invoice_end_date.'")';
        }
        
        $count = $modelDirectInvoice->with('customer_details')->count(array('condition' => $condition));
        $modelDirectInvoice = $modelDirectInvoice->with('customer_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($modelDirectInvoice as $i => $row) {
            $arr_items=array();
            //Get order item details
            $arr_order_item_details = DirectInvoiceItem::model()->with('product')->findAll(array('condition' => 'invoice_id=' . $row['id']));

            $order_item_status = 0;
            foreach ($arr_order_item_details as $items) {

                if ($items->rate < $items->product->rate) {
                    $order_item_status = 1;
                    break;
                }
            }
            //End get order item details
            
            
            $customer_id = $row['customer_id'];
            //activity details
            $model_Activity = new Activity();
            //$condition_Activity = ' t.isActive="Y" AND added_from="ID" AND t.customer_id='.$row['customer_id'].' AND t.file_id='.$row['file_id'];
            $condition_Activity = ' t.isActive="Y" AND t.customer_id='.$row['customer_id'].' AND t.file_id='.$row['file_id'];
            $model_Activity = $model_Activity->find(array('condition' => $condition_Activity,'order' => 'id DESC'));
            $task_status = array('1' => 'Open', '2' => 'Delayed', '3' => 'Closed');
            $task_type = array('6' => 'Others', '5' => 'Bugs / Issues', '4' => 'Payment Follow Up','3' => 'Demo', '2' => 'Meeting', '1' => 'Call');
               
            //activity details
            

            $div = '';
            $div .= '<div class="text-center">';

            if ((Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["direct_sales_view"]) && $row['posted']=='Y') {
                $div .= ' <button class="btn btn-primary btn-xs" title="View Order" onclick="loadPopupModal(\'directinvoice/create&type=view&id=' . $row['id'] . '\',\' View Invoice - ' . $row['id'] . ' \',\'xl\')"><i class="fa fa-eye"></i></button>';
            }
            
            if ($row['posted']=='N') {
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'packaging/create&status=DSI&id=' . (int)$row['reference'] . '\',\'Convert to Invoice\',\'xl\')" title="Convert Invoice"><i class="fa fa-retweet"></i></button>';
            }else{
                $div .= ' <a class="btn btn-primary btn-xs" title="Print Invoice Pdf" target="_blank" href="?r=invoice/PrintInvoiceReportPDF&id=' . $row['invoice_id'] . '&c_id=3&frm=tax&barcode=N"><i class="fa fa-file-pdf-o"></i></a>';
                $div .=' <a class="btn btn-danger btn-xs" title="Cancel Invoice" onclick="loadPopupModal(\'directinvoice/cancelcreate&id='.$row['invoice_id'].'\', \'Cancel Direct Sales- '.$row['invoice_id'].'\' , \'xl\')"><i class="fa fa-ban"></i></a>';
            }
            
            if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_sales_pdf"]))) {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=directinvoice/PrintInvoiceReportPDF&id=' . $row['id'] . '"><i class="fa fa-file-pdf-o"></i></a>';
            }
            $arr_items['posted']=$row['posted'];
            $arr_items['isActive']=$row['isActive'];
            $arr_items['invoice_id']=$row['invoice_id'];
            $arr_items['reference']=$row['reference'];
            $arr_items['customer_id']=$row['customer_id'];
            $arr_items['file_id']=$row['file_id'];
            //$task_type[$model_Activity->task_type].'-'.$task_status[$model_Activity->task_status]
            
            $invoice_status = $row->invoicestatus->status;
            $rowData[] = array($row['id'],((int) $row['invoice_id'] >0)?$row['invoice_id']:""/*,$row['remarks']*/, $row['customer_details']['customer_name'], date("d/m/Y", strtotime($row['invoice_date'])), '<div class="text-right">' . $row['total_tax_amount'] . '<div>', '<div class="text-right">' . $row['grand_total'] . '<div>',$invoice_status,$arr_items);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
      
        $model          = new DirectInvoice();
        $id             = Yii::app()->request->getParam('id');
        $type           = Yii::app()->request->getParam('type');
        $modelItems     = array(new DirectInvoiceItem);
        $modelAdditions = array(new DirectInvoiceAddition);
        $modelDeductions = array(new DirectInvoiceDeduction);
      
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelItems = DirectInvoiceItem::model()->findAll(array('condition' => 'invoice_id="' . $id . '"'));
            if (empty($modelItems)) {
                $modelItems = array(new DirectInvoiceItem());
            }
        $modelAdditions  = DirectInvoiceAddition::model()->findAll(array('condition'=>'invoice_id="'.$id.'"'));
        if(empty($modelAdditions)){
            $modelAdditions = array(new DirectInvoiceAddition);
        }
        $modelDeductions  = DirectInvoiceDeduction::model()->findAll(array('condition'=>'invoice_id="'.$id.'"'));
        if(empty($modelDeductions)){
            $modelDeductions = array(new DirectInvoiceDeduction);
        }
        }
      
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'modelItems' => $modelItems, 'type' => $type,'modelAdditions' => $modelAdditions,'modelDeductions' =>$modelDeductions));
    }

    public function actionSave()
    {
        if (isset($_POST['DirectInvoice'])) {
            $modelDirectInvoice = new DirectInvoice;
            $others = array();
            $update = 0;
            if ((int) $_POST['DirectInvoice']['id'] > 0) {

                $modelDirectInvoice = $modelDirectInvoice->findByPK($_POST['DirectInvoice']['id']);
                $modelDirectInvoice->updated_by = Yii::app()->user->id;
                $modelDirectInvoice->updated_datetime = date('Y-m-d H:i:s');
                $update = 1;

            } else {
                $modelDirectInvoice->created_by = Yii::app()->user->id;
                $modelDirectInvoice->created_datetime = date('Y-m-d H:i:s');
                $update = 0;
            }
            $modelDirectInvoice->attributes = $_POST['DirectInvoice'];
            if ($_POST['DirectInvoice']['invoice_date'] != '00/00/0000') {
                $modelDirectInvoice->invoice_date = str_replace('/', '-', $_POST['DirectInvoice']['invoice_date']);
                $modelDirectInvoice->invoice_date = date("Y-m-d", strtotime($modelDirectInvoice->invoice_date));
            } else {
                $modelDirectInvoice->invoice_date = '';
            }
            $grand_total = $total_tax = 0;
            if ($update == 0) {
                $modelDirectInvoice->grand_total = 0;
            }
          
            $modelDirectInvoice->terms_and_conditions   = $_POST['DirectInvoice']['terms_and_conditions'];
            $modelDirectInvoice->payment_terms          = $_POST['DirectInvoice']['payment_terms'];
            $modelDirectInvoice->invoice_type           = $_POST['DirectInvoice']['invoice_type'];
            $modelDirectInvoice->currency_id            = $_POST['DirectInvoice']['currency_id'];
            $modelDirectInvoice->remarks                = $_POST['DirectInvoice']['remarks'];
            $modelDirectInvoice->billing_address        = $_POST['DirectInvoice']['billing_address'];
            $modelDirectInvoice->invoice_status         = $_POST['DirectInvoice']['invoice_status'];
            

            $valid = $modelDirectInvoice->validate();

            $products_id = array();
            if (is_array($_POST['DirectInvoiceItem'])) {
                foreach ($_POST['DirectInvoiceItem'] as $i => $item) {
                    if ($item['product_id'] != '') {
                        $modelDirectInvoiceItems[$i] = new DirectInvoiceItem;
                        if ($item['id'] > 0) {
                            $modelDirectInvoiceItems[$i] = $modelDirectInvoiceItems[$i]->findByPk($item['id']);
                            $modelDirectInvoiceItems[$i]->updated_by = Yii::app()->user->id;
                            $modelDirectInvoiceItems[$i]->updated_datetime = date('Y-m-d H:i:s');
                        }else{
                            $modelDirectInvoiceItems[$i]->created_by = Yii::app()->user->id;
                            $modelDirectInvoiceItems[$i]->created_datetime = date('Y-m-d H:i:s');
                        }
                        
                        $modelDirectInvoiceItems[$i]->attributes = $item;
                        $modelDirectInvoiceItems[$i]->invoice_id = 0;
                        if((float)$item['rate']<=0){
                            $others[]='Rate should be greater than zero';
                            $valid=false;
                        }
                        
                        
                        $arr_secondary_unit = UnitOfMeasurement::model()->findByPk((int) $item['unit_id']);
                        
                        $item_actual_rate = $item['actual_rate'];
                        if(isset($arr_secondary_unit->factor) && (int) $arr_secondary_unit->factor > 0 && (int) $item['actual_rate'] > 0){
                            $item_actual_rate = number_format(($item['actual_rate'] * $arr_secondary_unit->factor),2);
                        }
                        
                        if (!isset(Yii::app()->user->havePermissionOn['edit_selling_price'])) {
                            
                            if((float)$item['rate'] < (float)$item_actual_rate){
                                $others[]='Rate should be greater than or equal to '.(float) $item_actual_rate.' ['.$item['part_no'].']';
                                $valid=false;
                            }
                            
                        }
                        if((int)$item['quantity']<=0){
                            $others[]='Quantity should be greater than zero';
                            $valid=false;
                        }
                        $modelDirectInvoiceItems[$i]->description = $item['description'];
                        $modelDirectInvoiceItems[$i]->amount = $item['amount'];
                        $modelDirectInvoiceItems[$i]->unit_id = $item['unit_id'];
                        $grand_total += $item['amount'];
                        $total_tax += $item['tax_vat_amount'];
                        $valid = $modelDirectInvoiceItems[$i]->validate() && $valid;
                    }
                }

            }
            
           

            if ($valid && !empty($modelDirectInvoiceItems)) {
                $modelMaster = new MasterFile();
                $modelMaster->customer_id = $_POST['DirectInvoice']['customer_id'];
                $modelMaster->start_from = "I";
                $modelMaster->current_process_status = "I";
                $modelMaster->crm_user_id = Yii::app()->user->id;
                $modelMaster->file_title = "";
                $modelMaster->save(false);
                $modelMaster->refresh();
                $file_id = $modelMaster->id;
                $modelDirectInvoice->save();
                $modelDelivery=new DeliveryNote();
                $modelDelivery->file_id = $file_id;
                $modelDelivery->customer_id = $modelDirectInvoice->customer_id;
                $modelDelivery->order_id = $modelDirectInvoice->id;
                $modelDelivery->delivery_date = $modelDirectInvoice->invoice_date;
                $modelDelivery->billing_address = $modelDirectInvoice->billing_address;
                $modelDelivery->shipping_address = $modelDirectInvoice->billing_address;
                $modelDelivery->contact_id = $modelDirectInvoice->contact_id;
                $modelDelivery->shipped_by = MasShipping::getDefault();
                $modelDelivery->sales_group = $modelDirectInvoice->sales_group_id;
                $modelDelivery->notes=$modelDirectInvoice->reference;
                $modelDelivery->terms_and_conditions =$modelDirectInvoice->terms_and_conditions;
                $modelDelivery->delivery_from = 'DI';
                $modelDelivery->created_by = Yii::app()->user->id;
                $modelDelivery->created_datetime = date('Y-m-d H:i:s');
                $modelDelivery->save(false);
                $modelDelivery->refresh();
                if (!empty($modelDirectInvoiceItems)) {
                    foreach ($modelDirectInvoiceItems as $eachItem) {
                        $eachItem->invoice_id = $modelDirectInvoice->id;
                        $eachItem->save(false);
                        $total_vat_amount += $eachItem->tax_vat_amount;
                    }
                    $modelItems=DirectInvoiceItem::model()->findAll(array('condition'=>'invoice_id="' . (int)$modelDirectInvoice->id. '"'));
                    foreach ($modelItems as $eachItem) {
                        $modelItem[$i] = new DeliveryNoteItem;
                        $modelItem[$i]->product_id = $eachItem['product_id'];
                        $modelItem[$i]->delivery_note_id = $modelDelivery->id;
                        $modelItem[$i]->description = $eachItem['description'];
                        $modelItem[$i]->quantity = $eachItem['quantity'];
                        $modelItem[$i]->order_item_id = $eachItem['id'];
                        $modelItem[$i]->unit_id = $eachItem['unit_id'];
                        $modelItem[$i]->picked_qty = floatval($eachItem['quantity']);
                        $modelItem[$i]->remarks = '';
                        $modelItem[$i]->save(false);
                    }
                }


                $modelDirectInvoice->updateByPk($modelDirectInvoice->id, array('reference'=>$modelDelivery->id,'file_id'=>$file_id,'total_tax_amount' => $total_tax, 'grand_total' => ($grand_total + $total_tax)));
              
                $jsonData['status'] = 'success';
                $jsonData['delivery_id'] = $modelDelivery->id;
                $jsonData['direct_id'] = $modelDirectInvoice->id;
                echo CJSON::encode($jsonData);

            } else {
                $error1 = $error2 = $error3 = $error4 = array();
                $error1 = json_decode(CActiveForm::validate($modelDirectInvoice, '', false), true);
                if (!empty($modelDirectInvoiceItems[0]->product_id)) {
                    $error2 = json_decode(CActiveForm::validateTabular($modelDirectInvoiceItems, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line item";
                }

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $others));

                if ($error != '[]') {
                    echo $error;
                }

            }
        } else {
            echo 'error';
        }
    }
    public function actionDeleteItem()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            DirectInvoiceItem::model()->deleteByPk($id);
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }
    public function actiongetExchangerate()
    {
        $id = $_POST['currency_id'];
        
        if ($id > 0) {
            $model = MasCurrency::model()->findByPk($id);
            $jsonData['rate'] = $model->exchange_rate;
            echo CJSON::encode($jsonData);
        }
    }
    public function actiongetCustomerContactdetails()
    {
        $id = Yii::app()->request->getparam("id");
        $models = CustomerContact::getCustomerContacts($id);
        $drop = '<li class="col-sm-4">';
        $model = new DirectInvoice();
        $drop .= CHtml::activedropDownList($model, 'contact_id', $models, array('class' => 'tooltipster', 'title' => 'Please Select Contact', 'data-label' => 'Contact', 'data-search' => true));
        $drop .= '</li>';
        $status = array("dt" => $drop);
        echo CJSON::encode($status);

    }

    public function actiongetInvoiceTypeWarehouse()
    {
        $id = Yii::app()->request->getparam("id");
        $select_warehouse_id = Yii::app()->request->getparam("warehouse_id");

        $model_invc_type = MasInvoiceType::model()->findByPK($id);
        $getInvcList = $model_invc_type['warehouse_id'];
        $models = MasInvWarehouse::getUserWarehouse();
        //$models = MasInvWarehouse::getInvoiceTypeWarehouse($getInvcList);
        $drop = '<li class="col-sm-4">';
        $model = new Invoice;
        $drop .= CHtml::activedropDownList($model, 'warehouse_id', $models, array('data-label' => 'Warehouse <span style="color:red">*</span>', 'class' => 'tooltipster', 'class' => 'text-bold', 'options' => array($select_warehouse_id => array('selected' => 'selected'))));
        $drop .= '</li>';
        $status = array("dt" => $drop);
        echo CJSON::encode($status);
    }
    public function actionPrintInvoiceReportPDF()
    {
        $model = new DirectInvoice();
        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $frm = Yii::app()->request->getParam('frm');
        $type = Yii::app()->request->getParam('type');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.direct_invoice_list_individual', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title, 'type' => $type), true));
        $mPDF1->Output("INVOICE_".$id.".pdf", 'I');
    }

    
    public function actionGetProducts() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 't.isActive = "Y" AND ( inventory_item_type =1 OR inventory_item_type=3) AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        $model = new Store();
        $model = $model->with('tax')->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number.' : '. $eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $data[$i]['tax_code'] = $eachModel->tax;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionCancelCreate(){
        $id=(int) Yii::app()->request->getParam('id');
        $modelInvoice=Invoice::model()->findByPk($id);
        $model= DeliveryNote::model()->findByPk((int)$modelInvoice->delivery_ids);
        $model_items= DeliveryNoteItem::model()->findAll(array('condition' => 'delivery_note_id="'. $modelInvoice->delivery_ids.'" and picked_qty>0'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);       
        $this->renderPartial('cancel_create', array('model' => $model,'model_items'=>$model_items,'invoice_id'=>$id), false, true);
    }
    public function actionCancelInvoice() {
        $id = (int) Yii::app()->request->getParam('id');
        $remarks_cancel = Yii::app()->request->getParam('remarks_cancel');
        if ($id > 0) {
            $model = Invoice::model()->findByPk($id);
            $delivery_ids=$model->delivery_ids;
            $file_id =$model->file_id;
            //Updating Delivery Table
            if($delivery_ids!=''){
                DeliveryNote::model()->updateAll(array('invoiced' =>"N",'updated_by'=>Yii::app()->user->id,'updated_datetime'=> date('Y-m-d H:i:s')), 'id IN('.$delivery_ids.')');
                //Updating File Table
                if($file_id>0)
                MasterFile::model()->updateAll(array('current_process_status' =>"O",'updated_by'=>Yii::app()->user->id,'updated_datetime'=> date('Y-m-d H:i:s')), 'id IN('.$model->file_id.')');
                //Updating Invoice Table  
                Invoice::model()->updateByPk($id, array('invoice_status' =>'C','updated_by'=>Yii::app()->user->id,'updated_datetime'=> date('Y-m-d H:i:s')));
                //Audit Log
                AuditLog::saveAuditLogs(
                        'INVOICE_CANCELLED',
                        Yii::app()->user->id,
                        'CANCELLED',
                        " with ID: - {$id}  "
                );
                //delivery
                DeliveryNote::model()->updateByPK($delivery_ids, array('status' =>'CN','remarks_cancel'=>$remarks_cancel,'updated_by'=>Yii::app()->user->id,'updated_datetime'=> date('Y-m-d h:i:s'))); 
                
                //Updating to Product Location
                $model_stock_ledger_exist= StockLedger::model()->findAll(array('condition' => 'header_id="'.$delivery_ids.'" and transaction_from="DELIVERY_NOTE"'));
                foreach ($model_stock_ledger_exist as $key_1 => $eachModel) {
                    $modelTransferInStockLedger                         =   new StockLedger();
                    $modelTransferInStockLedger->file_id                =   $eachModel->file_id;   
                    $modelTransferInStockLedger->header_id              =   $eachModel->header_id;   
                    $modelTransferInStockLedger->header_item_id         =   $eachModel->header_item_id;  
                    $modelTransferInStockLedger->customer_vendor_id     =   $eachModel->customer_vendor_id;
                    $modelTransferInStockLedger->customer_vendor_name   =   $eachModel->customer_vendor_name;  
                    $modelTransferInStockLedger->product_id             =   $eachModel->product_id;
                    $modelTransferInStockLedger->product_name           =   $eachModel->product_name;  
                    $modelTransferInStockLedger->product_description    =   $eachModel->product_description;
                    $modelTransferInStockLedger->brand_id               =   $eachModel->brand_id;  
                    $modelTransferInStockLedger->brand_name             =   $eachModel->brand_name;
                    $modelTransferInStockLedger->warehouse_id           =   $eachModel->warehouse_id;  
                    $modelTransferInStockLedger->warehouse_name         =   MasInventoryWarehouse::getWarehouseName($eachModel->warehouse_id);;
                    $modelTransferInStockLedger->rack_id                =   $eachModel->rack_id;  
                    $modelTransferInStockLedger->rack_name              =   MasInvRack::getRackName($eachModel->rack_id);
                    $modelTransferInStockLedger->bin_id                 =   $eachModel->bin_id;  
                    $modelTransferInStockLedger->bin_name               =   MasInvBin::getBinName($eachModel->bin_id);
                    $modelTransferInStockLedger->unit_id                =   $eachModel->unit_id;  
                    $modelTransferInStockLedger->unit_name              =   $eachModel->unit_name;
                    $modelTransferInStockLedger->unit_factor            =   $eachModel->unit_factor;  
                    $modelTransferInStockLedger->quantity               =   abs($eachModel->quantity);
                    $modelTransferInStockLedger->available_status       =   'A';
                    $modelTransferInStockLedger->batch_no               =   $eachModel->batch_no;  
                    $modelTransferInStockLedger->serial_no              =   $eachModel->serial_no;
                    $modelTransferInStockLedger->manufacturing_date     =   $eachModel->manufacturing_date;  
                    $modelTransferInStockLedger->expiry_date            =   $eachModel->expiry_date;
                    $modelTransferInStockLedger->cost_price             =   $eachModel->cost_price;  
                    $modelTransferInStockLedger->sales_price            =   $eachModel->sales_price;
                    $modelTransferInStockLedger->transaction_date       =   date('Y-m-d');
                    $modelTransferInStockLedger->transaction_from       =   'DELIVERY_NOTE_CANCEL';
                    $modelTransferInStockLedger->transaction_type       =   "IN";
                    $modelTransferInStockLedger->created_by             =   Yii::app()->user->id;
                    $modelTransferInStockLedger->created_date           =   date("Y-m-d H:i:s");     
                    $modelTransferInStockLedger->master_stock_ledger_id =   $eachModel->id;
                    $modelTransferInStockLedger->save(false);    
                }
                if($model->order_id>0){
                    DirectInvoice::model()->updateByPK((int)$model->order_id, array('isActive' =>'N','posted'=>'N','updated_by'=>Yii::app()->user->id,'updated_datetime'=> date('Y-m-d H:i:s'))); 
                
                }

                AuditLog::saveAuditLogs(
                            'DELIVERY_NOTE_CANCELLED',
                            Yii::app()->user->id,
                            'CANCELLED',
                            " with ID: - {$delivery_ids}  "
                );        
            }                
            $jsonData['status'] = 'success';
        }else{
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData); 
    }
    public function actionGetunitdrop() {
        $row = $_POST['row_field'];
        $product_id = (int) $_POST['product_id'];
        $type = $_POST['type'];
        $selling_price = $_POST['selling_price'];
        $drop = array();
        $modelOrder = new DirectInvoiceItem;
        
        if ($product_id > 0) {
            //$modelOrder->unit_id = UnitOfMeasurement::getBaseunit($product);
            $arr_uom = UnitOfMeasurement::getSecondaryBaseUnitWithName($product_id);
            //$modelOrder->unit_id = UnitOfMeasurement::getSecondaryBaseunit($product);
            $modelOrder->unit_id = $arr_uom->id;
            $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit_id", UnitOfMeasurement::getUnits($product_id), array('class' => 'unit go','onchange' => 'checkUnitItem(this.id);'));
            $drop['factor'] =  $arr_uom->factor;
            if (!empty($arr_uom)) {
                $drop['factor'] = $arr_uom->factor;
                $drop['selling_price'] = ($selling_price * $arr_uom->factor);
            } else {
                $drop['factor'] = 1;
                $drop['selling_price'] = $selling_price;
            }
            //$drop['selling_price'] =  number_format(($selling_price * $arr_uom->factor),2);
        }
        echo CJSON::encode($drop);
    }
     public function actionGetunitRate() {
        $product_id = (int) $_POST['product_id'];
        $unit_id = (int) $_POST['unit'];
        $selling_price = $_POST['selling_price'];
        $drop = array();
        if ($product_id > 0) {
            $arr_price_list = SalesPriceGroup::model()->find(array('condition' => 'product_id=' . (int) $product_id));
            $arr_uom = UnitOfMeasurement::model()->findByPK($unit_id);

            $drop['factor'] = $arr_uom->factor;
            if (!empty($arr_price_list->sales_price) && (int) $arr_price_list->sales_price > 0) {
                $drop['selling_price'] = number_format(($arr_price_list->sales_price), 2);
            } else {
                $drop['selling_price'] = 0.00;
            }
        }
        echo CJSON::encode($drop);
    }
    public function actionChangeStatus(){
       
        $model          = new DirectInvoice();
        $id             = Yii::app()->request->getParam('id');
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('change_status', array('model' => $model,'id'=>$id)); 
    }
    public function actionUpdateInvoiceStatus(){
        $modelDirectInvoice         = new DirectInvoice();
        $id                         = $_POST['DirectInvoice']['id'];
        $invoice_status             = $_POST['DirectInvoice']['invoice_status'];
        $modelDirectInvoice->updateByPk($id, array('invoice_status'=>$invoice_status));
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
}
