<?php
/** 
 * created by jisha jacob
 * on 22-11-17
 * 
 **/
class DemoController extends Controller {

    public $layout = 'layout';
    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetDemoList','GetCustomer','GetProduct',
                    'PrintInventoryReport','PrintInvLedgerReport','PrintInvStockSummaryReport','PrintInvStockAsOfReport'
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionIndex()
	{
		$this->render('index');
        }
        public function actionGetDemoList()
	{
                $model=new Quotes();
		$draw   = $_POST['draw'];
		$offset = $_POST['start'];
		$limit  = $_POST['length'];
		$columns = array(
				// datatable column index  => database column name
				0=>'file_id',
                                1 =>'t.id',
                               // 2 =>'currencyname.currency',
                               // 3 =>'t.exchange_rate',
				2=> 'customer.customer_name',
				3=> 't.qtn_date',
                                4=> 't.qtn_validity',
				5=> 't.grand_total',
				6=> 't.status'
		);
		$filterColumn = $columns[$_POST['order'][0]['column']];
		$filterOrder  = $_POST['order'][0]['dir'];
//		$orderBy      = $filterColumn." ".$filterOrder;
                $orderBy      = 't.id DESC';
		$condition = 't.isActive="Y" AND (file.current_process_status="Q") AND t.status = "Y"';
		if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
		{
			$condition = 't.isActive="Y"';
                        $searchString = $_POST['search']['value'];
			$condition.=" AND (file.file_title LIKE '%".$searchString."%' OR t.file_id LIKE '%".$searchString."%' OR t.id LIKE '%".$searchString."%' OR customer.customer_name LIKE '%".$searchString."%')";
		}
		$count = $model->with('customer','file','currencyname')->count(array('condition'=>$condition));
		$model=$model->with('customer','file','currencyname')->findAll(array('condition'=>$condition,'order'=>'t.id desc','limit'=>$limit,'offset'=>$offset));
		$recordsTotal = $count;
		$recordsFiltered = $count;
		$data['draw'] = $draw;
		$data['recordsTotal'] = $recordsTotal;
		$data['recordsFiltered'] = $recordsFiltered;
		$rowData=array();
                
		foreach ($model as $row)
		{
                        /*Valdity Check*/
                        $state = 0;
                        if(strtotime($row->qtn_validity) < strtotime(date('Y-m-d'))){
                            $state = 1;
                        }
                    
                        if($row['status'] == "Y")
                        {
                            $status = "Open";
                        }else if($row['status'] == "O")
                        {
                            $status = "Order"; 
                        }else if($row['status'] == "C")
                        {
                            $status = "Closed";
                        }else if($row['status'] == "L")
                        {
                            $status = "Lost";
                        }else{

                        }
                             switch ($row['file']['current_process_status'])
                    {
                        case 'PI':
                        $file_status="Partially Invoiced";
                         
                        break;
                    case 'PD':
                        $file_status="Partially Delivered";
                        break;
                    case 'I':
                        $file_status="Invoiced";
                        break;
                    case 'D':
                        $file_status="Delivered";
                        break;
                    case 'O':
                        $file_status="Order";
                        break;
                    case 'Q':
                        $file_status="Quotation";
                        break;
                    }
                    
                     if($row->file->current_process_status=='Q')
                        {
                             $div = '';
                            
                              $div .= ' <a class="btn btn-primary btn-xs" target="_blank" href="index.php?r=quotation/MissingList&id=' . $row['id'] .' "  title="List of materials that need to be ordered"><i class="material-icons">shopping_cart</i></a>';

                            $rowData[]=array($state,$row['file_id'],$row['id'],$row['customer']['customer_name'],date("d/m/Y",strtotime($row['qtn_date'])),date("d/m/Y",strtotime($row['qtn_validity'])),
                            Yii::app()->numberFormatter->formatCurrency($row['grand_total'],""),$status,$file_status,'<div class="btn-wrap text-center">'.$div.'</div>');
                        
                        }else{
                             $div = '';
                            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_view"])){ 
                                $div .= '<button class="btn btn-primary btn-xs" title ="View Quotation" onclick="loadPopupModal(\'quotation/create&id='.$row['id'].'&file_id='.$row['file_id'].'\',\''.$row['file_id']." / ".$row['id']." / ".$row['customer']['customer_name'].'\',\'xl\')"><i class="fa fa-eye"></i></button>';
                            }
                            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_activity"])){ 
                               $div .= ' <button class="btn btn-primary btn-xs" title ="Add Activity" onclick="loadPopupModal(\'activity/create&ftype=1&file_id='.$row['file_id'].'&customer_id='.$row->company_id.'\',\''.$row['id'].' / '.$row['file_id'].' / '.$row->customer->customer_name.''.'\',\'lg\')"><i class="fa fa-certificate"></i></button>';
                            }
//                             if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_note"])){ 
//                                $div .= ' <button title="Notes" class="btn btn-primary btn-xs" onclick="loadPopupModal(\'quotation/CreateNote&file_id='.$row['file_id'].'&id='.$row['id'].'&customer_id='.$row['company_id'].'\',\'Add Notes \',\'lg\');"><i class="fa fa-sticky-note-o" aria-hidden="true"></i></button>';
//                            }
                            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_pdf"])){ 
                                $div .= ' <a class="btn btn-primary btn-xs" title="Print Quotation" target="_blank" href="index.php?r=quotation/PrintQuotationReportPDF&id=' . $row['id'] .' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
                            }
                            // if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_pdf"])){ 
                                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'quotation/create&id='.$row['id'].'&duplicate=1\',\'Copy Quotation\',\'xl\')"  title="Copy Quotation"><i class="fa fa-file"></i></button>';

                            //}
                                $div .= ' <a class="btn btn-primary btn-xs" target="_blank" href="index.php?r=quotation/MissingList&id=' . $row['id'] .' "  title="List of materials that need to be ordered"><i class="material-icons">shopping_cart</i></a>';

                            $rowData[]=array($state,$row['file_id'],$row['id'],$row['customer']['customer_name'],date("d/m/Y",strtotime($row['qtn_date'])),date("d/m/Y",strtotime($row['qtn_validity'])),
                            Yii::app()->numberFormatter->formatCurrency($row['grand_total'],""),$status,$file_status,'<div class="btn-wrap text-center">'.$div.'</div>');
                        }
   
                            
                }
		$data['data'] = $rowData;
		echo json_encode($data);
        }
        public function actionCreate()
	{
		$model=new Quotes();
                $modellead=new Lead();
                $modelDocument = new Document;
                $modelmasterfile=new MasterFile();
		$id = (int) Yii::app()->request->getParam('id');
                $leadid=(int) Yii::app()->request->getParam('lead_id');
                $file_id=(int) Yii::app()->request->getParam('file_id');
		$duplicate=(int) Yii::app()->request->getParam('duplicate');
		$modelQuoteItems = array(new QuotesItem);
                $modelQuoteAdditions = array(new QuotesAddition);
                $modelQuoteDeductions = array(new QuotesDeduction);
                $modelNotes = new FileNotes();
		if($id > 0)
                {
                    $model=$model->findByPk($id);
                    $modelQuoteItems = QuotesItem::model()->findAll(array('condition'=>'quotes_id="'.$id.'"','order' => 'id ASC')); 
                    if(empty($modelQuoteItems)){
                             $modelQuoteItems = array(new QuotesItem);
                    }
                    $modelQuoteAdditions = QuotesAddition::model()->findAll(array('condition'=>'quotes_id="'.$id.'"','order' => 'id ASC')); 
                    if(empty($modelQuoteAdditions)){
                             $modelQuoteAdditions = array(new QuotesAddition);
                    }
                    $modelQuoteDeductions = QuotesDeduction::model()->findAll(array('condition'=>'quotes_id="'.$id.'"','order' => 'id ASC')); 
                    if(empty($modelQuoteDeductions)){
                             $modelQuoteDeductions = array(new QuotesDeduction);
                    }
                    if($duplicate=='1'){
                        $model->id='';
                        $model->file_id='';
                    }
                }   
                if($leadid > 0)
                {
                    $modellead=$modellead->findByPk($leadid);
                    $model->enq_ref = $modellead->id;
                }
                if($file_id > 0)
                {
                    $model_lead=Lead::model()->find(array('condition'=>'file_id="'.$file_id.'"'));
                    $modellead=$modellead->findByPk($model_lead->id);
                    $modelmasterfile=$modelmasterfile->findByPk($file_id);
                    $modelmasterfile->file_title=$modellead->title;
                }
                 Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
		$this->render('create',array('model'=>$model,
                                            'modelQuoteItems'=>$modelQuoteItems,
                                            'modelQuoteAdditions'=>$modelQuoteAdditions,
                                            'modelQuoteDeductions'=>$modelQuoteDeductions,
                                            'modellead'=>$modellead,
                                            'model_master'=>$modelmasterfile,
                                            'file_id'=>$file_id,
                                            'modelNotes'=>$modelNotes,
                                            'modelDocument'=>$modelDocument,
                                            'leadid'=>$leadid
                                            ));
	}
        
   
    public function actionPrintInvStockLedgerReport() {

        $model = new Invoice();
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $customer_id = $_POST['customer_id'];
        $type = $_POST['type'];
        $part_no = $_POST['part_no'];
        $id = $_POST['id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_inv_stockledger', array('model' => $model,'part_no' => $part_no, 'id' => $id, 'type' => $type, 'from_date' => $from_date, 'to_date' => $to_date,  'customer_id' => $customer_id, 'title' => $title), false, true);
    }
    public function actionPrintInventoryReport() {

        $model = new StockLedger();
        $type = $_POST['type'];
        $tax_code = $_POST['tax_code'];
        $part_no = $_POST['part_no'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_inv_report', array('model' => $model,'part_no' => $part_no,'tax_code' => $tax_code,'type' => $type,  'title' => $title), false, true);
    }
    
    public function actionPrintInvLedgerReport() {

        $model = new StockLedger();
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $type = $_POST['type'];
        $part_no = $_POST['part_no'];
        $product_id = $_POST['product_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_invledger_report', array('model' => $model,'product_id'=>$product_id,'from_date' => $from_date, 'to_date' => $to_date,'part_no' => $part_no,'type' => $type,  'title' => $title), false, true);
    }
    public function actionPrintInvStockSummaryReport() {

        $model = new StockLedger();
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $part_no = $_POST['part_no'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_invsummary_report', array('model' => $model,'part_no' => $part_no,'from_date' => $from_date, 'to_date' => $to_date,'type' => $type,  'title' => $title), false, true);
    }
    public function actionPrintInvStockAsOfReport() {

        $model = new StockLedger();
        $to_date = $_POST['to_date'];
        $part_no = $_POST['part_no'];
        $type = $_POST['type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_invstockstate_report', array('model' => $model, 'to_date' => $to_date,'part_no' => $part_no,'type' => $type,  'title' => $title), false, true);
    }
    
    public function actionPrintInventoryReportPDF() {

        $model = new StockLedger();
        $type = Yii::app()->request->getParam('type');
        $part_no = Yii::app()->request->getParam('part_no');
        
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inv_report',array('model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id,'type' => $type, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }
    public function actionPrintInvStockLedgerReportPDF() {

        $model = new Invoice();

        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $type = Yii::app()->request->getParam('type');
        $part_no = Yii::app()->request->getParam('part_no');
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inv_stockledger',array('model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id,'type' => $type, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }
    public function actionGetCustomer() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'customer_vendor_name LIKE "%' . $searchTerm . '%"';
        $model = new StockLedger();
        $model = $model->findAll(array('select' => 't.customer_vendor_id,t.customer_vendor_name', 'condition' => $condition,'group'=>'customer_vendor_id'));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->customer_vendor_id;
            $data[$i]['label'] = $eachModel->customer_vendor_name;
            
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionGetProduct() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'part_number LIKE "%' . $searchTerm . '%"';
        $model = new Store();
        $model = $model->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->part_number;
            $data[$i]['label'] = $eachModel->part_number;
            $data[$i]['product_id'] = $eachModel->id;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    
}