<?php

class DeliveryController extends Controller
{
    public $layout = 'layout';
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'Create',
                    'Savedelivery',
                    'PrintDeliveryReportWoHPDF',
                    'DeleteNotes',
                    'GetNotesList',
                    'UploadDocuments',
                    'GetDocumentList',
                    'DeleteDocument',
                    'PrintDeliveryReportPDF',
                    'GetDeliveryList',
                    'PrintPackinglist',
                    'GetStockDetails',
                    'GetSortedStockDetails',
                    'GetBillofExit',
                    'changeTrackingForm',
                    'UpdateTrackingno',
                    'UpdaterentDate',
                    'saverentdate',
                    'DamageDetails',
                    'SavedamageDetails',
                    'GetCreatedUser',
                    'damagesubstitute',
                    'Viewdeliverynote',
                    'getCustomerContactdetails'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function filters()
    {
        return array('accessControl'); // perform access control for CRUD operations
    }


    public function actionIndex()
    {
        $frm = (int) Yii::app()->request->getParam('frm');

        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['sales_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['delivery_view']) &&
                Yii::app()->user->havePermissionOn['sales_menu_view'] &&
                Yii::app()->user->havePermissionOn['delivery_view']
            )
        ) {
            $this->render('index', array('frm' => $frm));
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }
    public function actionGetDeliveryList()
    {
        $model = new DeliveryNote();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $frm = $_POST['frm'];
        // var_dump($frm);
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.order_id',
            2 => 't.id',
            3 => 'customer.customer_name',
            4 => 'leadowner.first_name',
            5 => 't.delivery_date',
            6 => 't.id',
            7 => '',
            8 => '',
            9 => '',
            10 => '',
            11 => '',
            12 => '',
            13 => 't.status'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if ($frm == 1 || $frm == 3) {
            $condition .= ' AND  t.invoiced = "N" AND t.status="CL"';
        } else {
            $condition .= ' AND  (file.current_process_status IN  ("D","PD","PI") AND t.invoiced = "N" AND t.status="CL")';

        }
        if ($frm == 3) {
            $condition .= ' AND t.delivery_type ="service"';
        } else {
            $condition .= ' AND t.delivery_type ="sales"';
        }

        //$condition = 't.ready_to_invoice ="Y" AND t.isActive="Y" AND (file.current_process_status IN  ("D","PD","PI") AND t.invoiced = "N" ) ';
        if (!isset(Yii::app()->user->havePermissionOn["delivery_view_all"]) && Yii::app()->user->authorised_user != 1) {
            $condition .= ' AND (file.lead_owner_id="' . Yii::app()->user->id . '")';
        }

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["delivery_view_all"])) {
                $condition = '(t.ready_to_invoice ="Y" OR t.status!="PN")';
            } else {
                $condition = '((t.ready_to_invoice ="Y"OR t.status!="PN"))';
            }
            if (!isset(Yii::app()->user->havePermissionOn["delivery_view_all"]) && Yii::app()->user->authorised_user != 1) {
                $condition .= ' AND (file.lead_owner_id="' . Yii::app()->user->id . '")';
            }
            $searchString = $_POST['search']['value'];
            $condition .= " AND ( leadowner.first_name LIKE '%" . $searchString . "%'  OR leadowner.last_name LIKE '%" . $searchString . "%'
    OR CONCAT(leadowner.first_name, ' ', leadowner.last_name) LIKE '%" . $searchString . "%'  OR t.order_id LIKE '%" . $searchString . "%' OR   t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR customer.customer_name LIKE '%" . $searchString . "%' OR  t.billing_address LIKE '%" . $searchString . "%' ) ";
        }
        // echo $condition;
        $count = $model->with('customer', 'file', 'file.leadowner')->count(array('condition' => $condition));
        $model = $model->with('customer', 'file', 'file.leadowner')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $status = '';
        $m = 1;
        foreach ($model as $row) {
            $status = $row['file']['status'];

            $div = '<div class="btn-wrap text-center">';
            if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["delivery_convert"])) && $row['invoiced'] == 'N' && $row['ready_to_invoice'] == 'Y') {
                $div .= '
            <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'invoice/createInvoice&delivery_id=' . $row['id'] . '&file_id=' . $row['file_id'] . '\',\'Convert to Invoice\',\'xl\')" title="Convert to Invoice"><i class="fa fa-retweet"></i></button>
                     ';
            }
            if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["delivery_convert"])) && $row['invoiced'] == 'Y') {
                $div .= '
            <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'delivery/create&id=' . $row['id'] . '&file_id=' . $row['file_id'] . '\',\'View Delivery Note\',\'xl\')" title="View Delivery Note"><i class="fa fa-eye"></i></button>
                     ';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["delivery_pdf"])) {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=delivery/PrintDeliveryReportPDF&id=' . $row['id'] . '"><i class="fa fa-file-pdf-o"></i></a>';
                //   $div.=' <a class="btn btn-primary btn-xs" title="Print Packing List" target="_blank" href="?r=delivery/PrintPackinglist&id='.$row['id'].'&c_id='.$row['crm_user_id'].'"><i class="fa fa-file-pdf-o"></i></a>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_activity"])) {
                $div .= ' <button class="btn btn-primary btn-xs" title ="Edit Activity" onclick="loadPopupModal(\'activity/create&customer_id=' . $row['customer']['id'] . '\',\'' . $row['customer']['id'] . ' : ' . $row['customer']['customer_name'] . ' - Activities ' . '\',\'lg\')"><i class="fa fa-certificate"></i></button>';
            }
            //            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["sales_tracking_edit"])){
//                $div.=' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'delivery/changeTrackingForm&id='.$row['id'].'&file_id='.$row['file_id'].'\',\'Change Tracking No\',\'lg\')" title="Change Tracking No"><i class="fa fa-pencil"></i></button>';
//            }
            $div .= '</div>';
            $lead = $row->order->leadowner->fullname;
            //Check CreditNote Exist
            $creditnote_exist = 'N';
            $model_creditnote_item = CreditnoteItem::model()->find(array('condition' => 'deliverynote_id="' . $row['id'] . '"'));
            if ($model_creditnote_item->id > 0) {
                $creditnote_exist = 'Y';
            }
            //Quantity Exist for return
            $creditnote_pending = 'Y';
            $model_creditnote_quantity = CreditnoteItem::model()->find(array('select' => 'SUM(t.returned_quantity+t.damage_quantity) AS returned_quantity', 'condition' => 'deliverynote_id="' . $row['id'] . '"'));
            $model_deliveryitem_quantity = DeliveryNoteItem::model()->find(array('select' => 'SUM(t.picked_qty) as picked_qty', 'condition' => 'delivery_note_id="' . $row['id'] . '"'));
            $balance_quantity_exist = $model_deliveryitem_quantity->picked_qty - $model_creditnote_quantity->returned_quantity;
            if ($balance_quantity_exist > 0) {
                $creditnote_pending = 'N';
            }
            $status = array('PN' => 'Packing Pending', 'CL' => 'Completed', 'CN' => 'Cancelled');
            $rowData[] = array(
                $row['file_id'],
                $row['order_id'],
                $row['id'],
                $row['customer']['customer_name'],
                $lead,
                date("d/m/Y", strtotime($row['delivery_date'])),
                $row['invoiced'],//6
                $row['ready_to_invoice'],
                $row['customer']['id'],
                '',
                $creditnote_exist,
                $creditnote_pending,
                $status[$row['status']],
                $row['status'],
                $row->created_user
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
        $model = new DeliveryNote();
        $order_id = (int) Yii::app()->request->getParam('order_id');
        $frm = (int) Yii::app()->request->getParam('frm');
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $modelItems = array(new DeliveryNoteItem);
        if ($order_id > 0) {//convert from order to delivery
            $modelorder = Order::model()->findByPK($order_id);
            $model->file_id = $modelorder->file_id;
            //CODE ADDED BY ABIN ON 24/01/2024 
            $model->quotes_id = $modelorder->quotes_id;
            $model->lead_owner_id = $modelorder->lead_owner_id;
            $model->customer_id = $modelorder->customer_id;
            $model->order_id = $modelorder->id;
            $model->delivery_date = $modelorder->delivery_date;
            $model->billing_address = $modelorder->billing_address;
            $model->shipping_address = $modelorder->shipping_address;
            $model->contact_id = $modelorder->contact_id;
            $model->shipped_by = $modelorder->shipping_by;
            $model->sales_group = $modelorder->sales_group_id;
            $model->notes = $modelorder->notes;
            $model->lpo = $modelorder->lpo;
            $model->others = $modelorder->others;
            $model->remarks = $modelorder->remarks;
            $model->terms_id = $modelorder->terms_id;
            $model->terms_and_conditions = $modelorder->terms_and_conditions;
            $model->city = $modelorder->shipping_city;
            $model->inco_term_id = $modelorder->inco_term_id;
            //CODE ADDED BY MEREENA ON 08/01/2019 FOR DO -- TERMS & CONDITION DEFAULT SET
            //$arr_master_terms_conditions = MasTermsAndConditions::model()->find(array('condition'=>'terms_type="DN"'));
            //$model->terms_and_conditions = $arr_master_terms_conditions->terms;
            //END

            $model->file_title = $modelorder->file_title;

            $dns = DeliveryNote::model()->with('items')->findAll(array('condition' => 'file_id=' . $modelorder->file->id, 'order' => 'items.id ASC'));
            if($frm==3){
                $modelOrderItems = OrderItem::model()->findAll(array('condition'=>'order_id='.$order_id,'group'=>'product_id_2'));
                foreach ($modelOrderItems as $i => $eachItem) {
                  if ($eachItem->product_id != 999999) {
                       $qty = OrderItem::model()->find(array('select'=>'SUM(quantity_2) AS quantity_2','condition'=>'order_id='.$order_id.' AND product_id_2='. $eachItem->product_id_2))->quantity_2;
                            $modelDeliveryItems[$i] = new DeliveryNoteItem;
                            $modelDeliveryItems[$i]->product_id = $eachItem->product_id_2;
                            $modelDeliveryItems[$i]->part_number = $eachItem->part_number_2;
                            $modelDeliveryItems[$i]->order_item_id = $eachItem->id;
                            $modelDeliveryItems[$i]->description = $eachItem->description_2;
                            $modelDeliveryItems[$i]->quantity =  $qty;//$eachItem->quantity_2;
                            $modelDeliveryItems[$i]->unit_id = $eachItem->unit_id_2;
                            $modelDeliveryItems[$i]->unit_name = Unit::model()->findByPk((int)$eachItem->unit_id_2)->unit_name;//$eachItem->unit_2->unit_name;
                            $modelDeliveryItems[$i]->factor = $eachItem->unit_2->factor;
                        }
                }
            }
            else
            {
                foreach ($modelorder->items as $i => $eachItem) {
                   
                         if ($eachItem->product_id != 999999) {
                        $modelDeliveryItems[$i] = new DeliveryNoteItem;
                        $modelDeliveryItems[$i]->product_id = $eachItem->product_id;
                        //CODE ADDED BY ABIN ON 24-01-2024 
                        $modelDeliveryItems[$i]->part_number = $eachItem->part_number;
                        $modelDeliveryItems[$i]->quotes_item_id = $eachItem->quotes_item_id;
                        //END OF CODE
                        $modelDeliveryItems[$i]->order_item_id = $eachItem->id;
                        $modelDeliveryItems[$i]->description = $eachItem->description;
                        $modelDeliveryItems[$i]->quantity = $eachItem->quantity;
                        $modelDeliveryItems[$i]->order_item_id = $eachItem->id;
                        $modelDeliveryItems[$i]->unit_id = $eachItem->unit_id;
                        $modelDeliveryItems[$i]->unit_name = $eachItem->orderunit->name;
                        $modelDeliveryItems[$i]->factor = $eachItem->orderunit->factor;
                        $totalPicked_qty = Yii::app()->db->createCommand('SELECT SUM(DI.picked_qty) FROM  erp_delivery_item DI LEFT JOIN erp_delivery_note DN ON DN.id = DI.delivery_note_id  WHERE DN.order_id = ' . $modelorder->id . ' AND  DI.order_item_id="' . $eachItem->id . '" and DN.status!="CN"')->queryScalar();
                        $modelDeliveryItems[$i]->pickable_quantity = ($eachItem->quantity - $totalPicked_qty);
                        /*/*for bonus qty
                        $modelDeliveryItems[$i]->bonus_qty=$eachItem->bonus_qty;
                        $totalPickedBonus_qty = Yii::app()->db->createCommand('SELECT SUM(DI.picked_bonus_qty) FROM  erp_delivery_item DI LEFT JOIN erp_delivery_note DN ON DN.id = DI.delivery_note_id  WHERE DN.order_id = '.$modelorder->id.' AND  DI.order_item_id="'.$eachItem->id.'" and DN.status!="CN"')->queryScalar();
                        $modelDeliveryItems[$i]->pickable_bonus_quantity= ($eachItem->bonus_qty -$totalPickedBonus_qty);*/
                        //CODE ADDED BY MEREENA ON 18/02/2020
                        $modelDeliveryItems[$i]->inventory_type = $eachItem->inventory_type;
                        //END
    
                        $modelDeliveryItems[$i]->alternate_id = $eachItem->alternate_id;
                    }
                     
                }
                
            }
           
            //            echo "deliveredqty - ".$modelorder->file->deliveredQuantity." delivered bonus- ".$modelorder->file->deliveredBonusQuantity;
//            echo "netQuantity - ".$modelorder->netQuantity." netbonusQuantity - ".$modelorder->netbonusQuantity;
//            if (($modelorder->file->deliveredQuantity +$modelorder->file->deliveredBonusQuantity)>= ($modelorder->netQuantity+$modelorder->netbonusQuantity)) {            
//               MasterFile::model()->updateByPk($modelorder->file_id, array('is_approved' => "Y",'current_process_status'=>'D')); ///need to check full delivey,status is not updating correctly 
//            } 

        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'modelDeliveryItems' => $modelDeliveryItems, 'modelOrder' => $modelorder, 'frm' => $frm));
    }
    public function actionSavedelivery()
    {

        $modelDeliveryNote = new DeliveryNote;
        $other_err = array();
        if (isset($_POST['DeliveryNote'])) {
            $modelDeliveryNote->scenario = 'add';
            $modelDeliveryNote->attributes = $_POST['DeliveryNote'];
            $modelDeliveryNote->lpo = $_POST['DeliveryNote']['lpo'];
            //added by abin on 24-01-2024
            $modelDeliveryNote->lead_owner_id = $_POST['DeliveryNote']['lead_owner_id'];
            $modelDeliveryNote->quotes_id = $_POST['DeliveryNote']['quotes_id'];
            $modelDeliveryNote->billing_address = $_POST['DeliveryNote']['billing_address'];
            $modelDeliveryNote->terms_id = $_POST['DeliveryNote']['terms_id'];
            $modelDeliveryNote->terms_and_conditions = $_POST['DeliveryNote']['terms_and_conditions'];
            if ($_POST['DeliveryNote']['delivery_date'] != '00/00/0000') {
                $modelDeliveryNote->delivery_date = str_replace('/', '-', $_POST['DeliveryNote']['delivery_date']);
                $modelDeliveryNote->delivery_date = date("Y-m-d", strtotime($modelDeliveryNote->delivery_date));
            }
            if ($_REQUEST['hid_frm'] == 3) {
                $modelDeliveryNote->delivery_type = 'service';
            }

            //            echo ($modelDeliveryNote->file->deliveredQuantity +$modelDeliveryNote->file->deliveredBonusQuantity);            echo '<br>';
//            echo ($modelDeliveryNote->file->order->nethiringQuantity+$modelDeliveryNote->file->order->nethiringbonusQuantity); die();
            $other_errors = array();
            $total_quatity_picked = 0;
            $valid1 = true;
            $valid = true;
            $flag = 0;
            $service_only_flag = 0;
            foreach ($_POST['DeliveryNoteItem'] as $i => $item) {
                if (!empty($item['product_id'])) {
                    $modelItem[$i] = new DeliveryNoteItem;
                    $modelItem[$i]->attributes = $_POST['DeliveryNoteItem'][$i];
                    $modelItem[$i]->unit_id = $item['unit_id'];
                    //CODE ADDED BY ABIN ON 24-01-2024
                    $modelItem[$i]->quotes_item_id = $item['quotes_item_id'];
                    $modelItem[$i]->part_number = $item['part_number'];
                    //END OF CODE
                    $modelItem[$i]->picked_qty = floatval($item['picked_qty']);

                    $modelItem[$i]->remarks = $item['remarks'];
                    //CODE ADDED BY MEREENA ON 18/02/2020
                    $modelItem[$i]->inventory_type = $item['inventory_type'];

                    if ($item['inventory_type'] != 2) {   // if ($item['inventory_type'] == 1) {
                        $service_only_flag = 1;
                    }

                    //END
                    $valid = $modelItem[$i]->validate() && $valid;

                    $thisProduct = Store::model()->findByPk($_POST['DeliveryNoteItem'][$i]['product_id']);
                    $total_quatity_picked += $modelItem[$i]->picked_qty;

                    $sql = 'SELECT IFNULL(sum(quantity),0) FROM erp_stock_ledger where product_id=' . $thisProduct->id;
                    $tot_ware_qty = Yii::app()->db->createCommand($sql)->queryScalar();

                    $prod_id = $_POST['DeliveryNoteItem'][$i]['product_id'];
                    $product[$prod_id] += (int) $_POST['DeliveryNoteItem'][$i]['picked_qty'];

                    $totallocatedQuantity = @AllocatedMaterial::model()->find('product_id=:product_id', array(':product_id' => $thisProduct->id))->quantity;
                    $allocatedQuantityForThis = @AllocatedMaterial::model()->find('file_id=:file_id AND product_id=:product_id AND allocation_end_date>=:today', array(':file_id' => $modelDeliveryNote->file_id, ':product_id' => $thisProduct->id, ':today' => date("Y-m-d")))->quantity;
                    $availableQty = ($tot_ware_qty + floatval($allocatedQuantityForThis)) - $totallocatedQuantity;

                    if ($availableQty < ($total_quatity_picked + $total_bonus_quatity_picked)) {
                        $flag = 1;
                    }
                }
            }
            if (($total_quatity_picked + $total_bonus_quatity_picked) <= 0) {
                $valid = false;
                $modelItem = "";
            }
            $valid = $valid && is_array($modelItem) && $valid1;
            if ($modelDeliveryNote->validate() && $valid) { // after validation saving the whole data 

                $customer_id = 0;
                if ((int) $modelDeliveryNote->file_id > 0) {
                    if ((int) $modelDeliveryNote->customer_id > 0)
                        $customer_id = $modelDeliveryNote->customer_id;
                    else
                        $customer_id = $modelDeliveryNote->file->customer_id;
                } else
                    $customer_id = $modelDeliveryNote->customer_id;
                $satus = MasterFile::model()->findByPk($modelDeliveryNote->file_id);
                MasterFile::model()->updateByPk($modelDeliveryNote->file_id, array('is_approved' => "Y", 'current_process_status' => 'PD'));

                if ((int) $_POST['DeliveryNote']['id'] == 0) {
                    $modelDeliveryNote->order_id = Order::model()->find(array('condition' => 'file_id=' . $modelDeliveryNote->file_id))->id;
                    $modelDeliveryNote->created_by = Yii::app()->user->id;
                    $modelDeliveryNote->created_datetime = date('Y-m-d H:i:s');
                } else
                    $modelDeliveryNote->id = $_POST['DeliveryNote']['id'];
                $notification = false;
                $modelDeliveryNote->updated_by = Yii::app()->user->id;
                $modelDeliveryNote->updated_datetime = date('Y-m-d H:i:s');


                if ((int) $modelDeliveryNote->id == 0) {// if id 0 means its a new record, otherwise needs to update the existing one
                    $notification = ($modelDeliveryNote->file->is_approved == "N");
                    $modelDeliveryNote->save();
                    if (trim($_POST['DeliveryNote']['tracking_no']) == '') {
                        $tracking_no = $modelDeliveryNote->id;
                        $modelDeliveryNote->tracking_no = $tracking_no;
                    } else {
                        $modelDeliveryNote->tracking_no = $_POST['DeliveryNote']['tracking_no'];
                    }

                    if ($service_only_flag == 0) {//only service item
                        $modelDeliveryNote->status = "CL";
                    }

                    $modelDeliveryNote->save(false);

                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'DELIVERY_NOTE',
                        Yii::app()->user->id,
                        'CREATED',
                        " with PKG No: - {$modelDeliveryNote->id}  "
                    );
                    // end audit log 
                } else {
                    $modelDeliveryNote->updateByPK($modelDeliveryNote->id, $modelDeliveryNote->attributes);
                    DeliveryNoteItem::model()->deleteAll('delivery_note_id=:id', array(':id' => $modelDeliveryNote->id));
                }

                $modelDeliveryNote->refresh();
                $jsonData['shoratage'] = "";
                foreach ($modelItem as $eachItem) {
                    $eachItem->delivery_note_id = $modelDeliveryNote->id;
                    $eachItem->save(false);
                    //if($eachItem->order_item_id>0)
                    // OrderItem::model()->updateByPk($eachItem->order_item_id, array('convert_to_delivery_note' => "Y"));
                    /*if($modelDeliveryNote->file_id){
                        $modelAllocate = new AllocatedMaterial();
                        $modelAllocate->deleteAll('file_id=:file_id', array(':file_id' => $modelDeliveryNote->file_id));
                    }*/
                }
                //if(is_countable($modelDeliveryNote->file->deliveredQuantity) && is_countable($modelDeliveryNote->file->order->OrderNetQuantity)){ 
                //echo $modelDeliveryNote->file_id."<br>";
                //echo $modelDeliveryNote->file->deliveredQuantity."<br>";
                //echo $modelDeliveryNote->file->order->OrderNetQuantity."<br>";
                if ($modelDeliveryNote->file->deliveredQuantity >= $modelDeliveryNote->file->order->OrderNetQuantity) {
                    MasterFile::model()->updateByPk($modelDeliveryNote->file_id, array('is_approved' => "Y", 'current_process_status' => 'D')); ///need to check full delivey,status is not updating correctly 
                }
                //}
                //$model_mail_setting=Notification::model()->find(array('condition' => 'event_id="7"'));
                //Yii::import('application.controllers.front.MasternotificationController'); 
                /*
                if($model_mail_setting->mail_required=='Y'){ 
                    MasternotificationController::sendmail(7,$modelDeliveryNote->id);
                }
                if($model_mail_setting->notification_required=='Y'){                    
                    MasternotificationController::sendnotification(7,$modelDeliveryNote->id);
                }
                if($model_mail_setting->sms_required=='Y'){                    
                    MasternotificationController::sendsms(7,$modelDeliveryNote->id);
                }
               */
                $modelDeliveryNote->update_if_have_service_only();
                $jsonData['file'] = $modelDeliveryNote->file;
                $jsonData['model'] = $modelDeliveryNote;
                $jsonData['frm'] = $_POST['hid_frm'];
                $jsonData['status'] = 'success';
                Yii::app()->session['customer_id'] = $modelDeliveryNote->customer_id;
                echo CJSON::encode($jsonData);


            } else {
                $error1 = json_decode(CActiveForm::validate($modelDeliveryNote, '', false), true);
                if (is_array($modelItem))
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                if ($flag == 1)
                    $error2[] = "Insufficient Quantity";
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $other_errors, $other_err));
                if ($error != '[]')
                    echo $error;
            }
            Yii::app()->end();
        } else {
            echo 'error';
        }
    }

    public function actionPrintDeliveryReportPDF()
    {
        $model = new DeliveryNote();
        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $type = (int) Yii::app()->request->getParam('type');
        $model_Delivery = DeliveryNote::model()->findByPk($id);
        $view = 'delivery_list_individual';
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        if ($model_Delivery->status == 'CN') {
            $mPDF1->SetWatermarkText('CANCELLED');
            $mPDF1->showWatermarkText = true;
        }
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.' . $view, array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title, 'type' => $type), true));
        $mPDF1->Output("Deliveryreport.pdf", 'I');
    }
    public function actionPrintPackinglist()
    {
        $model = new DeliveryNote();
        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.pickinglist', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title), true));
        $mPDF1->Output("PrintPackinglist.pdf", 'I');
    }
    public function actionUpdaterentDate()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $type = (int) Yii::app()->request->getParam('type');
        $model = DeliveryNote::model()->findByPk($id);
        $model_items = DeliveryNoteItem::model()->findAll(array('condition' => 'delivery_note_id="' . $id . '" and picked_qty>0', 'order' => 'id ASC'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('update_rent_date', array('model' => $model, 'model_items' => $model_items, 'type' => $type));
    }
    public function actionsaverentdate()
    {
        if (isset($_POST['DeliveryNote'])) {
            if ((int) @$_POST['DeliveryNote']['id'] > 0) {
                $id = (int) $_POST['DeliveryNote']['id'];
                $type = $_POST['type'];
                if ($type == 1) {
                    $rent_date = '';
                    if ($_POST['DeliveryNote']['rent_date'] != '0000-00-00' && $_POST['DeliveryNote']['rent_date'] != '') {
                        $rent_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['DeliveryNote']['rent_date'])));
                    }
                    DeliveryNote::model()->updateByPK($id, array('rent_date' => $rent_date, 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d h:i:s')));
                    AuditLog::saveAuditLogs(
                        'DELIVERY_RENT_DATE_CHANGED',
                        Yii::app()->user->id,
                        'RENT DATE CHANGED',
                        " with ID: - {$id}  "
                    );
                } else if ($type == 2) {
                    $delivery_date = '';
                    if ($_POST['DeliveryNote']['delivery_date'] != '0000-00-00' && $_POST['DeliveryNote']['delivery_date'] != '') {
                        $delivery_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['DeliveryNote']['delivery_date'])));
                    }
                    DeliveryNote::model()->updateByPK($id, array('delivery_date' => $delivery_date, 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d h:i:s')));
                    AuditLog::saveAuditLogs(
                        'DELIVERY_DELIVERY_DATE_CHANGED',
                        Yii::app()->user->id,
                        'DELIVERY DATE CHANGED',
                        " with ID: - {$id}  "
                    );
                }

                $jsonData['status'] = 'success';
            } else {
                $jsonData['status'] = 'error';
            }
            echo CJSON::encode($jsonData);
        }
    }
    public function actionDamageDetails()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $model = DeliveryNote::model()->findByPk($id);
        $model_items = HiringPackageDetails::model()->findAll(array('condition' => 'delivery_id="' . $id . '" and quantity>0', 'order' => 'id ASC'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('damage_details', array('model' => $model, 'model_items' => $model_items));
    }
    public function actionSavedamageDetails()
    {
        if (isset($_POST['DeliveryNote'])) {
            foreach ($_POST['HiringPackageDetails'] as $i => $item) {
                if ($item['id'] > 0 && $item['is_damage'] == 1 && $item['damage_quantity'] > 0) {
                    $modelItem[$i] = HiringPackageDetails::model()->findByPK($item['id']);
                    $modelItem[$i]->is_damage = 'Y';
                    $modelItem[$i]->damage_quantity = $item['damage_quantity'] + $modelItem[$i]->damage_quantity;
                    $modelItem[$i]->damage_remarks = $item['damage_remarks'];
                    if ($item['damage_date'] != '0000-00-00' && $item['damage_date'] != '') {
                        $modelItem[$i]->damage_date = date("Y-m-d", strtotime(str_replace('/', '-', $item['damage_date'])));
                    }
                    $modelItem[$i]->save(false);
                    //Damage History
                    date_default_timezone_set("Asia/Dubai");
                    $model_damage_history = new HiringDamageHistory();
                    $model_damage_history->created_by = Yii::app()->user->id;
                    $model_damage_history->created_date_time = date('Y-m-d h:i:s');
                    $model_damage_history->hiring_package_details = $modelItem[$i]->id;
                    $model_damage_history->pdt_loc_id = $modelItem[$i]->product_loc_hiring_id;
                    $model_damage_history->product_id = $modelItem[$i]->product_id;
                    $model_damage_history->damage_quantity = $modelItem[$i]->damage_quantity;
                    $model_damage_history->damage_date = $modelItem[$i]->damage_date;
                    $model_damage_history->damage_remarks = $modelItem[$i]->damage_remarks;
                    $model_damage_history->save(false);
                }
            }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
            Yii::app()->end();
        }
    }
    public function actionGetCreatedUser()
    {
        $delivery_id = (int) $_POST['id'];
        $modelDelivery = DeliveryNote::model()->findByPk($delivery_id);
        echo "<span style='color:red;'><b>" . $modelDelivery->created_user . "</b></span>";
    }
    public function actionPrintDeliveryReportWoHPDF()
    {
        $model = new DeliveryNote();
        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $type = (int) Yii::app()->request->getParam('type');
        $model_Delivery = DeliveryNote::model()->findByPk($id);
        $view = 'delivery_list_individual_woh';

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        if ($model_Delivery->status == 'CN') {
            $mPDF1->SetWatermarkText('CANCELLED');
            $mPDF1->showWatermarkText = true;
        }
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.' . $view, array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title, 'type' => $type), true));
        $mPDF1->Output("Deliveryreport.pdf", 'I');
    }
    public function actiondamagesubstitute()
    {
        $model = new DeliveryNote();
        $order_id = (int) Yii::app()->request->getParam('id');
        $file_id = (int) Yii::app()->request->getParam('file_id');
        if ($order_id > 0) {//convert from order to delivery
            $modelorder = Order::model()->findByPK($order_id);
            $model->file_id = $modelorder->file_id;
            $model->customer_id = $modelorder->customer_id;
            $model->order_id = $modelorder->id;
            $model->delivery_date = $modelorder->delivery_date;
            $model->billing_address = $modelorder->billing_address;
            $model->shipping_address = $modelorder->shipping_address;
            $model->contact_id = $modelorder->contact_id;
            $model->shipped_by = $modelorder->shipping_by;
            $model->sales_group = $modelorder->sales_group;
            $model->notes = $modelorder->notes;
            $model->terms_id = $modelorder->terms_id;
            $model->lpo = $modelorder->lpo;
            $model->others = $modelorder->others;
            $model->remarks = $modelorder->remarks;
            $arr_master_terms_conditions = MasTermsAndConditions::model()->find(array('condition' => 'terms_type="DN"'));
            $model->terms_and_conditions = $arr_master_terms_conditions->terms;
            $model->terms_id = $modelorder->terms_id;
            $model->file_title = $modelorder->file_title;
            //Hiring Package
            $model_package_details = OrderItem::model()->findAll(array('condition' => 'order_id="' . $modelorder->id));
            foreach ($model_package_details as $i => $eachItem) {
                $model_delivery_item = DeliveryNoteItem::model()->with('deliveryNote')->find(array('select' => 'sum(picked_qty) as quantity', 'condition' => 'deliveryNote.order_id="' . $modelorder->id . '" and order_item_id="' . $eachItem->id . '"'));
                if ($eachItem->quantity > $model_delivery_item->quantity) {
                    $pickable_quantity = $eachItem->quantity - $model_delivery_item->quantity;
                    $modelDeliveryItems[$i] = new DeliveryNoteItem;
                    $modelDeliveryItems[$i]->product_id = $eachItem->product_id;
                    $modelDeliveryItems[$i]->order_item_id = $eachItem->id;
                    $modelDeliveryItems[$i]->description = $eachItem->description;
                    $modelDeliveryItems[$i]->quantity = $eachItem->quantity;
                    $modelDeliveryItems[$i]->unit = $eachItem->unit_id;
                    $modelDeliveryItems[$i]->unit_name = $eachItem->orderunit->name;
                    $modelDeliveryItems[$i]->factor = $eachItem->orderunit->factor;
                    $modelDeliveryItems[$i]->pickable_quantity = $pickable_quantity;
                    $modelDeliveryItems[$i]->inventory_type = $eachItem->inventory_type;
                }
            }

        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'modelDeliveryItems' => $modelDeliveryItems, 'modelOrder' => $modelorder));
    }
    public function actionViewdeliverynote()
    {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = DeliveryNote::model()->findByPK($id);
            $model_items = DeliveryNoteItem::model()->findAll(array('condition' => 'delivery_note_id="' . $id . '"'));

        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('view_delivery_note', array('model' => $model, 'model_items' => $model_items));
    }
    public function actiongetCustomerContactdetails()
    {

        $id = Yii::app()->request->getparam("id");
        $customer = CustomerShippingDetails::model()->findBypk($id);
        if ($customer->shipping_customer_name != '')
            $ads = $customer->shipping_customer_name . PHP_EOL;
        else
            $ads = '';
        if ($customer->street_address != '')
            $street_address = $customer->street_address . PHP_EOL;
        else
            $street_address = '';
        if ($customer->state != '')
            $state = "PO Box : " . $customer->state . PHP_EOL;
        else
            $state = '';
        if ($customer->city != '')
            $city = $customer->city . PHP_EOL;
        else
            $city = '';
        $adds = $ads . $street_address . $city . $state . $customer->country->country_name;

        $status = array('adds' => $adds);
        echo CJSON::encode($status);
    }
}
