<?php

class DashboardmatrixController extends Controller
{

	public function accessRules()
	{
		return array(
			array(
				'allow',
				'actions' => array('DemoIndex', 'Index','DemoCopyIndex','GetStockDetails','GetProduct'),
				'expression' => '$user->isMember()',

			),
			array(
				'allow',
				'actions' => array('login', 'error', 'logout'),
				'users' => array('*'),
			),
			array(
				'deny', // deny all users
				'users' => array('*'),
			),
		);
	}
	public function actionIndex()
	{
		$this->render('index');
	}
	public function actionDemoIndex()
	{
		$this->render('demo_page');
	}
	public function actionDemoCopyIndex()
	{
		$this->render('demo_page_copy');
	}

	public function actionGetProduct()
	{
		$term = Yii::app()->request->getParam('term');
		$frm = Yii::app()->request->getParam('frm'); // you pass 'stock', can be used if needed

		$criteria = new CDbCriteria();
		$criteria->addSearchCondition('part_number', $term, true, 'OR');
		$criteria->addSearchCondition('description', $term, true, 'OR');
		$criteria->limit = 20;

		$products = Store::model()->findAll($criteria);

		$result = [];
		foreach ($products as $p) {
			$result[] = [
				'id' => $p->id,
				'part_number' => $p->part_number,
				'description' => $p->description,
			];
		}

		echo CJSON::encode($result);
		Yii::app()->end();
	}
	public function actionGetStockDetails($product_id)
	{
		$stock = StockLedger::model()->with('product')->find(array(
			'condition' => 'product_id=:pid',
			'params' => [':pid' => $product_id],
			'order' => 'transaction_date DESC',
		));

		if ($stock) {
			if ($stock) {
				$brand_name = '-';
				if (!empty($stock->product->brand_class_id)) {
					$model_brand = MasInvBrand::model()->findByPk($stock->product->brand_class_id);
					if ($model_brand) {
						$brand_name = $model_brand->brand_name;
					}
				}
				$result = [
					'part_number' => $stock->product->part_number,
					'description' => $stock->product->description,
					'brand_name' => $brand_name,
					'category_name' => $stock->product->genericdetails->generic_name,
					'quantity' => $stock->quantity * $stock->unit_factor,
					'rate' => number_format($stock->product->rate, 2),
					'value' => number_format($stock->quantity * $stock->unit_factor * $stock->cost_price, 2),
				];
			} else {
				$result = [
					'part_number' => '-',
					'description' => '-',
					'brand_name' => '-',
					'category_name' => '-',
					'quantity' => 0,
					'cost_price' => 0,
					'value' => 0
				];
			}

			echo CJSON::encode($result);
			Yii::app()->end();
		}

		// Uncomment the following methods and override them if needed
		/*
		public function filters()
		{
			// return the filter configuration for this controller, e.g.:
			return array(
				'inlineFilterName',
				array(
					'class'=>'path.to.FilterClass',
					'propertyName'=>'propertyValue',
				),
			);
		}

		public function actions()
		{
			// return external action classes, e.g.:
			return array(
				'action1'=>'path.to.ActionClass',
				'action2'=>array(
					'class'=>'path.to.AnotherActionClass',
					'propertyName'=>'propertyValue',
				),
			);
		}
		*/
	}
}