<?php
class DamagedstoreController extends Controller
{
    public $layout = 'layout';
    public function accessRules() {
        return array(
                        array('allow', // allow all users to perform 'index' and 'view' actions
                                        'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover'),
                                        'users' => array('*'),
                        ),
                        array('allow', // allow authenticated user to perform 'create' and 'update' actions
                                        'actions' => array('index','GetList','Create','Save'  ,'Getunitdrop','GetProducts','Append',
                                            'GetTotal','GetStockDetails','GetSortedStockDetails','GetFactor','Print'),
                                        'expression' => '$user->isMember()',
                        ),
                        array('deny', // deny all users
                                        'users' => array('*'),
                        ),
        );
    }
    public function filters() {
            return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex()
    {
            $this->render('index');
    }
    public function actionGetList()
    {
        $model=new DamagedStore();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
                        // datatable column index  => database column name
                        0=>'t.id',
                        1=>'transfer_date',
                        2=>'reference',
                        3=>'t.id'

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn." ".$filterOrder;
        $condition = '1=1 ';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
                $searchString = $_POST['search']['value'];
                $condition.=" AND (t.id LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.transfer_date DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $status='';
        foreach ($model as $row)
        {
            if($row['transfer_date'] !='0000-00-00'){
                $date = date("d/m/Y",strtotime($row['transfer_date']));
            }else{
                $date ='';
            }
            $print_btn='<a class="btn btn-primary btn-xs" title="View" href="#" onclick="loadPopupModal(\'damagedstore/create&id='.$row['id'].'\',\'Issue\',\'xl\')"><i class="fa fa-eye"></i></a>';
            if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["damaged_store_pdf"])) ){
                $print_btn.=' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=damagedstore/print&id='.$row['id'].'"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }

            $rowData[]=array($row['id'],$date,$row->reference,'<div class="btn-wrap text-center">
            '.$print_btn.'   </div>');
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
            $model=new DamagedStore();
            $model_items= array(new DamagedStoreDetails());
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0)
            {
                    $model = $model->findByPk($id);
                    $model_items= DamagedStoreDetails::model()->findAll(array('condition'=>'damaged_store_id='.$id));
            }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false);

            //$this->render('create',array('model'=>$model,'modelMaster'=>$modelMaster,'modelDocument'=>$modelDocument,'modelNotes'=>$modelNotes,'id' => $id));
        $this->render('create', array('model' => $model,'id' => $id,'model_items' =>$model_items));
    }
    public function actionGetunitdrop(){
        $row = $_POST['row_field'];
        $product = $_POST['product_id'];
        $drop = array();
        $modelOrder = new DamagedStoreDetails;
        if($product > 0){
            $modelOrder->unit = UnitOfMeasurement::getBaseunit($product);
            $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit",UnitOfMeasurement::getUnits($product), array('class'=>'unit go','onchange' => 'getFactor(this.id,this.value)'));
        }
        echo CJSON::encode($drop);
    }
     /**copied by jisha from issue on 16-2-18**/
        public function actionSave()
        {
            $model = new DamagedStore();
             
            if (isset($_POST['DamagedStore']))
            {
                if ((int) @$_POST['DamagedStore']['id'] > 0)
                {   
                    $id= (int) @$_POST['DamagedStore']['id'];
                    $model=$model->findByPk($id);
                }
                else{
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date_time =date('Y-m-d h:i:s');
                }
                
                $model->attributes=$_POST['DamagedStore'];
                if($_POST['DamagedStore']['transfer_date']!='00/00/0000' && $_POST['DamagedStore']['transfer_date']!=''){
                            $model->transfer_date = str_replace('/', '-', $_POST['DamagedStore']['transfer_date']);
                            $model->transfer_date= date("Y-m-d", strtotime($model->transfer_date));
                }
                
                if ($model->validate())
                {   
                          $valid= true;
                          if(!empty($_POST['DamagedStoreDetails'])) {
                              $date = date("Y-m-d H:i:s");
                               foreach ($_POST['DamagedStoreDetails'] as $k => $rowItem) {
                                    if($rowItem['id'] > 0){
                                        $model_item[$k] = DamagedStoreDetails::model()->findByPk($rowItem['id']);
                                    }else{
                                        $model_item[$k] = new DamagedStoreDetails();
                                        $model_item[$k]->created_by = Yii::app()->user->id; 
                                        $model_item[$k]->created_date_time = $date;
                                    }
                                    
                                    $model_item[$k]->product_id = $rowItem['product_id'];
                                    $model_item[$k]->part_number = $rowItem['part_number'];
                                    $model_item[$k]->description = $rowItem['description'];
                                    $model_item[$k]->quantity = $rowItem['quantity'];
                                    $model_item[$k]->unit = $rowItem['unit']; 
                                    $model_item[$k]->rate = $rowItem['rate'];
                                    $model_item[$k]->damaged_store_id = 0;
                                    $valid = $model_item[$k]->validate() && $valid;
                               }
                              
                          }
                          
                       if($valid){
                           $exist = DamagedStore::model()->findAll();
                            if(empty($exist)){
                                $value = MasNumberSettings::model()->findByPk(17)->value;
                                Yii::app()->db->createCommand("ALTER TABLE crm_damaged_store AUTO_INCREMENT=".$value." ")->query();

                            }
                           $model->save();
                           foreach ($model_item as $eachitem){
                               $eachitem->damaged_store_id = $model->id;
                               $eachitem->save();                               
                            }
                            /**
                            * Delivery Items Update
                            */
                           if(is_array($_POST['Data'])){
                               foreach($_POST['Data'] as $each){
                                   if($each['material_receipt_id'] > 0 && $each['picked_qty'] > 0){
                                       $stock = MaterialReceiptStockDetails::model()->findbypk($each['material_receipt_id']);

                                       /*Saving */
                                       $materialDetails = new DamagedStoreMaterialDetails;
                                       $materialDetails->damaged_store_id = $model->id;
                                       $materialDetails->product_id =$stock->product_id;
                                       $materialDetails->material_receipt_id =  $stock->id;
                                       $materialDetails->warehouse_id =  $stock->warehouse_id;
                                       $materialDetails->rack_id =  $stock->rack_id;
                                       $materialDetails->bin_id =  $stock->bin_id;
                                       $materialDetails->material_receipt_qty =  $stock->quantity;
                                       $materialDetails->issued_qty =  $each['picked_qty'];
                                       $materialDetails->bill_exit = $each['bill_of_exit'];
                                       $materialDetails->created_by = Yii::app()->user->id;
                                       $materialDetails->created_date_time  = date('Y-m-d h:i:s');
                                       $materialDetails->save(false);

                                       
                                       $stock->quantity = (float) $stock->quantity -  (float) $each['picked_qty'];
                                       $stock->save(false);
                               
                                       /*Inventory Update*/
                                       $old_total_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) FROM  crm_product_location WHERE stock_id='.$stock->product_id.' ')->queryScalar();
                                       /**
                                        * Variables
                                        */
                                       $warehouse = $stock->warehouse_id;
                                       $rack = $stock->rack_id;
                                       $bin = $stock->bin_id;
                                       $con = 'stock_id='. $stock->product_id;
                                       if($warehouse > 0)
                                           $con .= ' AND warehouse_id='.$warehouse;
                                       if($rack > 0)
                                           $con .= ' AND rack='.$rack;
                                       if($bin > 0)
                                           $con .= ' AND bin='.$bin;
                                       $productlocation = ProductLocation::model()->find(array('condition' => $con));
                                       if( $productlocation->id > 0){
                                           $loc = ProductLocation::model()->findByPk($productlocation->id);
                                           $loc->quantity = (float) $loc->quantity - (float) $each['picked_qty'];
                                           $loc->save(false);
                                       }
                                       Store::model()->updateByPk($stock->product_id, array('total_quantity' => ($old_total_qty -$each['picked_qty'])));
                                   }
                               }
                           }
                           /*End*/
                            $this->dailyclosingstock();
                            $jsonData['status'] = 'success';
                            $jsonData['frm'] = $_POST['issues_form'];
                            $jsonData['id'] = $model->id;
                            $jsonData['data'] = $data;
                            echo CJSON::encode($jsonData);
                       }else{
                           if (!empty($model_item[0]->product_id))
                                $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                            else
                                $error2[] = "Please add atleast one line item";
                           $error = CJSON::encode($error2);
                           if ($error != '[]')
                                echo $error;

                       }
                        
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }/**copied by jisha from issue on 8-11-17**/
        public function actionGetProducts() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'isActive = "Y" AND ( inventory_item_type =1 OR inventory_item_type=3) AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        $model = new Store();
        $model = $model->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            
           
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number.' : '. $eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $data[$i]['supercede_id'] = $eachModel->supercede_id;
            $data[$i]['supercede_name'] = $eachModel->supercede->part_number;
            $data[$i]['supercede_des'] = $eachModel->supercede->description;
            $data[$i]['supercede_unit_name'] = $eachModel->supercede->unit->symbol;
            $data[$i]['supercede_unit_id'] = $eachModel->supercede->unit->id;
            if($eachModel->supercede_id > 0){
                $id = $eachModel->supercede_id;
                $rate =  $eachModel->supercede->rate;
                $ware_house = $eachModel->supercede->default_warehouse_id;
            }else{
                $id = $eachModel->id;
                $rate =  $eachModel->rate;
                $ware_house = $eachModel->default_warehouse_id;
            }
            $total_allocated_product = AllocatedMaterial::model()->find(array('select' => 'sum(quantity) as quantity','condition'=>'product_id="'.$eachModel->id.'"'))->quantity; 
            $total_available_product=ProductLocation::model()->find(array('select' => 'sum(quantity) as quantity','condition'=>'stock_id="'.$eachModel->id.'"'))->quantity; 
            $data[$i]['total_qty'] = (float)$total_available_product;
            $data[$i]['allocated_qty'] = (float)$total_allocated_product;
            $data[$i]['rate'] = $rate;
            $data[$i]['warehouse'] = $ware_house;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    /**copied by jisha from bouleward on 8-11-17**/
    public function actionAppend(){
        $id=Yii::app()->request->getparam("id");  
        $i=Yii::app()->request->getparam("order");  
        $model=new DamagedStoreDetails();
        $data = ProductLocation::getProductWarehouses($id); 
        $drop = CHtml::activedropDownList($model,'[' . $i . ']product_location_id' , $data,array('class' => 'go', 'prompt' => '--select--', 'title' => '--select--','data-label'=>'Location *','onChange' => 'getQuantity(this.id,this.value)'));    
        $status=array("drop" => $drop);    
        echo CJSON::encode($status);
            
    }
    /**copied by jisha from bouleward on 8-11-17**/
    public function actionGetTotal(){
        $product = $_POST['product_id'];
        $warehouse =  $_POST['warehouse'];
        $status= array();
        if($product > 0 && $warehouse > 0){
            $loc = ProductLocation::model()->find(array('condition' => 'stock_id ='.$product.' AND warehouse_id='.$warehouse));
            if(!empty($loc))
                $status['total'] = $loc->quantity;
            else
                $status['total'] = 0 ;
        }
       echo CJSON::encode($status);

    }

    public function actionGetStockDetails(){
            
        $product_id = $_POST['product_id'];
        $quantity = $_POST['Qty'];
        $length = $_POST['length'];
        $stock_details = array(new MaterialReceiptStockDetails);

        if((int) $product_id > 0){
            $product = Store::model()->findBypk($product_id);
            $stock_details = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'product_id = '.$product_id.' AND quantity > 0'));
        }

        $table = '';
        if($stock_details[0]->id > 0){

            foreach($stock_details as $each){
//                    $mod_alloc=new AllocatedMaterial();
//                    $alloc_qty=$mod_alloc->find(array('select'=>'SUM(quantity)AS quantity ','condition'=>'product_id = '.$product_id.' AND warehouse_id ='.$each->warehousename->id))->quantity;
//                    $free_qty=(float)((float)$each->quantity-(float)$alloc_qty);
                $class = '';
                if($each->expiry_date != '0000-00-00'){
                    $expire = date('d/m/Y',strtotime($each->expiry_date));
                    if(strtotime($each->expiry_date) < strtotime(date('Y-m-d'))){
                        $class = 'bg-danger';
                    }
                }else{
                    $expire = '-';
                }
                if($each->stock_affect_date != '0000-00-00'){
                    $purchased = date('d/m/Y',strtotime($each->stock_affect_date));
                }else{
                    $purchased = '-';
                }

                $table .= '<tr class="'.$class.' TR-'.$length.'">';
                $table .= '<td>'.$each->warehousename->warehouse_name.'</td>';
                $table .= '<td>'.$product->part_number.CHtml::hiddenfield('Data['.$length.'][product_id]',$product_id).CHtml::hiddenfield('Data['.$length.'][material_receipt_id]',$each->id).'</td>';
                $table .= '<td>'.$each->rack->name.CHtml::hiddenfield('Data['.$length.'][rack_id]',$each->rack_id).'</td>';
                $table .= '<td>'.$each->bin->name.CHtml::hiddenfield('Data['.$length.'][bin_id]',$each->bin_id).'</td>';
                $table .= '<td>'.$each->batch_no.'</td>';
                $table .= '<td>'.$each->serial_no.'</td>';
                $table .= '<td>'.$purchased.'</td>';
                $table .= '<td>'.$expire.'</td>';
                $table .= '<td>'.CHtml::textfield('Data['.$length.'][bill_of_exit]','',array('class' => 'form-control')).'</td>';
                $table .= '<td>'.CHtml::textfield('Data['.$length.'][qty_available]',$each->quantity,array('class' => 'form-control text-right','readonly' => 'readonly')).'</td>';
                $table .= '<td>'.CHtml::textfield('Data['.$length.'][picked_qty]','',array('class' => 'form-control text-right','onkeyup' => 'verifyQty(this.id,this.value);')).'</td>';
                $table .= '</tr>';
                $length++;
            }

        }else{ 
            if($length == 0)
                $table .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
        }

        echo $table;
    }

    public function actionGetSortedStockDetails(){

        $products = array();
        if(is_array($_POST['products'])){
            foreach($_POST['products'] as $i => $each){
                $products[$i] = (int) $each;
            }
        }

        $attr = $_POST['attr'];

        if($_POST['toggle'] == 1)
            $toggle = 'DESC';
        else
            $toggle = 'ASC';


        if(!empty($products))
            $stock_details = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'product_id IN ('.implode(',',$products).') AND quantity > 0','order' => $attr.' '.$toggle));
        else
            $stock_details = array(new MaterialReceiptStockDetails);

        $table = '';
        if($stock_details[0]->id > 0){

            foreach($stock_details as $length => $each){

                $class = '';
                if($each->expiry_date != '0000-00-00'){
                    $expire = date('d/m/Y',strtotime($each->expiry_date));
                    if(strtotime($each->expiry_date) < strtotime(date('Y-m-d'))){
                        $class = 'bg-danger';
                    }
                }else{
                    $expire = '-';
                }
                if($each->stock_affect_date != '0000-00-00'){
                    $purchased = date('d/m/Y',strtotime($each->stock_affect_date));
                }else{
                    $purchased = '-';
                }

                $table .= '<tr class="'.$class.' TR-'.$length.'">';
                $table .= '<td>'.$each->warehousename->warehouse_name.'</td>';
                $table .= '<td>'.$each->product->part_number.CHtml::hiddenfield('Data['.$length.'][product_id]', $each->product_id).CHtml::hiddenfield('Data['.$length.'][material_receipt_id]',$each->id).'</td>';
                $table .= '<td>'.$each->rack->name.CHtml::hiddenfield('Data['.$length.'][rack_id]',$each->rack_id).'</td>';
                $table .= '<td>'.$each->bin->name.CHtml::hiddenfield('Data['.$length.'][bin_id]',$each->bin_id).'</td>';
                $table .= '<td>'.$each->batch_no.'</td>';
                $table .= '<td>'.$each->serial_no.'</td>';
                $table .= '<td>'.$purchased.'</td>';
                $table .= '<td>'.$expire.'</td>';
                $table .= '<td>'.CHtml::textfield('Data['.$length.'][bill_of_exit]','',array('class' => 'form-control')).'</td>';
                $table .= '<td>'.CHtml::textfield('Data['.$length.'][qty_available]',$each->quantity,array('class' => 'form-control text-right','readonly' => 'readonly')).'</td>';
                $table .= '<td>'.CHtml::textfield('Data['.$length.'][picked_qty]','',array('class' => 'form-control text-right','onkeyup' => 'verifyQty(this.id,this.value);')).'</td>';
                $table .= '</tr>';
                $length++;
            }

        }else{ 
            if($length == 0)
                $table .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
        }

        echo $table;
    }
    public function actionGetFactor(){
        $factor = 1;
        if((int) $_POST['value'] > 0){
            $factor = UnitOfMeasurement::getFactor($_POST['value']);
        }
        echo $factor;
    }
    public function actionPrint(){
        $model=new DamagedStore();
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.damaged_stock_individual', array('model' => $model, 'id' => $id,'title' => $title),true));
        $mPDF1->Output("DamagedStock.pdf", 'I');
    }
}