<?php

class CountryController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveCountry', 'DeleteCountry', 'DirectAdd', 'Disable','UploadProfilePhoto'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['master_country_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['master_country_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
                $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
        }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new MasCountry();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'country_name',
            1 => 'country_code',
            2 => 'nationality',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        // $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition  = "  (country_name LIKE '%" . $searchString . "%' OR country_code LIKE '%" . $searchString . "%' OR nationality LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["master_country_edit"])) {
                // $div .=   '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'country/create&id='.$row['id'].'\',\'Edit Currency\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_country_delete"])) {
                // $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteCountry('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            }
            $rowData[] = array($m,
                $row['country_name'],
                $row['country_code'],
                $row['nationality'],
                $row['isDefault'],
                // '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'],'code'=>$row['country_name'], 'status' => $row->isActive),);

            $m++;
        }



//                
//                foreach ($model as $row)
//                {
//                    $rowData[]=array($m,$row['country_name'],$row['country_code'],
//              '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'country/create&id='.$row['id'].'\',\'Edit Currency\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteCountry('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//                    $m++;
//                }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasCountry();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('country_form', array('model' => $model), false, false);
    }

    public function actionSaveCountry() {
        $model = new MasCountry();
    
        if (isset($_POST['MasCountry'])) {
            $isNew = true;
    
            // Check if it's an update
            if ((int) $_POST['MasCountry']['id'] > 0) {
                $model = MasCountry::model()->findByPk((int) $_POST['MasCountry']['id']);
                if ($model === null) {
                    echo CJSON::encode(array('status' => 'error', 'message' => 'Invalid Country ID'));
                    return;
                }
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d H:i:s');
                $audit_type = 'UPDATED';
                $isNew = false;
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d H:i:s');
                $audit_type = 'CREATED';
            }
    
            // Set attributes first
            $model->attributes = $_POST['MasCountry'];
            $model->nationality = $_POST['MasCountry']['country_name'];
            $model->isDefault = $_POST['MasCountry']['isDefault'];
            $model->phone_code = $_POST['MasCountry']['phone_code'];
            $model->flag_image = $_POST['MasCountry']['flag_image'];

    
            // Reset all other defaults if this isDefault is Y
            if ($model->isDefault == "Y") {
                MasCountry::model()->updateAll(array('isDefault' => 'N'), 'isDefault = "Y" AND id != :id', array(':id' => $model->id ? $model->id : 0));
            }
    
            // Handle flag image upload
            $uploadedFile = CUploadedFile::getInstance($model, 'flag_image');
            if ($uploadedFile) {
                $fileName = time() . '_' . $uploadedFile->name;
                $uploadPath = Yii::getPathOfAlias('webroot.uploads.flags') . '/' . $fileName;
    
                if ($uploadedFile->saveAs($uploadPath)) {
                    $model->flag_image = $fileName;
                }
            }
    
            // Save model
            if ($model->save()) {
                // Audit log
                AuditLog::saveAuditLogs(
                    'COUNTRY',
                    Yii::app()->user->id,
                    $audit_type,
                    " with code : - {$model->country_code}"
                );
    
                echo CJSON::encode(array(
                    'status' => 'success',
                    'id' => $model->id
                ));
            } else {
                echo CActiveForm::validate($model);
            }
        }
    }
    

    public function actionDeleteCountry() {

        $id = $_POST['id'];
        $model_c = Customer::model()->findAll(array('condition' => 'customer_country = ' . $id . ' '));
        $model_com = Company::model()->findAll(array('condition' => 'shipping_country = ' . $id . ' '));
        if (empty($model_c) && empty($model_com)) {
            $model = new MasCountry();
            $country = $model->findByPk($id); // audit log changes
            $model->deleteByPk($id);
            // inserting to audit log
				 AuditLog::saveAuditLogs(
                    'COUNTRY',
                    Yii::app()->user->id,
                    'DELETED',
                    " with code : - {$country->country_code}"
                );
                // end audit log
            echo "success";
        } else {
            echo "fail";
        }
    }

    public function actionDirectAdd() {
        $from = $_POST['from'];
        $name = $_POST['name'];
        $code = $_POST['code'];
        if ($name != '' && $code != '') {
            $modelCountry = new MasCountry;
            $modelCountry->created_by = Yii::app()->user->id;
            $modelCountry->created_datetime = date('Y-m-d h:i:s');
            $modelCountry->country_name = $name;
            $modelCountry->country_code = $code;
            if ($modelCountry->save()) {
                $data = MasCountry::getCountry();
                if ($from == 'customer') {
                    $model = new Customer;
                    $field_name = 'customer_country';
                }
                if ($from == 'vendor') {
                    $model = new Vendor;
                    $field_name = 'vendor_country';
                }
                $model->$field_name = $modelCountry->id;
                $drop = CHtml::activedropDownList($model, $field_name, $data, array('class' => 'tooltipster', 'data-label' => 'Country <span style="color:red;">*</span>'));
                $status = array("status" => "success", "drop" => $drop);
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelCountry, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
            public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasCountry();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    public function actionUploadProfilePhoto($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
    
        $field_id = Yii::app()->request->getParam('field_id', '');
        $uploadFolder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
    
        // Ensure upload directory exists
        if (!is_dir($uploadFolder)) {
            mkdir($uploadFolder, 0777, true);
        }
    
        $allowedExtensions = array("jpg", "jpeg", "gif", "png");
        $sizeLimit = 1 * 1024 * 1024; // 1 MB
    
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($uploadFolder);
    
        if (isset($result['success']) && $result['success']) {
            $result['fileType'] = pathinfo($uploadFolder . $result['filename'], PATHINFO_EXTENSION);
            $result['field_id'] = $field_id;
    
            // Optional thumbnail generation (uncomment if needed)
            /*
            $imagePath = $uploadFolder . $result['filename'];
            $thumbFolder = $uploadFolder . 'thumbs/';
            if (!is_dir($thumbFolder)) {
                mkdir($thumbFolder, 0777, true);
            }
            $thumbPath = $thumbFolder . $result['filename'];
    
            Yii::import("ext.EPhpThumb.EPhpThumb");
            $thumb = new EPhpThumb();
            $thumb->init();
            $thumb->create($imagePath)->resize(100, 100)->save($thumbPath);
            */
    
            echo htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        } else {
            // Handle error
            echo CJSON::encode([
                'success' => false,
                'error' => 'File upload failed.'
            ]);
        }
    }
    
    
}
