<?php
class CostpricinggroupController extends Controller

{

        public function accessRules() {

            return array(

                array('allow', // allow all users to perform 'index' and 'view' actions

                  'actions' => array('login', 'error', 'logout'),

                  'users' => array('*'),

                  ),

                array('allow', // allow authenticated user to perform 'create' and 'update' actions

                  'actions' => array('ChangeCostpriceGroupName','DefaultpricingGroup','SaveGroup','UploadCostPrice','SaveCostPricingGroup','DownloadCostPriceList','Upload'),

                  'expression' => '$user->isMember()',

                  ),

                array('deny', // deny all users

                  'users' => array('*'),

                  ),

                );

        }
        
    public function actionChangeCostpriceGroupName()
    {
    	$model = CostPriceGroupName::model()->findAll();
    	 
    	$this->render('change_cost_price_group_name',array('model'=>$model));
    }
	
     public function actionSaveGroup()
        {
        if (isset($_POST['CostPriceGroupName'])) {
                foreach ($_POST['CostPriceGroupName'] as $i => $items) {
                    if ($items['id']>0) {
                        $modal_group[$i] = CostPriceGroupName::model()->findByPK($items['id']);   
                    }else{
                        $modal_group[$i] = new CostPriceGroupName;   
                    }
                    $modal_group[$i]->pricing_group_name  = $items['pricing_group_name'];
                    $modal_group[$i]->pricing_group_description = $items['pricing_group_description'];
                    $validate = $modal_group[$i]->validate();                   
                }
                 if($validate){
                if(!empty($modal_group)){
                    foreach ($modal_group as $eachModel) {
                        $eachModel->save();   
                    }
                }
                $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
            }
            else{
                $error1 = json_decode(CActiveForm::validate($modal_group, '', false), true); 
                $error = CJSON::encode(array_merge_recursive($error1));
                if ($error != '[]')
                           echo $error;
            }
    }else{
        $modal_group = new SalesPriceGroupName();   
        $error =CActiveForm::validate($modal_group, '', false); 
        if ($error != '[]')
            echo $error;
        }  
    }
        
    public function actionDefaultpricingGroup()
    {
        $id = $_POST['id'];
        CostPriceGroupName::model()->updateAll(array('default_pricing_group' =>"N"));
        CostPriceGroupName::model()->updateByPk($id, array('default_pricing_group' =>"Y"));
        $jsonData['status'] = "success";
        echo CJSON::encode($jsonData);
    }   
        
    public function actionUploadCostPrice() {
        $this->render('upload_cost_price');
    }

public function actionSaveCostPricingGroup()
 {
  
     $price_list_file_name = $_POST['CostPriceGroup']['cost_price_group_file_name'];
     
     $pricing_list = $this->readCSV("uploads/pricelist/" . $price_list_file_name);
     $jsonData = array();
     foreach (array_slice($pricing_list, 1) as $i => $eachItem) {
     
      $part_number = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
      if (strlen($part_number) > 0) {
       
       $price1 = 0;
       if(isset($eachItem[1]) && $eachItem[1]!="" && $eachItem[1]!=0)
       {
        $price1 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
       }
       
       /*$price2 = 0;
       if(isset($eachItem[2]) && $eachItem[2]!="" && $eachItem[2]!=0)
       {
        $price2 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
       }
       
       $price3 = 0;
       if(isset($eachItem[3]) && $eachItem[3]!="" && $eachItem[3]!=0)
       {
        $price3 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[3]), '"'));
       }
       
       $price4 = 0;
       if(isset($eachItem[4]) && $eachItem[4]!="" && $eachItem[4]!=0)
       {
        $price4 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[4]), '"'));
       }
        
       $price5 = 0;
       if(isset($eachItem[5]) && $eachItem[5]!="" && $eachItem[5]!=0)
       {
        $price5 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[5]), '"'));
       }*/
       
       $product_model = Store::model()->find('part_number="' . $part_number . '"');
        
        if(count($product_model) > 0)
        {
         $model           = new CostPriceGroup();
         
         $arr_cost_price_group = CostPriceGroup::model()->find(array('condition'=>'product_id='.$product_model->id));
         $model->id = 0;
         if(count($arr_cost_price_group) > 0){
          $model->id = $arr_cost_price_group->id;
          $model=$model->findByPk($arr_cost_price_group->id);
          
          $model->product_id         = $product_model->id;
          
          if($price1 > 0)
          {
           $model->cost_price1       = $price1;
          }
          
          /*if($price2 > 0)
          {
           $model->cost_price2       = $price2;
          }
          
          if($price3 > 0)
          {
           $model->cost_price3       = $price3;
          }
          
          if($price4 > 0)
          {
           $model->cost_price4       = $price4;
          }
          
          if($price5 > 0)
          {
           $model->cost_price5       = $price5;
          }*/
          
          $model->cost_price_group_file_name     = $price_list_file_name;
          $model->uploaded_by        = Yii::app()->user->id;
          $model->uploaded_date        = date('Y-m-d h:i:s');
          $model->save();
          $jsonData['msg'][]= "Item " . $eachItem[0] . " price found and updated!";
         }
         else 
         {
          $model->product_id         = $product_model->id;
          $model->cost_price1        = $price1;
          /*$model->cost_price2        = $price2;
          $model->cost_price3        = $price3;
          $model->cost_price4        = $price4;
          $model->cost_price5        = $price5;*/
          $model->cost_price_group_file_name     = $price_list_file_name;
          $model->uploaded_by        = Yii::app()->user->id;
          $model->uploaded_date        = date('Y-m-d h:i:s');
          $model->save();
          $jsonData['msg'][]= "Item " . $eachItem[0] . " price found and added!";
         }
          
         
        }
        else
        {
         $jsonData['part_number'][] = $part_number;
        }
       }
       
     }
     
     
     $jsonData['errors']="";
     if(count($jsonData['part_number']) > 0 && $jsonData['part_number'][0]!="")
     {
      $jsonData['errors'][]="Please add the following part number into inventory <br>".implode("<br>", $jsonData['part_number']);
     }
     $jsonData['model'] = $model;
     $jsonData['status'] = "success";
     echo CJSON::encode($jsonData);
    }

     public function actionDownloadCostPriceList() {
    	//$filename = Yii::app()->getBaseUrl(true) . 'pricelistfiles/SALES_PRICE_LIST.csv';
    	/*$model = new CostPriceGroupName();
    	
    	$arr_cost_price_group = $model->findAll(array('condition'=>'pricing_group_name!=""'));
    	$data = array();
    	$j=0;
    	$data[0][$j] = 'Product';
    	foreach ($arr_cost_price_group as $i => $items) {
    	        
            	$data[0][$j+1] = $items->pricing_group_name;
    	    $j++;
    	}*/
    	
    	$data[0][0] = 'Product';
    	$data[0][1] = 'INTERNAL COST PRICE';
    
    
    
    	$export_file_name="COST_PRICE_LIST.csv";
    	$this->array_to_csv_download($data, // this array is going to be the second row
    			$export_file_name
    	);
    
    }
}