<?php

class CategoryController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','SaveCategory','DeleteCategoryL1Item','DeleteCategoryL2Item'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
		$this->render('index');
	}

	
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionDeleteCategoryL1Item() {

        $id = $_POST['id'];

        $model = new MasCategoryL1();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);

    }
     public function actionDeleteCategoryL2Item() {

        $id = $_POST['id'];

        $model = new MasCategoryL2();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);

    }
        public function actionGetList()
        {
                $model_generic = new MasGeneric();
//                $model_level1 = new MasCategoryL1();
//                $model_level2 = new MasCategoryL2();
                $draw   = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'id',
                   1 => 'generic_name_id',
                   2 => $model_level1->category_name,
                   3 => $model_level2->category_name,
                   
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and category_name LIKE '%".$searchString."%' OR category_description LIKE '%".$searchString."%'";
                }
                $count = $model_generic->count(array('condition'=>$condition));
                $model_generic=$model_generic->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                 foreach ($model_generic as $row)
                {
                    $div = '';
                     $model_level1 = MasCategoryL1::model()->find(array('condition'=>'generic_name_id='.$row->id));
                    $model_level2 = MasCategoryL2::model()->find(array('condition'=>'generic_name_id='.$row->id));
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inventory_level1_category_edit"])){
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'category/create&id='.$row['id'].'\',\'Category\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inventory_level1_category_delete"])){
                       // $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteCategory('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }
                       $rowData[]=array($m,$row['generic_name'],$model_level1->category_name,$model_level2->category_name,'<div class="btn-wrap text-center">'.$div.'</div>');
                
                    $m++;
                    
                }
                
//                foreach ($model_generic as $row)
//                {
//                    $model_level1 = MasCategoryL1::model()->find(array('condition'=>'generic_name_id='.$row->id));
//                    $model_level2 = MasCategoryL2::model()->find(array('condition'=>'generic_name_id='.$row->id));
//                    $rowData[]=array($m,$row['generic_name'],$model_level1->category_name,$model_level2->category_name,'<div class="btn-wrap text-center">'
//                        . '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'category/create&id='.$row['id'].'\',\'Category\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteCategory('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//                    $m++;
//                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
//         public function actionGetL2List()
//        {
//                $model = new MasCategoryL2();
//                $draw     = $_POST['draw'];
//                $offset = $_POST['start'];
//                $limit  = $_POST['length'];
//                $columns = array(
//                // datatable column index  => database column name
//                   0 =>'id',
//                   1 => 'generic_name_id',
//                   2 => 'category_name',
//                   3 => 'category_description',
//                   
//                   );
//                $filterColumn = $columns[$_POST['order'][0]['column']];
//                $filterOrder  = $_POST['order'][0]['dir'];
//                $orderBy   = $filterColumn." ".$filterOrder;
//                $condition = '1=1';
//                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
//                {
//                  $searchString = $_POST['search']['value'];
//                  $condition.=" and category_name LIKE '%".$searchString."%' OR category_description LIKE '%".$searchString."%'";
//                }
//                $count = $model->count(array('condition'=>$condition));
//                $model=$model->with('generic')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
//                $recordsTotal = $count;
//                $recordsFiltered = $count;
//                $data['draw'] = $draw;
//                $data['recordsTotal'] = $recordsTotal;
//                $data['recordsFiltered'] = $recordsFiltered;
//                $rowData=array();
//                $m = 1;
//               
//                foreach ($model as $row)
//                {
//                    $rowData[]=array($m,$row['generic']['generic_name'],$row['category_name'],$row['category_description'],'<div class="btn-wrap text-center">'
//                        . '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'category/createl2&id='.$row['id'].'\',\'Category Level-2\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteCategoryL2('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//                    $m++;
//                }
//                $data['data'] = $rowData;
//                echo json_encode($data);
//        }
         public function actionCreate()
        {
           $model_level1 = new MasCategoryL1();
           $model_level2 = new MasCategoryL2();
           $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model_level1=$model_level1->find(array('condition'=>'generic_name_id='.$id));
                $model_level2=$model_level2->find(array('condition'=>'generic_name_id='.$id));
            }
            if(empty($model_level1))
               $model_level1 = new MasCategoryL1();
            if(empty($model_level2))
               $model_level2 = new MasCategoryL2();
           
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('create', array('model_level1' => $model_level1,'model_level2' => $model_level2), false, false);
        }
       
  
        public function actionSaveCategory()
        {
           $model_level1 = new MasCategoryL1();
           $model_level2 = new MasCategoryL2();
            $date = date("Y-m-d H:i:s");
            if (isset($_POST['MasCategoryL1']) || isset($_POST['MasCategoryL2']))
            {
    		if ((int) @$_POST['MasCategoryL1']['id'] > 0 || (int) @$_POST['MasCategoryL2']['id'] > 0 )
                {   if ((int) @$_POST['MasCategoryL1']['id'] > 0)
                    {
                        $id= (int) @$_POST['MasCategoryL1']['id'];
                        $model_level1=$model_level1->findByPk($id); 
                        $model_level1->updated_by = Yii::app()->user->id; 
                        $model_level1->updated_date_time = $date;
                    }
                    else{
                        $model_level1->created_by = Yii::app()->user->id; 
                        $model_level1->created_date_time = $date;
                    }
                    if ((int) @$_POST['MasCategoryL2']['id'] > 0)
                    {
                        $id= (int) @$_POST['MasCategoryL2']['id'];
                        $model_level2=$model_level2->findByPk($id); 
                        $model_level2->updated_by = Yii::app()->user->id; 
                        $model_level2->updated_date_time = $date;
                    }
                    else
                    {
                        $model_level2->created_by = Yii::app()->user->id; 
                        $model_level2->created_date_time = $date;
                    }
                }
            
                $model_level1->generic_name_id=$_POST['MasCategoryL1']['generic_name_id'];
                $model_level1->category_name=$_POST['MasCategoryL1']['category_name'];
                
                $model_level2->generic_name_id=$_POST['MasCategoryL1']['generic_name_id'];
                $model_level2->category_name=$_POST['MasCategoryL2']['category_name'];
                
                if ($model_level1->save()&& $model_level2->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['category_form'];
                        $jsonData['l1_id'] = $model_level1->id;
                        $jsonData['l2_id'] = $model_level2->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
       
}