<?php

class ApplicationController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('uploadimage','Upload','SaveapplicationImages','removeapplicationimage','deleteuploadedfile','getapplicationimage'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
    public function actionUploadImage(){
        $id= Yii::app()->request->getParam('id');
        $model= ApplicationImages::model()->findAll(array('condition' => 'product_id="'. $id.'"'));
        if(empty($model)){
            $model=array(new ApplicationImages()); 
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('upload_application_image',array('model' => $model,'id' => $id));
    }	
    public function actionSaveapplicationImages() {
        if (isset($_POST['ApplicationImages'])) {            
            $valid=true;
            date_default_timezone_set("Asia/Dubai");
            if ((isset($_POST['ApplicationImages']))){                   		
                foreach ($_POST['ApplicationImages'] as $i => $items) {
                    if($items['id']>0){
                        $model[$i] =ApplicationImages::model()->findByPK($items['id']);      
                        $model[$i]->updated_by= Yii::app()->user->id;
                        $model[$i]->updated_date_time = date('Y-m-d h:i:s');
                    }else{
                        $model[$i] = new ApplicationImages();   
                        $model[$i]->created_by= Yii::app()->user->id;
                        $model[$i]->created_date_time = date('Y-m-d h:i:s');
                    } 
                    $model[$i]->product_id = $items['product_id'];
                    $model[$i]->application_id = $items['application_id'];
                    $model[$i]->application_images = $items['application_images'];
                    $valid=$model[$i]->validate() && $valid;
                }
            }else{
                $valid=false;
            }
            if($valid){             
                if (!empty($model)) {
                    foreach ($model as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            }else{                
                $error1=array();
                if (count($model)>0){                    
                   $error1 = json_decode(CActiveForm::validateTabular($model, '', false), true);
                }else{                    
                    $model = array(new ApplicationImages());                   
                    $error1 = json_decode(CActiveForm::validateTabular($model, '', false), true); 
                }
                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }	 
    public function actionRemoveapplicationImage() {
        $id = $_POST['id'];
        $model =ApplicationImages::model()->findByPk($id);
        $doc_file=$model->application_images;
        $arr_doc_val = explode(',', $doc_file);      
        $status=0;
        if (count($arr_doc_val) > 1) {
            foreach ($arr_doc_val as $value) {
                $path = Yii::getPathOfAlias('webroot') . "/upload/applicationhiring/".$value; 
                if (unlink($path)) {
                    $status=1;
                }
            }
            if ($status==1) {
                ApplicationImages::model()->deleteByPk($id);
                $jsonData['status'] = 'success';
            }else{
                $jsonData['status'] = 'error';
            }
            
        }else{
            $path = Yii::getPathOfAlias('webroot') . "/upload/applicationhiring/".$doc_file; 
            if (unlink($path)) {
                ApplicationImages::model()->deleteByPk($id);
                $jsonData['status'] = 'success';
            }else{
                $jsonData['status'] = 'error';
            }
        }
        echo CJSON::encode($jsonData);
    }
    public function actiondeleteuploadedfile() {
        $id = $_POST['id'];
        $file_name = $_POST['file_name'];
        $i = $_POST['row_field'];
        $model=new ApplicationImages();
        $model_application=ApplicationImages::model()->findByPk($id); 
        $image_file_array=  explode(',', $model_application->application_images);   
        if (($key = array_search($file_name, $image_file_array)) !== false) {
            unset($image_file_array[$key]);
            $files = implode(',',$image_file_array);
            ApplicationImages::model()->updateByPK($id, array('application_images' => $files));
            $div_file='<span id=spanfile_"'.$i.'">';
            foreach ($image_file_array as $value_file) {
                $f_name="'".$value_file."'";
                $div_image='<img src='.Yii::app()->baseUrl.'/upload/applicationhiring/'.$value_file.' width="100"/>';
                $div_file.=$div_image.'&nbsp;<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete this file" onclick="deleteuploadedfile('.$i.','.$id.','.$f_name.');"><i class="fa fa-trash"></i></a><br>';
            }
            $div_file.='</span>';
            $div_file.= CHtml::activeHiddenField($model, "[" . $i . "]application_images",array('value'=>$files));
            echo $div_file;
        }
    }
    public function actiongetapplicationimage() {
        $product_id = $_POST['product_id'];
        $application_id = $_POST['application_id'];
        $model_image_file= ApplicationImages::model()->find(array('condition' => 'application_id="'.$application_id.'" and product_id="'.$product_id.'"'));
        if($model_image_file->application_images!=''){
            $image_file_array=  explode(',', $model_image_file->application_images);  
            $div_file='<div class="each_image">';
            $div_file.='<input type="hidden" id="application_images" name="Hiring[application_image]" value="'.$model_image_file->application_images.'"/>';
            foreach ($image_file_array as $value_file) {
                $div_file.='<div id="divid_'.$value_file.'" data-file='.$value_file.'>';
                $div_image='<img src='.Yii::app()->baseUrl.'/upload/applicationhiring/'.$value_file.' width="100"/>';
                $div_file.=$div_image.'&nbsp;<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete Images" onclick="deleteImages(this)"><i class="fa fa-trash"></i></a><br>';
                $div_file.='</div>';
            }
            $div_file.='</div>';
            echo $div_file;
        }
    }
}