<?php

class ApistoreController extends Controller
{

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array("GetList", 'Brand', 'GetReport', 'PrintInventoryReportPDF','PrintInventoryListExcel'),
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action)
    {
        $this->ChangeDB();
        return parent::beforeAction($action);
    }

    public function actionBrand()
    {
        $brand_list = ProductClass::getAllProductClass();
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token='7-1668401312';
        //error_log('!'.json_encode($_REQUEST).'!');
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data = array('status' => "success");
            foreach ($brand_list as $key => $value) {
                $data['data'][] = [
                    "id" => $key,
                    "name" => $value
                ];
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }


    public function actionGetReport()
    {



        $term = trim($_REQUEST['term']);
        $bar_code = $_REQUEST['bar_code'];
        //$display_type = $_REQUEST['display_type'];
        $display_type = 1;

        $brand_id = $_REQUEST['brand_id'];
        $warehouse_id = $_REQUEST['warehouse_id'];

        //$token = filter_var('2-1672478354', FILTER_SANITIZE_STRING) ;

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);


        //$token='7-1668401312';
        error_log('!' . json_encode($_REQUEST) . '!');
        $userModel = User::model()->findBytoken($token);

        if ($userModel->id > 0) {
            //code added by mereena on 04/05/2022

            $warehouse_name = '';
            if ((int) $warehouse_id > 0) {
                $MasInventoryWarehouse = MasInventoryWarehouse::model()->findBypK($warehouse_id);
                $warehouse_name = $MasInventoryWarehouse->warehouse_name;
            }


            $condition = 'inventory_item_type=1';
            if ((int)$warehouse_id > 0) {
                $condition .= ' AND (warehouse_id = ' . (int)$warehouse_id . ' OR warehouse_id=0)';
            }

            if (!empty($term)) {
                $condition .= " AND ( 
                part_number  LIKE '%{$term}%' 
                OR  description  LIKE '%{$term}%'
                OR  bar_code  LIKE '%{$term}%'
                
                )";
            }

            if ((int)$brand_id > 0) {

                $condition .= ' AND brand_id = ' . (int)$brand_id;
            }
            if (!empty($bar_code)) { //$bar_code
              $condition .= " AND bar_code = '" . $bar_code . "'";
               //$condition .= "bar_code LIKE '" . $bar_code . "'";
            }
            if ($display_type == 1) {
                $qtycondition = ' WHERE quantity >0 ';
            }
            $orderBy   = 'part_number asc';

            $query = 'SELECT * FROM (SELECT generic_id,generic_name,product_id,part_number,description,bar_code,brand_id,brand,SUM(quantity) AS quantity,isActive,inventory_item_type,rate,selling_price_1,unit_name, SUM(quantity*rate) AS amount
            FROM view_warehousewise_stock 
            WHERE ' . $condition . ' 
            GROUP BY product_id
            )A' . $qtycondition . ' 
            ORDER BY ' . $orderBy . '  ';


            $models = Yii::app()->db->createCommand($query)->queryAll();

            $data = [];
            foreach ($models as $key => $row) {


                $second_unit_factor = 1;
                $arr_price_list = SalesPriceGroup::model()->find(array('condition' => 'product_id=' . $row['product_id']));
                $sales_price = $arr_price_list->sales_price;

                $modelUnits = UnitOfMeasurement::model()->findAll(array('condition' => 'product_id=' . (int) $row['product_id'], 'order' => 'is_secondary_unit'));

                $unit_data = [];
                if (!empty($modelUnits)) {
                    foreach ($modelUnits as $i => $each) {
                        $unit_price = number_format(($each['factor'] * $sales_price), 2);
                        $unit_data[] = [
                            "id" => $each['id'],
                            "unit_name" => $each['name'],
                            "unit_factor" => $each['factor'],
                            "unit_price" => $unit_price
                        ];
                    }
                }


                $data[] = [
                    "no" => $key +1,
                    "id" => $row['product_id'],
                    "part_number" => $row['part_number'],
                    "description" => $row['description'],
                    "bar_code" => $row['bar_code'],
                    "brand_id" => $row['brand_id'],
                    "brand_name" => $row['brand'],
                    "generic_id" => $row['generic_id'],
                    "generic_name" => $row['generic_name'],
                    "available_qty" => $row['quantity'],
                    "default_unit_name" => $row['unit'],
                    "default_unit_id" => $row['unit_id'],
                    "secondary_quantity" => (int) ($row['quantity'] / $second_unit_factor),
                    "secondary_unit_id" => 0,
                    "secondary_unit_name" => '',
                    "tax_code" => $row['tax_code'],
                    "active" =>  $row['isActive'],
                    "rate" => number_format(($row['rate'] * $second_unit_factor), 2, '.', ''),
                    "alias_name" => $row['part_number'],
                    "selling_price" => number_format(($sales_price), 2, '.', ''),
                    "warehouse_id" => $warehouse_id,
                    "warehouse_name" => $warehouse_name,
                    "arr_units" => $unit_data,
                    "quantity" => 1,
                    "discount" => 0,
                    "discount_percentage" => 0,
                    "discountvalue" => 0,
                    "discountpercentagevalue" => 0,
                    "totalafterdiscount" => 0,
                    "vatafterdiscount" => 0,
                    "subtotalafterdiscount" => 0,
                    "gross_total" => number_format($row['amount'], 2, '.', '')
                ];
            }

            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
            echo json_encode(array('status' => "success", 'data' => $data));
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user", 'data' => []);
            echo json_encode($data);
        }
    }


    public function actionGetList()
    {

        $term = trim($_REQUEST['term']);

        $bar_code = $_REQUEST['bar_code'];
        $display_type = $_REQUEST['display_type'];
        $brand_id = $_REQUEST['brand_id'];
        // $user_warehouse_id = $_REQUEST['warehouse_id'];

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token='7-1668401312';
        error_log('!' . json_encode($_REQUEST) . '!');
        $userModel = User::model()->findBytoken($token);

        if ($userModel->id > 0) {
            //code added by mereena on 04/05/2022
            $user_warehouse_id  = $userModel->available_warehouses;

            $warehouse_name = '';
            if ((int) $user_warehouse_id > 0) {
                $warehouse_name = $userModel->warehouse->warehouse_name;
            }

            $condition = 'type=1 AND isActive="Y"';
            if ($brand_id > 0) {
                $condition .= ' AND brand_id = ' . $brand_id;
            }
            /* if(!empty($user_warehouse_id)){
                    $condition.=' AND FIND_IN_SET("'.$user_warehouse_id.'", item_warehouse)';
            }
            
           if(!empty($user_warehouse_id)){
                    $condition.=' AND item_warehouse='.$user_warehouse_id;
            }*/

            if (!empty($term)) {
                $condition .= " AND ( part_number  LIKE '%{$term}%'  OR  description  LIKE '%{$term}%')";
            }

            //echo $condition;

            if (!empty($bar_code)) { //$bar_code
                $condition .= " AND bar_code = '" . $bar_code . "'";
            }
            //echo $condition;

            $SQL = 'SELECT * FROM view_all_stock_items WHERE ' . $condition . ' ORDER BY part_number LIMIT 0,100';
            $models = Yii::app()->db->createCommand($SQL)->queryAll();

            $data = [];
            foreach ($models as $key => $row) {

                //SELECT SUM(quantity) FROM `erp_stock_ledger` WHERE warehouse_id=5 AND product_id=1085

                $SQL = 'SELECT SUM(quantity) FROM `erp_stock_ledger` WHERE warehouse_id=' . $user_warehouse_id . ' AND product_id=' . (int) $row['id'];
                //echo $SQL;
                $warehouse_qty = Yii::app()->db->createCommand($SQL)->queryScalar();

                $arr_price_list = SalesPriceGroup::model()->find(array('condition' => 'product_id=' . $row['id']));
                $sales_price = $arr_price_list->sales_price;

                $modelUnits = UnitOfMeasurement::model()->findAll(array('condition' => 'product_id=' . (int) $row['id'], 'order' => 'is_secondary_unit'));

                $unit_data = [];
                if (!empty($modelUnits)) {
                    foreach ($modelUnits as $i => $each) {
                        $unit_price = number_format(($each['factor'] * $sales_price), 2, '.', '');
                        $unit_data[] = [
                            "id" => $each['id'],
                            "unit_name" => $each['name'],
                            "unit_factor" => $each['factor'],
                            "unit_price" => $unit_price
                        ];
                    }
                }

                $second_unit_factor = $row['second_unit_factor'];
                if ((int) $second_unit_factor == 0) {
                    $second_unit_factor = 1;
                }

                $gross_total = ($row['quantity'] *  ($row['rate'] * $second_unit_factor));

                if ((int) $warehouse_qty > 0) {
                    $data[] = [
                        "id" => $row['id'],
                        "part_number" => $row['part_number'],
                        "description" => $row['description'],
                        "bar_code" => $row['bar_code'],
                        "brand_id" => $row['brand_id'],
                        "brand_name" => $row['brand_name'],
                        "generic_id" => $row['generic_id'],
                        "generic_name" => $row['generic_name'],
                        "available_qty" => (int) $warehouse_qty, //$row['quantity'],
                        "default_unit_name" => $row['unit'],
                        "default_unit_id" => $row['unit_id'],
                        "secondary_quantity" => (int) ($row['quantity'] / $second_unit_factor),
                        "secondary_unit_id" => $arr_secondary_unit->id,
                        "secondary_unit_name" => $arr_secondary_unit->name,
                        "tax_code" => $row['tax_code'],
                        "active" =>  $row['isActive'],
                        "rate" => number_format(($row['rate'] * $second_unit_factor), 2, '.', ''),
                        "alias_name" => $row['alias_name'],
                        "selling_price" => number_format(($sales_price), 2, '.', ''),
                        "warehouse_id" => $user_warehouse_id,
                        "warehouse_name" => $warehouse_name,
                        "arr_units" => $unit_data,
                        "quantity" => 1,
                        "discount" => 0,
                        "discount_percentage" => 0,
                        "discountvalue" => 0,
                        "discountpercentagevalue" => 0,
                        "totalafterdiscount" => 0,
                        "vatafterdiscount" => 0,
                        "subtotalafterdiscount" => 0,
                        "gross_total" => number_format($gross_total, 2, '.', '')
                    ];
                }
            }

            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
            echo json_encode(array('status' => "success", 'data' => $data));
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user", 'data' => []);
            echo json_encode($data);
        }
    }


    // ------------indhu-31_01_2023-------------------------------------------------


    public function actionPrintInventoryReportPDF()
    {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {


            $term         = trim($_REQUEST['term']);
            $bar_code     = $_REQUEST['bar_code'];
            $display_type = 1;
            $brand_id     = $_REQUEST['brand_id'];
            $warehouse_id = $_REQUEST['warehouse_id'];


            $condition = 'inventory_item_type=1';

           

            $qtycondition = '';
            if ($display_type == 1) {
                $qtycondition = ' WHERE quantity >0 ';
            }

            if ($brand_id > 0) {
                $condition .= ' AND brand_id = ' . $brand_id;
            }
            if ($warehouse_id > 0) {
                $condition .= ' AND (warehouse_id = ' . (int)$warehouse_id . ' OR warehouse_id=0)';
            }

            // if (!empty($term)) {
            //     $condition .= " AND ( part_number  LIKE '%{$term}%'  OR  description  LIKE '%{$term}%')";
            // }


            if (!empty($term)) {
                $condition .= " AND ( 
                part_number  LIKE '%{$term}%' 
                OR  description  LIKE '%{$term}%'
                OR  bar_code  LIKE '%{$term}%'
                
                )";
            }
            



            $pdf_name = "inventorylist" .  date('dmYhis') . "_" . '.pdf';
            $file_path = 'uploads/apppdf/' . $pdf_name;
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.app_inventory_list', array('condition' => $condition, 'qtycondition' => $qtycondition, 'warehouse_id' => $warehouse_id), true));

            $mPDF1->Output($file_path, 'F');
            header('Content-Type: application/json');
            $data = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);
        } else {

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }
    
    
    
    
     public function actionPrintInventoryListExcel_old()
    {

        // $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        // $userModel = User::model()->findBytoken($token);
        // if ($userModel->id > 0) {

            $term         = trim($_REQUEST['term']);
            $bar_code     = $_REQUEST['bar_code'];
            $display_type = 1;
            $brand_id     = $_REQUEST['brand_id'];
            $warehouse_id = $_REQUEST['warehouse_id'];

            $condition    = 'inventory_item_type=1';


            $qtycondition = '';
            if ($display_type == 1) {
                $qtycondition = ' WHERE quantity >0 ';
            }

            if ($brand_id > 0) {
                $condition .= ' AND brand_id = ' . $brand_id;
            }
            if ($warehouse_id > 0) {
                $condition .= ' AND (warehouse_id = ' . (int)$warehouse_id . ' OR warehouse_id=0)';
            }

            if (!empty($term)) {
                $condition .= " AND ( 
                part_number  LIKE '%{$term}%' 
                OR  description  LIKE '%{$term}%'
                OR  bar_code  LIKE '%{$term}%'
                
                )";
            }

            $total = Yii::app()->db->createCommand('SELECT SUM(quantity*rate)  AS total FROM view_warehousewise_stock  WHERE ' . $condition)->queryScalar();
          
          $query = 'SELECT * FROM (SELECT product_id,part_number,description,bar_code,brand_id,brand,SUM(quantity) AS quantity,isActive,inventory_item_type,rate,selling_price_1,unit_name, SUM(quantity*rate) AS amount
                FROM view_warehousewise_stock 
                WHERE ' . $condition . ' 
                GROUP BY product_id
                )A' . $qtycondition . ' ORDER BY part_number ASC ';
            $countquery = 'SELECT COUNT(product_id) FROM (SELECT product_id,part_number,description,bar_code,brand_id,brand,SUM(quantity) AS quantity,isActive,inventory_item_type,rate,selling_price_1,unit_name,SUM(quantity*rate) AS amount 
                FROM view_warehousewise_stock 
                WHERE ' . $condition . ' 
                GROUP BY product_id
                )A' . $qtycondition . ' ORDER BY part_number ASC ';

            $count = Yii::app()->db->createCommand($countquery)->queryScalar();
            $model = Yii::app()->db->createCommand($query)->queryAll();



            $filename = 'inventorylist' . date('dmYhis') . '.xls';

            $data = '<html>
    
                        <head>
    
                            <style>
    
                                table{
    
                                    width:100%;
    
                                }
    
                                .head{
    
                                    background-color : yellow;
    
                                    font-weight: bold;
    
                                    font-size: 14px;
    
                                }
    
                                .total{
    
                                    text-align: right;
    
                                    font-weight: bold;
    
                                    font-size: 14px;
    
                                }
    
                            </style>
    
                        </head>
    
                        <body>
    
                            <table border=1>
    
                                <thead>
    
                        <th>No</th>
                        <th>Part No</th>
                        <th>Description</th>
                        <th>Barcode</th>
                        <th>Brand Name</th>
                        <th>Qty</th>
                        <th>Cost</th>
                        <th>Sales Price</th>
                        <th>Gross Total</th>
                                </thead>
    
                                <tbody>';

            foreach ($model as $i => $row) {

                $part_no = $row['part_number'];
                $data .= '<tr>
    
                                    <td>' . ($i + 1) . '</td>
    
                                    <td>' . $part_no . '</td>
    
                                    <td>' . $row['description'] . '</td>
    
                                    <td>' . $row['bar_code'] . '</td>
    
                                    <td>' . $row['brand'] . '</td>
    
                                    <td>' . Yii::app()->numberFormatter->formatCurrency($row['quantity'], " ") . '</td>
                                    
                                    <td>' . Yii::app()->numberFormatter->formatCurrency($row['rate'], " ") . '</td>
                                     
                                    <td>' . Yii::app()->numberFormatter->formatCurrency($row['selling_price_1'], " ") . '</td>
                                      
                                    <td>' . Yii::app()->numberFormatter->formatCurrency($row['amount'], " ") . '</td>
    
                                   
    
                                </tr>';
            }



            $data .= '      </tbody>
               
                            </table>
    
                        </body>
    
                    </html>';




            header("Content-type: application/vnd.ms-excel");

            header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
             $objWriter->save('php://output');

            // echo $data;
           //  Yii::app()->end();

          //   return;
            
          
           $file_path = 'uploads/appexcel/' . $filename;

          
            // Write file to the browser
          


            $data = array('status' => "success", "pdflink" => $file_path, "file_name" => $filename);
             
        // } else {

        //     header("HTTP/1.1 401 Unauthorized");

        //     header('Content-Type: application/json');

        //     $data = array('status' => "failed", "msg" => "Unauthorized user");
        // }
       echo json_encode($data);
    }




    public function actionPrintInventoryListExcel()
    {

    /*     $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) { */

            $term         = trim($_REQUEST['term']);
            $bar_code     = $_REQUEST['bar_code'];
            $display_type = 1;
            $brand_id     = $_REQUEST['brand_id'];
            $warehouse_id = $_REQUEST['warehouse_id'];
            $bar_code     = $_REQUEST['bar_code'];


            $condition    = 'inventory_item_type=1';

            if (!empty($bar_code)) { //$bar_code
                $condition .= " AND bar_code = '" . $bar_code . "'";
            }


            $qtycondition = '';
            if ($display_type == 1) {
                $qtycondition = ' WHERE quantity >0 ';
            }

            if ($brand_id > 0) {
                $condition .= ' AND brand_id = ' . $brand_id;
            }
            if ($warehouse_id > 0) {
                $condition .= ' AND (warehouse_id = ' . (int)$warehouse_id . ' OR warehouse_id=0)';
            }

            if (!empty($term)) {
                $condition .= " AND ( part_number  LIKE '%{$term}%'  OR  description  LIKE '%{$term}%')";
            }

        
    
            Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
            $filename = 'inventory_list_excel.xls';
            header("Content-type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
            header('Content-Type: application/json');
            
            
//$objWriter->save('php://output');




            $file_path = 'uploads/appexcel/' . $filename;
            $this->renderPartial('application.views.front.reports.excel.inventory_list_excel',  array('condition' => $condition, 'qtycondition' => $qtycondition, 'warehouse_id' => $warehouse_id), false, true);
            
            
            

            $data = array('status' => "success", "excellink" => $file_path, "file_name" => $filename);

// Yii::app()->end();

       /*  } else {

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg" => "Unauthorized user");
        } */
        echo json_encode($data);
    }

    
    

    
    
    
    
    
}
