<?php

class ApisettingsController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('getSettings'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Create','Save','UploadExes'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
            // 'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $this->ChangeDB();
        return parent::beforeAction($action);
    }

    /*added by jisha*/
    public function actiongetSettings() {
        $modelsetting = new ApiMasterSettings();
        $modelsetting =$modelsetting->find();
        $data = [];
        $data[] = [
                "version" => $modelsetting->version,
                "url" => $modelsetting->url,
                "releaseNotes" => $modelsetting->release_note,
                "mandatory" => true,
                "releaseDate" => $modelsetting->release_date,
                "sha512" => $modelsetting->sha512
        ];
        header('Content-Type: application/json');
        echo json_encode($data);
    }
    public function actionCreate() {
        $model = new ApiMasterSettings();
        $model = $model->find(array('limit'=>'1'));
        $this->render('create_api_settings', array('model' => $model));
    }
    public function actionSave() {
        $model = new ApiMasterSettings();
        $id = (int) $_POST['ApiMasterSettings']['id'];
        if ($id > 0) {
            $model = $model->findByPk($id);
        }else{
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');
        
        }
        $model->attributes = $_POST['ApiMasterSettings'];
        if($_POST['ApiMasterSettings']['release_date']!='00/00/0000' && $_POST['ApiMasterSettings']['release_date']!=''){
            $model->release_date = str_replace('/', '-', $_POST['ApiMasterSettings']['release_date']);
            $model->release_date = date("Y-m-d", strtotime($model->release_date));
        }
        $baseUrl = Yii::app()->baseUrl;
        if($model->file_name!=''){
            $url = Yii::app()->getBaseUrl(true) . "/uploads/api/$model->file_name";
            $model->url = $url;
        }
        $model->updated_by = Yii::app()->user->id;
        $model->updated_date_time = date('Y-m-d h:i:s');
        if ($model->validate()) {
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                $jsonData['url'] = $url;
                echo CJSON::encode($jsonData);
            }
        } else {
            $error = CActiveForm::validate($model, '', false);
            if ($error != '[]') {
                echo $error;
            }
        }
    }

}
