<?php

class ApireportController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('summary', 'list'),
                'users' => array('*'),
            ),
//            array('allow', // allow authenticated user to perform 'create' and 'update' actions
//                'actions' => array(''),
//                'expression' => '$user->isMember()',
//            ),
            array('deny', // deny all users
            // 'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
       $this->ChangeDB();
        return parent::beforeAction($action);
    }

    public function actionSummary() {
        $master = [
            1 => "card",
            2 => "cash",
            3 => 'later'
        ];
        $user_id = (int) Yii::app()->request->getParam('user_id');
        $data = [];
        $today = date('Y-m-d');
        $sql = "SELECT count(*) as c ,sum(`grand_total`) as s FROM `erp_direct_invoice` WHERE `created_by` =3 and invoice_date  = '{$today}'  ";
        $row_data = Yii::app()->db->createCommand($sql)->queryAll();
        $data["sales"] = number_format($row_data[0]['s'], 2);
        $data["bill"] = number_format($row_data[0]['c'], 0);
        $sql = "SELECT `payment_type` ,sum(`grand_total`) as total FROM `erp_direct_invoice` WHERE `created_by` =3 AND invoice_date  = '{$today}'   GROUP BY `payment_type` ";
        $row_data = Yii::app()->db->createCommand($sql)->queryAll();
        foreach ($master as $value) {
            $data[$value] = "";
        }
        foreach ($row_data as $value) {
            $data[$master[$value['payment_type']]] = number_format($value['total'], 2);
        }
        echo json_encode($data);
    }

    public function actionList() {
        $user_id = (int) Yii::app()->request->getParam('user_id');
        $today = date("Y-m-d");
        $condition = " invoice_date  = '{$today}'  AND created_by = {$user_id} ";
        $models = DirectInvoice::model()->findAll(["condition" => $condition]);
        $data = [];
        foreach ($models as $row) {
            $data[] = [
                "id" => $row->id,
                "id_key" => $this->ciphertext($row->id, "e"),
                "date" => date("d/m/Y", strtotime($row->invoice_date)),
                "amount" => number_format($row->grand_total, 2)
            ];
        }
        echo json_encode($data);
    }

}
