<?php

class ApiproductController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('loadlist', 'categorylist'),
                'users' => array('*'),
            ),
//            array('allow', // allow authenticated user to perform 'create' and 'update' actions
//                'actions' => array(''),
//                'expression' => '$user->isMember()',
//            ),
            array('deny', // deny all users
            // 'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /*public function beforeAction($action) {

        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $this->db_name;
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);

        if (isset($_SERVER['HTTP_TOKEN']) && $_SERVER['HTTP_TOKEN'] == $this->http_token) {
            return parent::beforeAction($action);
        } else {
            echo json_encode([
                "status" => false,
                "message" => "Invalid token"
            ]);
        }
        return parent::beforeAction($action);
    }*/

    public function actionLoadlist() {
        $models = Store::model()->findAll([
        ]);
        $data = [];
        foreach ($models as $row) {
            $data[] = [
                "id" => $row->id,
                "name" => $row->description,
                "price" => $row->rate,
                "pic" => $row->item_image,
                "tax" => $row->tax->percentage / 100,
                "url" => "",
                "qty" => "1",
                'details' => $row->details,
                'nutrition' => $row->nutrition,
                'allergy' => $row->allergy,
                "generic_id" => $row->generic_id
            ];
        }
        echo json_encode([
            "status" => true,
            "datas" => $data
        ]);
    }

    public function actionCategorylist() {
        $models = MasGeneric::model()->findAll(["order" => "generic_name"]);
        $data = [];
        foreach ($models as $value) {
            $data[] = [
                "id" => $value->id,
                "name" => $value->generic_name
            ];
        }
        echo json_encode($data);
    }

}
