<?php



class ApiinvoiceController extends Controller
{



    public function accessRules()
    {

        return array(

            array(
                'allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array("GetList", "SaveInvoice", 'UpdateInvoiceReceivedAmount', 'GetCommisionlist', 'GetCommisionlistpdf', 'GetItemSalespdf', 'GetInvoicelist', 'GetInvoiceDetails', 'SaveExchangeInvoice', 'GetInvoiceDetails1', 'GetCommissionDetailedpdf', 'GetSalesDetails', 'GetCommissionBranchpdf', 'GetBranchSalespdf','GetSalesDetailsByUser'),

                'users' => array('*'),

            ),

        );
    }




    public function filters()
    {

        return array(

            'accessControl', // perform access control for CRUD operations

        );
    }



  

    public function beforeAction($action)
    {

         $this->ChangeDB();
        return parent::beforeAction($action);
    }

    /**

     * API to get all invoice list

     * Author  : Ramesh

     * Modified :  29/06/2022

     * url https://cumuluserp.me/alaqsar/index.php?r=apiinvoice/GetList

     * input parameters HTTP_TOKEN

     */

    public function actionGetList()
    {

        try {

            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            //$token = '2-1668080011';
            $userModel = User::model()->findBytoken($token);


            if ($userModel->id > 0) {


                $modelInvoice = new Invoice();

                $condition = 't.isActive="Y" ';

                $term = $_REQUEST['term'];

                $invoice_date = $_REQUEST['invoice_date'];

                $sales_man_id = $_REQUEST['sales_man_id'];

                /*if(!empty($invoice_date)){
                        $condition.=' AND (invoice_date>="'.$invoice_date.'" AND invoice_date<="'.$invoice_date.'")';
                    }*/

                if (!empty($_REQUEST['warehouse_id'])) {
                    $warehouse_id =  (int) $_REQUEST['warehouse_id'];
                } else {
                    $warehouse_id =  (int) $userModel->available_warehouses;
                }
                if ($userModel->level > 0) {
                    $condition .= ' AND warehouse_id=' . $warehouse_id;
                }

                if (!empty($_REQUEST['sales_man_id'])) {
                    $sales_man_id =  (int) $_REQUEST['sales_man_id'];
                    $condition .= ' AND t.created_by=' . $sales_man_id;
                }
                if (!empty($term)) {

                    $condition .= " ( t.invoice_id  LIKE '{$term}%' OR t.file_id  LIKE '%{$term}%' OR customer_details.customer_name  LIKE '%{$term}%' )";
                }



                if ($invoice_date != '') {

                    $condition .= ' AND t.invoice_date="' . $invoice_date . '"';
                } else {

                    $condition .= ' AND t.invoice_date="' . date('Y-m-d') . '"';
                }



                $count =  $modelInvoice->with('customer', 'items')->count(array('condition' => $condition));


                $models = $modelInvoice->with('customer', 'items')->findAll(array('condition' => $condition, "order" => "t.id DESC"));


                $list = [];


                foreach ($models as $key => $row) {

                    $receipt_flag = 0;
                    if ($row['received_amount'] < $row['grand_total']) {
                        $receipt_flag = 1;
                    }

                    $item_list = [];
                    $total_discount = 0;
                    $total_wo_vat = 0;
                    $total_amount = 0;
                    foreach ($row->items as $eachItem) {
                        $total_discount += $eachItem['deduction_amount'];
                        $total_wo_vat += $eachItem['rate'] * $eachItem['quantity'];
                        $total_amount += $eachItem['net_per_item'] * $eachItem['quantity'];
                        $item_list[] = [

                            "product_id" => $eachItem['product_id'],
                            "part_number" => $eachItem['product']['part_number'],
                            "description" => $eachItem['product']['description'],
                            "bar_code" => $eachItem['product']['bar_code'],
                            "quantity" => $eachItem['quantity'],
                            "rate" => $eachItem['rate'],
                            "amount" => $eachItem['amount'],
                            "discount" => $eachItem['deduction_amount'],
                            "tax_vat_amount" => $eachItem['tax_vat_amount'],
                            "net_per_item" => $eachItem['net_per_item'],
                            "total_amount" => $eachItem['net_amount'],
                            "tax_vat_amount" => $eachItem['tax_vat_amount'],
                            "tax_vat_amount" => $eachItem['tax_vat_amount'],
                            "unit_id" => $eachItem['unit_id'],
                            "unit_name" => $eachItem['invoiceunit']['name'],

                            //"customer_name" => $row['customer']['customer_name'],

                        ];
                    }
                    $list[] = [

                        "id" => $row['id'],

                        "file_id" => $row['file_id'],

                        "customer_name" => $row['customer']['customer_name'],

                        "customer_address" => $row['customer']['customer_address'],

                        "customer_phone" => $row['customer']['customer_phone_no'],

                        "invoice_date" => date("d/m/Y", strtotime($row['invoice_date'])),

                        "vat_amount" => $row['total_tax_amount'],

                        "grand_total" => $row['grand_total'],

                        "posted" => $row['posted'],

                        //"invoice_no" => $row['invoice_no'],

                        "invoice_no" => $row['warehouse']['warehouse_code'] . " / " . $row['invoice_no'],

                        "receipt_type" => $row['receipt_type'],

                        "received_amount" => $row['received_amount'],

                        "received_card_amount" => $row['received_card_amount'],

                        "received_cash_amount" => $row['received_cash_amount'],

                        "authorization_code" => $row['authorization_code'],

                        "active" => $row['isActive'],

                        "receipt_flag" => $receipt_flag,

                        "warehouse_name" =>  $row['warehouse']['warehouse_name'],

                        "sales_man" =>  $row['createdby']['first_name'] . " " . $row['createdby']['last_name'],

                        "total_discount"    => $total_discount,

                        "total_wo_vat"      => $total_wo_vat,

                        "total_amount" => $total_amount,

                        "invoice_created_date_time" => date("d/m/Y h:i:s", strtotime($row['created_datetime'])),

                        "items" => $item_list

                    ];
                }

                $data = array('status' => "success", "count" => $count, "data" => $list, "message" => $count . " Records");

                header("HTTP/1.1 200 OK");

                header('Content-Type: application/json');
            } else {

                header("HTTP/1.1 401 Unauthorized");

                header('Content-Type: application/json');

                $data = array('status' => "error", "message" => "Unauthorized user");
            }
        } catch (Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message" => "Unexpected Server error");
        }

        echo json_encode($data);
    }
    /* output
    {status: success, invoice_id: 40046, customer_name: Cash Customer, customer_phone: , invoice_date: 14/11/2022, warehouse_name: DCC, 
    invoice_no: 40046, total_tax_amount: 16.67, total_amount: 333.33, grand_total: 350.00, receipt_type: , 
    received_amount: , authorization_code: , sales_man: DCC 01, 
    items: [{product_id: 1052, part_number: ABC-1001, description: Test Item 01, brand_id: 2, brand_name: SPRAY, rate: 200.00, quantity: 2,
    warehouse_id: 5, unit_name: PCS, unit_id: 52, arr_units: [{id: 52, unit_name: PCS, unit_factor: 1.000000, unit_price: 200.00}], 
    tax_code: 5, discount: 10, total_amount: 333.33, discount_percentage: 10, grand_total: 350.00, tax_vat_amount: 16.67, net_per_item: 166.665}]    }
    */

    public function actionSaveInvoice()
    {


        $others = array();
        $groups = array();

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

        $userModel = User::model()->findBytoken($token);
        $user_warehouse_id = (int) $userModel->available_warehouses;
        $warehouse_name = '';
        $maxi_discount_allowed = 0;
        if ((int) $user_warehouse_id > 0) {
            $warehouse_name = $userModel->warehouse->warehouse_name;

            $modelWarehouse = new MasInventoryWarehouse();

            $modelWarehouse = $modelWarehouse->findByPk($user_warehouse_id);
            $maxi_discount_allowed = (float) $modelWarehouse->maxi_discount_allowed;
        }
        $grand_total = 0;

        $user_id = (int) $userModel->id;

        if ($user_id > 0) {

            $input = file_get_contents('php://input');

            error_log('Invoice');

            error_log($input);

            $variables = json_decode($input, true);

            if (isset($variables['created_by']) && (int) $variables['created_by'] > 0) {
                $created_by = (int) trim($variables['created_by']);
            } else {
                $created_by = $user_id;
            }

            $footer_discount_pecentage = (float) $variables['footer_discount_percentage'];

            /* echo '<pre>';
            print_r($variables);
            exit;*/

            //$arr_mas_invoice_type = MasInvoiceType::model()->findByPk($variables['invoicetype']);

            $modelInvoice = new Invoice;

            $modelInvoiceItems = array(new InvoiceItem());

            $others = array();

            $update = 0;
            // -----------------------------------------------------

            $customer_id = (int) $variables['customer_id'];
            $modelCustomer = new Customer();
            $modelCustomer = $modelCustomer->findByPk($customer_id);

            $modelCustomerContact = new CustomerContact();
            $modelCustomerContact = $modelCustomerContact->find(array('condition' => 'customer_id=' . $customer_id));

            $arr_company = MasCompany::model()->findByPk($userModel->company_id);

            $modelInvoice->delivery_ids = 0;
            $modelInvoice->crm_user_id = $created_by;
            $modelInvoice->file_id = 0;
            $modelInvoice->order_id = 0;
            $modelInvoice->order_lpo_no = '';
            $modelInvoice->order_lpo_date = date('Y-m-d');
            $modelInvoice->project_id = 0;
            $modelInvoice->invoice_no = '';
            $modelInvoice->custom_invoice_no = '';
            $modelInvoice->invoice_start_date = date('Y-m-d');
            $modelInvoice->invoice_end_date = date('Y-m-d');
            $modelInvoice->customer_id = $customer_id;
            $modelInvoice->contact_id = $modelCustomerContact->id;
            $modelInvoice->lead_owner_id = $created_by;
            $modelInvoice->billing_address = $modelCustomer->customer_address;
            $modelInvoice->shipping_address = $modelCustomer->customer_address;
            $modelInvoice->shipping_conditions = '';
            $modelInvoice->invoice_date = date('Y-m-d');
            $modelInvoice->sales_group = 1;
            $modelInvoice->reference = '';
            $modelInvoice->currency = $arr_company->currency_id;
            $modelInvoice->exchange_rate = 1;
            $modelInvoice->payment_terms = 1; //cash 
            $modelInvoice->shipping_by = '';
            $modelInvoice->lpo = '';
            $modelInvoice->others = '';
            $modelInvoice->net_amount = 0;
            $modelInvoice->tax_type = 1;
            $modelInvoice->total_tax_amount = 0.000000;
            $modelInvoice->grand_total = 0.000000;
            $modelInvoice->notes = '';
            $modelInvoice->terms_id = 0;
            $modelInvoice->terms_and_conditions = '';
            $modelInvoice->remarks = '';
            $modelInvoice->paid = 'N';
            $modelInvoice->invoice_type = 1;
            $modelInvoice->isActive = 'Y';
            $modelInvoice->is_approved = 'N';
            $modelInvoice->is_direct_invoice = 'Y';
            $modelInvoice->approved_by = 0;
            $modelInvoice->payment_days = 0;
            $modelInvoice->is_hiring_invoice = 'N';
            $modelInvoice->invoice_notification = '';
            $modelInvoice->invoice_hiring_notification = '';
            $modelInvoice->posted = 'N';
            $modelInvoice->invoice_advance_remark = '';
            $modelInvoice->tax_advance_deduction = 0.000;
            $modelInvoice->invoice_nature = 'S';
            $modelInvoice->invoice_status = 'Y';
            $modelInvoice->out_for_delivery = 'N';
            $modelInvoice->created_by = $created_by;
            $modelInvoice->created_datetime = date('Y-m-d H:i:s');
            $modelInvoice->updated_by = 0;
            $modelInvoice->updated_datetime = '0000-00-00';
            $modelInvoice->added_from = 'A';
            $modelInvoice->receipt_type = $variables['receipt_type'];
            $modelInvoice->received_amount = $variables['received_amount'];
            if ($variables['receipt_type'] == 'CH') {
                $modelInvoice->received_cash_amount = $variables['received_amount'];
                $modelInvoice->received_card_amount = 0;
            } elseif ($variables['receipt_type'] == 'CA') {
                $modelInvoice->received_card_amount = $variables['received_amount'];
                $modelInvoice->received_cash_amount = 0;
            } else {
                $modelInvoice->received_cash_amount = $variables['received_cash_amount'];
                $modelInvoice->received_card_amount = $variables['received_card_amount'];
            }

            $modelInvoice->authorization_code = $variables['authorization_code'];
            $modelInvoice->warehouse_id = $user_warehouse_id;
            $modelInvoice->footer_discount_amount = 0; //$variables['footer_discount'];
            $modelInvoice->footer_discount = $footer_discount_pecentage;

            // -----------------------------------------------------




            //$grand_total = $variables['grand_total'];

            $grand_total = 0;

            $total_tax = 0;
            $total_discount = 0;
            $total_wo_vat = 0;

            /*if ($update == 0) {

                $modelInvoice->grand_total = 0;
            }*/

            //$modelInvoice->sales_group_id = 1;


            $valid = $modelInvoice->validate();

            $arr_items = $variables['items'];

            $total_amount_without_discount = 0;
            if (!empty($arr_items)) {

                foreach ($arr_items as $i => $item) {

                    if ($item['product_id'] != '') {

                        $modelInvoiceItems[$i] = new InvoiceItem();

                        $mod_store = Store::model()->findByPK((int) $item['product_id']);

                        // ----------------------------------------------------------------

                        $modelInvoiceItems[$i]->product_id = $item['product_id'];
                        //$modelInvoiceItems[$i]->part_no = $item['part_number'];
                        $modelInvoiceItems[$i]->quantity = $item['quantity'];
                        $modelInvoiceItems[$i]->rate = $item['rate'];
                        $modelInvoiceItems[$i]->invoice_item_type = 'D';
                        $modelInvoiceItems[$i]->order_item_id = 0;
                        $modelInvoiceItems[$i]->invoice_id = 0;
                        $modelInvoiceItems[$i]->description = $item['description'];
                        $modelInvoiceItems[$i]->brand_class_id = $mod_store->brand_class_id;
                        $modelInvoiceItems[$i]->product_generic_name = $mod_store->generic_id;
                        $modelInvoiceItems[$i]->quantity = $item['quantity'];
                        $modelInvoiceItems[$i]->duration = 0;
                        $modelInvoiceItems[$i]->bonus_qty = 0;
                        $modelInvoiceItems[$i]->picked_qty = $item['quantity'];
                        $modelInvoiceItems[$i]->unit_id = $item['unit_id'];
                        $modelInvoiceItems[$i]->rate = $item['rate'];
                        //$modelInvoiceItems[$i]->amount =  $item['quantity'] * ($item['rate'] - (float) $item['discount']);
                        $modelInvoiceItems[$i]->amount =  $item['total_amount'];
                        //$modelInvoiceItems[$i]->amount = ($item['rate'] * $item['quantity']);
                        $modelInvoiceItems[$i]->addition_percentage = '';
                        $modelInvoiceItems[$i]->addition_amount = 0;
                        $modelInvoiceItems[$i]->deduction_percentage = $item['discount_percentage'];
                        $modelInvoiceItems[$i]->item_final_amount = $item['grand_total'];
                        //discount--changed--14-11-22--jisha
                        /* 
                       $discount_amount=0;
                        if((int)$item['discount_percentage']>0){
                            $discount_amount =  ($item['rate'] * $item['quantity'])*((int)$item['discount_percentage']/100);
                        }
                        $modelInvoiceItems[$i]->deduction_amount = $discount_amount+$item['discount'];
                        */
                        $modelInvoiceItems[$i]->deduction_amount = $item['discount_amount'];
                        //discount--changed--14-11-22--jisha
                        $modelInvoiceItems[$i]->tax_vat_percentage = $mod_store->tax->percentage;
                        //odelInvoiceItems[$i]->tax_vat_percentage = $item['tax_vat_amount'];
                        $modelInvoiceItems[$i]->tax_vat_amount = $item['tax_vat_amount'];
                        $modelInvoiceItems[$i]->net_per_item = $item['net_per_item'];
                        $modelInvoiceItems[$i]->cost_rate = $mod_store->rate;
                        $modelInvoiceItems[$i]->fin_account_id = 0;
                        $modelInvoiceItems[$i]->invoice_from = '0000-00-00';
                        $modelInvoiceItems[$i]->invoice_to = '0000-00-00';
                        $modelInvoiceItems[$i]->bill_type = 0;
                        $modelInvoiceItems[$i]->quantity_hiring = '';
                        $modelInvoiceItems[$i]->unitprice_hiring = '';
                        $modelInvoiceItems[$i]->inventory_type = 'S';
                        $modelInvoiceItems[$i]->alternate_id = 0;
                        $modelInvoiceItems[$i]->created_by = $created_by;
                        $modelInvoiceItems[$i]->created_datetime = date('Y-m-d H:i:s');
                        $modelInvoiceItems[$i]->updated_by = 0;
                        $modelInvoiceItems[$i]->updated_datetime = '0000-00-00 00:00:00';

                        //$arr_mas_invoice_type = MasInvoiceType::model()->findByPk($variables['invoicetype']);

                        //if ($arr_mas_invoice_type['tax'] == 'Y') {

                        //$modelInvoiceItems[$i]->tax_vat_percentage = $mod_store->tax->percentage;
                        //$modelInvoiceItems[$i]->tax_vat_amount = ($mod_store->tax->percentage * $modelInvoiceItems[$i]->amount) / 100;

                        //$net_amount = $modelInvoiceItems[$i]->amount + $modelInvoiceItems[$i]->tax_vat_amount;

                        $modelInvoiceItems[$i]->net_amount = $item['net_per_item'] * $item['quantity'];
                        /*} else {

                            $modelInvoiceItems[$i]->tax_percentage = 0;

                            $modelInvoiceItems[$i]->tax_amount = 0;
                        }*/



                        if ($item['rate'] <= 0) {

                            $others[] = 'Rate should be greater than zero';

                            $valid = false;
                        }

                        if ((int) $item['quantity'] <= 0) {

                            $others[] = 'Quantity should be greater than zero';

                            $valid = false;
                        }



                        $total_amount_without_discount += ($item['rate'] * $item['quantity']);
                        $grand_total += $modelInvoiceItems[$i]->item_final_amount;

                        $total_tax += $modelInvoiceItems[$i]->tax_vat_amount;
                        /*******find total discount ----jisha--14/11/22 --start*******/
                        //$total_discount += $discount_amount+$item['discount'];
                        $total_discount += $item['discount_amount'];
                        $total_wo_vat += ($modelInvoiceItems[$i]->rate * $modelInvoiceItems[$i]->quantity);
                        /*******find total discount ----jisha--14/11/22 --end*******/


                        $valid = $modelInvoiceItems[$i]->validate() && $valid;


                        /*check whether product in user warehouse stock */
                        $modelUOM = UnitOfMeasurement::model()->findByPk((int) $item['unit_id']);
                        $key = $item['product_id'];
                        if (!array_key_exists($key, $groups)) {
                            if ($item['quantity'] && $modelUOM->factor) {
                                $qty = $item['quantity'] * $modelUOM->factor;
                            }
                            $groups[$key] = array(
                                'id' => $item['product_id'],
                                'quantity' => $qty,
                                'unit_id' => $item['unit_id']
                            );
                        } else {
                            $groups[$key]['quantity'] = $groups[$key]['quantity'] + ($item['quantity'] * $modelUOM->factor);
                        }
                        /*check whether product in user warehouse stock */
                    }
                }
            }

            if (!empty($groups)) {
                foreach ($groups as $key => $eachProduct) {
                    $availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . $eachProduct['id'] . ' AND warehouse_id=' . (int) $user_warehouse_id)->queryScalar();
                    $store = new Store();
                    $store = $store->findByPk((int)$eachProduct['id']);
                    $modelUOM = new UnitOfMeasurement();
                    $base_unit_name = $modelUOM->getBaseunitname((int)$eachProduct['id']);
                    if ($eachProduct['quantity'] > $availble_qty) {
                        $others[] = $store['part_number'] . ' maximum sellable qty : ' . number_format($availble_qty, 2) . ' ' . $base_unit_name;
                        $valid = false;
                    }
                }
            }


            if ((int) $total_discount > 0) {
                $discount_percent = ($total_discount / $total_amount_without_discount) * 100;
            }

            if ((int) $footer_discount_pecentage > 0 && ((float) $footer_discount_pecentage > (float) $maxi_discount_allowed)) {
                $others[] = 'Maximum discount allowed only: ' . $maxi_discount_allowed;
                $valid = false;
            }
            if (isset($variables['grand_total']) && $variables['received_amount'] != $variables['grand_total']) {
                $others[] = 'Received amount amd Grandtotal should be Equal';
                $valid = false;
            }
            if ($valid && !empty($modelInvoiceItems)) {

                //if ($file_id == 0) {

                //code added by mereena on 11/11/2022 to get current series no


                $current_serial_no = (int) $modelWarehouse->invoice_current_series_no;
                $start_series_no = (int) $modelWarehouse->invoice_start_series_no;

                if ($current_serial_no > 0) {
                    $invoice_current_series_no = $current_serial_no + 1;
                } else {
                    $invoice_current_series_no = $start_series_no;
                }
                //end

                $modelMaster = new MasterFile();

                $modelMaster->customer_id = $variables['customer_id'];

                $modelMaster->start_from = "I";

                $modelMaster->current_process_status = "I";

                $modelMaster->crm_user_id = $created_by;

                $modelMaster->file_title = "";

                $modelMaster->save(false);

                $modelMaster->refresh();

                $file_id = $modelMaster->id;
                //}
                $modelInvoice->file_id = $file_id;
                $modelInvoice->save();



                if (!empty($modelInvoiceItems)) {


                    foreach ($modelInvoiceItems as $eachItem) {

                        $modelStore = new Store();
                        $modelStore = $modelStore->findByPk($eachItem->product_id);
                        $eachItem->invoice_id = $modelInvoice->id;
                        $eachItem->save(false);
                        $total_vat_amount += $eachItem->tax_vat_amount;

                        $modelStockLedger                         =   new StockLedger();
                        $modelStockLedger->file_id                =   $file_id;
                        $modelStockLedger->header_id              =   $modelInvoice->id;
                        $modelStockLedger->header_item_id         =   $eachItem->id;
                        $modelStockLedger->customer_vendor_id     =   $customer_id;
                        $modelStockLedger->customer_vendor_name   =   $modelCustomer->customer_name;
                        $modelStockLedger->product_id             =   $eachItem->product_id;
                        $modelStockLedger->product_name           =   $modelStore->part_number;
                        $modelStockLedger->product_description    =   $eachItem->description;
                        $modelStockLedger->brand_id               =   $modelStore->brand_class_id;
                        $modelStockLedger->brand_name             =   $modelStore->brand_detail->product_class;
                        $modelStockLedger->warehouse_id           =   $user_warehouse_id;
                        $modelStockLedger->warehouse_name         =   $warehouse_name;
                        $modelRack = new MasInvRack();
                        $modelStockLedger->rack_id                =   $modelRack->getDefaultRackId();
                        $modelStockLedger->rack_name              =   MasInvRack::getRackName((int) $modelStockLedger->rack_id);
                        $modelBin = new MasInvBin();
                        $modelStockLedger->bin_id                 =   $modelBin->getDefaultBinId();
                        $modelStockLedger->bin_name               =   MasInvBin::getBinName($modelStockLedger->bin_id);
                        $modelStockLedger->unit_id                =   $eachItem->unit_id;
                        $modelUOM = new UnitOfMeasurement();
                        $modelStockLedger->unit_name              =   $modelUOM->getUOMName((int) $eachItem->unit_id);
                        $modelStockLedger->unit_factor            =   1;
                        $modelStockLedger->quantity               =   -1 * $eachItem->quantity;
                        $modelStockLedger->available_status       =   'U';
                        $modelStockLedger->batch_no               =   '';
                        $modelStockLedger->serial_no              =   '';
                        $modelStockLedger->manufacturing_date     =   '0000-00-00';
                        $modelStockLedger->expiry_date            =   '0000-00-00';
                        $modelStockLedger->buying_price           =   0;
                        $modelStockLedger->cost_price             =   $modelStore->rate;
                        $modelStockLedger->sales_price            =   $eachItem->rate;
                        $modelStockLedger->stock_after_transaction =   0;
                        $modelStockLedger->stock_value_after_transaction =   0;
                        $modelStockLedger->transaction_date       =   date('Y-m-d');
                        $modelStockLedger->transaction_from       =   'DIRECT_INVOICE';
                        $modelStockLedger->transaction_type       =   "OUT";
                        $modelStockLedger->master_stock_ledger_id  =   0;
                        $modelStockLedger->stock_updated          =  'Y';
                        $modelStockLedger->created_by             =   $created_by;
                        $modelStockLedger->created_date           =   date("Y-m-d H:i:s");
                        $modelStockLedger->save(false);
                    }
                }

                $invoice_id = $modelInvoice->id;
                //code added by jisha on 03-01-2023--start
                if (isset($variables['grand_total'])) {
                    $grand_total = $variables['grand_total'];
                }

                //code added by mereena on 03/02/2023
                if ((int) $created_by > 0) {

                    $grand_total_without_vat = round(($grand_total - $total_tax), 6);

                    $created_by = (int) $created_by;
                    $modelUser = new User();
                    $modelUser = $modelUser->findByPk($created_by);
                    $commision_percentage = (float) $modelUser->commission;
                    $commision_amount = 0;
                    if ((int) $commision_percentage > 0) {
                        $commision_amount = ($grand_total_without_vat * $commision_percentage) / 100;
                    }
                }


                //code added by jisha on 03-01-2023--end
                $modelInvoice->updateByPk($invoice_id, array('invoice_no' => $invoice_current_series_no, 'net_amount' => $grand_total, 'total_tax_amount' => $total_tax, 'grand_total' => ($grand_total), 'commision_percentage' => $commision_percentage, 'commision_amount' => $commision_amount));

                //code added by mereena on 11/11/2022 to update current series no
                $modelWarehouse = new MasInventoryWarehouse();
                $modelWarehouse->updateByPk($user_warehouse_id, array('invoice_current_series_no' => $invoice_current_series_no));
                //end


                // ----------added-by-indhu-24-01-2023---------------------------
                //if($user_id==64){

                Yii::import('application.modules.accounts.controllers.PostingController');
                $from = 'sales';
                PostingController::DirectPost((int)$invoice_id, $from);
                // }

                // ---------------------------------------------------------------

                $modelInv = new Invoice();

                $modelInv = $modelInv->findBypk($invoice_id);

                $data['status'] = 'success';

                $data['invoice_id'] = $invoice_id;

                $data['customer_name'] = $modelCustomer->customer_name;

                $data['customer_phone'] = $modelCustomer->customer_phone_no;

                $data['customer_address'] = $modelCustomer->customer_address;

                $data['invoice_date'] = date('d/m/Y', strtotime($modelInvoice->invoice_date));

                $data['warehouse_name'] = $warehouse_name;

                $data['invoice_no'] = $invoice_current_series_no;

                $data['total_tax_amount'] = number_format($total_tax, 2, '.', '');

                $data['total_amount'] = number_format($grand_total, 2, '.', '');

                $data['grand_total'] = number_format(($grand_total), 2, '.', '');

                $data['total_discount'] = number_format(($total_discount), 2, '.', '');

                $data['total_wo_vat'] = number_format(($grand_total - $total_tax), 2, '.', '');

                $data['receipt_type'] = $variables['receipt_type'];

                $data['received_amount'] = $variables['received_amount'];

                $data['received_card_amount'] = $modelInvoice->received_card_amount;

                $data['received_cash_amount'] = $modelInvoice->received_cash_amount;

                $data['authorization_code'] = $variables['authorization_code'];

                $data['sales_man'] = $modelInv->createdby->first_name . " " . $modelInv->createdby->last_name;

                $data['invoice_created_date_time'] = date('d/m/Y h:i:s', strtotime($modelInvoice->created_datetime));

                //$data['footer_discount'] = $variables['footer_discount'];

                $data['footer_discount_pecentage'] = $footer_discount_pecentage;

                $data['sub_total'] = $total_amount_without_discount;

                $data['items'] = $arr_items;
            } else {

                $data['status'] = 'failed';

                $error1 = json_decode(CActiveForm::validate($modelInvoice, '', false), true);

                if (!empty($modelInvoiceItems[0]->product_id))

                    $error2 = json_decode(CActiveForm::validateTabular($modelInvoiceItems, '', false), true);

                else

                    $error2[] = "Please add atleast one line item";

                $error = array_merge_recursive($error1, $error2, $others);

                foreach ($error as $a => $eacherror) {

                    $others[] = $eacherror[0];
                }

                if ($others != '[]')

                    $data['msg'] = implode(',', $others);
            }


            header("HTTP/1.1 200 OK");

            header('Content-Type: application/json');
        } else {

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }

        echo json_encode($data);
    }

    public function actionUpdateInvoiceReceivedAmount()
    {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

        $userModel = User::model()->findBytoken($token);
        $user_warehouse_id = $userModel->available_warehouses;
        $warehouse_name = '';
        if ((int) $user_warehouse_id > 0) {
            $warehouse_name = $userModel->warehouse->warehouse_name;
        }
        $grand_total = 0;

        $user_id = (int) $userModel->id;

        if ($user_id > 0) {

            $input = file_get_contents('php://input');

            $variables = json_decode($input, true);

            $invoice_id         = $variables['invoice_id'];
            $receipt_type       = $variables['receipt_type'];
            $received_amount    = $variables['received_amount'];
            $authorization_code = $variables['authorization_code'];

            $modelInvoice = new Invoice();
            $modelInvoice->updateByPk($invoice_id, array('receipt_type' => $receipt_type, 'received_amount' => $received_amount, 'authorization_code' => $authorization_code));

            $data = array('status' => "success", "msg" => "success");

            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        } else {

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }

        echo json_encode($data);
    }

    public function actionGetCommisionlist()

    {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);


        if ($userModel->id > 0) {


        $condition = '';
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        $leadowner_id = $_GET['leadowner_id'];
        //$warehouse_id = $_GET['warehouse_id'];
        $warehouse_id =(int)$userModel->available_warehouses;

        if ($leadowner_id > 0) {
            $condition .= ' AND (inv.created_by ="' . $leadowner_id . '"  )';
        }

        if ((int)$warehouse_id > 0) {
            $condition .= " AND inv.warehouse_id = " . $warehouse_id;
        }else{
            $condition .= " AND inv.warehouse_id = 0";
        }

        //echo $condition;
        $SQL = "SELECT sum(S.amount)as amount,sum(S.tax_vat_amount)as tax_vat_amount,sum(S.deduction_amount)as deduction_amount,sum(S.net_amount) AS net_amount,SUM(inv.grand_total) as grand_total,SUM(inv.total_tax_amount) as total_tax_amount,inv.created_by,inv.warehouse_id,W.warehouse_name,
                       creater.commission as commission_percent,creater.first_name as fname,
                       creater.last_name as lname FROM erp_invoice  inv JOIN erp_invoice_item S ON inv.id=S.invoice_id    JOIN blskysoftware_pos_dehnee_main.erp_user as creater 
                        ON inv.created_by=creater.id  JOIN erp_mas_inv_warehouse W ON inv.warehouse_id=W.id
                        WHERE  inv.invoice_date >='" . $from_date . "' AND inv.invoice_date <='" . $to_date . "'
                        $condition
                        GROUP BY inv.created_by";

        $model_commission = Yii::app()->db->createCommand($SQL)->queryAll();



        if (!empty($model_commission)) {




            foreach ($model_commission as $i => $model) {
                $total += $model['amount'];
                $amount_without_vat = $model['net_amount'] - $model['tax_vat_amount'];
                $commission_amount = ($amount_without_vat * $model['commission_percent']) / 100;
                $balance = (float) $amount_without_vat - (float)$commission_amount;
                $data[] = [
                    "warehouse" => $model['warehouse_name'],
                    "name" =>  $model['fname'] . ' ' . $model['lname'],
                    "Sub Total" => Yii::app()->numberFormatter->formatCurrency($model['amount'], ""),
                    "Discount" => Yii::app()->numberFormatter->formatCurrency($model['deduction_amount'], ""),
                    "Net Total" =>  Yii::app()->numberFormatter->formatCurrency($model['net_amount'], ""),
                    "VAT" => Yii::app()->numberFormatter->formatCurrency($model['tax_vat_amount'], ""),
                    "Total before VAT" =>  Yii::app()->numberFormatter->formatCurrency($amount_without_vat, ""),
                    "Commission" => Yii::app()->numberFormatter->formatCurrency($commission_amount, ""),
                    "Balance to be deposited in bank account" =>  Yii::app()->numberFormatter->formatCurrency($balance, ""),


                ];
            }
            $param = array(
                'from_date' => $from_date,
                'to_date' => $to_date,
                'leadowner_id' => $leadowner_id,
                'warehouse_id' => (int) $userModel->available_warehouses,
                'user_id' => (int) $userModel->id,
                'from' => 'APP',

            );
            $pdf_name = "CommisionReport" . $leadowner_id . "_" . '.pdf';
            $file_path = 'uploads/apppdf/' . $pdf_name;
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.commssion_pdf_list', $param, true));
            $mPDF1->Output($file_path, 'F');

            header('Content-Type: application/json');
            $data_pdf = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);
            header("HTTP/1.1 200 OK");

            header('Content-Type: application/json');
            $responseArray = ["status" => "success", "data" => $data, 'data_pdf' => $data_pdf];
        } else {
            $data = [];
            $responseArray = ["status" => "success", "message" => "data is not available", "data" => $data];
        }
        }
        else{

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $responseArray =["status" => "error", "message"=>"Unauthorized user","data" => $data,'data_pdf' => $data_pdf];


        } 

        echo json_encode($responseArray);
    }
    
    
    // ----------------used in api commission report----------------------------------------------------------

    public function actionGetCommisionlistpdf()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $condition = '';
            $from_date = $_GET['from_date'];
            $to_date = $_GET['to_date'];
            $leadowner_id = $_GET['leadowner_id'];


            $param = array(
                'from_date' => $from_date,
                'to_date' => $to_date,
                'leadowner_id' => $leadowner_id,
                'warehouse_id' => (int) $userModel->available_warehouses,
                'user_id' => (int) $userModel->id,
                 'from' => 'APP',

            );
            $pdf_name = "CommisionReport" . $leadowner_id . "_" . '.pdf';
            $file_path = 'uploads/apppdf/' . $pdf_name;
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
           
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.commssion_pdf_list', $param, true));
            $mPDF1->Output($file_path, 'F');

            header('Content-Type: application/json');
            $data = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);
        } else {

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionGetItemSalespdf()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token = '2-1668080011';
        $userModel = User::model()->findBytoken($token);


        if ($userModel->id > 0) {



            $from_date = $_GET['from_date'];
            $to_date = $_GET['to_date'];
            $leadowner_id = $_GET['leadowner_id'];


            $condition = ' I.invoice_status!="C" ';

            if ($from_date != '') {

                $condition .= ' AND I.invoice_date >="' . $from_date . '"';
            }
            if ($to_date != '') {

                $condition .= ' AND I.invoice_date <="' . $to_date . '"';
            }
            if ($leadowner_id > 0) {
                $condition .= ' AND (I.created_by ="' . $leadowner_id . '"  )';
            }

            if ((int) $userModel->level > 1) {
                $condition .= ' AND I.warehouse_id=' . (int) $userModel->available_warehouses;
            }

            $SQL = "SELECT sum(quantity)as qty,sum(amount)as amount,product_id,I.warehouse_id,W.warehouse_name,creater.first_name as fname,I.created_by,
                       creater.last_name as lname FROM erp_invoice_item inv JOIN erp_invoice I ON inv.invoice_id=I.id    JOIN blskysoftware_pos_dehnee_main.erp_user as 						creater 
                        ON I.created_by=creater.id
                         JOIN erp_mas_inv_warehouse W ON I.warehouse_id=W.id
                       WHERE " .  $condition . "
                       
                        GROUP BY I.created_by";


            $model_invoice_details = Yii::app()->db->createCommand($SQL)->queryAll();



            if (!empty($model_invoice_details)) {




                foreach ($model_invoice_details as $i => $model) {

                    $data[] = [
                        "warehouse" =>  $model['warehouse_name'],
                        "name" =>  $model['fname'] . ' ' . $model['lname'],
                        "quanatity" => Yii::app()->numberFormatter->formatCurrency($model['qty'], " "),
                        "amount" =>  Yii::app()->numberFormatter->formatCurrency($model['amount'], " "),



                    ];
                    $id = $model['created_by'];
                    $condition_item = 'I.created_by ="' . $id . '" AND I.invoice_status!="C"';


                    if ($from_date != '') {
                        $from_date = str_replace('/', '-', $from_date);
                        $from_date = date('Y-m-d', strtotime($from_date));
                        $condition_item .= ' AND I.invoice_date >="' . $from_date . '"';
                    }
                    if ($to_date != '') {
                        $to_date = str_replace('/', '-', $to_date);
                        $to_date = date('Y-m-d', strtotime($to_date));
                        $condition_item .= ' AND I.invoice_date <="' . $to_date . '"';
                    }

                    if ($leadowner_id > 0) {
                        $condition_item .= ' AND (I.created_by ="' . $leadowner_id . '"  )';
                    }
                    if ($part_no > 0) {
                        $condition_item .= ' AND (inv.product_id ="' . $part_no . '"  )';
                    }
                    $SQL = "SELECT sum(quantity)as qty,sum(amount)as amount,product_id,inv.description,S.part_number FROM erp_invoice_item inv JOIN erp_invoice I ON inv.invoice_id=I.id  JOIN erp_store S ON inv.product_id=S.id WHERE " .  $condition_item . "  GROUP BY inv.product_id";
                    $model_Invoice = Yii::app()->db->createCommand($SQL)->queryAll();

                    $model_Invoice = Yii::app()->db->createCommand($SQL)->queryAll();
                    // echo  $condition;
                    foreach ($model_Invoice as $i => $row) {
                        $data2[] = [
                            "Part No" =>  $row['part_number'],
                            "Description" =>  $row['description'],
                            "quanatity" => Yii::app()->numberFormatter->formatCurrency($row['qty'], " "),
                            "amount" =>  Yii::app()->numberFormatter->formatCurrency($row['amount'], " "),



                        ];
                    }
                }
                $param = array(
                    'from_date' => $from_date,
                    'to_date' => $to_date,
                    'leadowner_id' => $leadowner_id,
                    'warehouse_id' => (int) $userModel->available_warehouses,

                );
                $pdf_name = "ItemSalesReport" . $leadowner_id . "_" . '.pdf';
                $file_path = 'uploads/apppdf/' . $pdf_name;
                $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
                $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
                $mPDF1->WriteHTML($stylesheet, 1);
                $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.item_wise_sales_pdf_list', $param, true));
                $mPDF1->Output($file_path, 'F');

                header('Content-Type: application/json');
                $data_pdf = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);

                header("HTTP/1.1 200 OK");

                header('Content-Type: application/json');
                $responseArray = ["status" => "success", "data" => $data, "data2" => $data2, 'data_pdf' => $data_pdf];
            } else {
                $data = [];
                $responseArray = ["status" => "success", "message" => "data is not available", "data" => $data];
            }
        } else {

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $responseArray = ["status" => "error", "message" => "Unauthorized user", "data" => $data, 'data_pdf' => $data_pdf];
        }

        echo json_encode($responseArray);
    }
    /*public function actionGetInvoicelist() 

    {

          $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
          //$token = '2-1668080011';
          $userModel = User::model()->findBytoken($token);
          $condition = "";
     
         if ($userModel->id > 0) {


        
            $from_date = $_GET['from_date'];
            $to_date = $_GET['to_date'];
            $leadowner_id = (int)$_GET['leadowner_id'];
            $customer_id = (int)$_GET['customer_id'];
            $type = $_GET['type'];
            $condition = 't.invoice_status!="C" ';
            if($from_date != ''){
               
                $condition .= ' AND t.invoice_date >="'.$from_date.'"';
            }
            if($to_date != ''){
              
                $condition .= ' AND t.invoice_date <="'.$to_date.'"';
            }
            if($leadowner_id >0){
                $condition .= ' AND (t.lead_owner_id ="' . $leadowner_id.'"  )';//OR order_details.lead_owner_id ="' . $leadowner_id.'"
            }
             if($customer_id > 0){

                $condition .= ' AND t.customer_id ="' . $customer_id.'"';
            }
             if($type != ''){

                $condition .= ' AND t.invoice_type ="' . $type.'"';
            }
            
            if((int) $userModel->level>1){
                        $condition.=' AND t.warehouse_id='.(int) $userModel->available_warehouses;
            }
           
                   
                  $total=0;$total_tax=0;
             $total_net_amt_bc =0;
            $model_invoice = Invoice::model()->with('customer','items.product','items','order_details')->findAll(array('condition'=>$condition,'order'=>'t.id DESC'));
             if (!empty($model_invoice)) 

        {   
        foreach ($model_invoice as $i => $model) {
            
            $invoice_no   = $model->invoice_no;
            $invoice_type = $model->invoice_type;
            if((int) $invoice_type > 0){
                $modelInvoiceType         = new MasInvoiceType();
                $arr_invoice_type_details = $modelInvoiceType->findByPk((int) $invoice_type);
                $inv_code                 = $arr_invoice_type_details->inv_code;
                $invoice_no               = $inv_code.'-'.$invoice_no;
            }
            $invoice_no   = $model->id;
               $net_amount  = $model->grand_total-$model->total_tax_amount;  
                $amount=$model->grand_total;
                $model_currency = MasCurrency::model()->findByPk($model->currency);
                                $total_bc   = $amount*$model_currency->exchange_rate;
                                $tax        = $model->total_tax_amount*$model_currency->exchange_rate;
                                $net_amt_bc = $net_amount*$model_currency->exchange_rate;
                                $total_tax += $tax;
                                $total += $total_bc;
                                $total_net_amt_bc += $net_amt_bc;
                $data[] = [
                    "Invoice No" =>  $invoice_no,
                    "Invoice Date" => date("d/m/Y", strtotime($model->invoice_date)),
                    "File No" => $model->file_id,
                     "Warehouse" => $model->warehouse->warehouse_name,
                    "Customer Name" =>  $model->customer->customer_name,
                    "Created By" =>  $model->getCreated_user(),
                    "Currency" => $model->currencyname->currency_code,
                    "Sales Group" => $model->salesgroup->group_name,
                    "Lead Owner" =>  $model->leadowner->first_name.' '.$model->leadowner->last_name,
                     "Net Amt" =>  Yii::app()->numberFormatter->formatCurrency(round($net_amount,2), " "),
                    "VAT" =>  Yii::app()->numberFormatter->formatCurrency(round($model->total_tax_amount,2), " "),
                    "Grand Total" => Yii::app()->numberFormatter->formatCurrency(round($amount,2), " "),
                    "Net Amt(BC)" =>  Yii::app()->numberFormatter->formatCurrency(round($net_amt_bc,2), " "),
                    "VAT(BC)" => Yii::app()->numberFormatter->formatCurrency(round($tax,2), " "),
                    "Grand Total(BC)" => Yii::app()->numberFormatter->formatCurrency(round($total_bc,2), " "),
                   
                   
                    
                ];
            }
             $param = array(
            'invoice_from_date' =>$from_date,
            'invoice_to_date' => $to_date,
            'leadowner_id' => $leadowner_id,
            'customer_id' => $customer_id,
            'type' =>  $type,
            'warehouse_id' => (int) $userModel->available_warehouses
            
        );
             
            $pdf_name="invoicelist" . $leadowner_id . "_" . '.pdf';
            $file_path='uploads/apppdf/' . $pdf_name;
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.invoice_list', $param, true));
            $mPDF1->Output($file_path, 'F');

            header('Content-Type: application/json');
            $data_pdf = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name); 
   header("HTTP/1.1 200 OK");

            header('Content-Type: application/json');
         $responseArray =["status" => "success", "data" => $data, 'data_pdf' => $data_pdf];
        


        }else{ 
            $data=[];
            $responseArray =["status" => "success","message"=>"data is not available", "data" => $data, 'con' => $condition];
        }
    }
        else{

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $responseArray =["status" => "error", "message"=>"Unauthorized user","data" => $data,'data_pdf' => $data_pdf];


        }

        echo json_encode($responseArray);

    }*/





    public function actionGetInvoicelist()
    {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token='5-1679288888';
        $userModel = User::model()->findBytoken($token);
        $condition = "";

        if ($userModel->id > 0) {
            $from_date = $_GET['from_date'];
            $to_date = $_GET['to_date'];
            $leadowner_id = (int) $_GET['leadowner_id'];
            $customer_id = (int) $_GET['customer_id'];
            $type = $_GET['type'];
            $condition = 't.invoice_status!="C" ';
            if ($from_date != '') {

                $condition .= ' AND t.invoice_date >="' . $from_date . '"';
            }
            if ($to_date != '') {

                $condition .= ' AND t.invoice_date <="' . $to_date . '"';
            }
            if ($leadowner_id > 0) {
                $condition .= ' AND (t.lead_owner_id ="' . $leadowner_id . '"  )'; //OR order_details.lead_owner_id ="' . $leadowner_id.'"
            }
            if ($customer_id > 0) {

                $condition .= ' AND t.customer_id ="' . $customer_id . '"';
            }
            if ($type != '') {

                $condition .= ' AND t.invoice_type ="' . $type . '"';
            }

            if ((int) $userModel->level > 1) {
                $condition .= ' AND t.warehouse_id=' . (int) $userModel->available_warehouses;
            }


            $total = 0;
            $total_tax = 0;
            $total_net_amt_bc = 0;
            $model_invoice = Invoice::model()->with('customer', 'items.product', 'items', 'order_details')->findAll(array('condition' => $condition, 'order' => 't.id DESC'));
            if (!empty($model_invoice)) {
                $param = array(
                    'from_date' => $from_date,
                    'to_date' => $to_date,
                    'leadowner_id' => $leadowner_id,
                    'customer_id' => $customer_id,
                    'inv_type' => $type,
                    'warehouse_id' => (int) $userModel->available_warehouses
                );
                foreach ($model_invoice as $i => $model) {

                    $invoice_no   = $model->invoice_no;
                    $data[] = [
                        "Invoice No" =>  $invoice_no
                    ];
                }
                $pdf_name = "netsales_list" . $leadowner_id . "_" . (int)$userModel->available_warehouses . '.pdf';
                $file_path = 'uploads/apppdf/' . $pdf_name;
                $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
                $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
                $mPDF1->WriteHTML($stylesheet, 1);
                $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.netsales_list', $param, true));
                $mPDF1->Output($file_path, 'F');

                header('Content-Type: application/json');
                $data_pdf = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);
                header("HTTP/1.1 200 OK");

                header('Content-Type: application/json');
                $responseArray = ["status" => "success", "data" => $data, 'data_pdf' => $data_pdf];
            } else {
                $data = [];
                $responseArray = ["status" => "success", "message" => "data is not available", "data" => $data, 'con' => $condition];
            }
        } else {

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $responseArray = ["status" => "error", "message" => "Unauthorized user", "data" => $data, 'data_pdf' => $data_pdf];
        }

        echo json_encode($responseArray);
    }


    public function actionGetCommissionDetailedpdf_new()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token = '2-1668080011';
        $userModel = User::model()->findBytoken($token);
        $data['data'] = 'Success';

        if ($userModel->id > 0) {



            $from_date = $_GET['from_date'];
            $to_date = $_GET['to_date'];
            $leadowner_id = $_GET['leadowner_id'];

            $data = [];
            $param = array(
                'from_date' => $from_date,
                'to_date' => $to_date,
                'leadowner_id' => $leadowner_id,
                'warehouse_id' => (int) $userModel->available_warehouses,
                'user_id' => (int) $userModel->id,
                'from' => 'APP',

            );

            $pdf_name = "CommissionDetailedList" . $leadowner_id . "_" . '.pdf';
            $file_path = 'uploads/apppdf/' . $pdf_name;
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.commssion_invoice_pdf_list', $param, true));
            $mPDF1->Output($file_path, 'F');

            header('Content-Type: application/json');
            $data_pdf = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
            $responseArray = ["status" => "success", "data" => $data, "data2" => $data, 'data_pdf' => $data_pdf];

            /*  if (!empty($model_invoice_details)) {

                 $data['data'] = 'Success';
                $data2['data'] = 'Success'; 

            } else {
                $data = [];
                $responseArray = ["status" => "success", "message" => "data is not available", "data" => $data];
            }*/
        } else {

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $responseArray = ["status" => "error", "message" => "Unauthorized user", "data" => $data];
        }

        echo json_encode($responseArray);
    }


// -------------------commission detailed report api--------------------------------------------------

    public function actionGetCommissionDetailedpdf()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token = '5-1679289481';
        $userModel = User::model()->findBytoken($token);


        if ($userModel->id > 0) {
            $from_date = $_GET['from_date'];
            $to_date = $_GET['to_date'];
            $leadowner_id = $_GET['leadowner_id'];

            if ($from_date != '') {
                $from_date = str_replace('/', '-', $from_date);
                $from_date = date('Y-m-d', strtotime($from_date));
            }
            if ($to_date != '') {
                $to_date = str_replace('/', '-', $to_date);
                $to_date = date('Y-m-d', strtotime($to_date));
            }

            $data[] = [];

            $data2[] = [];

            $param = array(
                'from_date' => $from_date,
                'to_date' => $to_date,
                'leadowner_id' => $leadowner_id,
                'warehouse_id' => (int) $userModel->available_warehouses,
                'user_id' => (int) $userModel->id,
                'from' => 'APP',

            );
            $pdf_name = "CommissionInvoiceList" . $leadowner_id . "_" . '.pdf';
            $file_path = 'uploads/apppdf/' . $pdf_name;
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.commssion_invoice_pdf_list', $param, true));
            $mPDF1->Output($file_path, 'F');

            header('Content-Type: application/json');
            $data_pdf = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);

            header("HTTP/1.1 200 OK");

            header('Content-Type: application/json');
            $responseArray = ["status" => "success", "data" => $data, "data2" => $data2, 'data_pdf' => $data_pdf];
        } else {

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $responseArray = ["status" => "error", "message" => "Unauthorized user", "data" => $data, 'data_pdf' => $data_pdf];
        }

        echo json_encode($responseArray);
    }








    public function actionGetInvoiceDetails1()
    {


        echo "success";
    }

    public function actionGetInvoiceDetails()
    {

        try {

            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            //$token = '2-1669803362';
            $userModel = User::model()->findBytoken($token);


            if ($userModel->id > 0) {


                $modelInvoice = new Invoice();

                $invoice_id = 0;
                if ((int) $_REQUEST['warehouse_id'] > 0) {
                    $warehouse_id =  (int) $_REQUEST['warehouse_id'];
                } else {
                    $warehouse_id =  (int) $userModel->available_warehouses;
                }

                if ((int) $_REQUEST['invoice_id'] > 0) {

                    $invoice_id = $_REQUEST['invoice_id'];
                }

                if ((int) $_REQUEST['invoice_no'] > 0) {

                    $invoice_no = $_REQUEST['invoice_no'];

                    $modelInvoice = $modelInvoice->find(array('condition' => 'invoice_no="' . $invoice_no . '" AND warehouse_id=' . $warehouse_id));

                    $invoice_id = $modelInvoice->id;
                }

                if ((int) $invoice_id > 0) {

                    $condition = 't.id=' . $invoice_id;





                    $modelInvoice = $modelInvoice->with('customer', 'items')->findAll(array('condition' => $condition, "order" => "t.id DESC"));


                    $list = [];


                    foreach ($modelInvoice as $key => $row) {

                        $receipt_flag = 0;
                        if ($row['received_amount'] != $row['grand_total']) {
                            $receipt_flag = 1;
                        }

                        $item_list = [];
                        $total_discount = 0;
                        $total_wo_vat = 0;
                        $total_amount = 0;
                        foreach ($row->items as $eachItem) {
                            $total_discount += $eachItem['deduction_amount'];
                            $total_wo_vat += $eachItem['rate'] * $eachItem['quantity'];
                            $total_amount += $eachItem['net_per_item'] * $eachItem['quantity'];

                            $SQL = 'SELECT SUM(quantity) FROM `erp_stock_ledger` WHERE warehouse_id=' . $warehouse_id . ' AND product_id=' . (int) $eachItem['product_id'];
                            $warehouse_qty = Yii::app()->db->createCommand($SQL)->queryScalar();


                            $modelUnits = UnitOfMeasurement::model()->findAll(array('condition' => 'product_id=' . (int) $eachItem['product_id'], 'order' => 'is_secondary_unit'));

                            $unit_data = [];
                            if (!empty($modelUnits)) {
                                foreach ($modelUnits as $i => $each) {
                                    $unit_price = number_format(($each['factor'] * $sales_price), 2);
                                    $unit_data[] = [
                                        "id" => $each['id'],
                                        "unit_name" => $each['name'],
                                        "unit_factor" => $each['factor'],
                                        "unit_price" => $unit_price
                                    ];
                                }
                            }


                            $discount_amount = 0;
                            if ((int)$eachItem['deduction_percentage'] > 0) {
                                $discount_amount =  ($eachItem['rate'] * $eachItem['quantity']) * ((int)$eachItem['deduction_percentage'] / 100);
                            }

                            $subtotalafterdiscount = number_format($eachItem['net_amount'] - $eachItem['tax_vat_amount'], 6);
                            $discountvalue = $discount_amount - $eachItem['deduction_amount'];

                            $item_list[] = [

                                "product_id" => $eachItem['product_id'],
                                "part_number" => $eachItem['product']['part_number'],
                                "description" => $eachItem['product']['description'],
                                "brand_id" => $eachItem['product']['brand_class_id'],
                                "brand_name" => $eachItem['product']['brand_detail']['product_class'],
                                "bar_code" => $eachItem['product']['bar_code'],
                                "quantity" => $eachItem['quantity'],
                                "rate" => $eachItem['rate'],
                                "amount" => $eachItem['amount'],
                                "discount" => $eachItem['deduction_amount'],
                                "tax_vat_amount" => $eachItem['tax_vat_amount'],
                                "net_per_item" => $eachItem['net_per_item'],
                                "total_amount" => number_format($eachItem['net_amount'], 6),
                                "unit_id" => $eachItem['unit_id'],
                                "unit_name" => $eachItem['invoiceunit']['name'],
                                "availableqty" => $warehouse_qty,
                                "warehouse_id" => $warehouse_id,
                                "arr_units" => $unit_data,
                                "tax_code" => $eachItem['product']['tax']['percentage'],
                                "discount_percentage" => $eachItem['deduction_percentage'],
                                "totalafterdiscount" => number_format($eachItem['net_amount'], 6),
                                "vatafterdiscount" => number_format($eachItem['tax_vat_amount'], 6),
                                "subtotalafterdiscount" => $subtotalafterdiscount,
                                "discountvalue" => number_format(abs($discountvalue), 6),
                                "discountpercentagevalue" => number_format($discount_amount, 6)
                                //"customer_name" => $row['customer']['customer_name'],

                            ];
                        }
                        $list = [

                            "id" => $row['id'],

                            "file_id" => $row['file_id'],

                            "customer_name" => $row['customer']['customer_name'],

                            "customer_address" => $row['customer']['customer_address'],

                            "customer_phone" => $row['customer']['customer_phone_no'],

                            "invoice_date" => date("d/m/Y", strtotime($row['invoice_date'])),

                            "vat_amount" => $row['total_tax_amount'],

                            "grand_total" => $row['grand_total'],

                            "posted" => $row['posted'],

                            "invoice_no" => $row['invoice_no'],

                            "receipt_type" => $row['receipt_type'],

                            "received_amount" => $row['received_amount'],

                            "received_card_amount" => $row['received_card_amount'],

                            "received_cash_amount" => $row['received_cash_amount'],

                            "authorization_code" => $row['authorization_code'],

                            "active" => $row['isActive'],

                            "receipt_flag" => $receipt_flag,

                            "warehouse_name" =>  $row['warehouse']['warehouse_name'],

                            "sales_man" =>  $row['createdby']['first_name'] . " " . $row['createdby']['last_name'],

                            "total_discount"    => $total_discount,

                            "total_wo_vat"      => $total_wo_vat,

                            "total_amount" => $total_amount,

                            "invoice_created_date_time" => date("d/m/Y h:i:s", strtotime($row['created_datetime'])),

                            "items" => $item_list

                        ];
                    }

                    $data = array('status' => "success", "count" => $count, "data" => $list, "message" => $count . " Records");

                    header("HTTP/1.1 200 OK");

                    header('Content-Type: application/json');
                } else {
                    header("HTTP/1.1 401 Unauthorized");

                    header('Content-Type: application/json');

                    $data = array('status' => "error", "message" => "Invalid Invoice");
                }
            } else {

                header("HTTP/1.1 401 Unauthorized");

                header('Content-Type: application/json');

                $data = array('status' => "error", "message" => "Unauthorized user");
            }
        } catch (Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message" => "Unexpected Server error");
        }

        echo json_encode($data);
    }


    public function actionSaveExchangeInvoice()
    {


        $others = array();
        $groups = array();

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

        $userModel = User::model()->findBytoken($token);
        $user_warehouse_id = (int) $userModel->available_warehouses;
        $warehouse_name = '';
        if ((int) $user_warehouse_id > 0) {
            $warehouse_name = $userModel->warehouse->warehouse_name;
        }
        $grand_total = 0;

        $user_id = (int) $userModel->id;

        if ($user_id > 0) {

            $input = file_get_contents('php://input');

            error_log('Invoice');

            error_log($input);

            $variables = json_decode($input, true);

            if (isset($variables['created_by']) && (int) $variables['created_by'] > 0) {
                $created_by = (int) trim($variables['created_by']);
            } else {
                $created_by = $user_id;
            }


            $cancel_invoice_id = $variables['cancel_invoice_id'];

            /* echo '<pre>';
            print_r($variables);
            exit;*/

            //$arr_mas_invoice_type = MasInvoiceType::model()->findByPk($variables['invoicetype']);

            $modelInvoice = new Invoice;

            $modelInvoiceItems = array(new InvoiceItem());

            $others = array();

            $update = 0;
            // -----------------------------------------------------

            $customer_id = (int) $variables['customer_id'];
            $modelCustomer = new Customer();
            $modelCustomer = $modelCustomer->findByPk($customer_id);

            $modelCustomerContact = new CustomerContact();
            $modelCustomerContact = $modelCustomerContact->find(array('condition' => 'customer_id=' . $customer_id));

            $arr_company = MasCompany::model()->findByPk($userModel->company_id);

            $modelInvoice->delivery_ids = 0;
            $modelInvoice->crm_user_id = $created_by;
            $modelInvoice->file_id = 0;
            $modelInvoice->order_id = 0;
            $modelInvoice->order_lpo_no = '';
            $modelInvoice->order_lpo_date = date('Y-m-d');
            $modelInvoice->project_id = 0;
            $modelInvoice->invoice_no = '';
            $modelInvoice->custom_invoice_no = '';
            $modelInvoice->invoice_start_date = date('Y-m-d');
            $modelInvoice->invoice_end_date = date('Y-m-d');
            $modelInvoice->customer_id = $customer_id;
            $modelInvoice->contact_id = $modelCustomerContact->id;
            $modelInvoice->lead_owner_id = $created_by;
            $modelInvoice->billing_address = $modelCustomer->customer_address;
            $modelInvoice->shipping_address = $modelCustomer->customer_address;
            $modelInvoice->shipping_conditions = '';
            $modelInvoice->invoice_date = date('Y-m-d');
            $modelInvoice->sales_group = 1;
            $modelInvoice->reference = '';
            $modelInvoice->currency = $arr_company->currency_id;
            $modelInvoice->exchange_rate = 1;
            $modelInvoice->payment_terms = 1; //cash 
            $modelInvoice->shipping_by = '';
            $modelInvoice->lpo = '';
            $modelInvoice->others = '';
            $modelInvoice->net_amount = 0;
            $modelInvoice->tax_type = 1;
            $modelInvoice->total_tax_amount = 0.000000;
            $modelInvoice->grand_total = 0.000000;
            $modelInvoice->notes = '';
            $modelInvoice->terms_id = 0;
            $modelInvoice->terms_and_conditions = '';
            $modelInvoice->remarks = '';
            $modelInvoice->paid = 'N';
            $modelInvoice->invoice_type = 1;
            $modelInvoice->isActive = 'Y';
            $modelInvoice->is_approved = 'N';
            $modelInvoice->is_direct_invoice = 'Y';
            $modelInvoice->approved_by = 0;
            $modelInvoice->payment_days = 0;
            $modelInvoice->is_hiring_invoice = 'N';
            $modelInvoice->invoice_notification = '';
            $modelInvoice->invoice_hiring_notification = '';
            $modelInvoice->posted = 'N';
            $modelInvoice->invoice_advance_remark = '';
            $modelInvoice->tax_advance_deduction = 0.000;
            $modelInvoice->invoice_nature = 'S';
            $modelInvoice->invoice_status = 'Y';
            $modelInvoice->out_for_delivery = 'N';
            $modelInvoice->created_by = $created_by;
            $modelInvoice->created_datetime = date('Y-m-d H:i:s');
            $modelInvoice->updated_by = 0;
            $modelInvoice->updated_datetime = '0000-00-00';
            $modelInvoice->added_from = 'A';
            $modelInvoice->receipt_type = $variables['receipt_type'];
            $modelInvoice->received_amount = $variables['received_amount'];
            $modelInvoice->received_card_amount = $variables['received_card_amount'];
            $modelInvoice->received_cash_amount = $variables['received_cash_amount'];
            $modelInvoice->authorization_code = $variables['authorization_code'];
            $modelInvoice->warehouse_id = $user_warehouse_id;

            // -----------------------------------------------------




            $grand_total = $total_tax = 0;
            $total_discount = 0;
            $total_wo_vat = 0;

            if ($update == 0) {

                $modelInvoice->grand_total = 0;
            }

            //$modelInvoice->sales_group_id = 1;


            $valid = $modelInvoice->validate();

            $arr_items = $variables['items'];


            if (!empty($arr_items)) {

                foreach ($arr_items as $i => $item) {

                    if ($item['product_id'] != '') {

                        $modelInvoiceItems[$i] = new InvoiceItem();

                        $mod_store = Store::model()->findByPK((int) $item['product_id']);

                        // ----------------------------------------------------------------

                        $modelInvoiceItems[$i]->product_id = $item['product_id'];
                        //$modelInvoiceItems[$i]->part_no = $item['part_number'];
                        $modelInvoiceItems[$i]->quantity = $item['quantity'];
                        $modelInvoiceItems[$i]->rate = $item['rate'];
                        $modelInvoiceItems[$i]->invoice_item_type = 'D';
                        $modelInvoiceItems[$i]->order_item_id = 0;
                        $modelInvoiceItems[$i]->invoice_id = 0;
                        $modelInvoiceItems[$i]->description = $item['description'];
                        $modelInvoiceItems[$i]->brand_class_id = $mod_store->brand_class_id;
                        $modelInvoiceItems[$i]->product_generic_name = $mod_store->generic_id;
                        $modelInvoiceItems[$i]->quantity = $item['quantity'];
                        $modelInvoiceItems[$i]->duration = 0;
                        $modelInvoiceItems[$i]->bonus_qty = 0;
                        $modelInvoiceItems[$i]->picked_qty = $item['quantity'];
                        $modelInvoiceItems[$i]->unit_id = $item['unit_id'];
                        $modelInvoiceItems[$i]->rate = $item['rate'];
                        //$modelInvoiceItems[$i]->amount =  $item['quantity'] * ($item['rate'] - (float) $item['discount']);
                        $modelInvoiceItems[$i]->amount =  $item['total_amount'];
                        //$modelInvoiceItems[$i]->amount = ($item['rate'] * $item['quantity']);
                        $modelInvoiceItems[$i]->addition_percentage = '';
                        $modelInvoiceItems[$i]->addition_amount = 0;
                        $modelInvoiceItems[$i]->deduction_percentage = $item['discount_percentage'];
                        //discount--changed--14-11-22--jisha
                        $discount_amount = 0;
                        if ((int)$item['discount_percentage'] > 0) {
                            $discount_amount =  ($item['rate'] * $item['quantity']) * ((int)$item['discount_percentage'] / 100);
                        }
                        $modelInvoiceItems[$i]->deduction_amount = $discount_amount + $item['discount'];
                        //discount--changed--14-11-22--jisha
                        $modelInvoiceItems[$i]->tax_vat_percentage = $mod_store->tax->percentage;
                        //odelInvoiceItems[$i]->tax_vat_percentage = $item['tax_vat_amount'];
                        $modelInvoiceItems[$i]->tax_vat_amount = $item['tax_vat_amount'];
                        $modelInvoiceItems[$i]->net_per_item = $item['net_per_item'];
                        $modelInvoiceItems[$i]->cost_rate = $mod_store->rate;
                        $modelInvoiceItems[$i]->fin_account_id = 0;
                        $modelInvoiceItems[$i]->invoice_from = '0000-00-00';
                        $modelInvoiceItems[$i]->invoice_to = '0000-00-00';
                        $modelInvoiceItems[$i]->bill_type = 0;
                        $modelInvoiceItems[$i]->quantity_hiring = '';
                        $modelInvoiceItems[$i]->unitprice_hiring = '';
                        $modelInvoiceItems[$i]->inventory_type = 'S';
                        $modelInvoiceItems[$i]->alternate_id = 0;
                        $modelInvoiceItems[$i]->created_by = $created_by;
                        $modelInvoiceItems[$i]->created_datetime = date('Y-m-d H:i:s');
                        $modelInvoiceItems[$i]->updated_by = 0;
                        $modelInvoiceItems[$i]->updated_datetime = '0000-00-00 00:00:00';

                        //$arr_mas_invoice_type = MasInvoiceType::model()->findByPk($variables['invoicetype']);

                        //if ($arr_mas_invoice_type['tax'] == 'Y') {

                        //$modelInvoiceItems[$i]->tax_vat_percentage = $mod_store->tax->percentage;
                        //$modelInvoiceItems[$i]->tax_vat_amount = ($mod_store->tax->percentage * $modelInvoiceItems[$i]->amount) / 100;

                        $net_amount = $modelInvoiceItems[$i]->amount + $modelInvoiceItems[$i]->tax_vat_amount;

                        $modelInvoiceItems[$i]->net_amount = $net_amount;
                        /*} else {

                            $modelInvoiceItems[$i]->tax_percentage = 0;

                            $modelInvoiceItems[$i]->tax_amount = 0;
                        }*/



                        if ($item['rate'] <= 0) {

                            $others[] = 'Rate should be greater than zero';

                            $valid = false;
                        }

                        if ((int) $item['quantity'] <= 0) {

                            $others[] = 'Quantity should be greater than zero';

                            $valid = false;
                        }




                        $grand_total += $modelInvoiceItems[$i]->amount;

                        $total_tax += $modelInvoiceItems[$i]->tax_vat_amount;
                        /*******find total discount ----jisha--14/11/22 --start*******/
                        $total_discount += $discount_amount + $item['discount'];
                        $total_wo_vat += ($modelInvoiceItems[$i]->rate * $modelInvoiceItems[$i]->quantity);
                        /*******find total discount ----jisha--14/11/22 --end*******/


                        $valid = $modelInvoiceItems[$i]->validate() && $valid;


                        /*check whether product in user warehouse stock */
                        $modelUOM = UnitOfMeasurement::model()->findByPk((int) $item['unit_id']);
                        $key = $item['product_id'];
                        if (!array_key_exists($key, $groups)) {
                            if ($item['quantity'] && $modelUOM->factor) {
                                $qty = $item['quantity'] * $modelUOM->factor;
                            }
                            $groups[$key] = array(
                                'id' => $item['product_id'],
                                'quantity' => $qty,
                                'unit_id' => $item['unit_id']
                            );
                        } else {
                            $groups[$key]['quantity'] = $groups[$key]['quantity'] + ($item['quantity'] * $modelUOM->factor);
                        }
                        /*check whether product in user warehouse stock */
                    }
                }
            }

            if (!empty($groups)) {
                foreach ($groups as $key => $eachProduct) {
                    $availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . $eachProduct['id'] . ' AND warehouse_id=' . (int) $user_warehouse_id)->queryScalar();
                    $store = new Store();
                    $store = $store->findByPk((int)$eachProduct['id']);
                    $modelUOM = new UnitOfMeasurement();
                    $base_unit_name = $modelUOM->getBaseunitname((int)$eachProduct['id']);

                    $cancelled_availble_qty = abs(Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE header_id=' . $cancel_invoice_id . ' AND product_id=' . $eachProduct['id'] . ' AND warehouse_id=' . (int) $user_warehouse_id)->queryScalar());
                    //echo $cancelled_availble_qty;
                    $availble_qty += $cancelled_availble_qty;


                    if ($eachProduct['quantity'] > $availble_qty) {
                        $others[] = $store['part_number'] . ' maximum sellable qty : ' . number_format($availble_qty, 2) . ' ' . $base_unit_name;
                        $valid = false;
                    }
                }
            }

            if ($cancel_invoice_id > 0) {
                $new_invoice_amount = $grand_total + $total_tax;
                $modelCancelInvoice = new Invoice();
                $modelCancelInvoice = $modelCancelInvoice->findByPk($cancel_invoice_id);
                $cancel_invoice_amount = $modelCancelInvoice->grand_total;

                if ($new_invoice_amount < $cancel_invoice_amount) {
                    $others[] = 'New Invoice amount should be grater than Cancel Invoice';
                    $valid = false;
                }
            }

            if ($valid && !empty($modelInvoiceItems)) {

                //if ($file_id == 0) {

                //code added by mereena on 11/11/2022 to get current series no
                $modelWarehouse = new MasInventoryWarehouse();

                $modelWarehouse = $modelWarehouse->findByPk($user_warehouse_id);

                $current_serial_no = (int) $modelWarehouse->invoice_current_series_no;
                $start_series_no = (int) $modelWarehouse->invoice_start_series_no;

                if ($current_serial_no > 0) {
                    $invoice_current_series_no = $current_serial_no + 1;
                } else {
                    $invoice_current_series_no = $start_series_no;
                }
                //end

                $modelMaster = new MasterFile();

                $modelMaster->customer_id = $variables['customer_id'];

                $modelMaster->start_from = "I";

                $modelMaster->current_process_status = "I";

                $modelMaster->crm_user_id = $created_by;

                $modelMaster->file_title = "";

                $modelMaster->save(false);

                $modelMaster->refresh();

                $file_id = $modelMaster->id;
                //}
                $modelInvoice->file_id = $file_id;

                $modelInvoice->invoice_reference_id = $cancel_invoice_id;

                $modelInvoice->save();



                if (!empty($modelInvoiceItems)) {


                    foreach ($modelInvoiceItems as $eachItem) {

                        $modelStore = new Store();
                        $modelStore = $modelStore->findByPk($eachItem->product_id);
                        $eachItem->invoice_id = $modelInvoice->id;
                        $eachItem->save(false);
                        $total_vat_amount += $eachItem->tax_vat_amount;

                        $modelStockLedger                         =   new StockLedger();
                        $modelStockLedger->file_id                =   $file_id;
                        $modelStockLedger->header_id              =   $modelInvoice->id;
                        $modelStockLedger->header_item_id         =   $eachItem->id;
                        $modelStockLedger->customer_vendor_id     =   $customer_id;
                        $modelStockLedger->customer_vendor_name   =   $modelCustomer->customer_name;
                        $modelStockLedger->product_id             =   $eachItem->product_id;
                        $modelStockLedger->product_name           =   $modelStore->part_number;
                        $modelStockLedger->product_description    =   $eachItem->description;
                        $modelStockLedger->brand_id               =   $modelStore->brand_class_id;
                        $modelStockLedger->brand_name             =   $modelStore->brand_detail->product_class;
                        $modelStockLedger->warehouse_id           =   $user_warehouse_id;
                        $modelStockLedger->warehouse_name         =   $warehouse_name;
                        $modelRack = new MasInvRack();
                        $modelStockLedger->rack_id                =   $modelRack->getDefaultRackId();
                        $modelStockLedger->rack_name              =   MasInvRack::getRackName((int) $modelStockLedger->rack_id);
                        $modelBin = new MasInvBin();
                        $modelStockLedger->bin_id                 =   $modelBin->getDefaultBinId();
                        $modelStockLedger->bin_name               =   MasInvBin::getBinName($modelStockLedger->bin_id);
                        $modelStockLedger->unit_id                =   $eachItem->unit_id;
                        $modelUOM = new UnitOfMeasurement();
                        $modelStockLedger->unit_name              =   $modelUOM->getUOMName((int) $eachItem->unit_id);
                        $modelStockLedger->unit_factor            =   1;
                        $modelStockLedger->quantity               =   -1 * $eachItem->quantity;
                        $modelStockLedger->available_status       =   'U';
                        $modelStockLedger->batch_no               =   '';
                        $modelStockLedger->serial_no              =   '';
                        $modelStockLedger->manufacturing_date     =   '0000-00-00';
                        $modelStockLedger->expiry_date            =   '0000-00-00';
                        $modelStockLedger->buying_price           =   0;
                        $modelStockLedger->cost_price             =   $modelStore->rate;
                        $modelStockLedger->sales_price            =   $eachItem->rate;
                        $modelStockLedger->stock_after_transaction =   0;
                        $modelStockLedger->stock_value_after_transaction =   0;
                        $modelStockLedger->transaction_date       =   date('Y-m-d');
                        $modelStockLedger->transaction_from       =   'DIRECT_INVOICE';
                        $modelStockLedger->transaction_type       =   "OUT";
                        $modelStockLedger->master_stock_ledger_id  =   0;
                        $modelStockLedger->stock_updated          =  'Y';
                        $modelStockLedger->created_by             =   $created_by;
                        $modelStockLedger->created_date           =   date("Y-m-d H:i:s");
                        $modelStockLedger->save(false);
                    }
                }

                $modelCancelInvoiceItems = new InvoiceItem();

                $modelCancelInvoiceItems = $modelCancelInvoiceItems->findAll(array('condition' => 'invoice_id=' . $cancel_invoice_id));

                if (!empty($modelCancelInvoiceItems)) {
                    foreach ($modelCancelInvoiceItems as $eachCancelItem) {

                        $modelCancelStockLedger = new StockLedger();
                        $modelCancelStockLedger->file_id = $file_id;
                        $modelCancelStockLedger->header_id = $cancel_invoice_id;
                        $modelCancelStockLedger->header_item_id = $eachCancelItem['id'];
                        $modelCancelStockLedger->customer_vendor_id = $modelInvoice->customer_id;
                        $modelCancelStockLedger->customer_vendor_name = $modelCustomer->customer_name;
                        $modelCancelStockLedger->product_id = $eachCancelItem['product_id'];
                        $modelCancelStockLedger->product_name = $eachCancelItem->product->part_number;
                        $modelCancelStockLedger->product_description = $eachCancelItem->product->description;
                        $modelCancelStockLedger->brand_id = $eachCancelItem->product->brand_class_id;
                        $modelCancelStockLedger->brand_name = $eachCancelItem->product->brand_detail->product_class;
                        $modelCancelStockLedger->warehouse_id = $warehouse_id;
                        $modelCancelStockLedger->warehouse_name = $warehouse_name;
                        $modelRack = new MasInvRack();
                        $modelCancelStockLedger->rack_id = $modelRack->getDefaultRackId();
                        $modelCancelStockLedger->rack_name = $modelRack->getRackName((int)$modelCancelStockLedger->rack_id);
                        $modelBin = new MasInvBin();
                        $modelCancelStockLedger->bin_id = $modelBin->getDefaultBinId();
                        $modelCancelStockLedger->bin_name = $modelBin->getBinName((int)$modelCancelStockLedger->bin_id);
                        $modelCancelStockLedger->unit_id = $eachCancelItem['unit_id'];
                        $modelUOM = new UnitOfMeasurement();
                        $modelUOM = $modelUOM->findByPk((int) $eachCancelItem['unit_id']);
                        $modelCancelStockLedger->unit_name               = $modelUOM->name;
                        $modelCancelStockLedger->unit_factor             =  $modelUOM->factor;
                        $modelCancelStockLedger->quantity                =  abs($eachCancelItem['quantity']);
                        $modelCancelStockLedger->available_status        = 'A';
                        $modelCancelStockLedger->buying_price            = 0;
                        $modelCancelStockLedger->batch_no                = '';
                        $modelCancelStockLedger->serial_no               = '';
                        $modelCancelStockLedger->manufacturing_date      = '0000-00-00';
                        $modelCancelStockLedger->expiry_date             = '0000-00-00';
                        $modelCancelStockLedger->cost_price              = $eachCancelItem->product->rate;
                        $modelCancelStockLedger->sales_price             = $eachCancelItem['rate'] * $modelUOM->factor;
                        $modelCancelStockLedger->transaction_date        = $modelInvoice['invoice_date'];
                        $modelCancelStockLedger->transaction_from        = 'INVOICE_CANCEL';
                        $modelCancelStockLedger->transaction_type        = "IN";
                        $modelCancelStockLedger->stock_after_transaction =   0;
                        $modelCancelStockLedger->stock_value_after_transaction =   0;
                        $modelCancelStockLedger->master_stock_ledger_id  =   0;
                        $modelCancelStockLedger->stock_updated           =  'Y';
                        $modelCancelStockLedger->created_by              = (int) $created_by;;
                        $modelCancelStockLedger->created_date            = date("Y-m-d H:i:s");
                        $modelCancelStockLedger->save(false);
                    }
                }

                $invoice_id = $modelInvoice->id;

                $modelInvoice->updateByPk($invoice_id, array('invoice_no' => $invoice_current_series_no, 'net_amount' => $grand_total, 'total_tax_amount' => $total_tax, 'grand_total' => ($grand_total + $total_tax)));
                $modelCancelInvoice = new Invoice();
                $modelCancelInvoice->updateByPk($cancel_invoice_id, array('invoice_status' => 'C', 'invoice_reference_id' => $invoice_id));
                //code added by mereena on 11/11/2022 to update current series no
                $modelWarehouse = new MasInventoryWarehouse();
                $modelWarehouse->updateByPk($user_warehouse_id, array('invoice_current_series_no' => $invoice_current_series_no));
                //end

                $modelInv = new Invoice();

                $modelInv = $modelInv->findBypk($invoice_id);

                $data['status'] = 'success';

                $data['invoice_id'] = $invoice_id;

                $data['customer_name'] = $modelCustomer->customer_name;

                $data['customer_phone'] = $modelCustomer->customer_phone_no;

                $data['customer_address'] = $modelCustomer->customer_address;

                $data['invoice_date'] = date('d/m/Y', strtotime($modelInvoice->invoice_date));

                $data['warehouse_name'] = $warehouse_name;

                $data['invoice_no'] = $invoice_current_series_no;

                $data['total_tax_amount'] = number_format($total_tax, 2, '.', '');

                $data['total_amount'] = number_format($grand_total, 2, '.', '');

                $data['grand_total'] = number_format(($grand_total + $total_tax), 2, '.', '');

                $data['total_discount'] = number_format(($total_discount), 2, '.', '');

                $data['total_wo_vat'] = number_format(($total_wo_vat), 2, '.', '');

                $data['receipt_type'] = $variables['receipt_type'];

                $data['received_amount'] = $variables['received_amount'];

                $data['received_card_amount'] = $variables['received_card_amount'];

                $data['received_cash_amount'] = $variables['received_cash_amount'];

                $data['authorization_code'] = $variables['authorization_code'];

                $data['sales_man'] = $modelInv->createdby->first_name . " " . $modelInv->createdby->last_name;

                $data['invoice_created_date_time'] = date('d/m/Y h:i:s', strtotime($modelInvoice->created_datetime));

                $data['items'] = $arr_items;
            } else {

                $data['status'] = 'failed';

                $error1 = json_decode(CActiveForm::validate($modelInvoice, '', false), true);

                if (!empty($modelInvoiceItems[0]->product_id))

                    $error2 = json_decode(CActiveForm::validateTabular($modelInvoiceItems, '', false), true);

                else

                    $error2[] = "Please add atleast one line item";

                $error = array_merge_recursive($error1, $error2, $others);

                foreach ($error as $a => $eacherror) {

                    $others[] = $eacherror[0];
                }

                if ($others != '[]')

                    $data['msg'] = implode(',', $others);
            }


            header("HTTP/1.1 200 OK");

            header('Content-Type: application/json');
        } else {

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }

        echo json_encode($data);
    }


 public function actionGetSalesDetails()
    {
        //$token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

        //$userModel = User::model()->findBytoken($token);
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $user_id = $variables['user_id'];
        if (!empty($variables['from_date'])) {
            $from_date = date('Y-m-d', strtotime($variables['from_date']));
        } else {
            $from_date = date('Y-m-d');
        }

        if (!empty($variables['to_date'])) {
            $to_date = date('Y-m-d', strtotime($variables['to_date']));
        } else {
            $to_date = date('Y-m-d');
        }

        //$user_id=1;
        //$from_date = '2023-01-04';
        //$to_date = '2023-01-05';



        if ($user_id > 0) {


            $modelMasInventoryWarehouse = new MasInventoryWarehouse();
            $condition = 'isActive="Y" AND warehouse_code!="DAM" AND isBaseWareHouse="N"';
            $arr_warehouse_list = $modelMasInventoryWarehouse->findAll(array('condition' => $condition, 'order' => 'warehouse_name DESC'));
            $grand_total_sales               =   0;
            $grand_total_cash_sales          =   0;
            $grand_total_card_sales          =   0;
            $grand_total_tax_amount          =   0;
            $grand_total_commission_amount   =   0;
            $grand_total_balance_to_bank     =   0;
            $grand_total_cost_rate           =   0;
            $grand_total_profit              =   0;
            $grand_total_main_cr             =   0;
            $grand_total_cash_cr             =   0;
            $grand_total_card_cr             =   0;
            $grand_total_tax_amount_cr       =   0;
            $grand_total_commission_amount_cr=   0;
            $grand_total_cost_rate_cr        =   0;

            $item_list = [];

            foreach ($arr_warehouse_list as $warehouse_list) {


               /* $SQL_COST = 'SELECT SUM(cost_rate * quantity) AS total_cost FROM erp_invoice AS INV INNER JOIN erp_invoice_item ON invoice_id=INV.id WHERE  `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"';
                $total_cost_rate    = Yii::app()->db->createCommand($SQL_COST)->queryScalar();*/
                
                
                $total_cost_rate_inv = Yii::app()->db->createCommand('select IFNULL(SUM(cost_price*quantity),0)  from erp_stock_ledger where transaction_from="DIRECT_INVOICE" AND `transaction_date` >=" ' . $from_date . '"  AND `transaction_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"')->queryScalar();
                $total_cost_rate_cancel = Yii::app()->db->createCommand('select IFNULL(SUM(cost_price*quantity),0)  from erp_stock_ledger where transaction_from="CANCEL_INVOICE" AND `transaction_date` >=" ' . $from_date . '"  AND `transaction_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"')->queryScalar();
                $total_cost_rate =$total_cost_rate_inv+$total_cost_rate_cancel;


                //$SQL_INV =  'SELECT SUM(total_tax_amount) AS total_tax_amount,SUM(grand_total) AS grand_total,SUM(grand_total-total_tax_amount) AS invoice_amount,SUM((grand_total - total_tax_amount)*(commission/100)) AS commission_amount  FROM `view_sales_details` WHERE  `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"';

                // -------------------------------------------------------------
                $SQL_INV =  'SELECT SUM(total_tax_amount) AS total_tax_amount,SUM(grand_total) AS grand_total, 
                 SUM(grand_total-total_tax_amount) AS invoice_amount, 
                 SUM((grand_total - total_tax_amount)*(inv_commision_percentage/100)) AS commission_amount ,
                 sum(inv_commision_amount) AS inv_commission_amount 
                 FROM `view_sales_details` 
                 WHERE invoice_status!="C" AND    `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"';

                //echo $SQL_INV;
                $arr_sales    = Yii::app()->db->createCommand($SQL_INV)->queryAll();

                /*echo '<pre>';
                print_r($arr_sales);*/

                $total_invoice_amount    = $arr_sales[0]['invoice_amount'] - $arr_sales[0]['commission_amount'];
                $total_tax_amount        = $arr_sales[0]['total_tax_amount'];
                $grand_total             = $arr_sales[0]['grand_total'];
                $total_commission_amount = $arr_sales[0]['commission_amount'];

                // ---------------------------------------------------------------

                // -----------credit-note----------------------------------

            $total_cost_rate_cr = Yii::app()->db->createCommand('select IFNULL(SUM(cost_price*quantity),0)  from erp_stock_ledger where transaction_from="CREDIT_NOTE" AND `transaction_date` >=" ' . $from_date . '"  AND `transaction_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"')->queryScalar();


                $sql_comm_cn =  'SELECT 
                   SUM(total_tax_amount) AS total_tax_amount,SUM(credited_amount) AS credited_amount, sum(received_card_amount) as paid_card_amount, sum(received_cash_amount) as received_cash_amount, 
                   sum(inv_commision_amount) AS commission_amount 
                   FROM `view_creditnote_details` 
                   WHERE    `credited_date` >=" ' . $from_date . '"  AND `credited_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"';
                $arr_creditnote    = Yii::app()->db->createCommand($sql_comm_cn)->queryAll();

                $grand_total_cr             = $arr_creditnote[0]['credited_amount'];
                $total_card_cr              = $arr_creditnote[0]['paid_card_amount'];
                $total_cash_cr              = $arr_creditnote[0]['received_cash_amount'];
                $total_tax_amount_cr        = $arr_creditnote[0]['total_tax_amount'];
                $total_commission_amount_cr = $arr_creditnote[0]['commission_amount'];


                $grand_total_main_cr              += $grand_total_cr;
                $grand_total_cash_cr              += $total_cash_cr;
                $grand_total_card_cr              += $total_card_cr;
                $grand_total_tax_amount_cr        += $total_tax_amount_cr;
                $grand_total_commission_amount_cr += $total_commission_amount_cr;
                $grand_total_cost_rate_cr         += $total_cost_rate_cr;
                $profit_amount_cr                  = ($grand_total_cr + $total_tax_amount_cr + $total_commission_amount_cr + $total_cost_rate_cr);
                $grand_total_profit_cr            += $profit_amount_cr;

                // -----------------------------------------------------------------

                // -------------------------

                $SQL_CASH =  'SELECT SUM(received_amount) AS received_amount  FROM `view_sales_details` WHERE  `receipt_type`="CH" AND `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"';
                //echo $SQL_CASH;
                $total_cash_sales    = Yii::app()->db->createCommand($SQL_CASH)->queryScalar();

                // -------------------------

                $SQL_CARD =  'SELECT SUM(received_amount) AS received_amount  FROM `view_sales_details` WHERE  `receipt_type`="CA" AND `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"';

                $total_card_sales    = Yii::app()->db->createCommand($SQL_CARD)->queryScalar();

                // -------------------------

                // -------------------------
                $SQL_CASH_CARD =  'SELECT SUM(received_card_amount) AS received_card_amount,SUM(received_cash_amount) AS received_cash_amount FROM `view_sales_details` WHERE  `receipt_type`="CC" AND `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"';

                //$total_cash_card_sales    = Yii::app()->db->createCommand($SQL_CASH_CARD)->queryAll();
                $arr_cash_card_sales    = Yii::app()->db->createCommand($SQL_CASH_CARD)->queryRow();

                $total_cash_sales += $arr_cash_card_sales['received_cash_amount'];
                $total_card_sales += $arr_cash_card_sales['received_card_amount'];


                // -------------------------

                $balance_to_bank = $total_invoice_amount;

                $grand_total_sales += $grand_total;
                $grand_total_cash_sales += $total_cash_sales;
                $grand_total_card_sales += $total_card_sales;
                $grand_total_tax_amount += $total_tax_amount;
                $grand_total_commission_amount += $total_commission_amount;
                $grand_total_balance_to_bank += $balance_to_bank;
                $grand_total_cost_rate += $total_cost_rate;
                //  $profit_amount = ($grand_total - $total_tax_amount - $total_commission_amount - $total_cost_rate);

                $profit_amount =     ($grand_total - $grand_total_cr) - ($total_tax_amount - $total_tax_amount_cr) - ($total_commission_amount + $total_commission_amount_cr) + ($total_cost_rate + $total_cost_rate_cr);


                $grand_total_profit += $profit_amount;

                $item_list[] = [
                    "warehouse_name" => $warehouse_list->warehouse_name,
                    "total_sales"   => Yii::app()->numberFormatter->formatCurrency($grand_total - $grand_total_cr, ""),
                    "cash_sales"    => Yii::app()->numberFormatter->formatCurrency($total_cash_sales + $total_cash_cr, ""),
                    "card_sales"    => Yii::app()->numberFormatter->formatCurrency($total_card_sales + $total_card_cr, ""),
                    "vat_amount"    => Yii::app()->numberFormatter->formatCurrency($total_tax_amount - $total_tax_amount_cr, ""),
                    "commission"    => Yii::app()->numberFormatter->formatCurrency($total_commission_amount + $total_commission_amount_cr, ""),
                    "cost"          => Yii::app()->numberFormatter->formatCurrency(-1 * ($total_cost_rate + $total_cost_rate_cr), ""),
                    "profit"        => Yii::app()->numberFormatter->formatCurrency($profit_amount, ""),
                    'individual'    => 'Y'

                ];
            }


            $item_list[] = [
                "warehouse_name" => 'All Branches',
                "total_sales"   =>  Yii::app()->numberFormatter->formatCurrency($grand_total_sales - $grand_total_main_cr, ""),
                "cash_sales"    => Yii::app()->numberFormatter->formatCurrency($grand_total_cash_sales + $grand_total_cash_cr, ""),
                "card_sales"    => Yii::app()->numberFormatter->formatCurrency($grand_total_card_sales + $grand_total_card_cr, ""),
                "vat_amount"    => Yii::app()->numberFormatter->formatCurrency($grand_total_tax_amount - $grand_total_tax_amount_cr, ""),
                "commission"    => Yii::app()->numberFormatter->formatCurrency($grand_total_commission_amount + $grand_total_commission_amount_cr, ""),
                "cost"          => Yii::app()->numberFormatter->formatCurrency(-1*($grand_total_cost_rate + $grand_total_cost_rate_cr), ""),
                "profit"        => Yii::app()->numberFormatter->formatCurrency($grand_total_profit, ""),
                'individual'    => 'N'

            ];

            $item_list = (array_reverse($item_list));

            $data = array('status' => "success", "data" => $item_list, "message" => $count . " Records");

            header("HTTP/1.1 200 OK");

            header('Content-Type: application/json');
        } else {
            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message" => "Unauthorized user");
        }

        echo json_encode($data);
    }
   

    public function actionGetCommissionBranchpdf()
    {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token = '2-1668080011';
        $userModel = User::model()->findBytoken($token);


        //  if ($userModel->id > 0) {


        $condition = '';
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        $leadowner_id = $_GET['leadowner_id'];




        if ((int)$warehouse_id > 0) {
            $condition .= " AND inv.warehouse_id = " . $warehouse_id;
        }

        //echo $condition;
        $SQL = "SELECT sum(S.amount)as amount,sum(S.tax_vat_amount)as tax_vat_amount,sum(S.deduction_amount)as deduction_amount,sum(S.net_amount) AS net_amount,SUM(inv.grand_total) as grand_total,SUM(inv.total_tax_amount) as total_tax_amount,inv.warehouse_id,W.warehouse_name,creater.commission as commission_percent
                       FROM erp_invoice  inv JOIN erp_invoice_item S ON inv.id=S.invoice_id JOIN blskysoftware_pos_dehnee_main.erp_user as creater 
                        ON inv.created_by=creater.id  JOIN erp_mas_inv_warehouse W ON inv.warehouse_id=W.id
                        WHERE   inv.invoice_date >='" . $from_date . "' AND inv.invoice_date <='" . $to_date . "'
                        $condition
                        GROUP BY inv.warehouse_id";

        $model_commission = Yii::app()->db->createCommand($SQL)->queryAll();



        if (!empty($model_commission)) {




            foreach ($model_commission as $i => $model) {
                $total += $model['amount'];
                $amount_without_vat = $model['net_amount'] - $model['tax_vat_amount'];
                $commission_amount = ($amount_without_vat * $model['commission_percent']) / 100;
                $balance = (float) $amount_without_vat - (float)$commission_amount;
                $data[] = [
                    "warehouse" => $model['warehouse_name'],
                    "name" =>  $model['fname'] . ' ' . $model['lname'],
                    "Sub Total" => Yii::app()->numberFormatter->formatCurrency($model['amount'], ""),
                    "Discount" => Yii::app()->numberFormatter->formatCurrency($model['deduction_amount'], ""),
                    "Net Total" =>  Yii::app()->numberFormatter->formatCurrency($model['net_amount'], ""),
                    "VAT" => Yii::app()->numberFormatter->formatCurrency($model['tax_vat_amount'], ""),
                    "Total before VAT" =>  Yii::app()->numberFormatter->formatCurrency($amount_without_vat, ""),
                    "Commission" => Yii::app()->numberFormatter->formatCurrency($commission_amount, ""),
                    "Balance to be deposited in bank account" =>  Yii::app()->numberFormatter->formatCurrency($balance, ""),


                ];
            }
            $param = array(
                'from_date' => $from_date,
                'to_date' => $to_date,

                'warehouse_id' => (int) $userModel->available_warehouses,
                  'from' => 'APP',

            );
            $pdf_name = "CommisionBranchReport" .  "_" . '.pdf';
            $file_path = 'uploads/apppdf/' . $pdf_name;
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.commssion_branch_pdf_list', $param, true));
            $mPDF1->Output($file_path, 'F');

            header('Content-Type: application/json');
            $data_pdf = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);
            header("HTTP/1.1 200 OK");

            header('Content-Type: application/json');
            $responseArray = ["status" => "success", "data" => $data, 'data_pdf' => $data_pdf];
        } else {
            $data = [];
            $responseArray = ["status" => "success", "message" => "data is not available", "data" => $data];
        }
        /* }
        else{

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $responseArray =["status" => "error", "message"=>"Unauthorized user","data" => $data,'data_pdf' => $data_pdf];


        } */

        echo json_encode($responseArray);
    }
    public function actionGetBranchSalespdf()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token = '2-1668080011';
        $userModel = User::model()->findBytoken($token);


        //    if ($userModel->id > 0) {



        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        $leadowner_id = $_GET['leadowner_id'];
        $warehouse_id = $_GET['warehouse_id'];


        $condition = ' I.invoice_status!="C" ';

        if ($from_date != '') {

            $condition .= ' AND I.invoice_date >="' . $from_date . '"';
        }
        if ($to_date != '') {

            $condition .= ' AND I.invoice_date <="' . $to_date . '"';
        }
        if ($leadowner_id > 0) {
            $condition .= ' AND (I.created_by ="' . $leadowner_id . '"  )';
        }
        if ((int)$warehouse_id > 0) {
            $condition .= " AND I.warehouse_id = " . $warehouse_id;
        }



        $SQL = "SELECT sum(quantity)as qty,sum(amount)as amount,product_id,I.warehouse_id,W.warehouse_name FROM erp_invoice_item inv JOIN erp_invoice I ON inv.invoice_id=I.id JOIN erp_mas_inv_warehouse W ON I.warehouse_id=W.id
                       WHERE " .  $condition . "
                       
                        GROUP BY I.warehouse_id";


        $model_invoice_details = Yii::app()->db->createCommand($SQL)->queryAll();




        if (!empty($model_invoice_details)) {




            foreach ($model_invoice_details as $i => $model) {

                $data[] = [
                    "warehouse" =>  $model['warehouse_name'],

                    "quanatity" => Yii::app()->numberFormatter->formatCurrency($model['qty'], " "),
                    "amount" =>  Yii::app()->numberFormatter->formatCurrency($model['amount'], " "),



                ];
                $id = $model['warehouse_id'];
                $condition_item = 'I.warehouse_id ="' . $id . '" AND I.invoice_status!="C"';


                if ($from_date != '') {
                    $from_date = str_replace('/', '-', $from_date);
                    $from_date = date('Y-m-d', strtotime($from_date));
                    $condition_item .= ' AND I.invoice_date >="' . $from_date . '"';
                }
                if ($to_date != '') {
                    $to_date = str_replace('/', '-', $to_date);
                    $to_date = date('Y-m-d', strtotime($to_date));
                    $condition_item .= ' AND I.invoice_date <="' . $to_date . '"';
                }

                if ($leadowner_id > 0) {
                    $condition_item .= ' AND (I.created_by ="' . $leadowner_id . '"  )';
                }
                if ($part_no > 0) {
                    $condition_item .= ' AND (inv.product_id ="' . $part_no . '"  )';
                }
                $SQL = "SELECT sum(quantity)as qty,sum(amount)as amount,product_id,inv.description,S.part_number FROM erp_invoice_item inv JOIN erp_invoice I ON inv.invoice_id=I.id  JOIN erp_store S ON inv.product_id=S.id WHERE " .  $condition_item . "  GROUP BY inv.product_id";
                $model_Invoice = Yii::app()->db->createCommand($SQL)->queryAll();

                $model_Invoice = Yii::app()->db->createCommand($SQL)->queryAll();
                // echo  $condition;
                foreach ($model_Invoice as $i => $row) {
                    $data2[] = [
                        "Part No" =>  $row['part_number'],
                        "Description" =>  $row['description'],
                        "quanatity" => Yii::app()->numberFormatter->formatCurrency($row['qty'], " "),
                        "amount" =>  Yii::app()->numberFormatter->formatCurrency($row['amount'], " "),



                    ];
                }
            }
            $param = array(
                'from_date' => $from_date,
                'to_date' => $to_date,
                'leadowner_id' => $leadowner_id,
                'warehouse_id' => $warehouse_id,

            );
            $pdf_name = "BranchSalesReport" . $leadowner_id . "_" . '.pdf';
            $file_path = 'uploads/apppdf/' . $pdf_name;
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.branch_wise_sales_pdf_list', $param, true));
            $mPDF1->Output($file_path, 'F');

            header('Content-Type: application/json');
            $data_pdf = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);

            header("HTTP/1.1 200 OK");

            header('Content-Type: application/json');
            $responseArray = ["status" => "success", "data" => $data, "data2" => $data2, 'data_pdf' => $data_pdf];
        } else {
            $data = [];
            $responseArray = ["status" => "success", "message" => "data is not available", "data" => $data];
        }
        /* }
        else{

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $responseArray =["status" => "error", "message"=>"Unauthorized user","data" => $data,'data_pdf' => $data_pdf];


        }*/

        echo json_encode($responseArray);
    }
    
    
     // ------------------added by indhu 30_05_2023------------
    
    public function actionGetSalesDetailsByUser()
    {
        //$token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

        //$userModel = User::model()->findBytoken($token);
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $user_id = $variables['user_id'];
        
        $userModel = User::model()->findByPk($user_id);
        $user_mis_accessible_branches = $userModel->mis_accessible_branches;
         
        if (!empty($variables['from_date'])) {
            $from_date = date('Y-m-d', strtotime($variables['from_date']));
        } else {
            $from_date = date('Y-m-d');
        }

        if (!empty($variables['to_date'])) {
            $to_date = date('Y-m-d', strtotime($variables['to_date']));
        } else {
            $to_date = date('Y-m-d');
        }

        //$user_id=1;
        //$from_date = '2023-01-04';
        //$to_date = '2023-01-05';



        if ($user_id > 0) {


        $modelMasInventoryWarehouse = new MasInventoryWarehouse();

        $userModel = User::model()->findByPk($user_id);
        $user_mis_accessible_branches = $userModel->mis_accessible_branches;
        $userGroups = MasUserGroup::model()->find('id in (' . $userModel->user_group_id . ')');
        $permissionArray = CJSON::decode($userGroups->permissions); 
        
                     
        // if(array_key_exists('mis_dashboard_view',$permissionArray) && array_key_exists('dashboard_view',$permissionArray)){
        //         $condition = 'isActive="Y" AND warehouse_code!="DAM" AND isBaseWareHouse="N"';
                            
        // }else
        
        
        if(array_key_exists('dashboard_view',$permissionArray)){
  $condition = 'isActive="Y" AND warehouse_code!="DAM" AND isBaseWareHouse="N"';
        }else {
                            
                            $condition = ' isActive="Y" AND warehouse_code!="DAM" AND isBaseWareHouse="N" AND id IN ("' . $user_mis_accessible_branches . '")';
  
        }
                     
                     
        
       /* if (array_key_exists('mis_dashboard_view',$permissionArray)) {
           
                $condition = ' isActive="Y" AND warehouse_code!="DAM" AND isBaseWareHouse="N" AND id IN ("' . $user_mis_accessible_branches . '")';
 
        }else{
               $condition = 'isActive="Y" AND warehouse_code!="DAM" AND isBaseWareHouse="N"';
        }*/
                        
   
           
        $arr_warehouse_list = $modelMasInventoryWarehouse->findAll(array('condition' => $condition, 'order' => 'warehouse_name DESC'));
     
            $grand_total_sales               =   0;
            $grand_total_cash_sales          =   0;
            $grand_total_card_sales          =   0;
            $grand_total_tax_amount          =   0;
            $grand_total_commission_amount   =   0;
            $grand_total_balance_to_bank     =   0;
            $grand_total_cost_rate           =   0;
            $grand_total_profit              =   0;
            $grand_total_main_cr             =   0;
            $grand_total_cash_cr             =   0;
            $grand_total_card_cr             =   0;
            $grand_total_tax_amount_cr       =   0;
            $grand_total_commission_amount_cr=   0;
            $grand_total_cost_rate_cr        =   0;

            $item_list = [];

            foreach ($arr_warehouse_list as $warehouse_list) {


               /* $SQL_COST = 'SELECT SUM(cost_rate * quantity) AS total_cost FROM erp_invoice AS INV INNER JOIN erp_invoice_item ON invoice_id=INV.id WHERE  `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"';
                $total_cost_rate    = Yii::app()->db->createCommand($SQL_COST)->queryScalar();*/
                
                
                $total_cost_rate_inv = Yii::app()->db->createCommand('select IFNULL(SUM(cost_price*quantity),0)  from erp_stock_ledger where transaction_from="DIRECT_INVOICE" AND `transaction_date` >=" ' . $from_date . '"  AND `transaction_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"')->queryScalar();
                $total_cost_rate_cancel = Yii::app()->db->createCommand('select IFNULL(SUM(cost_price*quantity),0)  from erp_stock_ledger where transaction_from="CANCEL_INVOICE" AND `transaction_date` >=" ' . $from_date . '"  AND `transaction_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"')->queryScalar();
                $total_cost_rate =$total_cost_rate_inv+$total_cost_rate_cancel;


                //$SQL_INV =  'SELECT SUM(total_tax_amount) AS total_tax_amount,SUM(grand_total) AS grand_total,SUM(grand_total-total_tax_amount) AS invoice_amount,SUM((grand_total - total_tax_amount)*(commission/100)) AS commission_amount  FROM `view_sales_details` WHERE  `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"';

                // -------------------------------------------------------------
                $SQL_INV =  'SELECT SUM(total_tax_amount) AS total_tax_amount,SUM(grand_total) AS grand_total, 
                 SUM(grand_total-total_tax_amount) AS invoice_amount, 
                 SUM((grand_total - total_tax_amount)*(inv_commision_percentage/100)) AS commission_amount ,
                 sum(inv_commision_amount) AS inv_commission_amount 
                 FROM `view_sales_details` 
                 WHERE invoice_status!="C" AND    `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"';

                //echo $SQL_INV;
                $arr_sales    = Yii::app()->db->createCommand($SQL_INV)->queryAll();

                /*echo '<pre>';
                print_r($arr_sales);*/

                $total_invoice_amount    = $arr_sales[0]['invoice_amount'] - $arr_sales[0]['commission_amount'];
                $total_tax_amount        = $arr_sales[0]['total_tax_amount'];
                $grand_total             = $arr_sales[0]['grand_total'];
                $total_commission_amount = $arr_sales[0]['commission_amount'];

                // ---------------------------------------------------------------

                // -----------credit-note----------------------------------

            $total_cost_rate_cr = Yii::app()->db->createCommand('select IFNULL(SUM(cost_price*quantity),0)  from erp_stock_ledger where transaction_from="CREDIT_NOTE" AND `transaction_date` >=" ' . $from_date . '"  AND `transaction_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"')->queryScalar();


                $sql_comm_cn =  'SELECT 
                   SUM(total_tax_amount) AS total_tax_amount,SUM(credited_amount) AS credited_amount, sum(received_card_amount) as paid_card_amount, sum(received_cash_amount) as received_cash_amount, 
                   sum(inv_commision_amount) AS commission_amount 
                   FROM `view_creditnote_details` 
                   WHERE    `credited_date` >=" ' . $from_date . '"  AND `credited_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"';
                $arr_creditnote    = Yii::app()->db->createCommand($sql_comm_cn)->queryAll();

                $grand_total_cr             = $arr_creditnote[0]['credited_amount'];
                $total_card_cr              = $arr_creditnote[0]['paid_card_amount'];
                $total_cash_cr              = $arr_creditnote[0]['received_cash_amount'];
                $total_tax_amount_cr        = $arr_creditnote[0]['total_tax_amount'];
                $total_commission_amount_cr = $arr_creditnote[0]['commission_amount'];


                $grand_total_main_cr              += $grand_total_cr;
                $grand_total_cash_cr              += $total_cash_cr;
                $grand_total_card_cr              += $total_card_cr;
                $grand_total_tax_amount_cr        += $total_tax_amount_cr;
                $grand_total_commission_amount_cr += $total_commission_amount_cr;
                $grand_total_cost_rate_cr         += $total_cost_rate_cr;
                $profit_amount_cr                  = ($grand_total_cr + $total_tax_amount_cr + $total_commission_amount_cr + $total_cost_rate_cr);
                $grand_total_profit_cr            += $profit_amount_cr;

                // -----------------------------------------------------------------

                // -------------------------

                $SQL_CASH =  'SELECT SUM(received_amount) AS received_amount  FROM `view_sales_details` WHERE  `receipt_type`="CH" AND `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"';
                //echo $SQL_CASH;
                $total_cash_sales    = Yii::app()->db->createCommand($SQL_CASH)->queryScalar();

                // -------------------------

                $SQL_CARD =  'SELECT SUM(received_amount) AS received_amount  FROM `view_sales_details` WHERE  `receipt_type`="CA" AND `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"';

                $total_card_sales    = Yii::app()->db->createCommand($SQL_CARD)->queryScalar();

                // -------------------------

                // -------------------------
                $SQL_CASH_CARD =  'SELECT SUM(received_card_amount) AS received_card_amount,SUM(received_cash_amount) AS received_cash_amount FROM `view_sales_details` WHERE  `receipt_type`="CC" AND `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $to_date . '" AND  warehouse_id = "' . $warehouse_list->id . '"';

                //$total_cash_card_sales    = Yii::app()->db->createCommand($SQL_CASH_CARD)->queryAll();
                $arr_cash_card_sales    = Yii::app()->db->createCommand($SQL_CASH_CARD)->queryRow();

                $total_cash_sales += $arr_cash_card_sales['received_cash_amount'];
                $total_card_sales += $arr_cash_card_sales['received_card_amount'];


                // -------------------------

                $balance_to_bank = $total_invoice_amount;

                $grand_total_sales += $grand_total;
                $grand_total_cash_sales += $total_cash_sales;
                $grand_total_card_sales += $total_card_sales;
                $grand_total_tax_amount += $total_tax_amount;
                $grand_total_commission_amount += $total_commission_amount;
                $grand_total_balance_to_bank += $balance_to_bank;
                $grand_total_cost_rate += $total_cost_rate;
                //  $profit_amount = ($grand_total - $total_tax_amount - $total_commission_amount - $total_cost_rate);

                $profit_amount =     ($grand_total - $grand_total_cr) - ($total_tax_amount - $total_tax_amount_cr) - ($total_commission_amount + $total_commission_amount_cr) + ($total_cost_rate + $total_cost_rate_cr);


                $grand_total_profit += $profit_amount;

                $item_list[] = [
                    "warehouse_name" => $warehouse_list->warehouse_name,
                    "warehouse_id" => $warehouse_list->id,
                    "total_sales"   => Yii::app()->numberFormatter->formatCurrency($grand_total - $grand_total_cr, ""),
                    "cash_sales"    => Yii::app()->numberFormatter->formatCurrency($total_cash_sales + $total_cash_cr, ""),
                    "card_sales"    => Yii::app()->numberFormatter->formatCurrency($total_card_sales + $total_card_cr, ""),
                    "vat_amount"    => Yii::app()->numberFormatter->formatCurrency($total_tax_amount - $total_tax_amount_cr, ""),
                    "commission"    => Yii::app()->numberFormatter->formatCurrency($total_commission_amount + $total_commission_amount_cr, ""),
                    "cost"          => Yii::app()->numberFormatter->formatCurrency(-1 * ($total_cost_rate + $total_cost_rate_cr), ""),
                    "profit"        => Yii::app()->numberFormatter->formatCurrency($profit_amount, ""),
                    'individual'    => 'Y'

                ];
            }

            if (array_key_exists('dashboard_view',$permissionArray)) {
                 $item_list[] = [
                            "warehouse_name" => 'All Branches',
                             "warehouse_id" => 0,
                            "total_sales"   =>  Yii::app()->numberFormatter->formatCurrency($grand_total_sales - $grand_total_main_cr, ""),
                            "cash_sales"    => Yii::app()->numberFormatter->formatCurrency($grand_total_cash_sales + $grand_total_cash_cr, ""),
                            "card_sales"    => Yii::app()->numberFormatter->formatCurrency($grand_total_card_sales + $grand_total_card_cr, ""),
                            "vat_amount"    => Yii::app()->numberFormatter->formatCurrency($grand_total_tax_amount - $grand_total_tax_amount_cr, ""),
                            "commission"    => Yii::app()->numberFormatter->formatCurrency($grand_total_commission_amount + $grand_total_commission_amount_cr, ""),
                            "cost"          => Yii::app()->numberFormatter->formatCurrency(-1*($grand_total_cost_rate + $grand_total_cost_rate_cr), ""),
                            "profit"        => Yii::app()->numberFormatter->formatCurrency($grand_total_profit, ""),
                            'individual'    => 'N'
            
                        ];
            }

           

            $item_list = (array_reverse($item_list));

            $data = array('status' => "success", "data" => $item_list, "message" => $count . " Records");

            header("HTTP/1.1 200 OK");

            header('Content-Type: application/json');
        } else {
            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message" => "Unauthorized user");
        }

        echo json_encode($data);
    }
}
