<?php

class ApidiningController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('getmaster'),
                'users' => array('*'),
            ),
//            array('allow', // allow authenticated user to perform 'create' and 'update' actions
//                'actions' => array(''),
//                'expression' => '$user->isMember()',
//            ),
            array('deny', // deny all users
            // 'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
         $this->ChangeDB();
        return parent::beforeAction($action);
    }

    public function actionGetmaster() {
        $models = DiningTable::model()->findAll();
        $data = [];
        foreach ($models as $row) {
            $data[] = [
                "id" => $row->id,
                "name" => $row->code,
                "seat" => $row->seat,
                "occupied" => $row->getOccupied(),
                "seat_list" => $row->getSeatList(),
            ];
        }
        echo json_encode($data);
    }

}
