<?php

class ApicashclosingController extends Controller
{
        public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    ''
                ),
                'users' => array('*'),
            ),
        );
    }
     public function beforeAction($action)
    {
        $company_db_name = "blueskye_pos_dehnee";
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
        return true;
    }
    
    
    public function actiongetbyuserpdf22_03_2023() {
        
          try {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
     
            if(!empty($userModel)){
                
                 $date = trim($variables['date']);
                $warehouse_id = (int) trim($variables['warehouse_id']);
                

        $this->layout = false;
        $this->renderPartial('application.views.front.reports.pdf.cash_closing', array('date' => $date, 'warehouse_id' => $warehouse_id));
        
    }
            }
            catch(Exception $e) {
                print_r($e);
            $data = array('status' => "error", "message"=>"Unexpected Server error"); 
            echo json_encode($data);

	   }
    }
    
    
    
    public function actiongetbyuserpdf(){
            try {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
     
            if(!empty($userModel)){
                 $input = file_get_contents('php://input');
                $variables = json_decode($input, true);
                $selected_date = trim($variables['date']);
                $user_id = trim($variables['user_id']);
                $warehouse_id = (int) trim($variables['warehouse_id']);
                
                
                $userModel =  User::model()->findByPk($user_id);
                
                /*if((int) $warehouse_id == 0){
                    $warehouse_id = $userModel->available_warehouses;
                }*/
                $pdf_name = "closing_report_".$selected_date . "-".$warehouse_id.".pdf";
                $file_path='uploads/apppdf/' . $pdf_name;
                $mpdf = Yii::app()->ePdf->mpdf('', 'A7');
                $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');



                $mpdf->WriteHTML($stylesheet, 1);



                $mpdf->WriteHTML($this->renderPartial('cash_closing_pdf', array(
                    'selected_date' =>$selected_date,
                    'warehouse_id' => $warehouse_id
                ), true));



                 $mpdf->Output($file_path, 'F');

                header('Content-Type: application/json');
                $data_pdf = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);
                echo json_encode($data_pdf);
                    }
            }
            catch(Exception $e) {
                print_r($e);
            $data = array('status' => "error", "message"=>"Unexpected Server error"); 
            echo json_encode($data);

	   }
    }
    public function actiongetbyuser(){
        try {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
                
            if(!empty($userModel)){
                
                $input = file_get_contents('php://input');
                $variables = json_decode($input, true);
                $selected_date = trim($variables['date']);
                
                $warehouse_id = $userModel->available_warehouses;
                
                $condition = " t.opening_date = '$selected_date' ";
              
                $sql_vat = "SELECT SUM(total_tax_amount) FROM {{invoice}} WHERE warehouse_id = {$warehouse_id} AND invoice_date = '$selected_date' " ;
                $vat_amount = Yii::app()->db->createCommand($sql_vat)->queryScalar();
                
                $modelOpCash= new OpeningCash();
                $modelOpCash = $modelOpCash->find(['condition' => $condition]);
                $opening_cash =0;
                if(!empty($modelOpCash)){
                    $opening_cash = $modelOpCash->opening_cash;
                }
                $inv_model = new Invoice();
                $inv_condition = "t.invoice_date = '$selected_date' AND  warehouse_id = {$warehouse_id} AND t.invoice_status!='C' ";  
                $inv_models = $inv_model->findAll(['condition' => $inv_condition]);
                    
                // init before looping
                    
                $cash_sales = 0;
                $card_sales =0;
                $total_vat =0;
               
                    
                foreach($inv_models as $each_inv){
                        
                     switch(trim($each_inv->receipt_type)){
                        case "": 
                            $cash_sales += $each_inv->received_amount;
                            break;
                        case "CH": 
                            $cash_sales += $each_inv->received_cash_amount;
                            break;
                        case "CA": 
                            $card_sales += $each_inv->received_card_amount;
                            break;
                        case "CC": 
                            $card_sales += $each_inv->received_card_amount;
                            $cash_sales += $each_inv->received_cash_amount;
                            break;
                    }
                    //code added by rahul on 2-12-22 for exchange type amount calculation//
                     switch(trim($each_inv->exchange_receipt_type)){
                        case "": 
                            $cash_exchange_sales += $each_inv->exchange_received_amount;
                            break;
                        case "CH": 
                            $cash_exchange_sales += $each_inv->exchange_received_cash_amount;
                            break;
                        case "CA": 
                            $card_exchange_sales += $each_inv->exchange_received_card_amount;
                            break;
                        case "CC": 
                            $card_exchange_sales += $each_inv->exchange_received_card_amount;
                            $cash_exchange_sales += $each_inv->exchange_received_cash_amount;
                           
                            break;
                    }
                }
                 $cash_sales=$cash_sales+$cash_exchange_sales;
                $card_sales=$card_sales+$card_exchange_sales;
                
                $drawer_amount = $cash_sales + $opening_cash;
                $data =[];
                $data['opening'] = $opening_cash;
                $data['cash_sales'] = $cash_sales;
                $data['card_sales'] = $card_sales;
                $data['total_vat'] = $total_vat;
                $data['drawer_amount'] = $drawer_amount;
                $data['warehouse_id'] = $warehouse_id;
                $data['warehouse'] = MasInventoryWarehouse::getWarehouseName($warehouse_id);
                
                echo json_encode(array('status' => "success", 'data' => $data));
            }else{
                echo json_encode(array('status' => "error"));
            }
        }catch(Exception $e) {
            $data = array('status' => "error", "message"=>"Unexpected Server error"); 
            echo json_encode($data);

	   }
    }
}