<?php

class ApiPurchaseOrderApprovalController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array("approve"),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

   public function beforeAction($action) {
         $this->ChangeDB();
        return parent::beforeAction($action);
    }

    public function actionApprove() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        date_default_timezone_set("Asia/Dubai");
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $userModel = User::model()->findByPk($variables["user_id"]);
        if (!empty($userModel)) {
            error_log($input);
            $id = $variables['id'];
            $model = new PurchasingOrder();
            $model = $model->findByPk($id);
            $file_id = $model->file_id;
            $status = false;

            $model->level1_approved_by = $userModel->id;
            $model->level1_approved_time = date('Y-m-d H:i:s');

            $model->level2_approved_by = $userModel->id;
            $model->level2_approved_time = date('Y-m-d H:i:s');

            $model->level3_approved_by = $userModel->id;
            $model->level3_approved_time = date('Y-m-d H:i:s');

            $model->approved_level = 3;
            if ($model->save()) {
                $approval_history = new ApprovalHistory;
                $approval_history->file_id = $model->file_id;
                $approval_history->status = "Y";
                $approval_history->action_by = $userModel->id;
                $approval_history->created_by = $userModel->id;
                $approval_history->created_datetime = date('Y-m-d H:i:s');
                $approval_history->date = date('Y-m-d H:i:s');
                $approval_history->state = 'PO';
                $approval_history->save();

                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'PURCHASE_ORDER',
                        $userModel->id,
                        'UPDATED',
                        " with APPRVL LVL " . $model->approved_level . " for No: - {$model->id} "
                );
                if ($model->approved_level == 3) {//$file_id >0 &&
                    MasterFile::model()->updateByPk($file_id, array('is_approved' => "Y", 'approved_by' => $userModel->id, 'date_of_approval' => date('Y-m-d'), 'current_process_status' => "P_O"));
                }
                MasterFile::model()->updateByPk($file_id, array('current_process_status' => "P_O"));
                $status = true;
            }
            if ($status) {
                echo json_encode(["status" => "success", "message" => "Success"]);
            } else {
                echo json_encode(["status" => "error", "message" => "Error in approve order"]);
            }
        } else {
            echo json_encode(["status" => "error", "message" => "Invalid User"]);
        }
    }

}
