<?php
class ApiLoginController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'logout', 'error', 'Login', 'AutoLogin',
                    'customerexist'
                ),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
 
    public function actionLogin() {

        try {
            $input = file_get_contents('php://input');
            $variables = json_decode($input, true);
            $username = trim($variables['username']);
            $password = trim($variables['password']);
            $code = MasCompany::CODE;
            $model = new LoginForm();
            $model->company_code = $code;
            $model->username = $username;
            $model->password = $password;
            $user_data = [];
            $isLogin = $model->validate() && $model->login();

            $data = [];
            $user = new User();
            if ($isLogin) {
                $condition = 'LOWER(username)="' . strtolower($username) . '" AND isActive="Y"';
                $user = $user->find(array('condition' => $condition));
                $status = "";
                $message = "";

                if ($user->isActive === "Y") {
                    if (empty($user->token)) {
                        $user->get_generate_token();
                    }
                    $status = "success";
                    $message = "Login success.";
                    $user_data = [
                        "user_id" => $user->id,
                        "name" => ucwords($user->getfullname()),
                        "token" => $user->token,
                        "username" => strtolower($user->username),
                        "user_group" => ucwords($user->userGroup->group_name),
                        "technician_id" => (int) $user->technician_id,
                        "designation" => ucwords($user->designation),
                    ];
                } else {
                    $status = "error";
                    $message = "User account disabled";
                }
                $data = array(
                    'status' => $status,
                    "message" => $message,
                    "user_data" => $user_data
                );
            } else {
                $data['status'] = 'failed';
                $data['message'] = 'Unauthorized user';
                $data['user_data'] = $user_data;
            }
        } catch (Exception $e) {
            $data = array('status' => "error", "message" => "Unexpected Server error");
        }
        header('Content-Type: application/json');
        echo json_encode($data);
    }
    
    public function actionAutoLogin()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        // $input = file_get_contents('php://input');
        // $variables = json_decode($input, true);
        // $token = trim($variables['token']);
        $auth = new AppAuthentication($token);
        $data = [];
        $user = new User();
        $condition = 'token="' . $token . '"';
        $user = $user->find(array('condition' => $condition));
       
        if ($auth->login()) {
            $message = "Login success.";
            $user_data = [
                        "user_id" => $user->id,
                        "name" => ucwords($user->getfullname()),
                        "token" => $user->token,
                        "username" => strtolower($user->username),
                        "user_group" => ucwords($user->userGroup->group_name),
                        "technician_id" => (int) $user->technician_id,
                        "designation" => ucwords($user->designation),
                    ];
            $data = array(
                    'status' => "success",
                    "message" => $message,
                    "user_data" => $user_data);
        } else {
            $data = array('status' => "failed");
        }
        header("HTTP/1.1 200 OK");
        header('Content-Type: application/json');
        echo json_encode($data);
        
    }
     
 

}
