<?php
class ApiLoginController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'logout', 'error', 'Login', 'AutoLogin',
                    'customerexist'
                ),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
 
    public function actionLogin() {

        try {
            $input = file_get_contents('php://input');
            $variables = json_decode($input, true);
            $username = trim($variables['username']);
            $password = trim($variables['password']);
            $code = MasCompany::CODE;
            $model = new LoginForm();
            $model->company_code = $code;
            $model->username = $username;
            $model->password = $password;
            $user_data = [];
            $isLogin = $model->validate() && $model->login();

            $data = [];
            $user = new User();
            if ($isLogin) {
                $condition = 'LOWER(username)="' . strtolower($username) . '" AND isActive="Y"';
                $user = $user->find(array('condition' => $condition));
                $status = "";
                $message = "";

                if ($user->isActive === "Y") {
                    if (empty($user->token)) {
                        $user->get_generate_token();
                    }
                    $status = "success";
                    $message = "Login success.";
                    $permissions = array("dashboard" => "N", "customers" => "N", "customer_edit" => "N", "service_requests" => "N", "machine_issue" => "N", "machine_return" => "N", "transfer_to_warehouse" => "N", "warehouse_transfers_list" => "N");
                    if (Yii::app()->user->havePermissionOn["app_dashboard_view"]) {
                        $permissions['dashboard'] = 'Y';
                    }
                    if (Yii::app()->user->havePermissionOn["app_customers_view"]) {
                        $permissions['customers'] = 'Y';
                    }
                    if (Yii::app()->user->havePermissionOn["app_customer_edit_view"]) {
                        $permissions['customer_edit'] = 'Y';
                    }
                    if (Yii::app()->user->havePermissionOn["app_service_request_view"]) {
                        $permissions['service_requests'] = 'Y';
                    }
                    if (Yii::app()->user->havePermissionOn["app_machine_issue_view"]) {
                        $permissions['machine_issue'] = 'Y';
                    }
                    if (Yii::app()->user->havePermissionOn["app_machine_return_view"]) {
                        $permissions['machine_return'] = 'Y';
                    }
                    if (Yii::app()->user->havePermissionOn["app_transfer_to_warehouse_view"]) {
                        $permissions['transfer_to_warehouse'] = 'Y';
                    }
                    if (Yii::app()->user->havePermissionOn["app_warehouse_to_transfer_list_view"]) {
                        $permissions['warehouse_transfers_list'] = 'Y';
                    }
                    $user_data = [
                        "user_id" => $user->id,
                        "name" => ucwords($user->getfullname()),
                        "token" => $user->token,
                        "username" => strtolower($user->username),
                        "user_group" => ucwords($user->userGroup->group_name),
                        "technician_id" => (int) $user->technician_id,
                        "designation" => ucwords($user->designation),
                        "permissions" => $permissions
                    ];
                } else {
                    $status = "error";
                    $message = "User account disabled";
                }
                $data = array(
                    'status' => $status,
                    "message" => $message,
                    "user_data" => $user_data
                );
            } else {
                $data['status'] = 'failed';
                $data['message'] = 'Unauthorized user';
                $data['user_data'] = $user_data;
            }
        } catch (Exception $e) {
            $data = array('status' => "error", "message" => "Unexpected Server error");
        }
        header('Content-Type: application/json');
        echo json_encode($data);
    }
    
    public function actionAutoLogin()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        // $input = file_get_contents('php://input');
        // $variables = json_decode($input, true);
        // $token = trim($variables['token']);
        $auth = new AppAuthentication($token);
        $data = [];
        $user = new User();
        $condition = 'token="' . $token . '"';
        $user = $user->find(array('condition' => $condition));
       
        if ($auth->login()) {
            $message = "Login success.";
            // $permissions = array("dashboard" => "N", "customers" => "N", "customer_edit" => "N", "service_requests" => "N", "machine_issue" => "N", "machine_return" => "N", "transfer_to_warehouse" => "N", "warehouse_transfers_list" => "N");
            // if (Yii::app()->user->havePermissionOn["app_dashboard_view"]) {
            //     $permissions['dashboard'] = 'Y';
            // }
            // if (Yii::app()->user->havePermissionOn["app_customers_view"]) {
            //     $permissions['customers'] = 'Y';
            // }
            // if (Yii::app()->user->havePermissionOn["app_customer_edit_view"]) {
            //     $permissions['customer_edit'] = 'Y';
            // }
            // if (Yii::app()->user->havePermissionOn["app_service_request_view"]) {
            //     $permissions['service_requests'] = 'Y';
            // }
            // if (Yii::app()->user->havePermissionOn["app_machine_issue_view"]) {
            //     $permissions['machine_issue'] = 'Y';
            // }
            // if (Yii::app()->user->havePermissionOn["app_machine_return_view"]) {
            //     $permissions['machine_return'] = 'Y';
            // }
            // if (Yii::app()->user->havePermissionOn["app_transfer_to_warehouse_view"]) {
            //     $permissions['transfer_to_warehouse'] = 'Y';
            // }
            // if (Yii::app()->user->havePermissionOn["app_warehouse_to_transfer_list_view"]) {
            //     $permissions['warehouse_transfers_list'] = 'Y';
            // }
             $permissions = array("dashboard" => "N", "customers" => "N", "customer_edit" => "N", "service_requests" => "N", "machine_issue" => "N", "machine_return" => "N", "transfer_to_warehouse" => "N", "warehouse_transfers_list" => "N");
                $userGroups = MasUserGroup::model()->findAll('id in (' . $user->user_group_id . ')');
                $permissionArray = array();
                foreach ($userGroups as $eachUserGroup) {
                    if (!empty($eachUserGroup->permissions)) {
                        $permissionArray = CJSON::decode($eachUserGroup->permissions);
                        $formatted_array = array_map(function ($num) {
                            return (is_numeric(trim($num)) ? number_format(floatval($num), 0, '', '') : $num);
                        }, $permissionArray);
                    }
                }
                
                  if ($permissionArray["app_dashboard_view"]==1) {
                    $permissions['dashboard'] = 'Y';
                }
                if ($permissionArray["app_customers_view"]==1) {
                    $permissions['customers'] = 'Y';
                }
                if ($permissionArray["app_customer_edit_view"]==1) {
                    $permissions['customer_edit'] = 'Y';
                }
                if ($permissionArray["app_service_request_view"]==1) {
                    $permissions['service_requests'] = 'Y';
                }
                if ($permissionArray["app_machine_issue_view"]==1) {
                    $permissions['machine_issue'] = 'Y';
                }
                if ($permissionArray["app_machine_return_view"]==1) {
                    $permissions['machine_return'] = 'Y';
                }
                if ($permissionArray["app_transfer_to_warehouse_view"]==1) {
                    $permissions['transfer_to_warehouse'] = 'Y';
                }
                if ($permissionArray["app_warehouse_to_transfer_list_view"]==1) {
                    $permissions['warehouse_transfers_list'] = 'Y';
                }
            $user_data = [
                "user_id" => $user->id,
                "name" => ucwords($user->getfullname()),
                "token" => $user->token,
                "username" => strtolower($user->username),
                "user_group" => ucwords($user->userGroup->group_name),
                "technician_id" => (int) $user->technician_id,
                "designation" => ucwords($user->designation),
                 "permissions" => $permissions
            ];
            $data = array(
                    'status' => "success",
                    "message" => $message,
                    "user_data" => $user_data);
        } else {
            $data = array('status' => "failed");
        }
        header("HTTP/1.1 200 OK");
        header('Content-Type: application/json');
        echo json_encode($data);
        
    }
     
 

}
