<?php



class ApiCustomerStatementController extends Controller {



    public function accessRules() {

        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array("GetCustomerStatement",),

                'users' => array('*'),

            ),

        );

    }



    public function filters() {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }



    public function connectMainDB($company_db_name) {

         $this->ChangeDB();
        return parent::beforeAction($action);

    }

    public function beforeAction($action) {

        $company_db_name = "bluesky01_erp_alaqsar";

        Yii::app()->db->setActive(false);

        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;

        Yii::app()->db->tablePrefix = 'erp_';

        Yii::app()->db->setActive(true);

        return true;

    }

    public function actionGetCustomerStatement(){
        /*$token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
         $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {*/
            $customer_id = $_GET['customer_id'];
            $ledger=11;
            $subledger = FinanceSubledger::model()->find(array('condition'=>'subledger_type_id=1 AND parent_id='.$customer_id))->id;
            $ageing_type=1;
            $type='customer';
            $to = date('Y-m-d');
            $param = array(
            'ledger' => $ledger,
            'subledger' => $subledger,
            'type' => $type,
             'to' => $to,
            'ageing_type' => $ageing_type,
        );
            $pdf_name="CustomerStatement" . $customer_id . "_" . '.pdf';
            $file_path='uploads/apppdf/' . $pdf_name;
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.modules.finance.views.reports.pdf_statement_base_app_new', $param, true));
            $mPDF1->Output($file_path, 'F');

            header('Content-Type: application/json');
            $data = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name); 
        /*}else{

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 

        }*/
         echo json_encode($data);
    }
   


}

