<?php



class ApiChequeCollectionController extends Controller {



    public function accessRules() {

        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array("GetChequeCollectionList","UploadImage","SaveCollection"),

                'users' => array('*'),

            ),

        );

    }



    public function filters() {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }



    public function connectMainDB($company_db_name) {

        Yii::app()->db->setActive(false);

        if (empty($company_db_name)) {

            $company_db_name = '=bluesky01_erp_alaqsar_main';

        }

        Yii::app()->db->connectionString = 'mysql:host=e-sell.me;dbname=bluesky01_erp_alaqsar_main';

        Yii::app()->db->username = 'blueskyerp_qsarala';
        
        Yii::app()->db->password = 'S63mO4)(G_Xm';

        Yii::app()->db->tablePrefix = 'erp_';

        Yii::app()->db->setActive(true);

    }

    public function beforeAction($action) {

        $company_db_name = "bluesky01_erp_alaqsar";

        Yii::app()->db->setActive(false);

        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;

        Yii::app()->db->tablePrefix = 'erp_';

        Yii::app()->db->setActive(true);

        return true;

    }

    public function actionGetChequeCollectionList(){
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
                    $model=new ChequeCollection();
                    $data=[];
                    $condition="1=1";
                    $condition.=" AND status='Not Collected' ";
                    // if($userModel->level!=0){
                       
                        if(!empty($userModel->location_id)){
                            $condition  .= ' AND t.location_id IN ('.$userModel->location_id.') ';
                        }
                        else{
                            $condition  .= ' AND t.location_id=0 ';
                        }
                    // }
                    
                    $model=$model->findAll(array('condition'=>$condition,'order'=> 'id desc'));
                    foreach ($model as $i => $each) {
                        $img_name=$each->cheque_image;
                        $file_path='uploads/cheueImage/' . $img_name;
                        $data[] = [
                            "id" => $each->id,
                            "customer_name"=>$each->customer->customer_name,
                            "location_name" => $each->location->location_name,
                            "cheque_amount"=>$each->cheque_amount,
                            "no_of_cheque"=>$each->no_of_cheque,
                            "date_of_collection"=>$each->date_of_collection,
                            "status"=>$each->status,
                            "notes"=>$each->notes,
                            "upload_file"=>$file_path,
                        ];
                    }


            $data = array('status' => "success", "data" => $data); 
        }else{

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 

        }
         echo json_encode($data);
    }
    public function actionUploadImage() {
        $responseData = ["status" => false];
        $today = date("Y-m-d");
        $filename = $today . "_" . rand(0, getrandmax()) . "_" . basename($_FILES["file"]["name"]);
        $destination = "uploads/cheueImage/" . $filename;
        if (move_uploaded_file($_FILES["file"]["tmp_name"], $destination)) {
            $responseData = ["status" =>"success", "filename" => $filename];
        } else {
            $responseData = ["status" => "failed"];    
        }
        echo json_encode($responseData);
    }
    //save image that given from app
    public function actionSaveCollection(){
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $input = file_get_contents('php://input');
            $variables = json_decode($input, true);
            $collection_id   = (int)$variables['cheque_collection_id'];
            $img_name   = $variables['img_name'];
            $model = new ChequeCollection();
            if ($collection_id > 0)
                {   $model->updated_by = $userModel->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= $collection_id;
                    $model=$model->findByPk($id);
                    $model->scenario='update';
                   
                }
                else{
                    $model->created_by = $userModel->id;
                    $model->created_datetime =date('Y-m-d h:i:s');
                    $model->scenario='add';
               
                }
                $model->cheque_image = $img_name;
                $model->status = "Collected";
                
                if ($model->save(false)){
                    $file_path='uploads/cheueImage/' . $model->cheque_image;
                    $responseData = ["status" =>"success","filepath"=>$file_path];
                }
               
            
        }
        else{

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $responseData =['status' => "failed", "msg"=>"Unauthorized user"]; 

        }
        echo json_encode($responseData);
    }
   


}

