<?php

class AidashboardController extends Controller
{
	public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveAidashboard','Disable','DeleteAidashboardItem'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

public function actionIndex() {
   if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['ai_dashboard_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['ai_dashboard_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
                $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
}
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
  

 public function actionGetList() {
        $model = new MasAidashboardSettings();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 =>'t.id',
			1 => 't.ai_type'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
       // $orderBy = $filterColumn . " " . $filterOrder;
        $orderBy = "ai_type ASC";
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "(
					t.ai_type LIKE '%" . $searchString . "%'
				)";

        }
        $count = $model->count(array('condition' => $condition, 'group'=>'ai_type'));
        $model = $model->findAll(array('condition' => $condition, 'group'=>'ai_type','limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $rowData[] = array($m,
                $row->getAiTypeLabel(),
                array('code'=>$row['ai_type'])
            );
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }


    public function actionCreate() {
        $model = new MasAidashboardSettings();
        $code = Yii::app()->request->getParam('code');
        if ($code !='') {
                $model = MasAidashboardSettings::model()->findAll(array('condition'=>'ai_type="'.$code.'"'));
                if(empty($model)){
                    $model = array(new MasAidashboardSettings());
                }
        } else{
            $model = array(new MasAidashboardSettings());
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('modelAidashboardSettings' => $model,'code'=>$code), false, false);
    }


 
public function actionSaveAidashboard()
 {
    $model = new MasAidashboardSettings();
    $ai_type = $_POST['MasAidashboardSettings_ai_type'];
    $valid=true;
    $other=array();
    if (empty($ai_type)) {
        $valid=false;
        $other[]='AI Type can not be blank';
    }
    if (is_array($_POST['MasAidashboardSettings'])) {
    
           $p=0;
           foreach ($_POST['MasAidashboardSettings'] as $i => $item) {
            if (!empty($item['description'])) {
            $modelMasAidashboardSettings[$p] = new MasAidashboardSettings;
            if($item['id']>0){
                $modelMasAidashboardSettings[$p] = $model->findByPk((int) $item['id']);
                $modelMasAidashboardSettings[$p]->created_by = Yii::app()->user->id;
                $modelMasAidashboardSettings[$p]->created_date_time = date('Y-m-d H:i:s');
            }else{
                 $modelMasAidashboardSettings[$p]->updated_by = Yii::app()->user->id;
                $modelMasAidashboardSettings[$p]->updated_date_time = date('Y-m-d H:i:s');
            }
            $modelMasAidashboardSettings[$p]->attributes = $_POST['MasAidashboardSettings'][$i];
            $modelMasAidashboardSettings[$p]->ai_type = $ai_type;
            $modelMasAidashboardSettings[$p]->serial_no =$item['serial_no'];
            $modelMasAidashboardSettings[$p]->weigtage =$item['weigtage'];
            $modelMasAidashboardSettings[$p]->description = $item['description'];
             
            $modelMasAidashboardSettings[$p]->help = $item['help'];
            $valid = $modelMasAidashboardSettings[$p]->validate() && $valid;
            $p++;
         }
           }
    }
     if (empty($modelMasAidashboardSettings)) {
        $valid=false;
     }
    if($valid){
           if (!empty($modelMasAidashboardSettings)) {
                    foreach ($modelMasAidashboardSettings as $eachModel) {
                         $eachModel->save(false);
                    }
                }

            $jsonData['status'] = 'success';
            $jsonData['frm'] = $_POST['aidashboard-form'];
            echo CJSON::encode($jsonData);
    } else {
           
           if ($modelMasAidashboardSettings[0]->description!=''){
            $error1 = json_decode(CActiveForm::validateTabular($modelMasAidashboardSettings[0], '', false), true);
            }
              else
                    $error1[] = "Please add atleast one line item";
            $error = CJSON::encode(array_merge_recursive($error1,  $other));
                 if ($error != '[]')
		           echo $error;
                  
    }
    
 }



   /* public function actionSaveAidashboard2() 
    {
        $model = new MasAidashboardSettings();
		if (isset($_POST['MasAidashboardSettings'])) {
				$model = new MasAidashboardSettings();
				// Update or create
				if ((int) $_POST['MasAidashboardSettings']['id'] > 0) {
					$model = MasAidashboardSettings::model()->findByPk($_POST['MasAidashboardSettings']['id']);
					$model->updated_by = Yii::app()->user->id;
					$model->updated_date_time = date('Y-m-d H:i:s');
					$audit_type = 'UPDATED';
				} else {
					$model->created_by = Yii::app()->user->id;
					$model->created_date_time = date('Y-m-d H:i:s');
					$audit_type = 'CREATED';
				}

				$model->attributes = $_POST['MasAidashboardSettings'];


				if ($model->save()) {
                    // Save details
                    foreach ($_POST['MasAidashboardSettings'] as $key => $row) {
                        if (is_numeric($key) && is_array($row)) {
                            $detail = new MasAidashboardSettings();
                            $detail->serial_no = $row['serial_no'];
                            $detail->weigtage = $row['weigtage'];
                            $detail->description = $row['description'];
                            $detail->help = $row['help'];
                            $detail->ai_type = $model->ai_type;
                            $detail->save(false);
                        }
                }

					// Audit log
					AuditLog::saveAuditLogs(
						'AI DASHBOARD',
						Yii::app()->user->id,
						$audit_type,
						" with ai dashboard : - {$model->id}"
					);

					// Return response
					$jsonData['status'] = 'success';
					$jsonData['frm'] = $_POST['aidashboard-form'];
					$jsonData['id'] = $model->id;
					$jsonData['from'] = $_POST['from'];
					echo CJSON::encode($jsonData);
				} else {
					$error = CActiveForm::validate($model, '', false);
					if ($error != '[]') echo $error;
				}
            }

    }*/

	public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasAidashboardSettings();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }




    public function actionDeleteAidashboardItem(){
        $id = $_POST['id'];
        $model = new MasAidashboardSettings();
        $model->deleteByPk($id);
        $jsonData['status'] = 'success';
        $jsonData['id'] = $id;
        echo CJSON::encode($jsonData);
    }


}