<?php

class AdminsettingsController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'MasterReport', 'LoadMasterReportFilter', 
//                    'PrintEnquiryReport', 'PrintEnquiryReportPDF', 'PrintEnquiryExcel', 'PrintEnquiryExcelId', 'PrintProposalReport',
//                    'PrintCustomerExcel', 'PrintCustomerReportPDF', 'PrintCustomerContactReportPDF', 'PrintProposalReportPDF', 'PrintProposalExcel',
//                    'PrintProjectReport', 'PrintActivityReport', 'PrintExpenseReport', 'PrintTimesheetReport','PrintCustomerReport', 'PrintCustomerContactReport'
                    
//                    'PrintContractReportPDF','PrintMaterialRequest', 'PrintMaterialRequestReportPDF', 'PrintMaterialRequestExcel', 'PrintMaterialUsedRequest',
//                    'PrintMaterialUsedReportPDF', 'PrintMaterialUsedtExcel',
//                    'getSubledgerById', 'PrintServiceReportPDF', 'PrintServiceReport', 'PrintGroupServiceReportPDF', 'PrintGroupServiceReport',
//                    'PrintGroupServiceExcel', 'PrintGroupServiceExcelId',
                     'PrintLeadReport', 'PrintQuoteReport','PrintLeadExcel','PrintDeliveryReport',
                    'PrintOrderReport', 'PrintContractReport', 'PrintLeadReportPDF', 'PrintQuoteReportPDF', 'PrintOrderReportPDF', 
                    'PrintQuoteExcel', 'PrintOrderExcel', 'PrintContractExcel', 'PrintServiceExcel', 
                     'PrintRegistrationInvoiceRequest','PrintInvoiceReport','PrintDeliveryReportPDF',
                    'PrinRegistrationInvoiceReportPDF', 'PrintMaterialRegistrationInvoiceExcel','Report','PrintInvoiceExcel','PrintInvoiceReportPDF',
                    'PrintJobsheetOverwise', 'PrintOverViewReportPDF', 'PrintDailySchedule', 'PrintdailySchedulePDF','PrintTimeSchedule','PrintInventoryReport','PrintRequistionReportPDF','PrintCustomerReport','PrintCustomerContactReportPDF','PrintCustomerContactReport','PrintEnquiryReport','IndexReport','PrintCustomerReportPDF','PrintCustomerExcel','PrintInventoryReportPDF'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
     
//        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false );
        $this->render('master_settings');
    } 
    public function actionIndexReport() {
         $report_from = Yii::app()->request->getParam('report_from');
         $pagetitle = Yii::app()->request->getParam('pagetitle');
        $id = Yii::app()->request->getParam('id');
        
        if($id==1){
            $frm=$report_from;
            $title='Lead List';
        }
        else if($id==2){
            $frm=$report_from;
            $title='Quotation List';
        }
        else if($id==3){
            $frm=$report_from;
            $title='Order List';
        }
        else if($id==4){
            $frm=$report_from;
            $title='Delivery Note List';
        }
        else if($id==5){
            $frm=$report_from;
            $title='Invoice List';
        }
          else if($id==6){
            $frm=$report_from;
            $title='Inventory List';
        }
       
         Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('master_report_1',array('frm'=>$frm,'title'=>$title));
    }
    

//    public function actionMasterReport() {
//         Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
//        $this->render('master_report');
//    }
     public function actionReport() {
        $id = Yii::app()->request->getParam('id');
        if($id==1){
            $frm='leadlist';
            $title='Lead List';
        }
        else if($id==2){
            $frm='quotelist';
            $title='Quotation List';
        }
        else if($id==3){
            $frm='orderlist';
            $title='Order List';
        }
        else if($id==4){
            $frm='contractlist';
            $title='Contract List';
        }
        else if($id==5){
            $frm='invoicelist';
            $title='Invoice List';
        }
       
         Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('master_report_1',array('frm'=>$frm,'title'=>$title));
    }
    public function actionLoadMasterReportFilter() {
        $report_from = Yii::app()->request->getparam('report_from');
        
      

        if ($report_from == 'customerlist') {

            $this->renderPartial('//reports/filter_customerlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'customercontactlist') {

            $this->renderPartial('//reports/filter_customercontactlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'enquirylist') {

            $this->renderPartial('//reports/filter_enquirylist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'leadlist') {

            $this->renderPartial('//reports/filter_leadlist', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'inventorylist') {

            $this->renderPartial('//reports/filter_inventorylist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'quotelist') {

            $this->renderPartial('//reports/filter_quotelist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'orderlist') {

            $this->renderPartial('//reports/filter_orderlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'contractlist') {

            $this->renderPartial('//reports/filter_contractlist', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'invoicelist') {

            $this->renderPartial('//reports/filter_invoicelist', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'deliverylist') {

            $this->renderPartial('//reports/filter_deliverylist', array('report_from' => $report_from), false, true);
        }
//        if ($report_from == 'servicelist') {
//
//            $this->renderPartial('//reports/filter_servicelist', array('report_from' => $report_from), false, true);
//        }
//        if ($report_from == 'groupservicelist') {
//
//            $this->renderPartial('//reports/filter_groupservicelist', array('report_from' => $report_from), false, true);
//        }
//
//        if ($report_from == 'proposallist') {
//
//            $this->renderPartial('//reports/filter_proposallist', array('report_from' => $report_from), false, true);
//        }
//
//        if ($report_from == 'projectlist') {
//
//            $this->renderPartial('//reports/filter_projectlist', array('report_from' => $report_from), false, true);
//        }
//
//        if ($report_from == 'activitylist') {
//
//            $this->renderPartial('//reports/filter_activitylist', array('report_from' => $report_from), false, true);
//        }
//        if ($report_from == 'timesheetlist') {
//
//            $this->renderPartial('//reports/filter_timesheetlist', array('report_from' => $report_from), false, true);
//        }
//        if ($report_from == 'expenselist') {
//
//            $this->renderPartial('//reports/filter_expenselist', array('report_from' => $report_from), false, true);
//        }
//
//        if ($report_from == 'registrationlist') {
//
//            $this->renderPartial('//reports/filter_registrationlist', array('report_from' => $report_from), false, true);
//        }
//        if ($report_from == 'materialUserList') {
//
//            $this->renderPartial('//reports/filter_materialUserList', array('report_from' => $report_from), false, true);
//        }
//        if ($report_from == 'registrationInvoice') {
//
//            $this->renderPartial('//reports/filter_registrationInvoice', array('report_from' => $report_from), false, true);
//        }
//        if ($report_from == 'overwise') {
//
//            $this->renderPartial('//reports/filter_registrationOverwise', array('report_from' => $report_from), false, true);
//        }
//        if ($report_from == 'dailySchedule') {
//
//            $this->renderPartial('//reports/filter_dailySchedule', array('report_from' => $report_from), false, true);
//        }
//        if ($report_from == 'timeslothistory') {
//
//            $this->renderPartial('//reports/filter_timeslothistory', array('report_from' => $report_from), false, true);
//        }
    }

   public function actionPrintDeliveryReport() {

        $model = new DeliveryNote();

        $del_from_date = $_POST['del_from_date'];
        $del_to_date = $_POST['del_to_date'];
       // $type_of_contract = $_POST['type_of_contract'];
        $customer_id = $_POST['customer_id'];
        $sales_group_id = $_POST['sales_group_id'];
        $status = $_POST['status'];
       // $payment_terms = $_POST['payment_terms'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_delivery_list', array('model' => $model, 'del_from_date' => $del_from_date, 'del_to_date' => $del_to_date, 'sales_group_id' => $sales_group_id, 'customer_id' => $customer_id,'status' => $status, 'title' => $title), false, true);
    }
     public function actionPrintDeliveryReportPDF() {

        $model = new DeliveryNote();

        $del_from_date = Yii::app()->request->getParam('del_from_date');
        $del_to_date = Yii::app()->request->getParam('del_to_date');       
        $customer_id = Yii::app()->request->getParam('customer_id');
        $sales_group_id = Yii::app()->request->getParam('sales_group_id');
        $status = Yii::app()->request->getParam('status');        

//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.deliverynote_list', array('model' => $model, 'del_from_date' => $del_from_date, 'del_to_date' => $del_to_date, 'sales_group_id' => $sales_group_id, 'status' => $status, 'customer_id' => $customer_id, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }
    public function actionPrintInvoiceReport() {

        $model = new Invoice();

        $invoice_from_date = $_POST['invoice_from_date'];
        $invoice_to_date = $_POST['invoice_to_date'];
       // $type_of_contract = $_POST['type_of_contract'];
        $customer_id = $_POST['customer_id'];
        $sales_group = $_POST['sales_group'];
      $leadowner_id = $_POST['leadowner_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_invoice_list', array('model' => $model, 'invoice_from_date' => $invoice_from_date, 'invoice_to_date' => $invoice_to_date, 'sales_group' => $sales_group, 'customer_id' => $customer_id,'leadowner_id' => $leadowner_id, 'title' => $title), false, true);
    }

    public function actionPrintInvoiceReportPDF() {

        $model = new Invoice();

        $invoice_from_date = Yii::app()->request->getParam('invoice_from_date');
        $invoice_to_date = Yii::app()->request->getParam('invoice_to_date');
        //$type_of_contract = Yii::app()->request->getParam('type_of_contract');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $sales_group = Yii::app()->request->getParam('sales_group');
        //$payment_terms = Yii::app()->request->getParam('payment_terms');        

//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.invoice_list', array('model' => $model, 'invoice_from_date' => $invoice_from_date, 'invoice_to_date' => $invoice_to_date, 'sales_group' => $sales_group, 'customer_id' => $customer_id, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintInvoiceExcel() {
        
        $invoice_from_date = Yii::app()->request->getParam('invoice_from_date');
        $invoice_to_date = Yii::app()->request->getParam('invoice_to_date');
        $type_of_contract = Yii::app()->request->getParam('type_of_contract');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $sales_group_id = Yii::app()->request->getParam('sales_group_id');
        $payment_terms = Yii::app()->request->getParam('payment_terms'); //print_r($payment_terms);die();

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($invoice_from_date)) {
            $invoice_from_date = str_replace('/', '-', $invoice_from_date);
            $invoice_from_date = date('Y-m-d', strtotime($invoice_from_date));
            $criteria->addCondition('t.invoice_date>="' . $invoice_from_date . '"', 'AND');
        }
        if (!empty($invoice_to_date)) {
            $invoice_to_date = str_replace('/', '-', $invoice_to_date);
            $invoice_to_date = date('Y-m-d', strtotime($invoice_to_date));
            $criteria->addCondition('t.invoice_date<="' . $invoice_to_date . '"', 'AND');
        }

        if (!empty($customer_id))
            $criteria->addCondition('t.customer_id="' . $customer_id . '"', 'AND');
        if (!empty($sales_group_id))
            $criteria->addCondition('t.sales_group_id="' . $sales_group_id . '"', 'AND');
        if ($payment_terms!='')
            $criteria->addCondition('t.payment_terms="' . $payment_terms . '"', 'AND');
        if (!empty($type_of_contract))
            $criteria->addCondition('t.type_of_contract="' . $type_of_contract . '"', 'AND');
//        print_r($criteria);
        $invoice = Invoice::model()->findAll($criteria);//print_r($invoice);die();
        $j = 0;

        $list[$j++] = 'No!Customer Name!Order Date!Currency!Net Amount!Grand Total!Sales Group!Payment Term!Type of Contract!Contact Name!Mobile!Email';

        foreach ($invoice as $i => $row) {
            if ($row->invoice_date != '0000-00-00') {
                $d1 = date("d/m/Y", strtotime($row->invoice_date));
            } else {
                $d1 = " ";
            } 
           
            $list[$j++] = ($i + 1) . '!' . $row->customer->customer_name . '!' . $d1. '!' .$row->currencyname->currency_code
                    . '!' .$row->net_amount . '!' .$row->grand_total . '!' .$row->salesgroup->group_name
                    . '!' .$row->paymentTerm->payment_term . '!' .$row->typedetail->service_group_name . '!' .$row->customercontact->person_name . '!' .$row->mobile . '!' .$row->email;
                    
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"nittygritty_invoicelist.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }
   

    public function actionPrintOrderReport() {

        $model = new Order();

        $order_from_date = $_POST['order_from_date'];
        $delivery_from_date = $_POST['delivery_from_date'];
        $order_to_date = $_POST['order_to_date'];
        $delivery_to_date = $_POST['delivery_to_date'];
        $customer_id = $_POST['customer_id'];
        $sales_group = $_POST['sales_group'];
        $payment_terms = $_POST['payment_terms'];
        $type_of_contract = $_POST['type_of_contract'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_order_list', array('model' => $model, 'order_from_date' => $order_from_date, 'delivery_from_date' => $delivery_from_date, 'order_to_date' => $order_to_date, 'delivery_to_date' => $delivery_to_date, 'sales_group' => $sales_group, 'payment_terms' => $payment_terms, 'type_of_contract' => $type_of_contract, 'customer_id' => $customer_id, 'title' => $title), false, true);
    }

    public function actionPrintOrderReportPDF() {

        $model = new Order();

        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $delivery_from_date = Yii::app()->request->getParam('delivery_from_date');
        $delivery_to_date = Yii::app()->request->getParam('delivery_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $sales_group = Yii::app()->request->getParam('sales_group');
        $payment_terms = Yii::app()->request->getParam('payment_terms');
        $type_of_contract = Yii::app()->request->getParam('type_of_contract');

//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.order_list', array('model' => $model, 'order_from_date' => $order_from_date, 'delivery_from_date' => $delivery_from_date, 'order_to_date' => $order_to_date, 'delivery_to_date' => $delivery_to_date, 'sales_group' => $sales_group, 'payment_terms' => $payment_terms, 'type_of_contract' => $type_of_contract, 'customer_id' => $customer_id, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintOrderExcel() {
        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $delivery_from_date = Yii::app()->request->getParam('delivery_from_date');
        $delivery_to_date = Yii::app()->request->getParam('delivery_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $sales_group = Yii::app()->request->getParam('sales_group');
        $payment_terms = Yii::app()->request->getParam('payment_terms');
        $type_of_contract = Yii::app()->request->getParam('type_of_contract');

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($order_from_date)) {
            $order_from_date = str_replace('/', '-', $order_from_date);
            $order_from_date = date('Y-m-d', strtotime($order_from_date));
            $criteria->addCondition('t.order_date>="' . $order_from_date . '"', 'AND');
        }
        if (!empty($order_to_date)) {
            $order_to_date = str_replace('/', '-', $order_to_date);
            $order_to_date = date('Y-m-d', strtotime($order_to_date));
            $criteria->addCondition('t.order_date<="' . $order_to_date . '"', 'AND');
        }
        if (!empty($delivery_from_date)) {
            $delivery_from_date = str_replace('/', '-', $delivery_from_date);
            $delivery_from_date = date('Y-m-d', strtotime($delivery_from_date));
            $criteria->addCondition('t.delivery_date>="' . $delivery_from_date . '"', 'AND');
        }
        if (!empty($delivery_to_date)) {
            $delivery_to_date = str_replace('/', '-', $delivery_to_date);
            $delivery_to_date = date('Y-m-d', strtotime($delivery_to_date));
            $criteria->addCondition('t.delivery_date<="' . $delivery_to_date . '"', 'AND');
        }
        if (!empty($customer_id))
            $criteria->addCondition('t.customer_id="' . $customer_id . '"', 'AND');
        if (!empty($sales_group))
            $criteria->addCondition('t.sales_group="' . $sales_group . '"', 'AND');
        if (!empty($payment_terms))
            $criteria->addCondition('t.payment_terms="' . $payment_terms . '"', 'AND');
        if (!empty($type_of_contract))
            $criteria->addCondition('t.type_of_contract="' . $type_of_contract . '"', 'AND');

        $order = Order::model()->findAll($criteria);
        $j = 0;
        $list[$j++] = 'No!Customer Name!Order Date!Delivery Date!Currency!Net Amount!Final Addition Amount!Final Deduction Amount!Net Total!Grand Total!Exchange Rate!Billing Address!Shipping Address!Sales Group!Payment Term!Type of Contract!Contact Name!Mobile!Email';

        foreach ($order as $i => $row) {
            if ($row->order_date != '0000-00-00') {
                $d1 = date("d/m/Y", strtotime($row->order_date));
            } else {
                $d1 = " ";
            }
            if ($row->delivery_date != '0000-00-00') {
                $d2 = date("d/m/Y", strtotime($row->delivery_date));
            } else {
                $d2 = " ";
            }

            $list[$j++] = ($i + 1) . '!' . $row->customer->customer_name . '!' . $d1 . '!' . $d2 . '!' . $row->currencyname->currency_code . '!' . $row->net_amount . '!' . $row->final_addition_amount . '!' . $row->final_deduction_amount . '!' . $row->net_total . '!' . $row->grand_total . '!' . $row->exchange_rate . '!' . $row->billing_address . '!' . $row->shipping_address . '!' . $row->salesgroup->group_name . '!' . $row->paymentTerm->payment_term . '!' . $row->contractdetail->service_group_name . '!' . $row->contact->person_name . '!' . $row->mobile . '!' . $row->email;
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"nittygritty_orderlist.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintQuoteReport() {

        $model = new Quotes();
        $qtn_start_from_date = $_POST['qtn_start_from_date'];
        $qtn_start_to_date = $_POST['qtn_start_to_date'];        
        $qtn_validity_from_date = $_POST['qtn_validity_from_date'];
        $qtn_validity_to_date = $_POST['qtn_validity_to_date'];
        $customer_id = $_POST['customer_id'];
        $leadowner_id = $_POST['leadowner_id'];
        $sales_group = $_POST['sales_group'];        

        $status = $_POST['status'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_quote_list', array('model' => $model, 'qtn_start_from_date' => $qtn_start_from_date, 'qtn_start_to_date' => $qtn_start_to_date,'qtn_validity_from_date' => $qtn_validity_from_date, 'qtn_validity_to_date' => $qtn_validity_to_date, 'customer_id' => $customer_id, 'leadowner_id' => $leadowner_id, 'sales_group' => $sales_group, 'status' => $status, 'title' => $title), false, true);
    }

    public function actionPrintQuoteReportPDF() {

        $model = new Quotes();

        $qtn_start_from_date = Yii::app()->request->getParam('qtn_start_from_date');
        $qtn_start_to_date = Yii::app()->request->getParam('qtn_start_to_date');
        $qtn_close_from_date = Yii::app()->request->getParam('qtn_close_from_date');
        $qtn_close_to_date = Yii::app()->request->getParam('qtn_close_to_date');
        $qtn_delivery_from_date = Yii::app()->request->getParam('qtn_delivery_from_date');
        $qtn_delivery_to_date = Yii::app()->request->getParam('qtn_delivery_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');
        $sales_group = Yii::app()->request->getParam('sales_group');
        $payment_terms = Yii::app()->request->getParam('payment_terms');
        $type_of_contract = Yii::app()->request->getParam('type_of_contract');
        $status = Yii::app()->request->getParam('status');

//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.quote_list', array('model' => $model, 'qtn_start_from_date' => $qtn_start_from_date, 'qtn_start_to_date' => $qtn_start_to_date, 'qtn_close_from_date' => $qtn_close_from_date, 'qtn_close_to_date' => $qtn_close_to_date, 'qtn_delivery_from_date' => $qtn_delivery_from_date, 'qtn_delivery_to_date' => $qtn_delivery_to_date, 'customer_id' => $customer_id, 'leadowner_id' => $leadowner_id, 'sales_group' => $sales_group, 'payment_terms' => $payment_terms, 'type_of_contract' => $type_of_contract, 'status' => $status, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintQuoteExcel() {
        $qtn_start_from_date = Yii::app()->request->getParam('qtn_start_from_date');
        $qtn_start_to_date = Yii::app()->request->getParam('qtn_start_to_date');
        $qtn_close_from_date = Yii::app()->request->getParam('qtn_close_from_date');
        $qtn_close_to_date = Yii::app()->request->getParam('qtn_close_to_date');
        $qtn_delivery_from_date = Yii::app()->request->getParam('qtn_delivery_from_date');
        $qtn_delivery_to_date = Yii::app()->request->getParam('qtn_delivery_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');
        $sales_group = Yii::app()->request->getParam('sales_group');
        $payment_terms = Yii::app()->request->getParam('payment_terms');
        $type_of_contract = Yii::app()->request->getParam('type_of_contract');
        $status = Yii::app()->request->getParam('status');

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($qtn_start_from_date)) {
            $qtn_start_from_date = str_replace('/', '-', $qtn_start_from_date);
            $qtn_start_from_date = date('Y-m-d', strtotime($qtn_start_from_date));
            $criteria->addCondition('t.qtn_start_date>="' . $qtn_start_from_date . '"', 'AND');
        }
        if (!empty($qtn_start_to_date)) {
            $qtn_start_to_date = str_replace('/', '-', $qtn_start_to_date);
            $qtn_start_to_date = date('Y-m-d', strtotime($qtn_start_to_date));
            $criteria->addCondition('t.qtn_start_date<="' . $qtn_start_to_date . '"', 'AND');
        }
        if (!empty($qtn_close_from_date)) {
            $qtn_close_from_date = str_replace('/', '-', $qtn_close_from_date);
            $qtn_close_from_date = date('Y-m-d', strtotime($qtn_close_from_date));
            $criteria->addCondition('t.qtn_close_date>="' . $qtn_close_from_date . '"', 'AND');
        }
        if (!empty($qtn_close_to_date)) {
            $qtn_close_to_date = str_replace('/', '-', $qtn_close_to_date);
            $qtn_close_to_date = date('Y-m-d', strtotime($qtn_close_to_date));
            $criteria->addCondition('t.qtn_close_date<="' . $qtn_close_to_date . '"', 'AND');
        }
        if (!empty($qtn_delivery_from_date)) {
            $qtn_delivery_from_date = str_replace('/', '-', $qtn_delivery_from_date);
            $qtn_delivery_from_date = date('Y-m-d', strtotime($qtn_delivery_from_date));
            $criteria->addCondition('t.qtn_delivery_date>="' . $qtn_delivery_from_date . '"', 'AND');
        }
        if (!empty($qtn_delivery_to_date)) {
            $qtn_delivery_to_date = str_replace('/', '-', $qtn_delivery_to_date);
            $qtn_delivery_to_date = date('Y-m-d', strtotime($qtn_delivery_to_date));
            $criteria->addCondition('t.qtn_delivery_date<="' . $qtn_delivery_to_date . '"', 'AND');
        }
        if (!empty($customer_id))
            $criteria->addCondition('t.customer_id="' . $customer_id . '"', 'AND');
        if (!empty($sales_group))
            $criteria->addCondition('t.sales_group="' . $sales_group . '"', 'AND');
        if (!empty($payment_terms))
            $criteria->addCondition('t.payment_terms="' . $payment_terms . '"', 'AND');
        if (!empty($type_of_contract))
            $criteria->addCondition('t.type_of_contract="' . $type_of_contract . '"', 'AND');
        if (!empty($leadowner_id))
            $criteria->addCondition('file.leadowner_id="' . $leadowner_id . '"', 'AND');
        if (!empty($status))
            $criteria->addCondition('t.status="' . $status . '"', 'AND');

        $quote = Quotes::model()->findAll($criteria);
        $j = 0;

        $list[$j++] = 'No,Enquiry Reference,Company Name,Currency,Grand Total,Exchange Rate,Start Date,Close Date,Delivery Date,Quotation Validity,Quotation Date,Expected Order Date,Billing Address,Shipping Address,Probability,Qtn Close Reason,Type of Contract,Contact Name,Mobile,Email';

        foreach ($quote as $i => $row) {
            if ($row->qtn_start_date != '0000-00-00') {
                $d1 = date("d/m/Y", strtotime($row->qtn_start_date));
            } else {
                $d1 = " ";
            }
            if ($row->qtn_close_date != '0000-00-00') {
                $d2 = date("d/m/Y", strtotime($row->qtn_close_date));
            } else {
                $d2 = " ";
            }
            if ($row->qtn_delivery_date != '0000-00-00') {
                $d3 = date("d/m/Y", strtotime($row->qtn_delivery_date));
            } else {
                $d3 = " ";
            }
            if ($row->qtn_validity != '0000-00-00') {
                $d4 = date("d/m/Y", strtotime($row->qtn_validity));
            } else {
                $d4 = " ";
            }
            if ($row->qtn_date != '0000-00-00') {
                $d5 = date("d/m/Y", strtotime($row->qtn_date));
            } else {
                $d5 = " ";
            }
            if ($row->expected_order_date != '0000-00-00') {
                $d6 = date("d/m/Y", strtotime($row->expected_order_date));
            } else {
                $d6 = " ";
            }

            $list[$j++] = ($i + 1) . ',' . $row->enq_ref . ',' . $row->customer->customer_name . ',' . $row->currencyname->currency_code . ',' . $row->grand_total . ',' . $row->exchange_rate . ',' . $d1 . ',' . $d2 . ',' . $d3 . ',' . $d4 . ',' . $d5 . ',' . $d6 . ',' . $row->billing_address . ',' . $row->shipping_address . ',' . $row->probability->probability . ',' . $row->closereason->reason . ',' . $row->typeofcontract->service_group_name . ',' . $row->customercontact->person_name . ',' . $row->mobile . ',' . $row->email;
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"nittygritty_quotelist.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }
    public function actionPrintInventoryReport() {
            
        $model = new Store();
        $type = $_POST['type'];
        $part_number = $_POST['part_number'];
        $generic_name = $_POST['generic_name'];
         $tax_code = $_POST['tax_code'];
       
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_inventory_list', array('model' => $model, 'type' => $type, 'part_number' => $part_number, 'generic_name' => $generic_name,'tax_code' => $tax_code,'title' => $title), false, true);
    }

    public function actionPrintLeadReport() {

        $model = new Lead();
        $enq_from_date = $_POST['enq_from_date'];
        $enq_to_date = $_POST['enq_to_date'];
        $closing_from_date = $_POST['closing_from_date'];
        $closing_to_date = $_POST['closing_to_date'];
        $customer_id = $_POST['customer_id'];       
        $status = $_POST['status'];
        $lead_owner_id = $_POST['leadowner_id'];
        $sales_group_id = $_POST['sales_group_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_lead_list', array('model' => $model, 'enq_from_date' => $enq_from_date, 'enq_to_date' => $enq_to_date, 'closing_from_date' => $closing_from_date, 'closing_to_date' => $closing_to_date, 'customer_id' => $customer_id, 'status' => $status,'lead_owner_id' => $lead_owner_id,'sales_group_id' => $sales_group_id, 'title' => $title), false, true);
    }

    public function actionPrintLeadReportPDF() {

        $model = new Lead();
        $enq_from_date = Yii::app()->request->getParam('enq_from_date');
        $enq_to_date = Yii::app()->request->getParam('enq_to_date');
        $closing_from_date = Yii::app()->request->getParam('closing_from_date');
        $closing_to_date = Yii::app()->request->getParam('closing_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');       
        $status = Yii::app()->request->getParam('status');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');       
        $sales_group_id = Yii::app()->request->getParam('sales_group_id');

//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.lead_list', array('model' => $model, 'enq_from_date' => $enq_from_date, 'enq_to_date' => $enq_to_date, 'closing_from_date' => $closing_from_date, 'closing_to_date' => $closing_to_date, 'customer_id' => $customer_id, 'status' => $status, 'lead_owner_id' => $lead_owner_id,'sales_group_id' => $sales_group_id,'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }
      public function actionPrintInventoryReportPDF() {

        $model = new InventoryItems();
        $part_number = Yii::app()->request->getParam('part_number');
        $generic_name = Yii::app()->request->getParam('generic_name');
//        $closing_from_date = Yii::app()->request->getParam('closing_from_date');
//        $closing_to_date = Yii::app()->request->getParam('closing_to_date');
//        $customer_id = Yii::app()->request->getParam('customer_id');       
//        $status = Yii::app()->request->getParam('status');
//        $leadowner_id = Yii::app()->request->getParam('leadowner_id');       
//        $sales_group_id = Yii::app()->request->getParam('sales_group_id');

//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inventory_list', array('model' => $model, 'part_number' => $part_number, 'generic_name' => $generic_name, 'status' => $status, 'lead_owner_id' => $lead_owner_id,'sales_group_id' => $sales_group_id,'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintLeadExcel() {
        $enq_from_date = Yii::app()->request->getParam('enq_from_date');
        $enq_to_date = Yii::app()->request->getParam('enq_to_date');
        $closing_from_date = Yii::app()->request->getParam('closing_from_date');
        $closing_to_date = Yii::app()->request->getParam('closing_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');        
        $status = Yii::app()->request->getParam('status');

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($enq_from_date)) {
            $enq_from_date = str_replace('/', '-', $enq_from_date);
            $enq_from_date = date('Y-m-d', strtotime($enq_from_date));
            $criteria->addCondition('t.enq_date>="' . $enq_from_date . '"', 'AND');
        }
        if (!empty($enq_to_date)) {
            $enq_to_date = str_replace('/', '-', $enq_to_date);
            $enq_to_date = date('Y-m-d', strtotime($enq_to_date));
            $criteria->addCondition('t.enq_date<="' . $enq_to_date . '"', 'AND');
        }
        if (!empty($closing_from_date)) {
            $closing_from_date = str_replace('/', '-', $closing_from_date);
            $closing_from_date = date('Y-m-d', strtotime($closing_from_date));
            $criteria->addCondition('t.closing_date>="' . $closing_from_date . '"', 'AND');
        }
        if (!empty($closing_to_date)) {
            $closing_to_date = str_replace('/', '-', $closing_to_date);
            $closing_to_date = date('Y-m-d', strtotime($closing_to_date));
            $criteria->addCondition('t.closing_date<="' . $closing_to_date . '"', 'AND');
        }
        if (!empty($customer_id))
            $criteria->addCondition('t.customer_id="' . $customer_id . '"', 'AND');      
        if (!empty($status))
            $criteria->addCondition('t.status="' . $status . '"', 'AND');

        $lead = Lead::model()->findAll($criteria);
//          echo '<pre>'; print_r($criteria);
        $j = 0;

        $list[$j++] = 'No,Enquiry,Customer Name,Enquiry Date,Closing Date,Contact Name,Mobile,Email,Status';

        foreach ($lead as $i => $row) {
            if ($row->source_type_id == 1)
                $source = "Web";
            else if ($row->source_type_id == 2)
                $source = "Facebook";
            else if ($row->source_type_id == 3)
                $source = "Email";
            else if ($row->source_type_id == 4)
                $source = "Referral From Mouth";

            $list[$j++] = ($i + 1) . ',' . $row->title . ',' . $row->customer->customer_name . ',' . date_format(date_create($row->enq_date), 'd/m/Y') . ',' . date_format(date_create($row->closing_date), 'd/m/Y') . ',' . $row->file->leadowner->first_name . " " . $row->file->leadowner->last_name . ',' . $row->lead_reason . ',' . $row->salesgroup->group_name . ',' . $source . ',' . $row->lead_currency->currency_code . ',' . $row->amount . ',' . $row->probability->probability . ',' . $row->customercontact->person_name . ',' . $row->mobile1 . ',' . $row->email1;
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"nittygritty_leadlist.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintCustomerReport() {

        $model = new Customer_vendor();

        $customer_name = $_POST['customer_name'];

        $country = $_POST['country'];
        $user = $_POST['user'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_customer_list', array('model' => $model, 'customer_name' => $customer_name, 'country' => $country, 'title' => $title,'user'=>$user), false, true);
    }

    public function actionPrintCustomerContactReport() {

        $model = new CustomerContact();

        $customer_name = $_POST['customer_name'];

//        $customer_country = $_POST['customer_country']; ,'customer_name'=>$customer_name,'customer_country'=>$customer_country      



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_customercontact_list', array('model' => $model, 'customer_name' => $customer_name, 'title' => $title), false, true);
    }

    public function actionPrintEnquiryReport() {

        $model = new PurchasingEnquiry();

        $enquiry_start_date = $_POST['enquiry_start_date'];

        $enquiry_end_date = $_POST['enquiry_end_date'];

        $enquiry_status = $_POST['enquiry_status'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_enquiry_list', array('model' => $model, 'enquiry_start_date' => $enquiry_start_date, 'enquiry_end_date' => $enquiry_end_date,
            'enquiry_status' => $enquiry_status, 'title' => $title), false, true);
    }

    public function actionPrintEnquiryReportPDF() {

        $model = new Enquiry();

        $enquiry_start_date = Yii::app()->request->getParam('enquiry_start_date');

        $enquiry_end_date = Yii::app()->request->getParam('enquiry_end_date');

        $enquiry_status = Yii::app()->request->getParam('enquiry_status');

        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.enquiry_list', array('model' => $model, 'enquiry_id' => $enquiry_id, 'enquiry_start_date' => $enquiry_start_date, 'enquiry_end_date' => $enquiry_end_date, 'enquiry_status' => $enquiry_status, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEnquiryExcel() {
        $start_date = Yii::app()->request->getParam('start_date');
        $end_date = Yii::app()->request->getParam('end_date');
        $status = Yii::app()->request->getParam('status');
        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($start_date))
            $criteria->addCondition('t.enquiry_date>="' . $start_date . '"', 'AND');

        if (!empty($end_date))
            $criteria->addCondition('t.closing_date<="' . $end_date . '"', 'AND');

        $enquiry = Enquiry::model()->findAll($criteria);
        $j = 0;
        $list[$j++] = 'No,Enquiry,Customer Name,Contact Name,Mobile,Email,Enquiry Date,Closing Date';

        foreach ($enquiry as $i => $row) {
            $list[$j++] = ($i + 1) . ',' . $row->file_title . ',' . $row->customer->customer_name . ',' . $row->contact->person_name . ',' . $row->mobile_no . ',' . $row->email_id . ',' . date_format(date_create($row->enquiry_date), 'd/m/Y') . ',' . date_format(date_create($row->closing_date), 'd/m/Y');
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"enquiry.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintEnquiryExcelId() {

        $enquiry_id = Yii::app()->request->getParam('enquiry_id');
        $start_date = Yii::app()->request->getParam('start_date');
        $end_date = Yii::app()->request->getParam('end_date');
        $status = Yii::app()->request->getParam('status');
        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;

        if (!empty($enquiry_id))
            $criteria->addCondition('t.id=' . $enquiry_id, 'AND');

        if (!empty($start_date))
            $criteria->addCondition('t.enquiry_date<=' . $start_date, 'AND');

        if (!empty($end_date))
            $criteria->addCondition('t.closing_date>=' . $end_date, 'AND');

        $enquiry = Enquiry::model()->findAll($criteria);
        $j = 0;
        $list[$j++] = 'No,Enquiry,Customer Name,Contact Name,Mobile,Email,Enquiry Date,Closing Date';

        foreach ($enquiry as $i => $row) {
            $list[$j++] = ($i + 1) . ',' . $row->file_title . ',' . $row->customer->customer_name . ',' . $row->contact->person_name . ',' . $row->mobile_no . ',' . $row->email_id . ',' . date_format(date_create($row->enquiry_date), 'd/m/Y') . ',' . date_format(date_create($row->closing_date), 'd/m/Y');
        }
        $j++;

        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"customer_enquiry.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintCustomerContactReportPDF() {
        $model = new CustomerContact();
        $customer_name = Yii::app()->request->getParam('customer_name');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.customercontact_list', array('model' => $model, 'customer_name' => $customer_name, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintCustomerReportPDF() {
        $model = new Customer_vendor();
        $customer_name = Yii::app()->request->getParam('customer_name');
        $country = Yii::app()->request->getParam('country');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.customer_list', array('model' => $model, 'customer_name' => $customer_name, 'country' => $country, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintCustomerExcel() {
        $customer_name = Yii::app()->request->getParam('customer_name');
        $country = Yii::app()->request->getParam('country');
        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;
        if (!empty($customer_name))
            $criteria->addCondition('t.customer_name like "%' . $customer_name . '%"', 'AND');

        if (!empty($country))
            $criteria->addCondition('t.customer_country ="' . $country . '"', 'AND');

        $customer = Customer_vendor::model()->with('country')->findAll($criteria);
        $j = 0;
        $list[$j++] = 'No/Customer Name/Credit Limit/Address/City/Postal Code/State/Country';

        foreach ($customer as $i => $row) {
            $list[$j++] = ($i + 1) . '/' . $row->customer_name . '/' . $row->customer_credit_limit . '/' . $row->customer_address . '/' . $row->customer_city . '/' . $row->customer_postal_code . '/' . $row->customer_state . '/' . $row->country->country_name;
        }

        $j++;

        foreach ($list as $line) {
            fputcsv($file, explode('/', $line));
        }

        fclose($file);

        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"customer.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

   
    public function actionPrintRegistrationInvoiceRequest() {


        $model = new RegistrationInvoice();

        $invoice_no = $_POST['invoice_no'];
        $invoice_start_date = $_POST['invoice_start_date'];
        $invoice_end_date = $_POST['invoice_end_date'];
        $customer_id = $_POST['customer_id'];
        $payment_terms = $_POST['payment_terms'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_registration_invoice_list', array(
            'model' => $model,
            'invoice_no' => $invoice_no,
            'invoice_start_date' => $invoice_start_date,
            'invoice_end_date' => $invoice_end_date,
            'customer_id' => $customer_id,
            'payment_terms' => $payment_terms,
            'title' => $title), false, true);
    }

    public function actionPrinRegistrationInvoiceReportPDF() {

        $model = new RegistrationInvoice();

        $invoice_no = Yii::app()->request->getParam('invoice_no');
        $invoice_start_date = Yii::app()->request->getParam('invoice_start_date');
        $invoice_end_date = Yii::app()->request->getParam('invoice_end_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $payment_terms = Yii::app()->request->getParam('payment_terms');


        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.material_registration_invoice_list', array('model' => $model,
                    'invoice_no' => $invoice_no,
                    'invoice_start_date' => $invoice_start_date,
                    'invoice_end_date' => $invoice_end_date,
                    'customer_id' => $customer_id,
                    'payment_terms' => $payment_terms,
                    'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintMaterialRegistrationInvoiceExcel() {
        $customer_id = Yii::app()->request->getParam('customer_id');
        $invoice_start_date = Yii::app()->request->getParam('invoice_start_date');
        $invoice_end_date = Yii::app()->request->getParam('invoice_end_date');
        $invoice_no = Yii::app()->request->getParam('invoice_no');
        $payment_terms = Yii::app()->request->getParam('payment_terms');

        $file = fopen("uploads/csvs/test.csv", "w");

        $condition = '1=1';
        if ($customer_id != '') {
            $condition .= ' AND t.customer_id ="' . $customer_id . '"';
        }
        if ($invoice_start_date != '') {
            $invoice_start_date = str_replace('/', '-', $invoice_start_date);
            $invoice_start_date = date('Y-m-d', strtotime($invoice_start_date));
            $condition .= ' AND t.invoice_date >="' . $invoice_start_date . '"';
        }
        if ($invoice_end_date != '') {
            $invoice_end_date = str_replace('/', '-', $invoice_end_date);
            $invoice_end_date = date('Y-m-d', strtotime($invoice_end_date));
            $condition .= ' AND t.invoice_date <="' . $invoice_end_date . '"';
        }
        if ($invoice_no != '') {
            $condition .= ' AND t.file_id ="' . $invoice_no . '"';
        }
        if ($payment_terms != '') {
            $condition .= ' AND t.payment_terms ="' . $payment_terms . '"';
        }


        $model_registration_invoice = RegistrationInvoice::model()->findAll(array('condition' => $condition));

        $j = 0;
        $list[$j++] = 'No,File No,Customer Name,Invoice Date,Payment Term,Grand Total';

        foreach ($model_registration_invoice as $i => $row) {
            $list[$j++] = ($i + 1) . ',' . $row->file_id . ',' . $row->customers->customer_name . ',' . $row->invoice_date . ',' . $row->paymentname->payment_term . ',' . $row->grand_total;
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"material_Registration_Invoice.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

   public function actionSetMenu() {
        echo Yii::app()->session['selected_menu'] = $_POST['menu_name'];
    }


}
