<?php
class AdminledgerController extends Controller
{
    public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','UpdateStockLedger'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    
    public function filters()
    {
        return array(
        'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }
    public function actionclearall(){
        $SQL="Update erp_stock_ledger SET transaction_cost_rate=0,updated_cost_rate=0;";
        $sales_price= Yii::app()->db->createCommand($SQL)->execute();
        echo 'Success';
    }
    public function actionUpdateStockLedger(){
        $model = new StockLedger();
        $SQL="Select DISTINCT(product_id) AS product_id FROM erp_stock_ledger 
        where product_id = 1640
        ORDER By id asc";//  where file_id =22234          
        $arr_products= Yii::app()->db->createCommand($SQL)->queryAll();
	    foreach($arr_products as $eachitem){
	        $model->UpdateExistingStockLedger($eachitem['product_id']);
	    }
	    echo 'Success';
    }
    
}