<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'paymentmode-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<ul class="clearfix form-ul material">
    <li class="col-sm-3">
        <?php
        echo $form->hiddenfield($model, 'id', array());
        echo $form->textfield($model, 'mode', array('class' => 'tooltipster', 'data-label' => 'Mode <span style="color:red">*</span>',));
        ?>
    </li>

    <li class="col-sm-1">

        <?php
        if ($model->id > 0) {
            echo $form->textfield($model, 'code', array('class' => 'tooltipster', 'data-label' => 'Code', 'readonly' => true));
        } else {
            echo $form->textfield($model, 'code', array('class' => 'tooltipster', 'data-label' => 'Code'));
        }
        ?>
    </li>

    <li class="col-sm-4">
        <?php
        if ($model->ledger_id > 0) {
            $ledger = new AccLedger();
            $ledger = $ledger->findBypk($model->ledger_id);
            $model->ledger_name = $ledger['ledger_acc_name'];
        }
        ?>
        <?php
        echo $form->hiddenfield($model, 'ledger_id', array());
        echo $form->textfield($model, 'ledger_name', array('class' => 'tooltipster', 'placeholder' => 'Type & Select', 'data-label' => 'Ledger <span style="color:red">*</span>', 'onKeyup' => 'js:autoCompleteLedger(this.id,"AccPaymentMode");'));
        ?>

    </li>
    <li class="col-sm-4">
        <?php echo $form->dropDownList($model, 'isActive', ["Y" => "Yes", "N" => "No"], array('class' => 'tooltipster', 'data-label' => 'Is active')); ?>
    </li>
    <li class="col-sm-4" style="display:none;">
        <?php
        if ($model->subledger_id > 0) {
            $AccSubledger = new AccSubledger();
            $AccSubledger = $AccSubledger->findBypk($model->subledger_id);
            $model->subledger_name = $AccSubledger['subledger_name'];
        }
        ?>
        <?php
        echo $form->hiddenfield($model, 'subledger_id', array());
        echo $form->textfield($model, 'subledger_name', array('class' => 'tooltipster', 'placeholder' => 'Type & Select', 'data-label' => 'Sub Ledger <span style="color:red">*</span>', 'onKeyup' => 'js:autoCompletesubLedger(this.id,"AccPaymentMode");'));
        ?>

    </li>
  
    <li class="col-sm-4" style="display: none;">
        <?php echo $form->textfield($model, 'sort_order', array('class' => 'tooltipster', 'data-label' => 'Sort Order')); ?>
    </li>
    <li class="col-sm-4" style="display: none;">
        <?php echo $form->dropDownList($model, 'show_in_pos', ["Y" => "Yes", "N" => "No"], array('class' => 'tooltipster', 'data-label' => 'Show in POS')); ?>
    </li>
   
    <li class="col-sm-2">
        <?php echo $form->checkbox($model, 'bank_name', array('class' => 'tooltipster', 'data-label' => 'Bank Name', 'checked' => $checked, 'value' => 'Y', 'uncheckValue' => 'N')); ?>

    </li>

    <li class="col-sm-2">
        <?php echo $form->checkbox($model, 'card_no', array('class' => 'tooltipster', 'data-label' => 'Card No', 'checked' => $checked, 'value' => 'Y', 'uncheckValue' => 'N')); ?>

    </li>
    <li class="col-sm-2">
        <?php echo $form->checkbox($model, 'cheque_no', array('class' => 'tooltipster', 'data-label' => 'Cheque No', 'checked' => $checked, 'value' => 'Y', 'uncheckValue' => 'N')); ?>

    </li>
    <li class="col-sm-2">
        <?php echo $form->checkbox($model, 'cheque_date', array('class' => 'tooltipster', 'data-label' => 'Cheque Date', 'checked' => $checked, 'value' => 'Y', 'uncheckValue' => 'N')); ?>

    </li>

    <li class="col-sm-2">
        <?php echo $form->checkbox($model, 'reference_no', array('class' => 'tooltipster', 'data-label' => 'Reference No', 'checked' => $checked, 'value' => 'Y', 'uncheckValue' => 'N')); ?>

    </li>
    
        <li class="col-sm-2">
        <?php echo $form->checkbox($model, 'discount', array('class' => 'tooltipster', 'data-label' => 'Discount', 'checked' => $checked, 'value' => 'Y', 'uncheckValue' => 'N')); ?>

    </li>

</ul>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="cust_close" data-dismiss="modal">Close</button>
    <?php
    echo CHtml::ajaxSubmitButton('Save', Yii::app()->createUrl('accounts/paymentmode/Save'), array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                            $("#loader").hide();
                            $("#paymentmode-form .paymentmode-btn").prop("disabled", false);
                            $("#paymentmode-form .paymentmode-btn").addClass("btn-theme").removeClass("btn_loding");
                            if(data.status=="success"){
                                t8.success("Saved Successfully!");
                                $(".x.close").click();
                                reloadTable("#acc_payment_mode");
                            }else{
                                $.each(data, function(key, val) {
                                    t8.error(""+val+"");
                                });
                            }
                        }',
        'beforeSend' => 'function(){
                            $("#loader").show();
                               $("#paymentmode-form .ledger-btn").prop("disabled", true);
                               $("#paymentmode-form .ledger-btn").addClass("btn_loding").removeClass("btn-theme");
                        }',
            ), array('id' => 'mybtn' . rand(), 'class' => 'paymentmode-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("checkquotesitem", " function checkquotesitem(field_id) {
    alert('innn');
    $('#ckbCheckAll').prop('checked',false);
    }", CClientScript::POS_HEAD);

$cs->registerScript("autoCompletesubLedger", "function autoCompletesubLedger(field_id,frm)
        {

          var  account_id = $('#AccPaymentMode_ledger_id').val();
            if( account_id > 0 ){
            var url = '" . Yii::app()->createUrl('accounts/voucher/subledgerlist') . "&ledger='+account_id;


                $('#'+field_id).autocomplete({

                    minLength   : 1,

                    source      : function (request, response) { autoCompleteSource(request, response,url) },

                    focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},

                    select          : function( event, ui ) {

                        event.preventDefault();
                        trigger_target_id  	=   $(event.target).attr('id');
                        var ledger_id=ui.item.value;
                        $('#AccPaymentMode_subledger_name').val(ui.item.label);
                        $('#AccPaymentMode_subledger_id').val(ui.item.value);
                        var subledger=ui.item.value;


                    }

                });

            }else{
                t8.error('Choose Ledger First!');
                $('#AccPaymentMode_subledger_name').val('');
                return false;
            }

                }", CClientScript::POS_HEAD);

$cs->registerScript("autoCompleteLedger", "function autoCompleteLedger(field_id,frm)

        {

            var ledger_id =  $('#AccPaymentMode_ledger_id').val('');
             if(ledger_id!==''){

                var url = '" . Yii::app()->createUrl('accounts/accounts/GetLedgerDetails') . "'+'&ledger_id='+ledger_id+'&frm='+frm;
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response,url) },
                    focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
                    select          : function( event, ui ) {
                        event.preventDefault();
                        trigger_target_id  	=   $(event.target).attr('id');
                        var ledger_id=ui.item.value;
                        var have_subledger= ui.item.have_subledger;
                        var subledger_types=ui.item.subledger_types;

                        $('#AccPaymentMode_ledger_id').val(ledger_id);

                        if(ledger_id > 0){


                            jQuery.ajax({
                               'type': 'post',
                               'dataType': 'json',
                               'url': '" . Yii::app()->createUrl('accounts/accounts/GetsubledgerdropNew') . "',
                               'data': {'ledger_id' : ledger_id},
                               'cache': false,
                               'success': function(data) {
                                $('#subledger').html(data.drop);
                                return false;
                               }
                            });


                        }

                    }
                })
            }


                }", CClientScript::POS_HEAD);
?>