<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadtodolist", '
    function filterDataTable() {
        var table_id ="#tbl_todolist";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('todolist/GetList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
	  $(document).ready(function() {  	
  	  		
      filterDataTable();
    })
	
', CClientScript::POS_HEAD);
?>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-tasks"></i> Todo List
            <div class="pull-right">	
                <?php if (Yii::app()->user->authorised_user == 1) { ?>
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('todolist/create','Add Task','xl')"><i class="fa fa-plus"></i> ADD</button> 
                <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_todolist">
                    <thead>
                        <tr>
                            <th>No</th>  
                            <th>User</th>
                            <th>Date</th>
                            <th>Start Time</th>
                            <th>End Time</th>    
                            <th>Activity</th>   
                            <th>Status</th>   
                            <th>Actions</th>  
                        </tr>
                    </thead>
                    <tfoot>
                            <th>No</th>  
                            <th>User</th>
                            <th>Date</th>
                            <th>Start Time</th>
                            <th>End Time</th>    
                            <th>Activity</th>   
                            <th>Status</th>   
                            <th>Actions</th>   
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
