<?php
$cs = Yii::app()->getClientScript();

$baseUrl = Yii::app()->baseUrl;

$form = $this->beginWidget('CActiveForm', array(
    'id' => 'excel-upload-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>

<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-user"></i> Upload Day Book            
    </header>
    <div class="panel-body">

        <div class="row">
            <ul class="clearfix form-ul material">
                <li class="col-sm-6">
                    <input type="hidden" id="UploadDayBook_uploadfile" name="UploadDayBook[uploadfile]" />
                    <label >DayBook Excel</label>
                    <?php
                    $allowedExtensions = array("csv");
                    $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                        'id' => rand(),
                        'config' => array(
                            'action' => Yii::app()->createUrl(Yii::app()->controller->id . '/UploadInventoryFile', array('folder' => 'upload/daybook')),
                            'multiple' => false,
                            'allowedExtensions' => $allowedExtensions,
                            'sizeLimit' => 8 * 1024 * 1024,
                            'onStart' => "js:function(){}",
                            'class' => 'pull-right',
                            'onComplete' => "js:function(id, fileName, responseJSON){
                                 $('#UploadDayBook_uploadfile').val(responseJSON.filename);
                                $('.qq-upload-list').html(responseJSON.filename);
                            }",
                    )));
                    ?>


                    <div class="icon_images">
                        <input type="hidden" id="uploadfile" />

                    </div>
<?php //echo CHtml::hiddenField('update_customer_price',''); ?>
                </li>

                <li class="col-sm-6">
                    <?php echo CHtml::link("<i class='fa fa-download'></i> Download Format", Yii::app()->createUrl('tempupload/downloadformat'),array('class'=>'btn btn-link'));  ?>
                </li>
                <li class="col-sm-2">
                    <div  id="csv_msg">
                    </div>
                </li>
            </ul>
        </div>

        <div class="modal-footer">
<?php
$url = Yii::app()->createUrl('Tempupload/SaveDayBookUpload');
echo CHtml::ajaxSubmitButton('Save', $url, array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
        var id= data.id;
        if(data.status=="success"){  
            t8.success("Day Book Uploaded Successfully");                           
        } else if (data.status == "error") {
              if(data.link!=""){
                  $("#csv_msg").html(data.link);
              }
        }else { 
            $.each(data, function(key, val) {
                $("#excel-upload-form #"+key+"_em_").text(val).show(); 
                t8.error(""+val+""); 
            }); 
        } 
    }',
    'beforeSend' => 'function(){
        $("#excel-upload-form .excel-save-btn").prop("disabled", true);                                
        $("#excel-upload-form .excel-save-btn").removeClass("btn-theme").addClass("btn_loding");

        var file         = $("#UploadDayBook_uploadfile").val();
        if(file==""){
            t8.error("Please Upload a csv file"); 
            return false;
        }

       $(".toast8-error").hide();
    }',
    'complete' => 'function(){
        $("#excel-upload-form .excel-save-btn").prop("disabled", false);                                
        $("#excel-upload-form .excel-save-btn").addClass("btn-theme").removeClass("btn_loding");                        
    }'
        ), array('id' => 'mybtn' . rand(), 'class' => 'excel-save-btn btn btn-theme'));
?>
            <?php //} ?>   
        </div>
    </div></section>

            <?php $this->endWidget(); ?>