<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-arrows-h"></i> Change Rack and Bin
    </header>
    <div class="panel-body">
        <div class="tab-content">
            <div class="tab-pane active">
                    <ul class="clearfix form-ul material">
                        <li class="col-sm-2 m-select">            
                            <?php echo CHtml::dropDownList('hiring_warehouse_id', '', MasInventoryWarehouse::getHiringWarehouse(), array('class' => 'tooltipster', 'data-label' => 'Warehouse <span style="color : red;">*</span>', 'data-search' => 'true')); ?>            
                        </li>
                        <li class="col-sm-4">
                            <?php echo CHtml::textField('hiring_product_name', '', array('class' => 'tooltipster', 'placeholder' => 'Please choose a product', 'data-label' => 'Part No <span style="color : red;">*</span>', 'onKeyup' => 'js:autoCompleteProduct(this.id);')); ?>
                            <?php echo CHtml::hiddenField('hiring_product_id'); ?>
                            <?php echo CHtml::hiddenField('total_qty'); ?>
                            <?php echo CHtml::hiddenField('hiring_have_serial_no'); ?>
                        </li>
                        <li class="col-sm-2 m-select">            
                            <?php echo CHtml::dropDownList('hiring_rack_id', '', MasInvRack::getRacks(), array('class' => 'tooltipster', 'data-label' => 'Rack', 'data-search' => 'true', 'empty' => 'Select','onchange'=>'getbindetails(this.value);')); ?>            
                        </li>
                        <li class="col-sm-2" id="div_hiring_bin_id">            
                            <?php echo CHtml::dropDownList('hiring_bin_id', '', array(), array('class' => 'tooltipster', 'data-label' => 'Bin', 'data-search' => 'true', 'empty' => 'Select')); ?>            
                        </li>
                        <li class="col-sm-2">      
                            <input type="button" value="Search" onclick="loadProductDetails();return false;" class='btn btn-theme' id="rack_bin_btn"/>
                        </li>
                    </ul>
                    <div id="div_hiring_stock_detail"></div>
            </div>
        </div>
    </div>
</section>                
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompleteProduct", "function autoCompleteProduct(field_id){        
	var url = '" . Yii::app()->createUrl('storageswap/GetProduct') . "';
        $('#'+field_id).autocomplete({
            minLength   : 1,
            source      : function (request, response) { autoCompleteSource(request, response,url) },
            focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
            select          : function( event, ui ) {
                event.preventDefault();
                trigger_target_id  	=   $(event.target).attr('id');
                var part_num=ui.item.product_id;
                $('#hiring_product_id').val(part_num);
                $('#hiring_have_serial_no').val(ui.item.serialno);
            }
        });
}", CClientScript::POS_HEAD);
$cs->registerScript("getbindetails", "function getbindetails(rack_id){
    jQuery.ajax({
        'data' :{'rack_id':rack_id},
        'dataType' : 'json',
        'type':'post',
        'url': '" . Yii::app()->createUrl('storageswap/getbindetails') . "',
        'success': function(data) {
          $('#div_hiring_bin_id').html(data.bindetails); 
        }
    });
}", CClientScript::POS_HEAD);
$cs->registerScript("loadProductDetails", "function loadProductDetails(){
        var warehouse_id = $('#hiring_warehouse_id').val();
        var product_id = $('#hiring_product_id').val();        
        var rack_id    = $('#hiring_rack_id').val(); 
        var bin_id     = $('#hiring_bin_id').val();
        var serialno  = $('#hiring_have_serial_no').val();  
        $('#div_hiring_stock_detail').html('');
        if(warehouse_id!='' & product_id!=''){
            var pars = 'warehouse_id='+warehouse_id+'&product_id='+product_id+'&rack_id='+rack_id+'&bin_id='+bin_id+'&serialno='+serialno;            
            jQuery.ajax({
                'type': 'post',
                'data': pars,
                'url': '" . Yii::app()->createUrl('storageswap/fetchproductdetails') . "',
                'cache': false,
                'success': function(data){
                    $('#loader').hide();
                    $('#div_hiring_stock_detail').html(data);
                    $('#total_qty').val(data.total_qty);                 
                },
                'beforeSend': function(data){               
                    $('#loader').show();
                },
                'complete': function(data){              
                    $('#loader').hide();
                },
            });
        }
        else{
            t8.error('Please fill all mandatory fields');
            $('#div_hiring_stock_detail').html('');
            $('#total_qty').val('0'); 
        }
}", CClientScript::POS_HEAD);

?>    