<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("loadMismatchList", '
        $(document).ready(function() {

        var table_id ="#tbl_stock_mismatch_details";        
        var table = $(table_id).DataTable({
            scrollY         : "380px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('stockmismatch/stockdifferencelist') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
    ?>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-users"></i> STOCK DIFFERENCE LIST
            <div class="pull-right">
                <!--button class="btn btn-sm btn-theme" onclick="loadPopupModal('masinvoicetype/create','Add New Invoice Type','lg')"><i class="fa fa-plus"></i> ADD</button-->
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_stock_mismatch_details">
                    <thead>
                        <tr>
                             <th>No</th>
                            <th>Stock Id</th>
                            <th>Part Number</th>
                            <th>Description</th>
                            <th>Total Qty</th>
                            <th>Opening Balance</th>
                            <th>In Qty</th>
                            <th>Out Qty</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
