<?php

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

?>
<script>
    $(document).ready(function() {
        var table_id = "#tbl_restock_details";
        var table = $(table_id).on("preXhr.dt", function(e, settings, data) {
            data.warehouse_id = $("#warehouse_id").val();
            data.brand_id = $("#brand_id").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
             columns: [{
                    className: "nw sl col-max-1"
                },
                {
                    className: "nw sl col-max-1"
                },
                {
                    className: "nw sl col-max-3"
                },

                {
                    className: "nw sl col-max-1 "
                },
                {
                    className: "nw sl col-max-1 "
                },
              
                {
                    className: "nw sl col-max-1 text-right"
                },
                
            ],
            
            
            order: [
                [1, "ASC"]
            ],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('stockReorderLevel/GetList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function(nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
                if (aData[6].status == "N") {
                    $("td", nRow).addClass("bg-danger");
                }
            }
        });
    });

    function AddContextMenu(row, datas) {
        var mas_edit = 0;
        var mas_disable = 0;
        <?php if (isset(Yii::app()->user->havePermissionOn['mas_stock_reorder_level_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_edit = 1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['mas_stock_reorder_level_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_disable = 1;
        <?php } ?>
        $(row).contextMenu({
            selector: 'td',
            items: {
                "edit": {

                    name: "Edit",
                    icon: "edit",
                    accesskey: "e",
                    callback: function() {

                        loadPopupModal("stockReorderLevel/create&warehouse_id=" + datas[6].warehouse_id + "&product_id=" + datas[6].product_id, "Product - " + datas[6].part_number, "xs");


                    },
                    disabled: function(key, opt) {
                        // this references the trigger element
                        if (mas_edit == '0') {
                            return !this.data('editDisabled');
                        }
                    }
                },
                /*  "Disable_Enable":{
                          name: (datas[6].status == "Y") ?"Disable" : "Enable",
                                  icon: "edit",
                                  accesskey: "d",
                                  callback: function () {
                                  Disable(datas[6].warehouse_id,datas[6].product_id,datas[6].status);
                                  },
                      disabled: function(key, opt) { 
                              // this references the trigger element
                              if(mas_disable=='0'){
                                  return !this.data('Disable_EnableDisabled'); 
                              }
                      }
                  }*/

            }
        });
    }
</script>

<script>
    function Search() {
        reloadTable($("#tbl_restock_details"));
    }
</script>


<script>
    function Disable(warehouse_id, product_id, status) {
        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true) {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'warehouse_id=' + warehouse_id + "&product_id=" + product_id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=stockReorderLevel/Disable',
                'cache': false,
                'success': function(data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_restock_details').DataTable().ajax.reload()
                        t8.success(' Success!');
                    }
                }
            });
        }


    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-university"></i> Stock Reorder Level


        <div class="top_controls_select col-sm-8 pull-right">

            <div class="col-sm-3 pull-right">
                <?php echo CHtml::dropdownList('brand_id', '0', ProductClass::getAllProductClass(), array('class' => 'form-control', 'onChange' => 'reloadTable("#tbl_restock_details")', 'prompt' => '-All Brands-')); ?>
            </div>

            <div class="col-sm-2 pull-right">

                <?php
                if (Yii::app()->user->authorised_user  == 1 || ((int) Yii::app()->user->havePermissionOn["show_warehouse_all"])) {
                    $barray = array('class' => 'form-control', 'data-label' => 'Warehouse', 'prompt' => 'All Warehouse', 'onChange' => 'reloadTable("#tbl_restock_details")', 'data-search' => 'true');
                    $arr_warehouse = MasInventoryWarehouse::getWarehouse();
                } else {
                    $barray = array('class' => 'form-control', 'data-label' => 'Warehouse', 'onChange' => 'reloadTable("#tbl_restock_details")');
                    $arr_warehouse = MasInventoryWarehouse::getUserWarehousees();
                }
                echo CHtml::dropdownlist('warehouse_id', '', $arr_warehouse, $barray);
                ?>

            </div>

        </div>






        <div class="pull-right">
            <!--<?php if (isset(Yii::app()->user->havePermissionOn['mas_stock_reorder_level_add']) || Yii::app()->user->authorised_user == 1) { ?>-->

            <!--    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('stockReorderLevel/create', 'Add Stock Reorder Level', 'lg')"><i class="fa fa-plus"></i> ADD</button>-->

            <!--<?php } ?></div>-->


    </header>
    <div class="panel-body">
        <div class="custom-data-table">



            <table class="table table-hover table-bordered personal-task" id="tbl_restock_details" style="font-size:13px;">
                <thead>



                    <tr>
                        <th>No</th>
                        <th>Part No</th>
                        <th>Description</th>
                        <th>Warehouse</th>
                        <th>Brand</th>
                    
                        <th>Reorder Level</th>

                    </tr>
                </thead>
                <tfoot>
                   <tr>
                        <th>No</th>
                        <th>Part No</th>
                        <th>Description</th>
                        <th>Warehouse</th>
                        <th>Brand</th>
                     
                        <th>Reorder Level</th>

                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>
<?php

$cs = Yii::app()->getClientScript();



$cs->registerScript('DeleteAllFiles', 'function DeleteAllFiles(){ 

    var r = confirm("Are you sure to Delete All Files From App PDF Folder?");
   
    if(r==true)
    {

           $("#loader").show();
        jQuery.ajax({
        //    "data" : "phase_id="+phase_id+"&project_id="+project_id,
           "dataType" : "json",
           "type"  : "post",
           "url": "' . Yii::app()->createUrl('country/DeleteAllFiles') . '",
           "success":function(data){
            if(data.status=="success"){
              
                
                t8.success("Success");
                $("#loader").hide();
            }else{
                t8.error("Failed");
                $("#loader").hide();
            }
            // $("#loader").hide();
            // $("#pinfo_close").click();        
        },           
        });
     
 }
 
};', CClientScript::POS_HEAD);

?>