<?php 
$from_date= str_replace('/', '-',$from_date);
$from_date= date("Y-m-d", strtotime($from_date));
$to_date= str_replace('/', '-',$to_date);
$to_date= date("Y-m-d", strtotime($to_date));
//$current_date="2021-02-23";

$modelQuotes=Quotes::model()->with('customer')->findAll(array('condition'=>'qtn_start_date >= "'.$from_date.'" AND qtn_start_date <= "'.$to_date.'"','order'=>'customer_name'));
?>
<div class="popup_inner_element">
         <table class="table table-hover table-bordered personal-task">
            <thead>
                 <tr>
                    <th width="5%">S.No</th>
                    <th width="45%">Customer</th> 
                    <th width="15%">Lead Owner</th>  
                    <th width="15%">Created By</th> 
                    <th width="20%" class="text-right">Amount</th>
                </tr>
            </thead>
            <tbody>
            
            <?php
            
            
            if(!empty($modelQuotes)){
                $total_Quotes_value = 0;
                $i=0;
                $str_customer_id="";
                $customer_total=0;
                foreach ($modelQuotes as $eachItem) {
                    $total_amount = $eachItem['grand_total'] * $eachItem['exchange_rate'];
                    
                    
                    
                    if ($str_customer_id!=$eachItem['customer_id']){
                        if($str_customer_id!=""){
                         ?>
                       <tr>
                             <td class="text-right" colspan="4"><b>Total</b></td>
                            <td class="text-right"><b>AED <?php echo Yii::app()->numberFormatter->formatCurrency($customer_total,''); ?></b></td>
                        </tr>    
                       <?php
                        }
                       $customer_total=0;
                         $str_customer_id = $eachItem['customer_id'];
                    }
                    else{
                      
                    }
                    $customer_total+=$total_amount;
                    ?>
                        <tr>
                            <td><?php echo ($i+1); ?></td>
                            <td class="text-left"><?php echo $eachItem['customer']['customer_name']; ?></td>
                            <td class="text-left"><?php echo $eachItem['leadowner']['first_name']." ".$eachItem['leadowner']['last_name']; ?></td>
                            <td class="text-left"><?php echo $eachItem['createdby']['first_name']." ".$eachItem['createdby']['last_name']; ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_amount,""); ?></td>
                        </tr>
                    <?php
                    $total_Quotes_value+=$total_amount;
                    $i++;   
                }
                ?>
                    <tr style="background-color:#ddd;">
                        <td class="text-right" colspan="4"><b>Total Amount</b></td>
                        <td class="text-right"><b>AED <?php echo Yii::app()->numberFormatter->formatCurrency($total_Quotes_value,''); ?></b></td>
                    </tr>
                <?php
            }
            else{
                ?>
                    <tr>
                        <td colspan="5" class="text-center">No data found</td>
                    </tr>
                <?php
            }
            
            ?>
           
        </table>
    </div>