<?php 
$from_date= str_replace('/', '-',$from_date);
$from_date= date("Y-m-d", strtotime($from_date));
$to_date= str_replace('/', '-',$to_date);
$to_date= date("Y-m-d", strtotime($to_date));
//$current_date="2021-02-23";

$modelSalesInvoice=Invoice::model()->with('customer')->findAll(array('condition'=>'invoice_date >= "'.$from_date.'" AND invoice_date <= "'.$to_date.'"','order'=>'customer.customer_name'));
$modelCreditNote=Creditnote::model()->with('customer')->findAll(array('condition'=>'credited_date >= "'.$from_date.'" AND credited_date <= "'.$to_date.'"','order'=>'customer.customer_name'));
?>
<div class="popup_inner_element">
     <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-list"></i> Invoices

    </header>
    <br/>
        <table class="table table-hover table-bordered personal-task">
            <thead>
                 <tr>
                    <th width="5%">S.No</th>
                    <th width="45%">Customer</th> 
                    <th width="15%">Lead Owner</th>  
                    <th width="15%">Created By</th> 
                    <th width="20%" class="text-right">Amount</th>
                </tr>
            </thead>
            <tbody>
            
            <?php
            
            
            if(!empty($modelSalesInvoice)){
                $total_invoice_value = 0;
                $i=0;
                $str_customer_id="";
                $customer_total=0;
                foreach ($modelSalesInvoice as $eachItem) {
                    $total_amount = $eachItem['grand_total'] * $eachItem['exchange_rate'];
                    
                    
                    
                    if ($str_customer_id!=$eachItem['customer_id']){
                        if($str_customer_id!=""){
                         ?>
                       <tr>
                             <td class="text-right" colspan="4"><b>Total</b></td>
                            <td class="text-right"><b>AED <?php echo Yii::app()->numberFormatter->formatCurrency($customer_total,''); ?></b></td>
                        </tr>    
                       <?php
                        }
                       $customer_total=0;
                         $str_customer_id = $eachItem['customer_id'];
                    }
                    else{
                      
                    }
                    $customer_total+=$total_amount;
                    ?>
                        <tr>
                            <td><?php echo ($i+1); ?></td>
                            <td class="text-left"><?php echo $eachItem['customer']['customer_name']; ?></td>
                            <td class="text-left"><?php echo $eachItem['leadowner']['first_name']." ".$eachItem['leadowner']['last_name']; ?></td>
                            <td class="text-left"><?php echo $eachItem['createdby']['first_name']." ".$eachItem['createdby']['last_name']; ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_amount,""); ?></td>
                        </tr>
                    <?php
                    $total_invoice_value+=$total_amount;
                    $i++;   
                }
                ?>
                    <tr>
                        <td class="text-right" colspan="4"><b>Total Amount</b></td>
                        <td class="text-right"><b>AED <?php echo Yii::app()->numberFormatter->formatCurrency($total_invoice_value,''); ?></b></td>
                    </tr>
                <?php
            }
            else{
                ?>
                    <tr>
                        <td colspan="5" class="text-center">No data found</td>
                    </tr>
                <?php
            }
            
            ?>
            </tbody>
        </table>
        
        <br/>
         <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-list"></i>  Returns

    </header>
         <table class="table table-hover table-bordered personal-task">
            <thead>
                <tr>
                    <th>S.No</th>
                    <th>Customer</th> 
                    <th class="text-right">Amount</th>
                </tr>
            </thead>
            <tbody>
            
            <?php
            
            
            if(!empty($modelCreditNote)){
                $total_credited_value = 0;
                $i=0;
                $str_credited_customer_id="";
                $credit_customer_total=0;
                foreach ($modelCreditNote as $eachItem) {
                    $total_credited_amount = $eachItem['credited_amount'] * $eachItem['exchange_rate'];
                    
                    
                    
                    if ($str_credited_customer_id!=$eachItem['customer_id']){
                        if($str_customer_id!=""){
                         ?>
                       <tr>
                             <td class="text-right" colspan="2"><b>Total</b></td>
                            <td class="text-right"><b>AED <?php echo Yii::app()->numberFormatter->formatCurrency($credit_customer_total,''); ?></b></td>
                        </tr>    
                       <?php
                        }
                       $credit_customer_total=0;
                         $str_credited_customer_id = $eachItem['customer_id'];
                    }
                    else{
                      
                    }
                    $credit_customer_total+=$total_credited_amount;
                    ?>
                        <tr>
                            <td><?php echo ($i+1); ?></td>
                            <td class="text-left"><?php echo $eachItem['customer']['customer_name']; ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_credited_amount,""); ?></td>
                        </tr>
                    <?php
                    $total_credited_value+=$total_credited_amount;
                    $i++;   
                }
                ?>
                    <tr>
                        <td class="text-right" colspan="2"><b>Total Amount</b></td>
                        <td class="text-right"><b>AED <?php echo Yii::app()->numberFormatter->formatCurrency($total_credited_value,''); ?></b></td>
                    </tr>
                <?php
            }
            else{
                ?>
                    <tr>
                        <td colspan="3" class="text-center">No data found</td>
                    </tr>
                <?php
            }
            
            ?>
              <tr>
                        <td class="text-right" colspan="2"><b>Total Amount(Invoice - Return)</b></td>
                        <td class="text-right"><b>AED <?php echo Yii::app()->numberFormatter->formatCurrency($total_invoice_value - $total_credited_value ,''); ?></b></td>
                    </tr>
            </tbody>
            </tbody>
        </table>
    </div>