<?php 
$from_date= str_replace('/', '-',$from_date);
$from_date= date("Y-m-d", strtotime($from_date));
$to_date= str_replace('/', '-',$to_date);
$to_date= date("Y-m-d", strtotime($to_date));
//$current_date="2021-02-23";

$modelPurchaseInvoice=PurchasingInvoice::model()->with('vendor')->findAll(array('condition'=>'invoice_date >= "'.$from_date.'" AND invoice_date <= "'.$to_date.'"','order'=>'vendor.vendor_name'));
$modelPurchaseDebitNote=Purchasingdebitnote::model()->with('vendor')->findAll(array('condition'=>'debited_date >= "'.$from_date.'" AND debited_date <= "'.$to_date.'"','order'=>'vendor.vendor_name'));
?>
<div class="popup_inner_element">
     <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-list"></i> Purchase Invoices

    </header>
    <br/>
        <table class="table table-hover table-bordered personal-task">
            <thead>
                <tr>
                    <th>S.No</th>
                    <th>Supplier</th> 
                    <th class="text-right">Amount</th>
                </tr>
            </thead>
            <tbody>
            
            <?php
            
            
            if(!empty($modelPurchaseInvoice)){
                $total_invoice_value = 0;
                $i=0;
                $str_vendor_id="";
                $vendor_total=0;
                foreach ($modelPurchaseInvoice as $eachItem) {
                    $total_amount = $eachItem['grand_total'] * $eachItem['exchange_rate'];
                    
                    
                    
                    if ($str_vendor_id!=$eachItem['vendor_id']){
                        if($str_vendor_id!=""){
                         ?>
                       <tr>
                             <td class="text-right" colspan="2"><b>Total</b></td>
                            <td class="text-right"><b>AED <?php echo Yii::app()->numberFormatter->formatCurrency($vendor_total,''); ?></b></td>
                        </tr>    
                       <?php
                        }
                       $vendor_total=0;
                         $str_vendor_id = $eachItem['vendor_id'];
                    }
                    else{
                      
                    }
                    $vendor_total+=$total_amount;
                    ?>
                        <tr>
                            <td><?php echo ($i+1); ?></td>
                            <td class="text-left"><?php echo $eachItem['vendor']['vendor_name']; ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_amount,""); ?></td>
                        </tr>
                    <?php
                    $total_invoice_value+=$total_amount;
                    $i++;   
                }
                ?>
                    <tr>
                        <td class="text-right" colspan="2"><b>Total Amount</b></td>
                        <td class="text-right"><b>AED <?php echo Yii::app()->numberFormatter->formatCurrency($total_invoice_value,''); ?></b></td>
                    </tr>
                <?php
            }
            else{
                ?>
                    <tr>
                        <td colspan="3" class="text-center">No data found</td>
                    </tr>
                <?php
            }
            
            ?>
            </tbody>
        </table>
        
        <br/>
         <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-list"></i> Purchase Returns

    </header>
         <table class="table table-hover table-bordered personal-task">
            <thead>
                <tr>
                    <th>S.No</th>
                    <th>Supplier</th> 
                    <th class="text-right">Amount</th>
                </tr>
            </thead>
            <tbody>
            
            <?php
            
            
            if(!empty($modelPurchaseDebitNote)){
                $total_debited_value = 0;
                $i=0;
                $str_debited_vendor_id="";
                $debit_vendor_total=0;
                foreach ($modelPurchaseDebitNote as $eachItem) {
                    $total_debited_amount = $eachItem['debited_amount'] * $eachItem['exchange_rate'];
                    
                    
                    
                    if ($str_debited_vendor_id!=$eachItem['vendor_id']){
                        if($str_vendor_id!=""){
                         ?>
                       <tr>
                             <td class="text-right" colspan="2"><b>Total</b></td>
                            <td class="text-right"><b>AED <?php echo Yii::app()->numberFormatter->formatCurrency($debit_vendor_total,''); ?></b></td>
                        </tr>    
                       <?php
                        }
                       $debit_vendor_total=0;
                         $str_debited_vendor_id = $eachItem['vendor_id'];
                    }
                    else{
                      
                    }
                    $debit_vendor_total+=$total_debited_amount;
                    ?>
                        <tr>
                            <td><?php echo ($i+1); ?></td>
                            <td class="text-left"><?php echo $eachItem['vendor']['vendor_name']; ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_debited_amount,""); ?></td>
                        </tr>
                    <?php
                    $total_debited_value+=$total_debited_amount;
                    $i++;   
                }
                ?>
                    <tr>
                        <td class="text-right" colspan="2"><b>Total Amount</b></td>
                        <td class="text-right"><b>AED <?php echo Yii::app()->numberFormatter->formatCurrency($total_debited_value,''); ?></b></td>
                    </tr>
                <?php
            }
            else{
                ?>
                    <tr>
                        <td colspan="3" class="text-center">No data found</td>
                    </tr>
                <?php
            }
            
            ?>
              <tr>
                        <td class="text-right" colspan="2"><b>Total Amount(Invoice - Return)</b></td>
                        <td class="text-right"><b>AED <?php echo Yii::app()->numberFormatter->formatCurrency($total_invoice_value - $total_debited_value ,''); ?></b></td>
                    </tr>
            </tbody>
            </tbody>
        </table>
    </div>