<?php
        $model_sales_total_invoice = Invoice::model()->find(array('select'=>'sum(grand_total*exchange_rate) as grand_total','condition' =>'YEAR(invoice_date)="'.$currentyear.'" AND MONTH(invoice_date)="'.$currentmonth.'"'));
        
        $model_total_credit_note = Creditnote::model()->find(array('select'=>'IFNULL(SUM(credited_amount*exchange_rate),0) as credited_amount','condition' =>'YEAR(credited_date)="'.$currentyear.'" AND MONTH(credited_date)="'.$currentmonth.'"'));
        $total_sale_amount=($model_sales_total_invoice->grand_total - $model_total_credit_note->credited_amount);    

        $model_lead_owner = User::model()->with('userGroup')->findAll(array('condition' =>'userGroup.is_salesman = "Y" AND t.isActive= "Y" AND t.company_id=' . Yii::app()->user->master_user_company_id));        
        $chartData = '';
        foreach ($model_lead_owner as $key => $value) {
            $model_sales_invoice = Invoice::model()->find(array('select'=>'sum(grand_total*exchange_rate) as grand_total','condition' =>'YEAR(invoice_date)="'.$currentyear.'" AND MONTH(invoice_date)="'.$currentmonth.'" AND lead_owner_id="'.$value->id.'"'));
            $model_credit_note = CreditNote::model()->with('invoice')->find(array('select'=>'sum(credited_amount*t.exchange_rate) as credited_amount','condition' =>'YEAR(credited_date)="'.$currentyear.'" AND MONTH(credited_date)="'.$currentmonth.'" AND invoice.lead_owner_id="'.$value->id.'"'));
            $sale_invoice_amount=($model_sales_invoice->grand_total - $model_credit_note->credited_amount);
            $total_inv_amount=$sale_invoice_amount;
            //if($total_inv_amount>0){
                $percentage_sales= number_format(($sale_invoice_amount/$total_sale_amount)*100,2);
                $chartData.='{"lead_owner": "'.$value->Fullname.'","total_amount": "'.$sale_invoice_amount.'","percentage_amount": "'.$percentage_sales.'"},';
            //}
        }
?>
    <div class="col-sm-12">
    <section class="panel">
      <header class="panel-heading">
        Invoice MTD <?php
                $selected=$currentyear.'-'.$currentmonth;
                echo CHtml::dropDownList('invoice_month', '', Dashboard::getMonths1($currentyear,1,12), array(
               'options' => array($selected=>array('selected'=>true)),
                "onChange" => "loadInvoicesMtdGraph(this.value);"));
                ?> - <?php echo Yii::app()->numberFormatter->formatCurrency($total_sale_amount,"");?>
      </header>
      <div class="panel-body">
        <div id="invoice_mtd_graph"></div>	
      </div>
      </section>
    </div>
<script type="text/javascript">


var chart_mileage = AmCharts.makeChart("invoice_mtd_graph", {
    "theme": "light",
    "type": "serial",
    "dataProvider": [ <?php echo $chartData; ?> ],
    "valueAxes": [{
        "stackType": "3d",
        "unit": " AED",
        "position": "left",
        "title": "Total in AED",
    }],
    "startDuration": 1,
    "graphs": [{
        "balloonText": "[[lead_owner]] - [[total_amount]] ([[percentage_amount]]%)",
        "fillAlphas": 0.9,
        "lineAlpha": 0.2,
        "title": "ThisYear",
        "type": "column",
        "valueField": "total_amount"
    }/*, {
        "balloonText": "Fuel Expense [[category]] Last Year: <b>[[value]]</b>",
        "fillAlphas": 0.9,
        "lineAlpha": 0.2,
        "title": "LastYear",
        "type": "column",
        "valueField": "last_year"
    }*/],
    "plotAreaFillAlphas": 0.1,
    "depth3D": 60,
    "angle": 30,
    "categoryField": "lead_owner",
    "categoryAxis": {
        "gridPosition": "start",
	    "labelRotation": 90,
        
    },
    "export": {
    	"enabled": true
     },
  "hideCredits":true,
});

chart_mileage.xAxes.rotation=270;

jQuery('.chart-input').off().on('input change',function() {
    alert(1);
	var property	= jQuery(this).data('property');
	var target		= chart_mileage;
	chart_mileage.startDuration = 0;
	chart_mileage.xAxes.rotation=270;

	if ( property == 'topRadius') {
		target = chart_mileage.graphs[0];
      	if ( this.value == 0 ) {
          this.value = undefined;
      	}
	}

	target[property] = this.value;
	chart_mileage.validateNow();
});






</script>
<style>
#invoice_mtd_graph {
  width: 100%;
  height: 500px;
}																				
</style>        
        