<?php
$default_fromdate  = date('01-01-Y');
$default_todate  = date('31-12-Y');
$current_date = date('Y-m-d');
//$from_date=date('Y-01-01');
//$end_date= date('Y-12-31');

$from_date=date('Y-m-d');
$end_date= date('Y-m-d');

$model_lead= new Lead();
$count_lead = $model_lead->with('file')->count(array('condition'=>'t.isActive="Y" AND enq_date BETWEEN "'.$from_date.'" AND "'.$end_date.'"'));
$model_quote= new Quotes();
$count_quote = $model_quote->with('file')->count(array('condition'=>'t.isActive="Y" AND t.status = "Y" AND (qtn_start_date >= "'.$from_date.'" AND qtn_start_date <= "'.$end_date.'")') );
$model_order=new Order();
$count_order = $model_order->with('file')->count(array('condition'=>'t.isActive="Y" AND (order_date >= "'.$from_date.'" AND order_date <= "'.$end_date.'")') );
$model_invoice=new Invoice();
$count_invoice = $model_invoice->with('file')->count(array('condition'=>'t.isActive="Y" AND (invoice_date >= "'.$from_date.'" AND invoice_date <= "'.$end_date.'")'));

/*$SQL = 'SELECT SUM(`exchange_rate` *`grand_total` ) FROM `erp_invoice` WHERE `invoice_date` = "'.$current_date.'"';
$today_invoice_value = Yii::app()->db->createCommand($SQL)->queryScalar();*/

$SQL = "SELECT SUM(exchange_rate * grand_total) AS invoice_amount FROM `erp_invoice` AS invoice WHERE isActive='Y' AND invoice_date >='".$from_date."' AND invoice_date<='".$end_date."'";
$arr_today_invoice_value = Yii::app()->db->createCommand($SQL)->queryRow();


$SQL = "SELECT SUM(exchange_rate * credited_amount) AS credit_note_amount FROM `erp_creditnote` AS CN WHERE CN.isActive='Y' AND credited_date >='".$from_date."' AND credited_date<='".$end_date."'";
$arr_credit_note_value = Yii::app()->db->createCommand($SQL)->queryRow();

$today_invoice_value = $arr_today_invoice_value['invoice_amount'] - $arr_credit_note_value['credit_note_amount']; 

$SQL = 'SELECT SUM(total_voucher_amount) FROM `erp_finance_voucher_head` WHERE (voucher_type=2 OR voucher_type=13) AND voucher_date >= "'.$from_date.'" AND voucher_date <= "'.$end_date.'" AND is_posted="Y"';
$today_collection=Yii::app()->db->createCommand($SQL)->queryScalar();
$SQL = 'SELECT SUM(total_voucher_amount) FROM `erp_finance_voucher_head` WHERE (voucher_type=1) AND voucher_date >= "'.$from_date.'" AND voucher_date <= "'.$end_date.'" AND is_posted="Y"';
$today_payment=Yii::app()->db->createCommand($SQL)->queryScalar();
$SQL = 'SELECT SUM(amount) FROM `erp_finance_voucher_head` H INNER JOIN erp_finance_voucher_items V ON V.header_id=H.id WHERE V.ledger_id=20 AND H.voucher_date <= "'.$end_date.'" AND H.is_posted="Y"';
$account_payable=Yii::app()->db->createCommand($SQL)->queryScalar();
$SQL = 'SELECT SUM(amount) FROM `erp_finance_voucher_head` H INNER JOIN erp_finance_voucher_items V ON V.header_id=H.id WHERE V.ledger_id=11 AND H.voucher_date <= "'.$end_date.'" AND H.is_posted="Y"';
$account_receivable=Yii::app()->db->createCommand($SQL)->queryScalar();


//purchase order
$SQL = 'SELECT SUM(stock_grand_total * exchange_rate) FROM `erp_purchasing_order` WHERE  order_date >= "'.$from_date.'" AND order_date <= "'.$end_date.'"';
$today_purchase_order=Yii::app()->db->createCommand($SQL)->queryScalar();

//purchase invoice
$SQL = 'SELECT SUM(grand_total * exchange_rate) FROM `erp_purchasinginvoice` WHERE  invoice_date >= "'.$from_date.'" AND invoice_date <= "'.$end_date.'"';
$today_purchase_invoice=Yii::app()->db->createCommand($SQL)->queryScalar();

//purchase debit note
$SQL = 'SELECT SUM(debited_amount * exchange_rate) FROM `erp_purchasing_debit_note` WHERE  debited_date >= "'.$from_date.'" AND debited_date <= "'.$end_date.'"';
$today_purchase_debit_note=Yii::app()->db->createCommand($SQL)->queryScalar();


$total_purchased_amount = $today_purchase_invoice - $today_purchase_debit_note;

$cs = Yii::app()->getClientScript();

$baseUrl = Yii::app()->baseUrl;
?>
<?php $cs->registerScriptFile($baseUrl . "/js/amchart/amcharts.js", CClientScript::POS_HEAD); ?>
<?php $cs->registerScriptFile($baseUrl . "/js/amchart/serial.js", CClientScript::POS_HEAD); ?>
<?php $cs->registerScriptFile($baseUrl . "/js/amchart/export.min.js", CClientScript::POS_HEAD); ?>
<?php $cs->registerCssFile($baseUrl . "/css/amchart/export.css"); ?>
<?php $cs->registerScriptFile($baseUrl . "/js/amchart/light.js", CClientScript::POS_HEAD); ?>
<?php $cs->registerScriptFile($baseUrl . "/js/amchart/funnel.js", CClientScript::POS_HEAD); ?>
<?php if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["stagingdashboard_view"])){ ?>
<section class="box-group clearfix" id="accordion">
    <ul class="clearfix form-ul material"> 
        <li class="col-sm-3">
            <div class="material">    
                <?php echo CHtml::dropDownList('graph_year',date('Y'), Dashboard::getYear(),array('data-label'=>'Select Year','onchange'=>'setgraphdate(this.value);'));?>
            </div>
        </li>
         <li class="col-sm-6">
            <div class="material">  
                <?php echo CHtml::hiddenField('graph_from_date','01/01/2018');?>
                <?php echo CHtml::hiddenField('graph_to_date','31/12/2018');?>
            </div>
             <button type="button" onclick="loadGraph();return false;" class='plan-save-btn btn btn-theme'>Load</button>
             <button type="button" value="Today" onclick="loadToday();return false;" class='btn btn-theme'>Reminder</button>
        </li>
    </ul>
    <div style="padding: 10px 15px;border: 1px solid #1f67b2;margin-top: 15px;font-weight: 600;background-color: #fff;display: block;">
        
         <ul class="clearfix form-ul material"> 
        <li class="col-sm-3">
            <div class="material">    
                <?php echo CHtml::textField('total_from_date',date('d/m/Y'),array('data-label'=>'Select From Date','class'=>'datepicker'));?>
            </div>
        </li>
        <li class="col-sm-3">
            <div class="material">    
                <?php echo CHtml::textField('total_to_date',date('d/m/Y'),array('data-label'=>'Select To Date','class'=>'datepicker'));?>
            </div>
        </li>
         <li class="col-sm-6">
             <button type="button" onclick="loadDashboardGraph('count_details','total_count_details');return false;" class='plan-save-btn btn btn-theme'>Load</button>
        </li>
    </ul>
        
    <div class="row status" id="total_count_details">
        
    <!--//onclick="loadGraph('lead');return false;"-->
    <a href="javascript:void(0)"  onclick="getTotalsBySalesLeads();">
       <div class="col-lg-3 col-sm-6">
           <section class="panel">
               <div class="symbol bg-terques">
                   <i class="fa fa-user"></i>
               </div>
               <div class="value">
                   <h3 class="count" id="lead_count"><?php echo $count_lead;?></h3>
                   <p>Total Leads
               </div>
           </section>
       </div>
   </a>
   <a href="javascript:void(0)" onclick="getTotalsBySalesQuotes();">
       <div class="col-lg-3 col-sm-6">
           <section class="panel">
               <div class="symbol bg-red">
                   <i class="fa fa-tags"></i>
               </div>
               <div class="value">
                   <h3 class="count" id="quote_count"><?php echo $count_quote;?></h3>
                   <p>Total Quotes</p>
               </div>
           </section>
       </div>
   </a>
    <a href="#20" onclick="getTotalsBySalesOrders();">
       <div class="col-lg-3 col-sm-6">
           <section class="panel">
               <div class="symbol bg-yellow">
                   <i class="fa fa-shopping-cart"></i>
               </div>
               <div class="value">
                   <h3 class="count" id="order_count"><?php echo $count_order;?></h3>
                   <p>Total Orders</p>
               </div>
           </section>
       </div>
   </a>
   <a href="#20" onclick="getTotalsBySalesInvoices();">
       <div class="col-lg-3 col-sm-6">
           <section class="panel">
               <div class="symbol bg-blue">
                   <i class="fa fa-bar-chart-o"></i>
               </div>
               <div class="value">
                   <h3 class="count" id="invoice_count"><?php echo $count_invoice;?></h3>
                   <p>Total Invoices</p>
               </div>
           </section>a
       </div>
   </a>
   
    <a href="#20" onclick="getTotalsByLeadOwner();">
        <div class="col-lg-3 col-sm-6">
            <section class="panel">
                <div class="symbol bg-purple">
                    <i class="fa fa-shopping-cart"></i>
                </div>
                <div class="value">
                    <h3 class="count" id="invoice_value"><?php echo round($today_invoice_value,0);?></h3>
                    <p>Total Sales</p>
                </div>
            </section>
        </div>
    </a>
    
     <a href="#20" onclick="getTotalsByReceipt();">
        <div class="col-lg-3 col-sm-6">
            <section class="panel">
                <div class="symbol"  style="background:#990000;">
                    <i class="fa fa-money"></i>
                </div>
                <div class="value">
                    <h3 class="count" id="invoice_value"><?php echo round($today_collection,0);?></h3>
                    <p>Total Collection</p>
                </div>
            </section>
        </div>
    </a>
    
     <a href="#20" onclick="getTotalsByPayment();">
        <div class="col-lg-3 col-sm-6">
            <section class="panel">
                <div class="symbol" style="background:#00004d;">
                    <i class="fa fa-exchange"></i>
                </div>
                <div class="value">
                    <h3 class="count" id="invoice_value"><?php echo round($today_payment,0);?></h3>
                    <p>Total Payment</p>
                </div>
            </section>
        </div>
    </a>
   
         <!--<a href="#20" onclick="getTotalsByPayment();">-->
        <div class="col-lg-3 col-sm-6">
<!--            <section class="panel">
                <div class="symbol" style="background:#00004d;">
                    <i class="fa fa-exchange"></i>
                </div>
                <div class="value">
                    <h3 class="count" id="invoice_value"><?php //echo Yii::app()->numberFormatter->formatCurrency($today_payment,""); ?></h3>
                    <p>Total Payment</p>
                </div>
            </section>-->
        </div>
    <!--</a>-->
     <a href="#20" onclick="getTotalsByAccountPayables();">
        <div class="col-lg-3 col-sm-6">
            <section class="panel">
                <div class="symbol" style="background:#00ffcc;">
                    <i class="fa fa-exchange"></i>
                </div>
                <div class="value">
                    <h3 class="count" id="invoice_value"><?php echo round(-1*$account_payable,0);?></h3>
                    <p>Account Payables</p>
                </div>
            </section>
        </div>
    </a>
    
    <a href="#20" onclick="getTotalsByAccountReceivables();">
        <div class="col-lg-3 col-sm-6">
            <section class="panel">
                <div class="symbol" style="background:#999966;">
                    <i class="fa fa-exchange"></i>
                </div>
                <div class="value">
                    <h3 class="count" id="invoice_value"><?php echo Yii::app()->numberFormatter->formatCurrency($account_receivable,"");?></h3>
                    <p>Account Receivables</p>
                </div>
            </section>
        </div>
    </a>
    
  <a href="#20" onclick="getTotalsByPurcahseOrders();">
        <div class="col-lg-3 col-sm-6">
            <section class="panel">
                <div class="symbol" style="background:#a472c5;">
                    <i class="fa fa-book"></i>
                </div>
                <div class="value">
                    <h3 class="count" id="invoice_value"><?php echo Yii::app()->numberFormatter->formatCurrency($today_purchase_order,"");?></h3>
                    <p>Purchase Order</p>
                </div>
            </section>
        </div>
    </a>
    
     <a href="#20" onclick="getTotalsByPurchaseInvoices();">
        <div class="col-lg-3 col-sm-6">
            <section class="panel">
                <div class="symbol" style="background:#990000;">
                    <i class="fa fa-list"></i>
                </div>
                <div class="value">
                    <h3 class="count" id="invoice_value"><?php echo Yii::app()->numberFormatter->formatCurrency($total_purchased_amount,"");?></h3>
                    <p>Purchase Invoice</p>
                </div>
            </section>
        </div>
    </a>
</div>
</div>
 <!--div class="row status" id="total_count_details">
    
   
</div-->
</section>
<section class="box-group clearfix" id="accordion">
    
    <?php if (isset(Yii::app()->user->havePermissionOn['stagingdashboard_leads_view']) ||Yii::app()->user->authorised_user == 1) {      ?>
    <div class="col-sm-12" onclick="loadDashboardGraph('leads_owner_graph','lead-accordion');">
        <a class="cards-title" href="#lead-accordion" data-toggle="collapse" data-parent="#accordion" aria-expanded="true">
          <i class="fa fa-line-chart" aria-hidden="true"></i> LEADS
        </a>
    </div>
    <section class="acc" id="lead-accordion" class="collapse in clearfix" aria-expanded="true"> 
    </section>
    <?php } ?>
    <?php if (isset(Yii::app()->user->havePermissionOn['stagingdashboard_quote_view']) ||Yii::app()->user->authorised_user == 1) {      ?>
    <div class="col-sm-12" onclick="loadDashboardGraph('quotation_graph','quotation-accordion');">
        <a class="cards-title" href="#quotation-accordion" data-toggle="collapse" data-parent="#accordion" aria-expanded="true">
            <i class="fa fa-line-chart" aria-hidden="true"></i> QUOTATION<span id="span_qtn"></span>
        </a>
    </div>
    <section class="acc" id="quotation-accordion" class="collapse in clearfix" aria-expanded="true"> 
    </section>
    <?php } ?>
    <?php if (isset(Yii::app()->user->havePermissionOn['stagingdashboard_order_view']) ||Yii::app()->user->authorised_user == 1) {      ?>
    <div class="col-sm-12" onclick="loadDashboardGraph('order_graph','order-accordion');">
        <a class="cards-title" href="#order-accordion" data-toggle="collapse" data-parent="#accordion" aria-expanded="true">
          <i class="fa fa-line-chart" aria-hidden="true"></i> ORDER<span id="span_ord"></span>
        </a>
    </div>
    <section class="acc" id="order-accordion" class="collapse in clearfix" aria-expanded="true"> 
    </section>
    <?php } ?>
    <?php if (isset(Yii::app()->user->havePermissionOn['stagingdashboard_invoice_view']) ||Yii::app()->user->authorised_user == 1) {      ?>
    <div class="col-sm-12" onclick="loadDashboardGraph('invoice_graph','invoice-accordion');">
        <a class="cards-title" href="#invoice-accordion" data-toggle="collapse" data-parent="#accordion">
          <i class="fa fa-line-chart" aria-hidden="true"></i> INVOICE<span id="span_inv"></span>
        </a>
    </div>
    <section class="acc" id="invoice-accordion"> 
    </section>
    <?php } ?>
     <!-- <div class="col-sm-12" onclick="loadDashboardGraph('stock_graph','stock-accordion');">
        <a class="cards-title" href="#stock-accordion" data-toggle="collapse" data-parent="#accordion" aria-expanded="true">
          <i class="fa fa-line-chart" aria-hidden="true"></i> STOCK
        </a>
    </div>
    <section class="acc" id="stock-accordion" > 
    </section> -->
</section>
<?php } ?>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadDashboardGraph", " function loadDashboardGraph(page,field_id) {
            var url = '" . Yii::app()->createUrl('stagingdashboard/GetGraph') . "';
            //$('#loader').show();
            var total_count_from_date   = $('#total_from_date').val();
            var total_count_to_date     = $('#total_to_date').val();
            var year = $('#graph_year').val();
            var fromdate='01/01/'+year;
            var todate='31/12/'+year;
            jQuery.ajax({
            'type':'post',
            'data':'page='+page+'&fromdate='+fromdate+'&todate='+todate+'&total_count_from_date='+total_count_from_date+'&total_count_to_date='+total_count_to_date,
            'url': url,
            'cache': false,
            'success': function(data) {
                    $('#loader').hide();
                   // alert(data);
                    $('#'+field_id).html(data);
            }

           });           

    } ", CClientScript::POS_HEAD);
$cs->registerScript("loadleadgraphs", '$(document).ready(function() { 
    loadDashboardGraph("leads_owner_graph","lead-accordion");
    loadDashboardGraph("quotation_graph","quotation-accordion");
    loadDashboardGraph("order_graph","order-accordion");
    loadDashboardGraph("invoice_graph","invoice-accordion");
    //loadDashboardGraph("stock_graph","stock-accordion");
    loadDashboardGraph("count_details","total_count_details");  
    var url = "' . Yii::app()->createUrl('stagingdashboard/GetGraphTotals') . '";
    var year = $("#graph_year").val();
    var fromdate="01/01/"+year;
    var todate="31/12/"+year;
    jQuery.ajax({
        "type":"post",
        "dataType":"json",
        "data":"fromdate="+fromdate+"&todate="+todate,
        "url": url,
        "cache": false,
        "success": function(data) {
            $("#span_qtn").html("("+data.qtn_total+")");
            $("#span_ord").html("("+data.ord_total+")");
            $("#span_inv").html("("+data.inv_total+")");
        }
    });       
});', CClientScript::POS_END);
$cs->registerScript("loadGraph",  "function loadGraph(){  
    loadDashboardGraph('leads_owner_graph','lead-accordion');
    loadDashboardGraph('quotation_graph','quotation-accordion');
    loadDashboardGraph('order_graph','order-accordion');
    loadDashboardGraph('invoice_graph','invoice-accordion');
    //loadDashboardGraph('stock_graph','stock-accordion');
    loadDashboardGraph('count_details','total_count_details');
    var url = '" . Yii::app()->createUrl('stagingdashboard/GetGraphTotals') . "';
    var year = $('#graph_year').val();
    var fromdate='01/01/'+year;
    var todate='31/12/'+year;
    jQuery.ajax({
        'type':'post',
        'dataType':'json',
        'data':'fromdate='+fromdate+'&todate='+todate,
        'url': url,
        'cache': false,
        'success': function(data) {
            $('#span_qtn').html('('+data.qtn_total+')');
            $('#span_ord').html('('+data.ord_total+')');
            $('#span_inv').html('('+data.inv_total+')');
        }

    });
};", CClientScript::POS_HEAD); 
$cs->registerScript("setgraphdate",  "function setgraphdate(year){  
    var d_from='01/01/'+year;
    var d_to='31/12/'+year;
        $('#graph_from_date').val(d_from);
        $('#graph_to_date').val(d_to);
};", CClientScript::POS_HEAD); 
$cs->registerScript("loadToday",  "function loadToday(){ 
    window.open($('#liveSite').val()+'index.php?r=stagingdashboard/followups', '_blank');
    };", CClientScript::POS_HEAD);
    
    $cs->registerScript("getTotalsByLeadOwner",  "function getTotalsByLeadOwner(){ 
    
    var total_count_from_date   = $('#total_from_date').val();
    var total_count_to_date     = $('#total_to_date').val();
    
    loadPopupModal('stagingdashboard/getleadownersales&from_date='+total_count_from_date+'&to_date='+total_count_to_date,'Total Sales','xl');
    };", CClientScript::POS_HEAD);
    
    $cs->registerScript("getTotalsByReceipt",  "function getTotalsByReceipt(){ 
    
    var total_count_from_date   = $('#total_from_date').val();
    var total_count_to_date     = $('#total_to_date').val();
    
    loadPopupModal('stagingdashboard/getreceiptall&from_date='+total_count_from_date+'&to_date='+total_count_to_date,'Total Receipt','lg');
    };", CClientScript::POS_HEAD);
    
    $cs->registerScript("getTotalsByPayment",  "function getTotalsByPayment(){ 
    
    var total_count_from_date   = $('#total_from_date').val();
    var total_count_to_date     = $('#total_to_date').val();
    
    loadPopupModal('stagingdashboard/getpaymentall&from_date='+total_count_from_date+'&to_date='+total_count_to_date,'Total Payment','lg');
    };", CClientScript::POS_HEAD);
    
    $cs->registerScript("getTotalsByAccountPayables",  "function getTotalsByAccountPayables(){ 
    
    var total_count_from_date   = $('#total_from_date').val();
    var total_count_to_date     = $('#total_to_date').val();
    
    loadPopupModal('stagingdashboard/GetTotalsByAccountPayables&from_date='+total_count_from_date+'&to_date='+total_count_to_date,'Total Account Payables','lg');
    };", CClientScript::POS_HEAD);
        
    $cs->registerScript("getTotalsByAccountReceivables",  "function getTotalsByAccountReceivables(){ 
    
    var total_count_from_date   = $('#total_from_date').val();
    var total_count_to_date     = $('#total_to_date').val();
    
    loadPopupModal('stagingdashboard/GetTotalsByAccountReceivables&from_date='+total_count_from_date+'&to_date='+total_count_to_date,'Total Account Receivables','lg');
    };", CClientScript::POS_HEAD);
    
    $cs->registerScript("getTotalsByPurcahseOrders",  "function getTotalsByPurcahseOrders(){ 
    
    var total_count_from_date   = $('#total_from_date').val();
    var total_count_to_date     = $('#total_to_date').val();
    
    loadPopupModal('stagingdashboard/GetTotalsByPurcahseOrders&from_date='+total_count_from_date+'&to_date='+total_count_to_date,'Total Purchase Orders','lg');
    };", CClientScript::POS_HEAD);
    
    $cs->registerScript("getTotalsByPurchaseInvoices",  "function getTotalsByPurchaseInvoices(){ 
    
    var total_count_from_date   = $('#total_from_date').val();
    var total_count_to_date     = $('#total_to_date').val();
    
    loadPopupModal('stagingdashboard/GetTotalsByPurchaseInvoices&from_date='+total_count_from_date+'&to_date='+total_count_to_date,'Total Purchase Invoices','lg');
    };", CClientScript::POS_HEAD);
    
      $cs->registerScript("getTotalsBySalesOrders",  "function getTotalsBySalesOrders(){ 
    
    var total_count_from_date   = $('#total_from_date').val();
    var total_count_to_date     = $('#total_to_date').val();
    
    loadPopupModal('stagingdashboard/GetTotalsBySalesOrders&from_date='+total_count_from_date+'&to_date='+total_count_to_date,'Total Sales Orders','lg');
    };", CClientScript::POS_HEAD);
    
     $cs->registerScript("getTotalsBySalesInvoices",  "function getTotalsBySalesInvoices(){ 
    
    var total_count_from_date   = $('#total_from_date').val();
    var total_count_to_date     = $('#total_to_date').val();
    
    loadPopupModal('stagingdashboard/GetTotalsBySalesInvoices&from_date='+total_count_from_date+'&to_date='+total_count_to_date,'Total Sales invoices','lg');
    };", CClientScript::POS_HEAD);
    
      $cs->registerScript("getTotalsBySalesLeads",  "function getTotalsBySalesLeads(){ 
    
    var total_count_from_date   = $('#total_from_date').val();
    var total_count_to_date     = $('#total_to_date').val();
    
    loadPopupModal('stagingdashboard/GetTotalsBySalesLeads&from_date='+total_count_from_date+'&to_date='+total_count_to_date,'Total Sales Leads','lg');
    };", CClientScript::POS_HEAD);
    
      $cs->registerScript("getTotalsBySalesQuotes",  "function getTotalsBySalesQuotes(){ 
    
    var total_count_from_date   = $('#total_from_date').val();
    var total_count_to_date     = $('#total_to_date').val();
    
    loadPopupModal('stagingdashboard/GetTotalsBySalesQuotes&from_date='+total_count_from_date+'&to_date='+total_count_to_date,'Total Sales Quotations','lg');
    };", CClientScript::POS_HEAD);
    
    
    
?>