<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'security_cheque_update-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-2">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->dropdownlist($model, 'transaction_type', array('I' => 'Issue', 'R' => 'Received'), array('data-label' => 'Transaction Type','class'=>'text-bold','disabled'=>true)); ?>
            </li>
            <li class="col-sm-3">
                <?php
                if($model->transaction_date!='' && $model->transaction_date!='0000-00-00'){
                    $model->transaction_date=date("d/m/Y", strtotime($model->transaction_date));
                }else{
                    $model->transaction_date='';
                }
                echo $form->textField($model, 'transaction_date', array('data-label' => 'Transaction Date','disabled'=>true,'class'=>'text-bold')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'bank_name', array('data-label' => 'Bank Name','disabled'=>true,'class'=>'text-bold')); ?>
            </li>	
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'location', array('data-label' => 'Location','disabled'=>true,'class'=>'text-bold')); ?>
            </li>
            <li class="col-sm-5">
                <?php echo $form->textField($model, 'cheque_payee', array('data-label' => 'Payee','disabled'=>true,'class'=>'text-bold')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'cheque_no', array('data-label' => 'Cheque No','disabled'=>true,'class'=>'text-bold')); ?>
            </li> 
            <li class="col-sm-3">
                <?php 
                if($model->cheque_date!='' && $model->cheque_date!='0000-00-00'){
                    $model->cheque_date=date("d/m/Y", strtotime($model->cheque_date));
                }else{
                    $model->cheque_date='';
                }
                echo $form->textField($model, 'cheque_date', array('data-label' => 'Cheque Date','disabled'=>true,'class'=>'text-bold')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'cheque_amount', array('data-label' => 'Amount','disabled'=>true,'class'=>'text-bold')); ?>
            </li>
            <hr>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'transaction_return_date', array('data-label' => '<b>Return Date <span style="color:red">*</span></b>', 'class' => 'datepicker', 'onkeypress' => 'return false;')); ?>
            </li>
            <li class="col-sm-9">
                <?php echo $form->textArea($model, 'notes', array('data-label' => '<b>Notes</b>')); ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-default " id="security_cheque_close_1" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" onclick="savereturndetail();">Save</button>
</div>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript('savereturndetail', 'function savereturndetail(){	
    jQuery.ajax({
        "dataType":"json",
        "data" : $("#security_cheque_update-form").serialize(),
        "type"  : "post",
        "url": "' . Yii::app()->createUrl('securitycheque/savereturndetail') . '",
        "success":function(data){
            if(data.status=="success"){  
                t8.success("Return Details Updated!");  
                $("#security_cheque_close_1").click();
                reloadTable("#tbl_security_cheque_details");
            } 
        },
        "beforeSend":function(){
            var return_date=$("#SecurityCheque_transaction_return_date").val();
            if(return_date==""){
                t8.error("Select Return Date");
                return false;
            }else{
                $("#loader").show();
            }
        },
        "complete":function(){
            $("#loader").hide();
        }
    });
};', CClientScript::POS_HEAD);
?>