<?php
$cs = Yii::app()->getClientScript();

$baseUrl = Yii::app()->baseUrl;
?>
<div class="table-responsive">
    <table class="table table-hover table-bordered personal-task" id="nonstock_item_table">
        <tr>
            <th style="width:2%">No</th>  
            <th style="width:10%">Item</th>
            <th style="width:30%">Description</th>
            <th style="width:10%">Brand</th>
            <th style="width:10%">Quantity</th>
            <th style="width:10%">Unit</th>
            <th class="text-center">
                <a class="btn btn-xs btn-theme " href="javascript:void(0);" onclick="addTableRow($('#nonstock_item_table'));"><i class="fa fa-plus"></i></a></th>
        </tr>

        <?php foreach ($modelNonStock as $i => $rowitem) { ?>
        <tr>
            <td>  <label><?php echo ($i + 1); ?> </label></td>
            <td><?php echo $form->textField($rowitem, "[" . $i . "]non_stock_item_name", array('data-label' => 'Item Name', 'class' => 'tooltipster go')); ?></td>
                <?php echo $form->hiddenField($rowitem, "[" . $i . "]id"); ?>
            <td><?php echo $form->textArea($rowitem, "[" . $i . "]non_stock_item_description", array('data-label' => 'Description', 'class' => 'go en-text-area')); ?></td>
            <td><?php echo $form->textField($rowitem, "[" . $i . "]non_stock_item_brand", array('class' => 'tooltipster go')); ?></td>
            <td><?php echo $form->textField($rowitem, "[" . $i . "]non_stock_item_quantity", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isPositiveNumber(event)', 'onKeyup' => 'validatequantity(this.id);highlightfield(this.id)')); ?></td>
            <td><?php echo $form->dropDownList($rowitem, "[" . $i . "]non_stock_item_unit", Unit::getUnits(), array('data-label' => 'Unit', 'class' => 'unit go', 'empty' => '--select--')); ?></td>
            <td class="text-center nw" width="1%">
                <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-xs btn-danger', 'onclick' => 'removeitemTable($(\'#nonstock_item_table\'),this,this.id)', 'title' => 'Remove this item', 'id' => 'PurchasingRequisitionNonStockItem_' . $i)); ?>
            </td>
        </tr>
        <?php } ?>
    </table>
</div>
<?php
    $cs = Yii::app()->getClientScript();
    $cs->registerScript("isPositiveNumber", " function isPositiveNumber(event) { 
            if (event.which != 8 && event.which != 0 &&(event.which != 46 || $(this).val().indexOf('.') != -1) && (event.which < 48 || event.which > 57)) {
                event.preventDefault();
            }            
    } ", CClientScript::POS_HEAD);
    $cs->registerScript("removeitemTable ", "function removeitemTable(jQtable,evt,field_id) {
        var arr_fields= field_id.split('_');
        
        var row_field=arr_fields[1];
        var id=$('#PurchasingRequisitionNonStockItem_'+row_field+'_id').val();
           formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
                var num_rows    =   jQtable.find('tr:gt(0)').length;
                if(num_rows>1){
                    var tr  =   $(evt).parent().parent();
                    if(isRowEmpty(tr)) { 
                        
                                $(evt).parents('tr').remove();
                                var i=0;
                                jQtable.find('tr:gt(0)').each(function() { $(this).find('input,textarea,.errorMessage').each(function()
                                {
                                old_id   =   $(this).attr('id');
                                new_id   =   old_id.replace(/\d+/,i);
                                $(this).attr('id',new_id);
                                old_name =   $(this).attr('name');
                                if(old_name!==undefined) {
                                new_name =   old_name.replace(/\d+/,i);
                                $(this).attr('name',new_name);} });
                                $(this).find('td:first label').html(++i); }); 
                            
                            

                    }else {
                        alert('Atleast one item needed here','Alert');
                    }
            }     
    };", CClientScript::POS_HEAD);
?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("validatequantity", "function validatequantity(field_id){
        var arr_fields= field_id.split('_');
        
        var row_field=arr_fields[1];
        var id=$('#PurchasingRequisitionNonStockItem_'+row_field+'_non_stock_item_quantity').val();
        if($('#PurchasingRequisitionNonStockItem_'+row_field+'_non_stock_item_quantity').val()<=0)
        {
            $('#PurchasingRequisitionNonStockItem_'+row_field+'_non_stock_item_quantity').select();
            return false;
         }
        else
        {
         return true;
        }
      };", CClientScript::POS_HEAD);
$cs->registerScript("highlightfield", "function highlightfield(field_id){
        var arr_fields= field_id.split('_');
        
        var row_field=arr_fields[1];
        var id=$('#PurchasingRequisitionNonStockItem_'+row_field+'_non_stock_item_quantity').val();
        if($('#PurchasingRequisitionNonStockItem_'+row_field+'_non_stock_item_quantity').val()<=0)
        {
            $('#PurchasingRequisitionNonStockItem_'+row_field+'_non_stock_item_quantity').css('background','#f2dede');
            return false;
         }
        else
        {
            $('#PurchasingRequisitionNonStockItem_'+row_field+'_non_stock_item_quantity').css('background','');
         return true;
        }
      };", CClientScript::POS_HEAD);
?>