<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>
<script>
    $(document).ready(function () {
        var table_id = "#tbl_requisition_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            order: [[3, "desc"]],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('requisition/getrequisitionlist') ?>",
                type: "POST",
                cache: false,
            },
            columnDefs: [
                { "bSortable": false, "aTargets": [0] },
            ],
            "rowCallback": function (row, data) {
               /* if (data[7] == "C") {
                    $("td", row).css("background-color", "#f5dbdb"); //Closed
                    $("td", row).css("text-decoration", "line-through"); //Closed

                }
                if (data[8] == "N") {
                    $("td", row).css("background-color", "#f5dbdb"); //Closed

                }*/
                

            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
        });

        $('#tbl_requisition_details tbody').on('click', 'tr', function () {
            $.contextMenu('destroy');
            var data = table.row(this).data();
            console.log(data);
            
            var file_id = data[10];
            var completed = data[8];
            var is_approved = data[9];

            $.contextMenu({
                selector: '.context-menu',
                callback: function (key, options) {
                    var action_id = key;
                    var data = table.row(this).data();
                    var id = data[1];
                    var convert_status = data[7];
                    
                    
                    var row_index = table.row(this).index();
                    if (action_id == "approve" && is_approved == "N") {
                        loadPopupModal("requisition/create&id=" + id + "&file_id=" + file_id + "&type=1", "Approve Requisition-" + file_id + "/" + id, "xl");
                    }
                    if (action_id == "convertenquiry" && convert_status != '0' && is_approved == "Y") {
                        loadPopupModal("enquiry/create&req_id=" + id, "Convert to Enquiry - " + id, "xl");
                    } 
                    else if (action_id == "selectcheckbox" && convert_status != '0') {
                        selectcheckbox(row_index, id);
                    }
                    else if (action_id == "convertpo" && convert_status != '0') {
                        loadPopupModal("purchasingorder/create&req_id=" + id, "Convert to Order - " + id, "xl");
                    }
                    else if (action_id == "edit" && convert_status != '0') {
                        loadPopupModal("requisition/create&id=" + id + "&file_id=" + file_id+"&type=2", "Edit Requisition / " + id, "xl");
                    }
                    else if (action_id == "view" && convert_status == '0') {
                        loadPopupModal("requisition/create&id=" + id, "View Requisition / " + id, "xl");
                    }
                    else if (action_id == "activity") {
                        loadPopupModal("activity/activity/history&file_id=" + id + "&id=" + id + "&header_id=" + id + "&frm=RE", "Requisition", "xl");
                    }
                    else if (action_id == "print") {
                        printreq(id)
                    }
                    else if (action_id == "cancel") {
                        loadPopupModal("requisition/create&type=cancel&id=" + id, "Cancel Requisition / " + id, "xl");
                    }
                },
                items: {
                      <?php
                        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_edit"])) { ?>
                                        "edit": {
                            name: "Edit", icon: "edit", disabled: function (key, opt) {
                                // this references the trigger element
                                if (completed == 'C') {
                                    return !this.data('editDisabled');
                                }
                            }
                        },

                    <?php }
                    ?>
                    <?php /*if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_approve"])) { ?>
                    "approve": {
                            name: "Approve", icon: "fa-question", disabled: function (key, opt) {
                                // this references the trigger element
                                if (is_approved == 'Y' || completed == 'C') {
                                    return !this.data('approveDisabled');
                                }
                            }
                        },
                    <?php }*/ ?>
                    <?php
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_convert_enq"])) { ?>
                                        "selectcheckbox": {
                            name: "Select/Deselect", icon: "fa-check", disabled: function (key, opt) {
                                // this references the trigger element
                                if (completed == 'C' ) {
                                    return !this.data('selectcheckboxenquiryDisabled');
                                }
                            }
                        },
                        "convertenquiry": {
                            name: "Convert to Enquiry", icon: "fa-retweet", disabled: function (key, opt) {
                                // this references the trigger element
                               /* if (completed == 'C' || is_approved == 'N') {
                                    return !this.data('convertenquiryDisabled');
                                }*/
                            }
                        },
                    <?php } ?>

                        <?php
                        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_convert_po"])) { ?>
                                         "convertpo": {
                            name: "Convert to Purchase Order", icon: "fa-retweet", disabled: function (key, opt) {
                                // this references the trigger element
                               /* if (completed == 'C' || is_approved == 'N') {
                                    return !this.data('convertpoDisabled');
                                }*/
                            }
                        },
                    <?php } ?>
                      <?php
                        /*if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_view"])){?>
                            "view": {name: "View", icon: "fa-eye"},           
                        <?php }*/ ?>
                    <?php
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_cancel"])) { ?>
                                         "cancel": {
                        name: "Cancel", icon: "fa-ban", disabled: function (key, opt) {
                            // this references the trigger element
                            if (completed == 'C') {
                                return !this.data('cancelDisabled');
                            }
                        }
                    },
                <?php }  if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_activity"])) {?>
                            "activity": {
                    name: "Activity",
                    icon: "fa-certificate",
                    disabled: function (key, opt) {

                    }
                },

                <?php } if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_pdf"])) { ?>
                                        "print": { name: "Print", icon: "fa-print" },
                <?php } ?>

            }
            });


    });



    });
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-info-circle"></i> -->
         Requisitions
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['requisition_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <a class="ad-btn"  id="add_popup"
                    onclick="loadPopupModal('requisition/create','Add New Requisition','xl')" title="Add">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                    <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                    <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                    <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                    </svg>
                    <a>
            <?php } ?> <input type="hidden" id="req_ids">
        </div>

    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_requisition_details"
                style="font-size:13px;">
                <thead>
                    <tr>
                        <th class="text-center"><a title="Create Enquiry" class="btn btn-theme btn-xs"
                                href="javascript:void(0);" onclick="createEnq()" id="select_all"><i
                                    class="fa fa-phone"></i></a></th>
                        <th>#</th>
                        <th>Date</th>
                        <th>Required Date</th>
                        <th>Reference</th>
                        <th>Status</th>
                        <th>Requested By</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("createPo", "function createEnq(){
                       var req_ids = $('#req_ids').val();
                       if(req_ids == ''){
                            alert('Select Atleast One Requisition!');
                       }else{
                            $('#loader').show();
                            var url = '" . Yii::app()->createUrl('requisition/addenquiry') . "';
                            jQuery.ajax({
                                    'dataType':'json',  
                                    'type':'post',
                                    'url': url,
                                    'data' : {'req_ids':req_ids},
                                    'cache': false,
                                    'success': function(data) {
                                        
                                            if(data.status == 'success'){
                                                $('#loader').hide();
                                                $('#req_ids').val('');
                                                $('.req_check').prop('checked', false);
                                                loadPopupModal('enquiry/create&temp_id='+data.id,'Purchase Enquiry','xl');   
                                            }else{
                                                $('#loader').hide();
                                                t8.error('Operation failed!');
                                            }

                                            }

                                   });
                       }
}", CClientScript::POS_HEAD);
$cs->registerScript("getValue", "function getValue(field_id,req_id){
                        
                         var old = $('#req_ids').val();
                         if($('#'+field_id).is(':checked') == true){
                            if(old == ''){
                                   $('#req_ids').val(req_id);
                            }else{
                                   var new_str = old.concat(',',req_id);
                                   $('#req_ids').val(new_str);
                            }
                         }else{
                                        if(old.includes(','+req_id) == true){
                                                $('#req_ids').val(old.replace(','+req_id,''));
                                        }else{
                                                $('#req_ids').val(old.replace(req_id,''));
                                        }
                           
                         }
                         if($('input.req_check:checked').length > 0){   
                            $('.all-selecter').each(function() { $(this).find('button,a').prop('disabled', true); });
                         }else{
                            $('.all-selecter').each(function() { $(this).find('button,a').prop('disabled', false); });
                         }
                         $('#checkAll').prop('checked', false);
                         
                        
                          
}", CClientScript::POS_HEAD);
$cs->registerScript("printreq", "function printreq(id){
    window.open('index.php?r=requisition/PrintRequistionReportPDF&id='+id);
}", CClientScript::POS_HEAD);
$cs->registerScript("selectcheckbox", "function selectcheckbox(index,id){
    var field_id='Enquiry_'+index+'_check';
    var isChecked = $('#'+field_id+'').is(':checked'); 
    if (isChecked) {
        $('input[id=Enquiry_'+index+'_check]').prop('checked',false);
    }else {
        $('input[id=Enquiry_'+index+'_check]').prop('checked', true);
    }
    getValue(field_id,id);
}", CClientScript::POS_HEAD);