<div class="panel">
    <div class="panel-heading panel-theme">
        <p>Warehouse Stock Report - Horizontal </p>
    </div>
    <div class="panel-body">
        <div >
            <label>Page Size </label>
            <select name='spg' id ="pagesize">
                <option value="20" <?php if ($page_size == 20) echo ' selected="selected" '; ?> >20</option>
                <option value="50" <?php if ($page_size == 50) echo 'selected="selected" '; ?>>50</option>
                <option value="100" <?php if ($page_size == 100) echo 'selected="selected" '; ?>>100</option>
            </select>
        </div>
        <div class="table-responsive"> 
            <input type="hidden" id="type" name="type" value="<?php echo $type; ?>" />
            <input type="hidden" id="part_number" name="part_number" value="<?php echo $part_no; ?>" />
            <input type="hidden" id="generic_name" name="generic_name" value="<?php echo $generic_name; ?>" />

            <table id="tbl_inventory_table" class="table table-fixed table-bordered table-primary dataTable html_table">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Part Number</th>
                        <th>Unit</th>
                        <th>Brand</th>
                        <?php
                        $total = array();
                        $model_warehouse = new MasInventoryWarehouse();
                        $model_warehouse_param = null;
                        if ($loc == '' || $loc == 'null') {
                            $model_warehouse_param = array('condition' => 't.isActive="Y"', 'order' => 'warehouse_name asc');
                        } else {
                            $model_warehouse_param = array('condition' => ' t.id in (' . $loc . ')', 'order' => 'warehouse_name asc');
                        }

                        $model_warehouse = $model_warehouse->findAll($model_warehouse_param);
                        if (!empty($model_warehouse)) {
                            foreach ($model_warehouse as $k => $each) {
                                $total[$k] = 0;
                                ?>
                                <th><?php echo $each->warehouse_name; ?></th>
                                <?php
                            }
                        }
                        ?>
                        <th>Total</th>        
                    </tr>
                </thead>
                <tbody>       
                    <?php
                    $toalval = 0;
                    $offset = ($page_no - 1) * $page_size;
                    $condition = '1=1';
                    ;
                    if ($part_no != '') {
                        $condition .= ' AND t.id="' . $part_no . '"';
                    }
                    if ($brand_id != '') {
                        $condition .= ' AND t.brand_class_id="' . $brand_id . '"';
                    }
                    $condition .= ' AND t.inventory_item_type="1"';
                    $criteria = new CDbCriteria();
                    $criteria->condition = $condition;
                    $criteria->order = 'part_number asc';
                    $item_count = Store::model()->count($criteria);

                    $criteria->offset = $offset;
                    $criteria->limit = $page_size;

                    $pageCounts = $item_count / $page_size;


                    $model_inventory = Store::model()->findAll($criteria);

                    foreach ($model_inventory as $i => $model) {
                        
                        $arr_secondary_unit = UnitOfMeasurement::getSecondaryBaseUnitWithName($model->id);
                                    
                        $second_unit_factor = $arr_secondary_unit->factor;
                        $second_unit_name = $arr_secondary_unit->name;
                        ?>

                        <tr>      
                            <td><?php echo $offset + $i + 1; ?></td>
                            <td><?php echo $model->part_number; ?></td>
                            <td><?php echo $model->unit->unit_name; ?></td>
                            <td><?php 
                             echo $brand_row = MasInvBrand::model()->findByPk($model->brand_class_id)->brand_name;
                            
                           // echo $model->brand_detail->product_class; ?></td> 
                            <?php
                            if (!empty($model_warehouse)) {
                                $toalval = 0;
                                $total_second_unit_qty=0;
                                foreach ($model_warehouse as $n => $each) {
                                    $warehouse_id = $each->id;
                                    $location_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity * unit_factor),0)  as quantity FROM erp_stock_ledger WHERE warehouse_id = ' . $warehouse_id . ' AND  product_id='.$model->id.' AND stock_updated="Y" GROUP BY warehouse_id')->queryScalar();
                                    
                                    
                                    
                                    
                                    /*$location_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity),0) FROM erp_product_location_details 
                                                                                            WHERE warehouse_id = ' . $warehouse_id . ' AND 
                                                                                            product_id = ' . $model->id.'
                                                                                            AND isActive="Y"')->queryScalar();*/
                                    $total[$n]+=$location_qty;
                                    $toalval+=$location_qty;
                                    if($second_unit_factor>0){
                                        $total_second_unit_qty+=($location_qty / $second_unit_factor);
                                    }
                                    ?>
                                    <td class="text-right"><?php 
                                    if((int) $location_qty < 0){
                                    echo (int) $location_qty; 
                                    }?>
                                        

                                    </td>
                                    <?php
                                }
                            }
                            ?>
                            <td class="text-right"><?php echo (int) $toalval; ?></td>        
                        </tr>
                    <?php } ?>   
                </tbody>
            </table>
            <div class ="text-center">
                <input type="hidden" value="<?= $page_no ?>" name ="pgcount" id ="pagecount">

                <ul class="pagination">
                    <?php for ($index = 0; $index < $pageCounts; $index++) {
                        ?>
                        <li class="<?php if ($page_no == ($index + 1)) echo "active"; ?>" ><a href="#"  onclick="SetPage(<?= $index + 1 ?>)"  ><?php echo $index + 1; ?></a></li>
                    <?php }
                    ?>


                </ul> 
            </div>
            <br>
            <div class="btn-wrap text-center"> 
                <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inv_warehouse_report_download"]))) { ?>
                <a title="Export Pdf" class="btn btn-theme" onclick="loadWarehousePDF();"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</a> 
                <a title="Export Excel" class="btn btn-theme" onclick="excelInvoiceList();"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</a>
                <?php } ?>
                <?php //echo CHtml::link('Export PDF',array('invreports/PrintWarehouseStockReportPDF','part_number'=>$part_no,'brand_id'=> $brand_id ,'loc' => $loc), array('title'=>'Print Lead List','target'=>'_blank','class' =>  'btn btn-theme'));     ?>    
                <!--<button type="button" class="btn btn-theme" onclick="excelInvoiceList();">Export Excel</button>-->
            </div>    
        </div>
    </div>
</div>
<script>
    function SetPage(pg)
    {
        $("#pagecount").val(pg);
        loadMasterReport();
        return false;
    }
</script>

<?php $cs = Yii::app()->getClientScript(); 



    $cs->registerScript("loadWarehousePDF", "function loadWarehousePDF(){
                           
            var url= '" . Yii::app()->createUrl('reports/PrintexcelInvoiceList') . "';
            var part_no = $('#warehouse_part_no').val(); 
            var type = $('#warehouse_report_type').val(); 
            var brand_id = $('#inv_warehouse_brand_name').val();
            var page_size =$('#pagesize').val();
            var page_no =$('#pagecount').val();
            var loc = $('#inv_warehouse_warehouse').val();
            window.open($('#liveSite').val()+'index.php?r=invreports/PrintWarehouseStockReportPDF&part_number='+part_no+'&type='+type+'&brand_id='+brand_id+'&loc='+loc, '_blank'); 
            return false;
                
    }", CClientScript::POS_HEAD);
    

$cs->registerScript("excelInvoiceList", "function excelInvoiceList(){

            var url= '" . Yii::app()->createUrl('reports/PrintexcelInvoiceList') . "';
            var part_no = $('#warehouse_part_no').val(); 
            var type = $('#warehouse_report_type').val(); 
            var brand_id = $('#inv_warehouse_brand_name').val();
            var page_size =$('#pagesize').val();
            var page_no =$('#pagecount').val();
            var loc = $('#inv_warehouse_warehouse').val();
    window.open($('#liveSite').val()+'index.php?r=invreports/PrintWarehouseStockReportList&part_no='+part_no+'&type='+type+'&brand_id='+brand_id+'&loc='+loc, '_blank');

}", CClientScript::POS_HEAD);
