<div class="panel"> 
    <div class="panel-heading panel-theme clearfix report-head"> 
        <p>Vehicle Service / Maintenance Report</p> 
        <div class="pull-right"> 
            <div class="filter_details"> 
                <?php if ($sheduled_from_date != '') { ?>
                    <div class="filter-item">
                        <label> Scheduled From :</label>
                        <?php echo $sheduled_from_date ?>
                    </div>
                <?php } ?>

                <?php if ($sheduled_to_date != '') { ?>
                    <div class="filter-item">
                        <label>Scheduled To :</label>
                        <?php echo $sheduled_to_date; ?>
                    </div>
                <?php } ?>

                <?php 
                // Vehicle filter (from first service record if available)
                if (!empty($services) && $services[0]->vehicle) {
                    $vehicleNameFilter = $services[0]->vehicle->vehicle_make . ' ' . $services[0]->vehicle->vehicle_model;
                    ?>
                    <div class="filter-item">
                        <label>Vehicle :</label>
                        <?php echo $vehicleNameFilter; ?>
                    </div>
                <?php } ?>
            </div> 
        </div> 
    </div> 

    <div class="panel-body"> 
        <div class="table-responsive"> 
            <table class="table table-bordered table-primary html_table"> 
                <thead> 
                    <tr> 
                        <th style="width:5%;">No</th> 
                        <th style="width:20%;">Scheduled Date/Time</th>
                        <th style="width:20%;">Vehicle</th>
                        <th style="width:20%;">Garage</th>
                        <th style="width:20%;">Maintenance Type</th> 
                        <th style="width:10%; text-align:right;">Cost</th>
                        
                        <!-- <th style="width:10%;">Odometer</th> -->
                        <!-- <th style="width:15%;">Planned Date/Time</th> -->
                        <!-- <th style="width:10%;">Status</th> -->
                         
                    </tr> 
                </thead> 
                <tbody> 
                    <?php 
                    $condition = "1=1";
                    
                    if (!empty($sheduled_from_date)) {
                        $scheduled_from_date = date("Y-m-d", strtotime(str_replace('/', '-', $scheduled_from_date)));
                        $condition .= " AND DATE(sheduled_date_time) >= '" . $sheduled_from_date . "'";
                    }
                    if (!empty($sheduled_to_date)) {
                        $sheduled_to_date = date("Y-m-d", strtotime(str_replace('/', '-', $sheduled_to_date)));
                        $condition .= " AND DATE(sheduled_date_time) <= '" . $sheduled_to_date . "'";
                    }
                    // if (!empty($garage_name)) {
                    //     $condition .= " AND garage_name LIKE '%" . $garage_name . "%'";
                    // }
                    // if (!empty($service_status)) {
                    //     $condition .= " AND service_status='" . $service_status . "'";
                    // }
                    if ($vehicle_model != '') {
                        $condition .= " AND vehicle_name='" . $vehicle_model . "'";
                    }

                    $services = MasMaintainanceService::model()->findAll([
                        'condition' => $condition,
                        'order' => 'sheduled_date_time ASC'
                    ]);
                    // echo $condition;
                    $grandTotal = 0;
                    $count = 1;

                    if (!empty($services)) {
                        foreach ($services as $service) {
                            // Vehicle Type
                            $vehicleType = '';
                            if ($service->vehicle) {
                                $vehicleType = $service->vehicle->vehicle_make . ' ' . $service->vehicle->vehicle_model;
                            }


                            $details = ServiceDetails::model()->findAllByAttributes(['service_id' => $service->id]);

                            if (!empty($details)) {
                                foreach ($details as $detail) {
                                    $maintType = MasMaintainance::model()->findByPk($detail->maintainance_master_id);
                                    $typeName = $maintType ? $maintType->maintainance_type : '--';
                                    $grandTotal += (float)$detail->service_cost;
                                    ?>
                                    <tr>
                                        <td><?php echo $count++; ?></td>
                                        <td><?php echo date('d/m/Y', strtotime($service->sheduled_date_time)); ?></td>
                                        <td><?php echo CHtml::encode($vehicleType); ?></td>
                                        <td><?php echo CHtml::encode($service->garage_name); ?></td>
                                        <td><?php echo CHtml::encode($typeName); ?></td>
                                        <td style="text-align:right;"><?php echo number_format((float)$detail->service_cost, 2, '.', ''); ?></td>
                                        <!-- <td><?php //echo CHtml::encode($service->odometer_reading); ?></td>
                                        <td><?php //echo date('d-m-Y H:i', strtotime($service->planned_date)); ?></td> -->
                                        <!-- <td><?php //echo CHtml::encode($service->service_status); ?></td> -->
                                        
                                    </tr>
                                    <?php
                                }
                            }
                        }
                    } else { ?>
                        <tr> 
                            <td colspan="6" class="bg-total text-center"><b>No Service Details Found</b></td> 
                        </tr>
                    <?php } ?>
                </tbody> 

                <?php if ($grandTotal > 0) { ?>
                <tfoot> 
                    <tr> 
                        <td colspan="5" class="text-right" style="font-weight:bold;">Total Cost:</td> 
                        <td style="text-align:right; font-weight:bold;"><?php echo number_format($grandTotal, 2, '.', ''); ?></td> 
                    </tr> 
                </tfoot>
                <?php } ?>
            </table> 
        </div> 
    </div> 
</div>
