<?php
$condition = "1=1";

if ($vehicle_id > 0) {
    $condition .= " AND t.vehicle_id=".(int)$vehicle_id;
}
if ($employee_id > 0) {
    $condition .= " AND t.employee_id=".(int)$employee_id;
}
if (!empty($from_date)) {
    $from_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));
    $condition .= " AND DATE(from_date) >= '" . $from_date . "'";
}
if (!empty($to_date)) {
    $to_date = date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
    $condition .= " AND DATE(to_date) <= '" . $to_date . "'";
}

$modelVehicleAllotment = VehicleAllotment::model()
    ->with('vehicle','employee')
    ->findAll(array(
        'condition' => $condition,
        'order' => 't.from_date ASC'
    ));
    //  echo $condition;
?>

<div class="panel"> 
    <div class="panel-heading panel-theme clearfix report-head"> 
        <p>Vehicle Allotment Report</p> 
        <div class="pull-right"> 
            <div class="filter_details"> 
                <?php if ($from_date != '') { ?>
                    <div class="filter-item">
                        <label>From :</label>
                        <?php echo date("d/m/Y", strtotime($from_date)); ?>
                    </div>
                <?php } ?>

                <?php if ($to_date != '') { ?>
                    <div class="filter-item">
                        <label>To :</label>
                        <?php echo date("d/m/Y", strtotime($to_date)); ?>
                    </div>
                <?php } ?>

                <?php if ($vehicle_id) {
                    $vehicle = MasVehicle::model()->findByPk($vehicle_id);
                    if ($vehicle) { ?>
                        <div class="filter-item">
                            <label>Vehicle :</label>
                            <?php echo $vehicle->vehicle_make . ' ' . $vehicle->vehicle_model; ?>
                        </div>
                <?php } } ?>

                <?php if ($employee_id) {
                    $emp = Employee::model()->findByPk($employee_id);
                    if ($emp) { ?>
                        <div class="filter-item">
                            <label>Employee :</label>
                            <?php echo $emp->employeefullname; ?>
                        </div>
                <?php } } ?>
            </div> 
        </div> 
    </div> 

    <div class="panel-body"> 
        <div class="table-responsive"> 
            <table class="table table-bordered table-primary html_table"> 
    <thead> 
        <tr> 
            <th style="width:5%;">No</th> 
            <th style="width:15%;">Employee</th>
            <th style="width:20%;">Vehicle</th>
            <th style="width:15%;">From Date</th>
            <th style="width:15%;">To Date</th>
        </tr> 
    </thead> 
    <tbody> 
        <?php 
        $count = 1;
        $grandTotal = 0;

        if (!empty($modelVehicleAllotment)) {
            foreach ($modelVehicleAllotment as $eachItem) {
                $actual_date = $cost = "";

                // Get service
                $modelService = MasMaintainanceService::model()->find(array(
                    'condition' => 'vehicle_name='.(int)$eachItem['vehicle_id']
                ));

                if ($modelService) {
                    $date1 = new DateTime($eachItem['from_date']);
                    $date2 = new DateTime($eachItem['to_date']);
                    $date3 = new DateTime($modelService->sheduled_date_time);

                    if ($date3 >= $date1 && $date3 <= $date2) {
                        $actual_date = ($modelService->sheduled_date_time != "0000-00-00 00:00:00") 
                            ? date('d/m/Y h:i A', strtotime($modelService->sheduled_date_time)) 
                            : "";
                        $cost = number_format($modelService->total_cost, 2);
                        $grandTotal += (float)$modelService->total_cost;
                    }
                }
                ?>
                <tr>
                    <td><?php echo $count++; ?></td>
                    <td><?php echo $eachItem->employee ? CHtml::encode($eachItem->employee->employeefullname) : '--'; ?></td>
                    <td><?php echo $eachItem->vehicle ? $eachItem->vehicle->vehicle_make . ' ' . $eachItem->vehicle->vehicle_model : '--'; ?></td>
                    <td><?php echo ($eachItem['from_date']!="0000-00-00 00:00:00") ? date('d/m/Y h:i A', strtotime($eachItem['from_date'])) : ""; ?></td>
                    <td><?php echo ($eachItem['to_date']!="0000-00-00 00:00:00") ? date('d/m/Y h:i A', strtotime($eachItem['to_date'])) : ""; ?></td>
                    
                </tr>
            <?php } 
        } else { ?>
            <tr>
                <td colspan="7" class="text-center"><b>No Allotment Records Found</b></td>
            </tr>
        <?php } ?>
    </tbody> 
</table>

        </div> 
    </div> 
</div>
